/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.ScriptStatus;
import io.apigee.trireme.core.ScriptStatusListener;
import io.apigee.trireme.core.internal.NodeExitException;
import io.apigee.trireme.core.internal.ScriptRunner;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFuture
implements RunnableFuture<ScriptStatus> {
    private static final Logger log = LoggerFactory.getLogger(ScriptFuture.class);
    private final ScriptRunner runner;
    private ScriptStatusListener listener;
    private ScriptStatus result;
    private Scriptable moduleResult;
    private volatile boolean cancelled;

    ScriptFuture(ScriptRunner runner) {
        this.runner = runner;
    }

    @Override
    public synchronized boolean cancel(boolean interrupt) {
        if (this.result != null) {
            return false;
        }
        this.cancelled = true;
        this.runner.getSelector().wakeup();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.cancelled || this.result != null;
    }

    private ScriptStatus getResult() throws ExecutionException {
        assert (Thread.holdsLock(this));
        ScriptStatus s = this.result;
        if (s.hasCause()) {
            throw new ExecutionException(s.getCause());
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        return s;
    }

    @Override
    public synchronized ScriptStatus get() throws InterruptedException, ExecutionException {
        while (this.result == null) {
            this.wait();
        }
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptStatus get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ScriptFuture scriptFuture;
        long now = System.currentTimeMillis();
        long expiration = now + timeUnit.toMillis(timeout);
        while (now < expiration && this.result == null) {
            scriptFuture = this;
            synchronized (scriptFuture) {
                this.wait(expiration - now);
            }
            now = System.currentTimeMillis();
        }
        scriptFuture = this;
        synchronized (scriptFuture) {
            if (this.result == null) {
                throw new TimeoutException();
            }
            return this.getResult();
        }
    }

    public synchronized Scriptable getModuleResult() throws InterruptedException, ExecutionException {
        while (this.moduleResult == null) {
            if (this.result != null) {
                ScriptStatus ss = this.getResult();
                throw new ExecutionException((Throwable)((Object)new NodeExitException(NodeExitException.Reason.NORMAL, ss.getExitCode())));
            }
            this.wait();
        }
        return this.moduleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scriptable getModuleResult(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ScriptFuture scriptFuture;
        long now = System.currentTimeMillis();
        long expiration = now + timeUnit.toMillis(timeout);
        while (now < expiration && this.result == null) {
            scriptFuture = this;
            synchronized (scriptFuture) {
                if (this.result != null) {
                    ScriptStatus ss = this.getResult();
                    throw new ExecutionException((Throwable)((Object)new NodeExitException(NodeExitException.Reason.NORMAL, ss.getExitCode())));
                }
                this.wait(expiration - now);
            }
            now = System.currentTimeMillis();
        }
        scriptFuture = this;
        synchronized (scriptFuture) {
            if (this.moduleResult == null) {
                throw new TimeoutException();
            }
            return this.moduleResult;
        }
    }

    public NodeRuntime getRuntime() {
        return this.runner;
    }

    private synchronized void set(ScriptStatus status) {
        this.result = status;
        if (this.listener != null) {
            this.listener.onComplete(this.runner.getScriptObject(), status);
        }
        this.notifyAll();
    }

    public synchronized void setModuleResult(Scriptable result) {
        this.moduleResult = result;
        this.notifyAll();
    }

    @Override
    public void run() {
        try {
            ScriptStatus status = this.runner.call();
            this.set(status);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("Script failed with {}", t);
            }
            this.set(new ScriptStatus(t));
        }
    }

    public ScriptStatusListener getListener() {
        return this.listener;
    }

    public synchronized void setListener(ScriptStatusListener listener) {
        this.listener = listener;
        if (this.result != null) {
            listener.onComplete(this.runner.getScriptObject(), this.result);
        }
    }
}

