/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SignatureAlgorithms {
    public static final String SIGNATURE = "Signature";
    private static final SignatureAlgorithms myself = new SignatureAlgorithms();
    private final Pattern SIGNATURE_NAME = Pattern.compile("([0-9a-zA-Z]+)with([0-9a-zA-Z]+)");
    private final HashMap<String, Algorithm> algs = new HashMap();

    public static SignatureAlgorithms get() {
        return myself;
    }

    private SignatureAlgorithms() {
        for (Provider prov : Security.getProviders()) {
            for (Provider.Service svc : prov.getServices()) {
                Matcher m;
                if (!SIGNATURE.equals(svc.getType()) || !(m = this.SIGNATURE_NAME.matcher(svc.getAlgorithm())).matches()) continue;
                Algorithm sig = new Algorithm();
                String sslName = m.group(2) + '-' + m.group(1);
                sig.setJavaName(svc.getAlgorithm());
                sig.setName(sslName);
                sig.setKeyFormat(m.group(2));
                this.algs.put(sslName, sig);
            }
        }
    }

    public Algorithm get(String name) {
        return this.algs.get(name.toUpperCase());
    }

    public static class Algorithm {
        private String name;
        private String javaName;
        private String keyFormat;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public void setJavaName(String javaName) {
            this.javaName = javaName;
        }

        public String getKeyFormat() {
            return this.keyFormat;
        }

        public void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }
    }
}

