/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.CompositeTrustManager;
import io.apigee.trireme.core.internal.CryptoException;
import io.apigee.trireme.core.internal.CryptoService;
import io.apigee.trireme.core.internal.SSLCiphers;
import io.apigee.trireme.core.modules.Buffer;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLWrap
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(SSLWrap.class);
    protected static final Pattern COLON = Pattern.compile(":");
    protected static final DateFormat X509_DATE = new SimpleDateFormat("MMM dd HH:mm:ss yyyy zzz");
    protected static CryptoService cryptoService;

    public String getModuleName() {
        return "ssl_wrap";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, WrapperImpl.class);
        ScriptableObject.defineClass((Scriptable)scope, EngineImpl.class);
        ScriptableObject.defineClass((Scriptable)scope, ContextImpl.class);
        WrapperImpl wrapper = (WrapperImpl)cx.newObject(scope, "_sslWrapper");
        wrapper.init(runner);
        SSLWrap.loadCryptoService();
        return wrapper;
    }

    private static void loadCryptoService() {
        ServiceLoader<CryptoService> loc = ServiceLoader.load(CryptoService.class);
        if (loc.iterator().hasNext()) {
            if (log.isDebugEnabled()) {
                log.debug("Using crypto service implementation {}", (Object)cryptoService);
            }
            cryptoService = loc.iterator().next();
        } else if (log.isDebugEnabled()) {
            log.debug("No crypto service available");
        }
    }

    private static final class AllTrustingManager
    implements X509TrustManager {
        static final AllTrustingManager INSTANCE = new AllTrustingManager();

        private AllTrustingManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EngineImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_sslEngineClass";
        public static final int STATUS_OK = 0;
        public static final int STATUS_NEED_WRAP = 1;
        public static final int STATUS_NEED_UNWRAP = 2;
        public static final int STATUS_NEED_TASK = 3;
        public static final int STATUS_UNDERFLOW = 4;
        public static final int STATUS_OVERFLOW = 5;
        public static final int STATUS_CLOSED = 6;
        public static final int STATUS_ERROR = 7;
        private static final int MIN_BUFFER_SIZE = 128;
        private SSLEngine engine;
        private NodeRuntime runner;
        private X509TrustManager trustManager;
        private boolean peerAuthorized;
        private Scriptable authorizationError;
        private boolean trustStoreValidation;
        private static final ByteBuffer EMPTY_BUF = ByteBuffer.allocate(0);

        public String getClassName() {
            return CLASS_NAME;
        }

        void init(NodeRuntime runner, SSLContext ctx, boolean clientMode, boolean trustStoreValidation, X509TrustManager trustManager) {
            this.runner = runner;
            this.trustManager = trustManager;
            this.trustStoreValidation = trustStoreValidation;
            this.engine = ctx.createSSLEngine();
            this.engine.setUseClientMode(clientMode);
        }

        private static ByteBuffer doubleBuffer(ByteBuffer b) {
            ByteBuffer ret = ByteBuffer.allocate(b.capacity() * 2);
            b.flip();
            ret.put(b);
            return ret;
        }

        @JSGetter(value="peerAuthorized")
        public boolean isPeerAuthorized() {
            return this.peerAuthorized;
        }

        @JSGetter(value="authorizationError")
        public Object getAuthorizationError() {
            if (this.authorizationError == null) {
                return Context.getUndefinedValue();
            }
            return this.authorizationError;
        }

        @JSFunction
        public static Object wrap(Context cx, Scriptable thisObj, Object[] args, Function func) {
            SSLEngineResult sslResult;
            Buffer.BufferImpl buf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, false);
            int offset = ArgUtils.intArg(args, 1, 0);
            EngineImpl self = (EngineImpl)thisObj;
            ByteBuffer toWrap = EMPTY_BUF;
            if (buf != null) {
                toWrap = buf.getBuffer();
                toWrap.position(toWrap.position() + offset);
            }
            ByteBuffer fromWrap = ByteBuffer.allocate(self.engine.getSession().getPacketBufferSize());
            Scriptable result = cx.newObject(thisObj);
            try {
                do {
                    if (log.isDebugEnabled()) {
                        log.debug("SSLEngine wrap {} -> {}", (Object)toWrap, (Object)fromWrap);
                    }
                    sslResult = self.engine.wrap(toWrap, fromWrap);
                    if (log.isDebugEnabled()) {
                        log.debug("  wrap {} -> {} = {}", new Object[]{toWrap, fromWrap, sslResult});
                    }
                    if (sslResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                    fromWrap = EngineImpl.doubleBuffer(fromWrap);
                } while (sslResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW);
            }
            catch (SSLException ssle) {
                if (log.isDebugEnabled()) {
                    log.debug("SSLException: {}", (Throwable)ssle);
                }
                return self.makeException(result, ssle);
            }
            return self.makeResult(cx, toWrap, fromWrap, sslResult, result);
        }

        @JSFunction
        public static Object unwrap(Context cx, Scriptable thisObj, Object[] args, Function func) {
            SSLEngineResult sslResult;
            Buffer.BufferImpl buf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, false);
            int offset = ArgUtils.intArg(args, 1, 0);
            EngineImpl self = (EngineImpl)thisObj;
            ByteBuffer toUnwrap = EMPTY_BUF;
            if (buf != null) {
                toUnwrap = buf.getBuffer();
                toUnwrap.position(toUnwrap.position() + offset);
            }
            int bufLen = Math.max(toUnwrap.remaining(), 128);
            bufLen = Math.min(bufLen, self.engine.getSession().getApplicationBufferSize());
            ByteBuffer fromUnwrap = ByteBuffer.allocate(bufLen);
            Scriptable result = cx.newObject(thisObj);
            try {
                do {
                    if (log.isDebugEnabled()) {
                        log.debug("SSLEngine unwrap {} -> {}", (Object)toUnwrap, (Object)fromUnwrap);
                    }
                    sslResult = self.engine.unwrap(toUnwrap, fromUnwrap);
                    if (log.isDebugEnabled()) {
                        log.debug("  unwrap {} -> {} = {}", new Object[]{toUnwrap, fromUnwrap, sslResult});
                    }
                    if (sslResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                    fromUnwrap = ByteBuffer.allocate(fromUnwrap.capacity() * 2);
                } while (sslResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW);
            }
            catch (SSLException ssle) {
                if (log.isDebugEnabled()) {
                    log.debug("SSLException: {}", (Throwable)ssle);
                }
                return self.makeException(result, ssle);
            }
            return self.makeResult(cx, toUnwrap, fromUnwrap, sslResult, result);
        }

        private Scriptable makeException(Scriptable r, Exception e) {
            Throwable rootCause = e;
            while (rootCause.getCause() != null && (rootCause.getCause() instanceof GeneralSecurityException || rootCause.getCause() instanceof SSLException)) {
                rootCause = rootCause.getCause();
            }
            r.put("status", r, (Object)7);
            r.put("error", r, (Object)e.toString());
            return r;
        }

        private Scriptable makeResult(Context cx, ByteBuffer inBuf, ByteBuffer outBuf, SSLEngineResult sslResult, Scriptable result) {
            int returnStatus;
            boolean justHandshaked = false;
            block0 : switch (sslResult.getStatus()) {
                case BUFFER_OVERFLOW: {
                    returnStatus = 5;
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    returnStatus = 4;
                    break;
                }
                case CLOSED: 
                case OK: {
                    switch (sslResult.getHandshakeStatus()) {
                        case NEED_TASK: {
                            returnStatus = 3;
                            break block0;
                        }
                        case NEED_UNWRAP: {
                            returnStatus = 2;
                            break block0;
                        }
                        case NEED_WRAP: {
                            returnStatus = 1;
                            break block0;
                        }
                        case FINISHED: {
                            justHandshaked = true;
                            returnStatus = sslResult.getStatus() == SSLEngineResult.Status.CLOSED ? 6 : 0;
                            break block0;
                        }
                        case NOT_HANDSHAKING: {
                            returnStatus = sslResult.getStatus() == SSLEngineResult.Status.CLOSED ? 6 : 0;
                            break block0;
                        }
                    }
                    throw new AssertionError();
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (outBuf.position() > 0) {
                outBuf.flip();
                Buffer.BufferImpl resultBuf = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, outBuf, false);
                outBuf.clear();
                result.put("data", result, (Object)resultBuf);
            }
            result.put("status", result, (Object)returnStatus);
            result.put("consumed", result, (Object)sslResult.bytesConsumed());
            result.put("remaining", result, (Object)inBuf.remaining());
            if (justHandshaked) {
                result.put("justHandshaked", result, (Object)Boolean.TRUE);
                this.checkPeerAuthorization(cx);
            }
            return result;
        }

        @JSFunction
        public void runTask(final Function callback) {
            final Runnable task = this.engine.getDelegatedTask();
            final Scriptable domain = this.runner.getDomain();
            if (task == null) {
                this.fireFunction(callback, domain);
            } else {
                this.runner.getAsyncPool().execute(new Runnable(){

                    public void run() {
                        if (log.isDebugEnabled()) {
                            log.debug("Running async task {} in thread pool", (Object)task);
                        }
                        task.run();
                        EngineImpl.this.fireFunction(callback, domain);
                    }
                });
            }
        }

        @JSFunction
        public void beginHandshake() {
            try {
                this.engine.beginHandshake();
            }
            catch (SSLException e) {
                throw new EvaluatorException(e.toString());
            }
        }

        @JSFunction
        public void closeInbound() {
            try {
                this.engine.closeInbound();
            }
            catch (SSLException e) {
                throw new EvaluatorException(e.toString());
            }
        }

        @JSFunction
        public void closeOutbound() {
            this.engine.closeOutbound();
        }

        @JSFunction
        public boolean isOutboundDone() {
            return this.engine.isOutboundDone();
        }

        @JSFunction
        public boolean isInboundDone() {
            return this.engine.isInboundDone();
        }

        private void fireFunction(Function callback, Scriptable domain) {
            this.runner.enqueueCallback(callback, (Scriptable)this, (Scriptable)this, domain, null);
        }

        private void checkPeerAuthorization(Context cx) {
            Certificate[] certChain;
            try {
                certChain = this.engine.getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException unver) {
                if (log.isDebugEnabled()) {
                    log.debug("Peer is unverified");
                }
                this.peerAuthorized = false;
                return;
            }
            if (certChain == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Peer has no client- or server-side certs");
                }
                this.peerAuthorized = false;
                return;
            }
            if (this.trustManager == null) {
                this.peerAuthorized = this.trustStoreValidation;
                return;
            }
            try {
                if (this.engine.getUseClientMode()) {
                    this.trustManager.checkServerTrusted((X509Certificate[])certChain, "RSA");
                } else {
                    this.trustManager.checkClientTrusted((X509Certificate[])certChain, "RSA");
                }
                this.peerAuthorized = true;
                if (log.isDebugEnabled()) {
                    log.debug("SSL peer is valid");
                }
            }
            catch (CertificateException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Error verifying SSL peer: {}", (Throwable)e);
                }
                this.authorizationError = Utils.makeErrorObject(cx, (Scriptable)this, e.toString());
                this.peerAuthorized = false;
            }
        }

        @JSFunction
        public static Object getCipher(Context cx, Scriptable thisObj, Object[] args, Function func) {
            EngineImpl self = (EngineImpl)thisObj;
            if (self.engine == null || self.engine.getSession() == null) {
                return null;
            }
            Scriptable ret = cx.newObject(thisObj);
            SSLCiphers.Ciph ciph = SSLCiphers.get().getJavaCipher(self.engine.getSession().getCipherSuite());
            ret.put("name", ret, (Object)(ciph == null ? self.engine.getSession().getCipherSuite() : ciph.getSslName()));
            ret.put("version", ret, (Object)self.engine.getSession().getProtocol());
            return ret;
        }

        @JSFunction
        public boolean validateCiphers(String cipherList) {
            boolean ret = true;
            HashSet<String> enabled = new HashSet<String>(Arrays.asList(this.engine.getEnabledCipherSuites()));
            for (String cipher : COLON.split(cipherList)) {
                SSLCiphers.Ciph c = SSLCiphers.get().getSslCipher("TLS", cipher);
                if (c == null) {
                    log.debug(cipher + " is unknown");
                    ret = false;
                    continue;
                }
                if (enabled.contains(c.getJavaName())) continue;
                log.debug(cipher + " is not supported in the JVM");
                ret = false;
            }
            return ret;
        }

        @JSFunction
        public void setClientAuthRequired(boolean required) {
            this.engine.setNeedClientAuth(required);
        }

        @JSFunction
        public void setClientAuthRequested(boolean requested) {
            this.engine.setWantClientAuth(requested);
        }

        @JSFunction
        public void setCiphers(String cipherList) {
            ArrayList<String> finalList = new ArrayList<String>();
            for (String cipher : COLON.split(cipherList)) {
                SSLCiphers.Ciph c = SSLCiphers.get().getSslCipher("TLS", cipher);
                if (c == null) {
                    throw new EvaluatorException("Unsupported SSL cipher suite \"" + cipher + '\"');
                }
                finalList.add(c.getJavaName());
            }
            this.engine.setEnabledCipherSuites(finalList.toArray(new String[finalList.size()]));
        }

        @JSFunction
        public static Object getPeerCertificate(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Certificate cert;
            EngineImpl self = (EngineImpl)thisObj;
            if (self.engine == null || self.engine.getSession() == null) {
                return Context.getUndefinedValue();
            }
            try {
                cert = self.engine.getSession().getPeerCertificates()[0];
            }
            catch (SSLPeerUnverifiedException puve) {
                log.debug("getPeerCertificates threw {}", (Throwable)puve);
                cert = null;
            }
            if (cert == null || !(cert instanceof X509Certificate)) {
                log.debug("Peer certificate is not an X.509 cert");
                return Context.getUndefinedValue();
            }
            return self.makeCertificate(cx, (X509Certificate)cert);
        }

        private Object makeCertificate(Context cx, X509Certificate cert) {
            if (log.isDebugEnabled()) {
                log.debug("Returning subject " + cert.getSubjectX500Principal());
            }
            Scriptable ret = cx.newObject((Scriptable)this);
            ret.put("subject", ret, (Object)cert.getSubjectX500Principal().getName("RFC2253"));
            ret.put("issuer", ret, (Object)cert.getIssuerX500Principal().getName("RFC2253"));
            ret.put("valid_from", ret, (Object)X509_DATE.format(cert.getNotBefore()));
            ret.put("valid_to", ret, (Object)X509_DATE.format(cert.getNotAfter()));
            try {
                this.addAltNames(cx, ret, "subject", "subjectAltNames", cert.getSubjectAlternativeNames());
                this.addAltNames(cx, ret, "issuer", "issuerAltNames", cert.getIssuerAlternativeNames());
            }
            catch (CertificateParsingException e) {
                log.debug("Error getting all the cert names: {}", (Throwable)e);
            }
            return ret;
        }

        private void addAltNames(Context cx, Scriptable s, String attachment, String type, Collection<List<?>> altNames) {
            if (altNames == null) {
                return;
            }
            Scriptable o = cx.newObject((Scriptable)this);
            s.put(type, s, (Object)o);
            for (List<?> an : altNames) {
                String typeName;
                if (an.size() < 2 || !(an.get(0) instanceof Integer) || !(an.get(1) instanceof String)) continue;
                int typeNum = (Integer)an.get(0);
                switch (typeNum) {
                    case 1: {
                        typeName = "rfc822Name";
                        break;
                    }
                    case 2: {
                        typeName = "dNSName";
                        break;
                    }
                    case 6: {
                        typeName = "uniformResourceIdentifier";
                        break;
                    }
                    default: {
                        return;
                    }
                }
                o.put(typeName, s, an.get(1));
            }
            Scriptable subject = (Scriptable)s.get(attachment, s);
            subject.put(type, subject, (Object)o);
        }

        @JSFunction
        public static Object getSession(Context cx, Scriptable thisObj, Object[] args, Function func) {
            EngineImpl self = (EngineImpl)thisObj;
            SSLSession session = self.engine.getSession();
            Buffer.BufferImpl id = Buffer.BufferImpl.newBuffer(cx, thisObj, session.getId());
            return id;
        }

        @JSFunction
        public static boolean isSessionReused(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return false;
        }

        @JSGetter(value="OK")
        public int getOK() {
            return 0;
        }

        @JSGetter(value="NEED_WRAP")
        public int getNeedWrap() {
            return 1;
        }

        @JSGetter(value="NEED_UNWRAP")
        public int getNeedUnwrap() {
            return 2;
        }

        @JSGetter(value="NEED_TASK")
        public int getNeedTask() {
            return 3;
        }

        @JSGetter(value="UNDERFLOW")
        public int getUnderflow() {
            return 4;
        }

        @JSGetter(value="OVERFLOW")
        public int getOverflow() {
            return 5;
        }

        @JSGetter(value="CLOSED")
        public int getClosed() {
            return 6;
        }

        @JSGetter(value="ERROR")
        public int getError() {
            return 7;
        }
    }

    public static class ContextImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_sslContextClass";
        private static final String DEFAULT_KEY_ENTRY = "key";
        private static final String DEFAULT_CERT_ENTRY = "cert";
        private SSLContext context;
        private NodeRuntime runner;
        private KeyManager[] keyManagers;
        private PrivateKey privateKey;
        private X509Certificate[] certChain;
        private TrustManager[] trustManagers;
        private X509CRL crl;
        private KeyStore trustedCertStore;
        private X509TrustManager trustedCertManager;
        private boolean trustStoreValidation;

        public String getClassName() {
            return CLASS_NAME;
        }

        void init(NodeRuntime runner) {
            this.runner = runner;
        }

        public SSLContext getSslContext() {
            return this.context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JSFunction
        public void setKeyStore(String name, String p) {
            char[] passphrase = p.toCharArray();
            try {
                FileInputStream keyIn = new FileInputStream(this.runner.translatePath(name));
                try {
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(keyIn, passphrase);
                    KeyManagerFactory keyFactory = KeyManagerFactory.getInstance("SunX509");
                    keyFactory.init(keyStore, passphrase);
                    this.keyManagers = keyFactory.getKeyManagers();
                }
                finally {
                    keyIn.close();
                }
            }
            catch (GeneralSecurityException gse) {
                throw new EvaluatorException("Error opening key store: " + gse);
            }
            catch (IOException ioe) {
                throw new EvaluatorException("I/O error reading key store: " + ioe);
            }
            finally {
                if (passphrase != null) {
                    Arrays.fill(passphrase, '\u0000');
                }
            }
        }

        @JSFunction
        public static void setPfx(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Buffer.BufferImpl pfxBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            String p = ArgUtils.stringArg(args, 1, null);
            char[] passphrase = p == null ? null : p.toCharArray();
            ContextImpl self = (ContextImpl)thisObj;
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(pfxBuf.getArray(), pfxBuf.getArrayOffset(), pfxBuf.getLength());
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(bis, passphrase);
                KeyManagerFactory keyFactory = KeyManagerFactory.getInstance("SunX509");
                keyFactory.init(keyStore, passphrase);
                self.keyManagers = keyFactory.getKeyManagers();
            }
            catch (GeneralSecurityException gse) {
                throw new EvaluatorException("Error opening key store: " + gse);
            }
            catch (IOException ioe) {
                throw new EvaluatorException("I/O error reading key store: " + ioe);
            }
            finally {
                if (passphrase != null) {
                    Arrays.fill(passphrase, '\u0000');
                }
            }
        }

        @JSFunction
        public static void setKey(Context cx, Scriptable thisObj, Object[] args, Function func) {
            if (cryptoService == null) {
                throw Utils.makeError(cx, thisObj, "No crypto service available to read PEM key");
            }
            Buffer.BufferImpl keyBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            String p = ArgUtils.stringArg(args, 1, null);
            char[] passphrase = p == null ? null : p.toCharArray();
            ContextImpl self = (ContextImpl)thisObj;
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(keyBuf.getArray(), keyBuf.getArrayOffset(), keyBuf.getLength());
                KeyPair kp = cryptoService.readKeyPair("RSA", bis, passphrase);
                self.privateKey = kp.getPrivate();
            }
            catch (CryptoException ce) {
                throw Utils.makeError(cx, thisObj, ce.toString());
            }
            catch (IOException ioe) {
                throw Utils.makeError(cx, thisObj, ioe.toString());
            }
            finally {
                Arrays.fill(passphrase, '\u0000');
            }
        }

        @JSFunction
        public static void setCert(Context cx, Scriptable thisObj, Object[] args, Function func) {
            if (cryptoService == null) {
                throw Utils.makeError(cx, thisObj, "No crypto service available to read PEM key");
            }
            Buffer.BufferImpl keyBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            ContextImpl self = (ContextImpl)thisObj;
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(keyBuf.getArray(), keyBuf.getArrayOffset(), keyBuf.getLength());
                X509Certificate cert = cryptoService.readCertificate(bis);
                if (log.isDebugEnabled()) {
                    log.debug("My SSL certificate is {}", (Object)cert.getSubjectDN());
                }
                self.certChain = new X509Certificate[]{cert};
            }
            catch (CryptoException ce) {
                throw Utils.makeError(cx, thisObj, ce.toString());
            }
            catch (IOException ioe) {
                throw Utils.makeError(cx, thisObj, ioe.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JSFunction
        public void setTrustStore(String name) {
            try {
                FileInputStream keyIn = new FileInputStream(this.runner.translatePath(name));
                try {
                    KeyStore trustStore = KeyStore.getInstance("JKS");
                    trustStore.load(keyIn, null);
                    TrustManagerFactory trustFactory = TrustManagerFactory.getInstance("SunX509");
                    trustFactory.init(trustStore);
                    this.trustManagers = trustFactory.getTrustManagers();
                    this.trustStoreValidation = true;
                }
                finally {
                    keyIn.close();
                }
            }
            catch (GeneralSecurityException gse) {
                throw new EvaluatorException("Error opening key store: " + gse);
            }
            catch (IOException ioe) {
                throw new EvaluatorException("I/O error reading key store: " + ioe);
            }
        }

        @JSFunction
        public static void addTrustedCert(Context cx, Scriptable thisObj, Object[] args, Function func) {
            if (cryptoService == null) {
                throw Utils.makeError(cx, thisObj, "No crypto service available to read cert");
            }
            int sequence = ArgUtils.intArg(args, 0);
            ArgUtils.ensureArg(args, 1);
            ContextImpl self = (ContextImpl)thisObj;
            Buffer.BufferImpl certBuf = null;
            if (args[1] != null) {
                certBuf = ArgUtils.objArg(args, 1, Buffer.BufferImpl.class, true);
            }
            try {
                if (self.trustedCertStore == null) {
                    self.trustedCertStore = cryptoService.createPemKeyStore();
                    self.trustedCertStore.load(null, null);
                }
                if (certBuf != null) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(certBuf.getArray(), certBuf.getArrayOffset(), certBuf.getLength());
                    X509Certificate cert = cryptoService.readCertificate(bis);
                    if (log.isDebugEnabled()) {
                        log.debug("Adding trusted CA cert {}");
                    }
                    self.trustedCertStore.setCertificateEntry("Cert " + sequence, cert);
                }
            }
            catch (GeneralSecurityException gse) {
                throw Utils.makeError(cx, thisObj, gse.toString());
            }
            catch (CryptoException ce) {
                throw Utils.makeError(cx, thisObj, ce.toString());
            }
            catch (IOException ioe) {
                throw Utils.makeError(cx, thisObj, ioe.toString());
            }
        }

        @JSFunction
        public static void setCRL(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Buffer.BufferImpl crlBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            ContextImpl self = (ContextImpl)thisObj;
            ByteArrayInputStream bis = new ByteArrayInputStream(crlBuf.getArray(), crlBuf.getArrayOffset(), crlBuf.getLength());
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                self.crl = (X509CRL)certFactory.generateCRL(bis);
            }
            catch (CertificateException e) {
                throw Utils.makeError(Context.getCurrentContext(), thisObj, "Error reading CRL: " + e);
            }
            catch (CRLException e) {
                throw Utils.makeError(Context.getCurrentContext(), thisObj, "Error reading CRL: " + e);
            }
        }

        @JSFunction
        public static void init(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ContextImpl self = (ContextImpl)thisObj;
            if (self.keyManagers == null && self.privateKey != null) {
                if (cryptoService == null) {
                    throw Utils.makeError(cx, thisObj, "No crypto service available");
                }
                KeyStore pemKs = cryptoService.createPemKeyStore();
                try {
                    pemKs.load(null, null);
                    pemKs.setKeyEntry(DEFAULT_KEY_ENTRY, self.privateKey, null, self.certChain);
                    KeyManagerFactory keyFactory = KeyManagerFactory.getInstance("SunX509");
                    keyFactory.init(pemKs, null);
                    self.keyManagers = keyFactory.getKeyManagers();
                }
                catch (GeneralSecurityException gse) {
                    throw Utils.makeError(cx, thisObj, gse.toString());
                }
                catch (IOException ioe) {
                    throw Utils.makeError(cx, thisObj, ioe.toString());
                }
            }
            if (self.trustedCertStore != null && self.trustManagers == null) {
                try {
                    TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
                    factory.init(self.trustedCertStore);
                    self.trustManagers = factory.getTrustManagers();
                    self.trustStoreValidation = true;
                }
                catch (GeneralSecurityException gse) {
                    throw Utils.makeError(cx, thisObj, gse.toString());
                }
            }
            TrustManager[] tms = self.trustManagers;
            if (self.trustManagers != null && self.crl != null) {
                tms[0] = new CompositeTrustManager((X509TrustManager)self.trustManagers[0], self.crl);
            }
            try {
                if (self.keyManagers == null && tms == null) {
                    self.context = SSLContext.getDefault();
                    self.trustStoreValidation = true;
                } else {
                    self.context = SSLContext.getInstance("TLS");
                    self.context.init(self.keyManagers, tms, null);
                }
            }
            catch (NoSuchAlgorithmException nse) {
                throw new AssertionError((Object)nse);
            }
            catch (KeyManagementException kme) {
                throw Utils.makeError(cx, thisObj, "Error initializing SSL context: " + kme);
            }
            if (self.trustedCertStore != null) {
                try {
                    TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
                    factory.init(self.trustedCertStore);
                    self.trustedCertManager = (X509TrustManager)factory.getTrustManagers()[0];
                    if (self.crl != null) {
                        self.trustedCertManager = new CompositeTrustManager(self.trustedCertManager, self.crl);
                    }
                }
                catch (GeneralSecurityException gse) {
                    throw Utils.makeError(cx, thisObj, gse.toString());
                }
            }
        }

        @JSFunction
        public void setTrustEverybody() {
            this.trustManagers = new TrustManager[]{AllTrustingManager.INSTANCE};
        }

        @JSFunction
        public static Object createEngine(Context cx, Scriptable thisObj, Object[] args, Function func) {
            boolean clientMode = ArgUtils.booleanArg(args, 0);
            ContextImpl self = (ContextImpl)thisObj;
            EngineImpl engine = (EngineImpl)cx.newObject(thisObj, "_sslEngineClass");
            engine.init(self.runner, self.context, clientMode, self.trustStoreValidation, self.trustedCertManager);
            return engine;
        }
    }

    public static class WrapperImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_sslWrapper";
        private NodeRuntime runner;

        public String getClassName() {
            return CLASS_NAME;
        }

        void init(NodeRuntime runner) {
            this.runner = runner;
        }

        @JSFunction
        public static Object createContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            WrapperImpl self = (WrapperImpl)thisObj;
            ContextImpl ctx = (ContextImpl)cx.newObject(thisObj, "_sslContextClass");
            ctx.init(self.runner);
            return ctx;
        }

        @JSFunction
        public static Object getCiphers(Context cx, Scriptable thisObj, Object[] args, Function func) {
            try {
                SSLEngine eng = SSLContext.getDefault().createSSLEngine();
                List<String> supported = SSLCiphers.get().getSslCiphers("TLS", Arrays.asList(eng.getSupportedCipherSuites()));
                Scriptable l = cx.newObject((Scriptable)func);
                int i = 0;
                for (String s : supported) {
                    l.put(i++, l, (Object)s.toLowerCase());
                }
                return l;
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }
    }
}

