/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.Referenceable;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerWrap
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(TimerWrap.class);

    public String getModuleName() {
        return "timer_wrap";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Scriptable export = cx.newObject(scope);
        export.setPrototype(scope);
        export.setParentScope(null);
        ScriptableObject.defineClass((Scriptable)export, Referenceable.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)export, TimerImpl.class, (boolean)false, (boolean)true);
        return export;
    }

    public static class TimerImpl
    extends Referenceable
    implements ScriptTask {
        public static final String CLASS_NAME = "Timer";
        private Function onTimeout;
        private Object domain;
        private ScriptRunner.Activity activity;

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSConstructor
        public static Object newTimerImpl(Context cx, Object[] args, Function fn, boolean isNew) {
            TimerImpl t = new TimerImpl();
            t.ref();
            return t;
        }

        @JSGetter(value="ontimeout")
        public Function getTimeout() {
            return this.onTimeout;
        }

        @JSSetter(value="ontimeout")
        public void setTimeout(Function f) {
            this.onTimeout = f;
        }

        @JSGetter(value="domain")
        public Object getDomain() {
            return this.domain;
        }

        @JSSetter(value="domain")
        public void setDomain(Object d) {
            this.domain = d;
        }

        @JSFunction
        public static int start(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int timeout = ArgUtils.intArg(args, 0);
            int interval = ArgUtils.intArg(args, 1, 0);
            TimerImpl timer = (TimerImpl)thisObj;
            if (log.isDebugEnabled()) {
                log.debug("Starting timer {} in {} interval = {}", new Object[]{System.identityHashCode(timer), timeout, interval});
            }
            timer.activity = interval > 0 ? TimerImpl.getRunner().createTimer(timeout, true, interval, timer, (Scriptable)timer) : TimerImpl.getRunner().createTimer(timeout, false, 0L, timer, (Scriptable)timer);
            return 0;
        }

        @JSFunction
        public void close() {
            super.close();
            if (log.isDebugEnabled()) {
                log.debug("Cancelling timer {}", (Object)System.identityHashCode(this));
            }
            if (this.activity != null) {
                this.activity.setCancelled(true);
            }
            this.unref();
        }

        public void execute(Context cx, Scriptable scope) {
            if (log.isDebugEnabled()) {
                log.debug("Executing timer {} ontimeout = {}", (Object)System.identityHashCode(this), (Object)this.onTimeout);
            }
            if (this.onTimeout != null) {
                Object oldDomain = TimerImpl.getRunner().getProcess().getDomain();
                if (this.domain != null) {
                    TimerImpl.getRunner().getProcess().setDomain(this.domain);
                }
                this.onTimeout.call(cx, (Scriptable)this.onTimeout, (Scriptable)this, null);
                if (this.domain != null) {
                    TimerImpl.getRunner().getProcess().setDomain(oldDomain);
                }
            }
        }
    }
}

