/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.CircularOutputStream;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.GZipHeader;
import io.apigee.trireme.core.modules.Buffer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.annotations.JSFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZLib
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger((String)ZLib.class.getName());
    public static final int Z_NO_FLUSH = 0;
    public static final int Z_PARTIAL_FLUSH = 1;
    public static final int Z_SYNC_FLUSH = 2;
    public static final int Z_FULL_FLUSH = 3;
    public static final int Z_FINISH = 4;
    public static final int Z_BLOCK = 5;
    public static final int Z_TREES = 6;
    public static final int Z_OK = 0;
    public static final int Z_STREAM_END = 1;
    public static final int Z_NEED_DICT = 2;
    public static final int Z_ERRNO = -1;
    public static final int Z_STREAM_ERROR = -2;
    public static final int Z_DATA_ERROR = -3;
    public static final int Z_MEM_ERROR = -4;
    public static final int Z_BUF_ERROR = -5;
    public static final int Z_VERSION_ERROR = -6;
    public static final int Z_NO_COMPRESSION = 0;
    public static final int Z_BEST_SPEED = 1;
    public static final int Z_BEST_COMPRESSION = 9;
    public static final int Z_DEFAULT_COMPRESSION = -1;
    public static final int Z_FILTERED = 1;
    public static final int Z_HUFFMAN_ONLY = 2;
    public static final int Z_RLE = 3;
    public static final int Z_FIXED = 4;
    public static final int Z_DEFAULT_STRATEGY = 0;
    public static final int Z_BINARY = 0;
    public static final int Z_TEXT = 1;
    public static final int Z_ASCII = 1;
    public static final int Z_UNKNOWN = 2;
    public static final int Z_DEFLATED = 8;
    public static final int Z_NULL = 0;
    public static final int NONE = -1;
    public static final int DEFLATE = 1;
    public static final int INFLATE = 2;
    public static final int GZIP = 3;
    public static final int GUNZIP = 4;
    public static final int DEFLATERAW = 5;
    public static final int INFLATERAW = 6;
    public static final int UNZIP = 7;
    private static Method deflateFlush;

    public String getModuleName() {
        return "zlib";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, ZLibImpl.class);
        ScriptableObject.defineClass((Scriptable)scope, ZLibObjImpl.class);
        ZLibImpl zlib = (ZLibImpl)cx.newObject(scope, "_zlibClass");
        zlib.initialize(runner, runner.getAsyncPool());
        return zlib;
    }

    static {
        try {
            deflateFlush = Deflater.class.getMethod("deflate", byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static class ZLibObjImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "ZLib";
        public static final int DEFAULT_OUT_SIZE = 8192;
        private Buffer.BufferImpl dictionary;
        private int mode;
        private int level;
        private int strategy;
        private ZLibImpl parentModule;
        private boolean inflating;
        private Deflater deflater;
        private Inflater inflater;
        private boolean headerDone;
        private boolean trailerDone;
        private ByteBuffer remaining;
        private CRC32 checksum;
        private CircularOutputStream trailerBuf;
        private long totalSupplied;

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSFunction
        public static void init(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ZLibObjImpl self = (ZLibObjImpl)thisObj;
            self.mode = ArgUtils.intArg(args, 0);
            self.level = ArgUtils.intArg(args, 2);
            int strategy = ArgUtils.intArg(args, 4);
            ArgUtils.ensureArg(args, 5);
            Object dictionary = args[5];
            if (strategy == 0) {
                self.strategy = 0;
            } else if (strategy == 1) {
                self.strategy = 1;
            } else if (strategy == 2) {
                self.strategy = 2;
            } else {
                throw Utils.makeError(cx, (Scriptable)self, "strategy not supported");
            }
            if (!dictionary.equals(Undefined.instance)) {
                self.dictionary = (Buffer.BufferImpl)((Object)dictionary);
            }
            switch (self.mode) {
                case 1: 
                case 3: 
                case 5: {
                    self.inflating = false;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    self.inflating = true;
                    break;
                }
                default: {
                    throw Utils.makeError(cx, (Scriptable)self, "mode not supported");
                }
            }
        }

        @JSFunction
        public void reset() throws IOException {
            if (this.deflater != null) {
                this.deflater.reset();
            }
            if (this.inflater != null) {
                this.inflater.reset();
            }
            this.trailerDone = false;
            this.headerDone = false;
            this.remaining = null;
            this.checksum = null;
            this.trailerBuf = null;
            this.totalSupplied = 0L;
        }

        @JSFunction
        public void close() throws IOException {
            if (this.deflater != null) {
                this.deflater.end();
            }
            if (this.inflater != null) {
                this.inflater.end();
            }
        }

        @JSFunction
        public static void transform(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Buffer.BufferImpl chunk = args[0] == null ? null : ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            int flushFlag = ArgUtils.intArg(args, 1);
            Function cb = ArgUtils.functionArg(args, 2, true);
            ZLibObjImpl self = (ZLibObjImpl)thisObj;
            if (self.inflating) {
                try {
                    self.inflate(cx, chunk, flushFlag, cb);
                }
                catch (DataFormatException e) {
                    cb.call(cx, thisObj, thisObj, new Object[]{Utils.makeErrorObject(cx, thisObj, e.getMessage())});
                }
            } else {
                self.deflate(cx, chunk, flushFlag, cb);
            }
        }

        private boolean initDeflate(Context cx, Function cb) {
            boolean nowrap;
            boolean bl = nowrap = this.mode == 5 || this.mode == 3;
            if (log.isDebugEnabled()) {
                log.debug("New deflater mode = {} nowrap = {}", (Object)this.mode, (Object)nowrap);
            }
            this.deflater = new Deflater(this.level, nowrap);
            this.deflater.setStrategy(this.strategy);
            this.deflater.setLevel(this.level);
            if (this.dictionary != null) {
                try {
                    this.deflater.setDictionary(this.dictionary.getArray(), this.dictionary.getArrayOffset(), this.dictionary.getLength());
                }
                catch (IllegalArgumentException e) {
                    cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Utils.makeErrorObject(cx, (Scriptable)this, "Bad dictionary")});
                    return false;
                }
            }
            return true;
        }

        private void initInflate(boolean nowrap) {
            this.inflater = new Inflater(nowrap);
        }

        private void deflate(Context cx, Buffer.BufferImpl chunk, int flushFlag, Function cb) {
            boolean done;
            if (this.deflater == null && !this.initDeflate(cx, cb)) {
                return;
            }
            if (!this.headerDone) {
                if (this.mode == 3) {
                    this.checksum = new CRC32();
                    GZipHeader hdr = new GZipHeader();
                    hdr.setTimestamp(System.currentTimeMillis());
                    Buffer.BufferImpl buf = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, hdr.store(), false);
                    log.debug("Sending GZIP header");
                    cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Context.getUndefinedValue(), buf, false});
                }
                this.headerDone = true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Consuming {} bytes from buffer", (Object)chunk.getLength());
            }
            if (chunk != null) {
                this.deflater.setInput(chunk.getArray(), chunk.getArrayOffset(), chunk.getLength());
                if (this.mode == 3) {
                    this.checksum.update(chunk.getArray(), chunk.getArrayOffset(), chunk.getLength());
                }
            }
            if (flushFlag == 4) {
                this.deflater.finish();
            }
            do {
                int count;
                byte[] outBuf = new byte[8192];
                if (flushFlag != 0 && flushFlag != 4 && deflateFlush != null) {
                    try {
                        count = (Integer)deflateFlush.invoke((Object)this.deflater, outBuf, 0, outBuf.length, flushFlag);
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                    catch (InvocationTargetException e) {
                        cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Utils.makeErrorObject(cx, (Scriptable)this, e.getCause().toString())});
                        return;
                    }
                } else {
                    count = this.deflater.deflate(outBuf);
                }
                boolean bl = done = count == 0 && (this.deflater.needsInput() || this.deflater.finished());
                if (log.isDebugEnabled()) {
                    log.debug("Deflater produced {}. needsInput = {} finished = {}", new Object[]{count, this.deflater.needsInput(), this.deflater.finished()});
                }
                if (count <= 0) continue;
                Buffer.BufferImpl outChunk = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, outBuf, 0, count);
                cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Context.getUndefinedValue(), outChunk, false});
            } while (!done);
            Buffer.BufferImpl lastChunk = null;
            if (this.deflater.finished() && !this.trailerDone) {
                if (this.mode == 3) {
                    ByteBuffer bb = GZipHeader.writeGZipTrailer(this.checksum.getValue(), this.deflater.getBytesRead());
                    lastChunk = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, bb, false);
                    log.debug("Sending GZIP trailer");
                }
                this.trailerDone = true;
            }
            cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Context.getUndefinedValue(), lastChunk, true});
        }

        private void inflate(Context cx, Buffer.BufferImpl chunk, int flushFlag, Function cb) throws DataFormatException {
            this.remaining = Utils.catBuffers(this.remaining, chunk.getBuffer());
            this.doInflate(cx, flushFlag, cb);
        }

        private void doInflate(Context cx, int flushFlag, Function cb) throws DataFormatException {
            if (!this.headerDone) {
                switch (this.mode) {
                    case 2: {
                        this.initInflate(false);
                        this.headerDone = true;
                        break;
                    }
                    case 6: {
                        this.initInflate(true);
                        this.headerDone = true;
                        break;
                    }
                    case 4: {
                        GZipHeader hdr = GZipHeader.load(this.remaining);
                        if (hdr == null) break;
                        this.headerDone = true;
                        this.initInflate(true);
                        this.checksum = new CRC32();
                        this.trailerBuf = new CircularOutputStream(8);
                        break;
                    }
                    case 7: {
                        GZipHeader.Magic magic = GZipHeader.peekMagicNumber(this.remaining);
                        if (magic == GZipHeader.Magic.GZIP) {
                            log.debug("Found a GZip magic number header -- using GZip encoding");
                            this.mode = 4;
                            this.doInflate(cx, flushFlag, cb);
                            return;
                        }
                        if (magic != GZipHeader.Magic.UNDEFINED) break;
                        log.debug("Found magic number header-- using inflate encoding");
                        this.mode = 2;
                        this.doInflate(cx, flushFlag, cb);
                        return;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            if (!this.headerDone) {
                cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Context.getUndefinedValue(), Context.getUndefinedValue(), true});
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("New input for inflater: {}", (Object)this.remaining);
            }
            if (this.remaining != null && this.remaining.hasRemaining()) {
                this.totalSupplied += (long)this.remaining.remaining();
                this.inflater.setInput(this.remaining.array(), this.remaining.arrayOffset() + this.remaining.position(), this.remaining.remaining());
                if (this.mode == 4) {
                    this.trailerBuf.write(this.remaining.array(), this.remaining.arrayOffset() + this.remaining.position(), this.remaining.remaining());
                }
                this.remaining = null;
            }
            boolean done = this.inflater.finished();
            while (!done) {
                byte[] outBuf = new byte[8192];
                int count = this.inflater.inflate(outBuf);
                boolean bl = done = count == 0 && (this.inflater.needsInput() || this.inflater.finished()) && !this.inflater.needsDictionary();
                if (log.isDebugEnabled()) {
                    log.debug("Inflater produced {}. needsInput = {} finished = {} needsDict = {}", new Object[]{count, this.inflater.needsInput(), this.inflater.finished(), this.inflater.needsDictionary()});
                }
                if (count > 0) {
                    Buffer.BufferImpl outChunk = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this, outBuf, 0, count);
                    if (this.mode == 4) {
                        this.checksum.update(outBuf, 0, count);
                    }
                    cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Context.getUndefinedValue(), outChunk, false});
                }
                if (!this.inflater.needsDictionary()) continue;
                if (this.dictionary == null) {
                    cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Utils.makeErrorObject(cx, (Scriptable)this, "Missing dictionary")});
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Inflater setting dictionary {}", (Object)this.dictionary);
                }
                try {
                    this.inflater.setDictionary(this.dictionary.getArray(), this.dictionary.getArrayOffset(), this.dictionary.getLength());
                }
                catch (IllegalArgumentException e) {
                    cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Utils.makeErrorObject(cx, (Scriptable)this, "Bad dictionary")});
                    return;
                }
            }
            int leftover = (int)(this.totalSupplied - this.inflater.getBytesRead());
            if (log.isDebugEnabled()) {
                log.debug("{} bytes remaining from supplied input", (Object)this.remaining);
            }
            if (this.inflater.finished() && !this.trailerDone) {
                if (this.mode == 4) {
                    if (leftover >= 8) {
                        byte[] trailer = this.trailerBuf.toByteArray();
                        assert (trailer.length == 8);
                        ByteBuffer tb = ByteBuffer.wrap(trailer, 0, 8);
                        GZipHeader.Trailer t = GZipHeader.readGZipTrailer(tb);
                        if (t.getLength() != this.inflater.getBytesWritten()) {
                            throw new DataFormatException("Bad length: expected " + t.getLength() + " and actually read " + this.inflater.getBytesWritten());
                        }
                        if (t.getChecksum() != this.checksum.getValue()) {
                            throw new DataFormatException("Bad crc: expected " + t.getChecksum() + " and actually got " + this.checksum.getValue());
                        }
                        this.trailerDone = true;
                    }
                } else {
                    this.trailerDone = true;
                }
            }
            cb.call(cx, (Scriptable)this, (Scriptable)this, new Object[]{Context.getUndefinedValue(), Context.getUndefinedValue(), true});
        }

        private void setParentModule(ZLibImpl parentModule) {
            this.parentModule = parentModule;
        }
    }

    public static class ZLibImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_zlibClass";
        protected NodeRuntime runner;
        protected Executor pool;

        public String getClassName() {
            return CLASS_NAME;
        }

        public ZLibImpl() {
            this.put("Z_NO_FLUSH", (Scriptable)this, 0);
            this.put("Z_PARTIAL_FLUSH", (Scriptable)this, 1);
            this.put("Z_SYNC_FLUSH", (Scriptable)this, 2);
            this.put("Z_FULL_FLUSH", (Scriptable)this, 3);
            this.put("Z_FINISH", (Scriptable)this, 4);
            this.put("Z_BLOCK", (Scriptable)this, 5);
            this.put("Z_TREES", (Scriptable)this, 6);
            this.put("Z_OK", (Scriptable)this, 0);
            this.put("Z_STREAM_END", (Scriptable)this, 1);
            this.put("Z_NEED_DICT", (Scriptable)this, 2);
            this.put("Z_ERRNO", (Scriptable)this, -1);
            this.put("Z_STREAM_ERROR", (Scriptable)this, -2);
            this.put("Z_DATA_ERROR", (Scriptable)this, -3);
            this.put("Z_MEM_ERROR", (Scriptable)this, -4);
            this.put("Z_BUF_ERROR", (Scriptable)this, -5);
            this.put("Z_VERSION_ERROR", (Scriptable)this, -6);
            this.put("Z_NO_COMPRESSION", (Scriptable)this, 0);
            this.put("Z_BEST_SPEED", (Scriptable)this, 1);
            this.put("Z_BEST_COMPRESSION", (Scriptable)this, 9);
            this.put("Z_DEFAULT_COMPRESSION", (Scriptable)this, -1);
            this.put("Z_FILTERED", (Scriptable)this, 1);
            this.put("Z_HUFFMAN_ONLY", (Scriptable)this, 2);
            this.put("Z_RLE", (Scriptable)this, 3);
            this.put("Z_FIXED", (Scriptable)this, 4);
            this.put("Z_DEFAULT_STRATEGY", (Scriptable)this, 0);
            this.put("Z_BINARY", (Scriptable)this, 0);
            this.put("Z_TEXT", (Scriptable)this, 1);
            this.put("Z_ASCII", (Scriptable)this, 1);
            this.put("Z_UNKNOWN", (Scriptable)this, 2);
            this.put("Z_DEFLATED", (Scriptable)this, 8);
            this.put("Z_NULL", (Scriptable)this, 0);
            this.put("DEFLATE", (Scriptable)this, 1);
            this.put("INFLATE", (Scriptable)this, 2);
            this.put("GZIP", (Scriptable)this, 3);
            this.put("GUNZIP", (Scriptable)this, 4);
            this.put("DEFLATERAW", (Scriptable)this, 5);
            this.put("INFLATERAW", (Scriptable)this, 6);
            this.put("UNZIP", (Scriptable)this, 7);
        }

        protected void initialize(NodeRuntime runner, ExecutorService fsPool) {
            this.runner = runner;
            this.pool = fsPool;
        }

        @JSFunction
        public static Object createZLib(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ZLibObjImpl zo = (ZLibObjImpl)cx.newObject(thisObj, "ZLib");
            ZLibImpl self = (ZLibImpl)thisObj;
            zo.setParentModule(self);
            return zo;
        }
    }
}

