/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.crypto.AbstractDH;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;

public class DHImpl
extends AbstractDH {
    public static final String CLASS_NAME = "DiffieHellman";

    public String getClassName() {
        return CLASS_NAME;
    }

    @JSConstructor
    public static Object construct(Context cx, Object[] args, Function ctor, boolean inNew) {
        if (!inNew) {
            return cx.newObject((Scriptable)ctor, CLASS_NAME);
        }
        DHImpl self = new DHImpl();
        ArgUtils.ensureArg(args, 0);
        if (args[0] instanceof Number) {
            int primeLen = ArgUtils.intArg(args, 0);
            try {
                AlgorithmParameterGenerator paramGen = self.getParamGen();
                paramGen.init(primeLen);
                DHParameterSpec params = paramGen.generateParameters().getParameterSpec(DHParameterSpec.class);
                self.prime = params.getP();
            }
            catch (NoSuchAlgorithmException nse) {
                throw new AssertionError((Object)nse);
            }
            catch (InvalidParameterSpecException e) {
                throw Utils.makeError(cx, (Scriptable)ctor, e.toString());
            }
        } else {
            Buffer.BufferImpl primeBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            self.prime = self.intFromBuf(primeBuf, cx);
        }
        return self;
    }

    @JSFunction
    public static Object generateKeys(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHImpl self = (DHImpl)thisObj;
        assert (self.prime != null);
        return self.generateKeys(cx);
    }

    @JSFunction
    public static Object computeSecret(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl keyBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        DHImpl self = (DHImpl)thisObj;
        assert (self.prime != null);
        return self.computeSecret(cx, keyBuf);
    }

    @JSFunction
    public static Object getPrime(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHImpl self = (DHImpl)thisObj;
        if (self.prime == null) {
            return null;
        }
        return self.bufFromInt(self.prime, cx);
    }

    @JSFunction
    public static Object getGenerator(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHImpl self = (DHImpl)thisObj;
        return self.bufFromInt(DH_GENERATOR, cx);
    }

    @JSFunction
    public static Object getPublicKey(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHImpl self = (DHImpl)thisObj;
        if (self.pubKey == null) {
            return null;
        }
        return self.bufFromInt(self.pubKey.getY(), cx);
    }

    @JSFunction
    public static Object getPrivateKey(Context cx, Scriptable thisObj, Object[] args, Function func) {
        DHImpl self = (DHImpl)thisObj;
        if (self.privKey == null) {
            return null;
        }
        return self.bufFromInt(self.privKey.getX(), cx);
    }

    @JSFunction
    public static void setPublicKey(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl keyBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        DHImpl self = (DHImpl)thisObj;
        assert (self.prime != null);
        BigInteger y = self.intFromBuf(keyBuf, cx);
        DHPublicKeySpec spec = new DHPublicKeySpec(y, self.prime, DH_GENERATOR);
        try {
            KeyFactory kf = self.getKeyFactory();
            self.pubKey = (DHPublicKey)kf.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeySpecException e) {
            throw Utils.makeError(cx, (Scriptable)self, e.toString());
        }
    }

    @JSFunction
    public static void setPrivateKey(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl keyBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        DHImpl self = (DHImpl)thisObj;
        assert (self.prime != null);
        BigInteger x = self.intFromBuf(keyBuf, cx);
        DHPrivateKeySpec spec = new DHPrivateKeySpec(x, self.prime, DH_GENERATOR);
        try {
            KeyFactory kf = self.getKeyFactory();
            self.privKey = (DHPrivateKey)kf.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeySpecException e) {
            throw Utils.makeError(cx, (Scriptable)self, e.toString());
        }
    }
}

