/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.net;

import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.net.HTTPGrammar;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class HTTPParsingMachine {
    public static final String CONNECT_METHOD = "CONNECT";
    private final ParsingMode mode;
    private BodyMode bodyMode;
    private Status state;
    private ByteBuffer oddData;
    private boolean readCR;
    private String method;
    private String uri;
    private int majorVersion;
    private int minorVersion;
    private int statusCode;
    private String reasonPhrase;
    private boolean shouldKeepAlive;
    private boolean upgradeHeader;
    private boolean connectionUpgrade;
    private boolean connectMethod;
    private Map.Entry<String, String> lastHeader;
    private Map.Entry<String, String> lastTrailer;
    private int contentLength;
    private int readLength;

    public HTTPParsingMachine(ParsingMode mode) {
        this.mode = mode;
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result parse(ByteBuffer buf) {
        Result r = new Result();
        block11: while (true) {
            switch (this.state) {
                case START: {
                    if (this.processStart(buf, r)) continue block11;
                    return r;
                }
                case HEADERS: {
                    if (this.processHeaders(buf, r)) continue block11;
                    return r;
                }
                case BODY: {
                    if (this.processBody(buf, r)) continue block11;
                    return r;
                }
                case CHUNK_HEADER: {
                    if (this.processChunkHeader(buf)) continue block11;
                    return r;
                }
                case CHUNK_BODY: {
                    if (this.processChunkBody(buf, r)) continue block11;
                    return r;
                }
                case CHUNK_TRAILER: {
                    if (this.processChunkTrailer(buf)) continue block11;
                    return r;
                }
                case TRAILERS: {
                    if (!this.processTrailers(buf, r)) return r;
                    continue block11;
                }
                case COMPLETE: {
                    return r;
                }
                case ERROR: {
                    return r;
                }
            }
            break;
        }
        throw new AssertionError();
    }

    public void reset() {
        this.bodyMode = BodyMode.NONE;
        this.state = Status.START;
        this.oddData = null;
        this.readCR = false;
        this.method = null;
        this.uri = null;
        this.minorVersion = 0;
        this.majorVersion = 0;
        this.statusCode = 0;
        this.reasonPhrase = null;
        this.shouldKeepAlive = false;
        this.upgradeHeader = false;
        this.connectionUpgrade = false;
        this.connectMethod = false;
        this.lastHeader = null;
        this.contentLength = 0;
        this.readLength = -1;
    }

    public void setIgnoreBody(boolean ignore) {
        if (ignore && this.state == Status.BODY) {
            this.state = Status.COMPLETE;
        }
    }

    private boolean processStart(ByteBuffer buf, Result r) {
        String startLine = this.readLine(buf);
        if (startLine == null) {
            this.storeRemaining(buf);
            return false;
        }
        switch (this.mode) {
            case REQUEST: {
                Matcher m = HTTPGrammar.REQUEST_LINE_PATTERN.matcher(startLine);
                if (!m.matches() || m.groupCount() != 4) {
                    this.state = Status.ERROR;
                    return true;
                }
                this.method = m.group(1);
                if (CONNECT_METHOD.equalsIgnoreCase(this.method)) {
                    this.connectMethod = true;
                }
                this.uri = m.group(2);
                try {
                    this.majorVersion = Integer.parseInt(m.group(3));
                    this.minorVersion = Integer.parseInt(m.group(4));
                    break;
                }
                catch (NumberFormatException nfe) {
                    this.state = Status.ERROR;
                    return true;
                }
            }
            case RESPONSE: {
                Matcher m = HTTPGrammar.STATUS_LINE_PATTERN.matcher(startLine);
                if (!m.matches() || m.groupCount() < 4) {
                    this.state = Status.ERROR;
                    return true;
                }
                try {
                    this.majorVersion = Integer.parseInt(m.group(1));
                    this.minorVersion = Integer.parseInt(m.group(2));
                    this.statusCode = Integer.parseInt(m.group(3));
                }
                catch (NumberFormatException nfe) {
                    this.state = Status.ERROR;
                    return true;
                }
                if (m.groupCount() <= 4) break;
                this.reasonPhrase = m.group(4).trim();
            }
        }
        if (this.majorVersion == 1 && this.minorVersion == 1) {
            this.shouldKeepAlive = true;
        }
        this.state = Status.HEADERS;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processHeaders(ByteBuffer buf, Result r) {
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        r.setHeaders(headers);
        String line = this.readLine(buf);
        while (true) {
            if (line == null) {
                this.storeRemaining(buf);
                return false;
            }
            if (line.isEmpty()) {
                this.state = Status.BODY;
                return (!this.upgradeHeader || !this.connectionUpgrade) && !this.connectMethod;
            }
            Matcher m = HTTPGrammar.HEADER_PATTERN.matcher(line);
            if (m.matches() && m.groupCount() == 2) {
                AbstractMap.SimpleEntry<String, String> hdr = new AbstractMap.SimpleEntry<String, String>(m.group(1), m.group(2).trim());
                headers.add(hdr);
                this.lastHeader = hdr;
                if (!this.processHeader((String)hdr.getKey(), (String)hdr.getValue())) {
                    this.state = Status.ERROR;
                    return true;
                }
            } else {
                if (this.lastHeader == null) {
                    this.state = Status.ERROR;
                    return true;
                }
                Matcher cm = HTTPGrammar.HEADER_CONTINUATION_PATTERN.matcher(line);
                if (cm.matches() && cm.groupCount() == 1) {
                    this.lastHeader.setValue(this.lastHeader.getValue() + cm.group(1));
                } else {
                    this.state = Status.ERROR;
                    return true;
                }
            }
            line = this.readLine(buf);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean processTrailers(ByteBuffer buf, Result r) {
        ArrayList<Map.Entry<String, String>> trailers = new ArrayList<Map.Entry<String, String>>();
        r.setTrailers(trailers);
        String line = this.readLine(buf);
        while (true) {
            if (line == null) {
                this.storeRemaining(buf);
                return false;
            }
            if (line.isEmpty()) {
                this.state = Status.COMPLETE;
                return true;
            }
            Matcher m = HTTPGrammar.HEADER_PATTERN.matcher(line);
            if (m.matches() && m.groupCount() == 2) {
                AbstractMap.SimpleEntry<String, String> hdr = new AbstractMap.SimpleEntry<String, String>(m.group(1), m.group(2));
                trailers.add(hdr);
                this.lastTrailer = hdr;
            } else {
                if (this.lastTrailer == null) {
                    this.state = Status.ERROR;
                    return true;
                }
                Matcher cm = HTTPGrammar.HEADER_CONTINUATION_PATTERN.matcher(line);
                if (cm.matches() && cm.groupCount() == 1) {
                    this.lastTrailer.setValue(this.lastTrailer.getValue() + cm.group(1));
                } else {
                    this.state = Status.ERROR;
                    return true;
                }
            }
            line = this.readLine(buf);
        }
    }

    private boolean processHeader(String key, String value) {
        if (key.equalsIgnoreCase("Content-Length")) {
            try {
                this.contentLength = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            this.bodyMode = BodyMode.LENGTH;
        } else if (key.equalsIgnoreCase("Transfer-Encoding")) {
            if (!value.equalsIgnoreCase("identity")) {
                this.bodyMode = BodyMode.CHUNKED;
            }
        } else if (key.equalsIgnoreCase("Connection")) {
            if (value.equalsIgnoreCase("close")) {
                this.shouldKeepAlive = false;
            } else if (value.equalsIgnoreCase("keep-alive")) {
                this.shouldKeepAlive = true;
            } else if (value.equalsIgnoreCase("upgrade")) {
                this.connectionUpgrade = true;
            }
        } else if (key.equalsIgnoreCase("Upgrade")) {
            this.upgradeHeader = true;
        }
        return true;
    }

    private boolean processBody(ByteBuffer buf, Result r) {
        if (this.bodyMode == BodyMode.NONE && (this.mode == ParsingMode.REQUEST || this.mode == ParsingMode.RESPONSE && (this.statusCode >= 300 || this.statusCode < 200 || this.statusCode == 204))) {
            this.contentLength = 0;
            this.bodyMode = BodyMode.LENGTH;
        }
        switch (this.bodyMode) {
            case NONE: {
                return this.processUndelimitedBody(buf, r);
            }
            case LENGTH: {
                return this.processLengthBody(buf, r);
            }
            case CHUNKED: {
                this.state = Status.CHUNK_HEADER;
                return true;
            }
        }
        throw new AssertionError();
    }

    private boolean processUndelimitedBody(ByteBuffer buf, Result r) {
        if (buf == null) {
            this.state = Status.COMPLETE;
            return true;
        }
        if (buf.hasRemaining()) {
            ByteBuffer chunk = buf.duplicate();
            r.setBody(chunk);
            buf.position(buf.limit());
        }
        return false;
    }

    private boolean processLengthBody(ByteBuffer buf, Result r) {
        boolean pr;
        if (this.readLength < 0) {
            this.readLength = 0;
        }
        if (pr = this.processChunk(buf, r)) {
            this.state = Status.COMPLETE;
            return true;
        }
        return false;
    }

    private boolean processChunkHeader(ByteBuffer buf) {
        String line = this.readLine(buf);
        if (line == null) {
            this.storeRemaining(buf);
            return false;
        }
        try {
            String hdr = line;
            int semi = hdr.indexOf(59);
            if (semi > 0) {
                hdr = line.substring(0, semi);
            }
            this.contentLength = Integer.parseInt(hdr, 16);
            this.readLength = 0;
            this.state = this.contentLength == 0 ? Status.TRAILERS : Status.CHUNK_BODY;
            return true;
        }
        catch (NumberFormatException nfe) {
            this.state = Status.ERROR;
            return true;
        }
    }

    private boolean processChunkTrailer(ByteBuffer buf) {
        String line = this.readLine(buf);
        if (line == null) {
            this.storeRemaining(buf);
            return false;
        }
        this.state = this.contentLength == 0 ? Status.TRAILERS : Status.CHUNK_HEADER;
        return true;
    }

    private boolean processChunkBody(ByteBuffer buf, Result r) {
        boolean pc = this.processChunk(buf, r);
        if (pc) {
            if (this.contentLength == 0) {
                this.state = Status.TRAILERS;
                return true;
            }
            this.state = Status.CHUNK_TRAILER;
            return false;
        }
        return false;
    }

    private boolean processChunk(ByteBuffer buf, Result r) {
        int remaining = this.contentLength - this.readLength;
        if (remaining == 0) {
            return true;
        }
        if (buf == null) {
            return false;
        }
        if (!buf.hasRemaining()) {
            return false;
        }
        if (buf.remaining() <= remaining) {
            this.readLength += buf.remaining();
            ByteBuffer chunk = buf.duplicate();
            r.setBody(chunk);
            buf.position(buf.limit());
            return this.readLength == this.contentLength;
        }
        ByteBuffer chunk = buf.duplicate();
        chunk.limit(chunk.position() + remaining);
        buf.position(buf.position() + remaining);
        r.setBody(chunk);
        return true;
    }

    private String readLine(ByteBuffer buf) {
        if (buf == null) {
            return null;
        }
        for (int p = buf.position(); p < buf.limit(); ++p) {
            byte b = buf.get(p);
            if (this.readCR && b == 10) {
                String ret;
                this.readCR = false;
                ByteBuffer line = buf.duplicate();
                line.limit(++p);
                buf.position(p);
                if (this.oddData == null) {
                    ret = Utils.bufferToString(line, Charsets.ASCII);
                } else {
                    this.oddData.flip();
                    ret = Utils.bufferToString(new ByteBuffer[]{this.oddData, line}, Charsets.ASCII);
                    this.oddData.clear();
                }
                assert (ret.endsWith("\r\n"));
                return ret.substring(0, ret.length() - 2);
            }
            this.readCR = !this.readCR && b == 13;
        }
        return null;
    }

    private void storeRemaining(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        if (this.oddData == null) {
            this.oddData = ByteBuffer.allocate(buf.remaining());
        } else if (this.oddData.remaining() < buf.remaining()) {
            ByteBuffer newData = ByteBuffer.allocate(this.oddData.position() + buf.remaining());
            this.oddData.flip();
            newData.put(this.oddData);
            this.oddData = newData;
        }
        this.oddData.put(buf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Result {
        private List<Map.Entry<String, String>> headers;
        private List<Map.Entry<String, String>> trailers;
        private ByteBuffer body;

        public boolean isError() {
            return HTTPParsingMachine.this.state == Status.ERROR;
        }

        public boolean isComplete() {
            return HTTPParsingMachine.this.state == Status.COMPLETE;
        }

        public boolean isHeadersComplete() {
            return HTTPParsingMachine.this.state != Status.START && HTTPParsingMachine.this.state != Status.HEADERS;
        }

        public boolean shouldKeepAlive() {
            return HTTPParsingMachine.this.shouldKeepAlive;
        }

        public boolean isUpgradeRequested() {
            return HTTPParsingMachine.this.upgradeHeader && HTTPParsingMachine.this.connectionUpgrade;
        }

        public boolean isConnectRequest() {
            return HTTPParsingMachine.this.connectMethod;
        }

        public String getUri() {
            return HTTPParsingMachine.this.uri;
        }

        public String getMethod() {
            return HTTPParsingMachine.this.method;
        }

        public int getMajor() {
            return HTTPParsingMachine.this.majorVersion;
        }

        public int getMinor() {
            return HTTPParsingMachine.this.minorVersion;
        }

        public int getStatusCode() {
            return HTTPParsingMachine.this.statusCode;
        }

        public List<Map.Entry<String, String>> getHeaders() {
            return this.headers;
        }

        void setHeaders(List<Map.Entry<String, String>> h) {
            this.headers = h;
        }

        public boolean hasHeaders() {
            return this.headers != null && !this.headers.isEmpty();
        }

        public List<Map.Entry<String, String>> getTrailers() {
            return this.trailers;
        }

        void setTrailers(List<Map.Entry<String, String>> h) {
            this.trailers = h;
        }

        public boolean hasTrailers() {
            return this.trailers != null && !this.trailers.isEmpty();
        }

        public ByteBuffer getBody() {
            return this.body;
        }

        public void setBody(ByteBuffer body) {
            this.body = body;
        }

        public boolean hasBody() {
            return this.body != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BodyMode {
        NONE,
        LENGTH,
        CHUNKED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        START,
        HEADERS,
        BODY,
        CHUNK_HEADER,
        CHUNK_BODY,
        CHUNK_TRAILER,
        TRAILERS,
        COMPLETE,
        ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParsingMode {
        REQUEST,
        RESPONSE;

    }
}

