/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.journal.leveldb;

import akka.persistence.PersistentConfirmation;
import akka.persistence.PersistentId;
import akka.persistence.PersistentRepr;
import akka.persistence.journal.leveldb.Key;
import akka.persistence.journal.leveldb.Key$;
import akka.persistence.journal.leveldb.LeveldbStore;
import akka.persistence.journal.leveldb.LeveldbStore$;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import java.io.File;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.iq80.leveldb.impl.Iq80DBFactory;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

public abstract class LeveldbStore$class {
    public static ReadOptions leveldbReadOptions(LeveldbStore $this) {
        return new ReadOptions().verifyChecksums($this.config().getBoolean("checksum"));
    }

    public static DBFactory leveldbFactory(LeveldbStore $this) {
        return $this.nativeLeveldb() ? JniDBFactory.factory : Iq80DBFactory.factory;
    }

    public static void writeMessages(LeveldbStore $this, Seq messages) {
        $this.withBatch(new Serializable($this, messages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final Seq messages$1;

            public final void apply(WriteBatch batch) {
                this.messages$1.foreach((Function1)new Serializable(this, batch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LeveldbStore$.anonfun.writeMessages.1 $outer;
                    private final WriteBatch batch$1;

                    public final void apply(PersistentRepr message) {
                        LeveldbStore$class.akka$persistence$journal$leveldb$LeveldbStore$$addToMessageBatch(this.$outer.akka$persistence$journal$leveldb$LeveldbStore$$anonfun$$$outer(), message, this.batch$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.batch$1 = batch$1;
                    }
                });
            }

            public /* synthetic */ LeveldbStore akka$persistence$journal$leveldb$LeveldbStore$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messages$1 = messages$1;
            }
        });
    }

    public static void writeConfirmations(LeveldbStore $this, Seq confirmations) {
        $this.withBatch(new Serializable($this, confirmations){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final Seq confirmations$1;

            public final void apply(WriteBatch batch) {
                this.confirmations$1.foreach((Function1)new Serializable(this, batch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LeveldbStore$.anonfun.writeConfirmations.1 $outer;
                    private final WriteBatch batch$2;

                    public final void apply(PersistentConfirmation confirmation) {
                        LeveldbStore$class.akka$persistence$journal$leveldb$LeveldbStore$$addToConfirmationBatch(this.$outer.akka$persistence$journal$leveldb$LeveldbStore$$anonfun$$$outer(), confirmation, this.batch$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.batch$2 = batch$2;
                    }
                });
            }

            public /* synthetic */ LeveldbStore akka$persistence$journal$leveldb$LeveldbStore$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.confirmations$1 = confirmations$1;
            }
        });
    }

    public static void deleteMessages(LeveldbStore $this, Seq messageIds, boolean permanent) {
        $this.withBatch(new Serializable($this, messageIds, permanent){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final Seq messageIds$1;
            public final boolean permanent$1;

            public final void apply(WriteBatch batch) {
                this.messageIds$1.foreach((Function1)new Serializable(this, batch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LeveldbStore$.anonfun.deleteMessages.1 $outer;
                    private final WriteBatch batch$3;

                    public final WriteBatch apply(PersistentId messageId) {
                        return this.$outer.permanent$1 ? this.batch$3.delete(Key$.MODULE$.keyToBytes(new Key(this.$outer.akka$persistence$journal$leveldb$LeveldbStore$$anonfun$$$outer().numericId(messageId.persistenceId()), messageId.sequenceNr(), 0))) : this.batch$3.put(Key$.MODULE$.keyToBytes(Key$.MODULE$.deletionKey(this.$outer.akka$persistence$journal$leveldb$LeveldbStore$$anonfun$$$outer().numericId(messageId.persistenceId()), messageId.sequenceNr())), Array$.MODULE$.emptyByteArray());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.batch$3 = batch$3;
                    }
                });
            }

            public /* synthetic */ LeveldbStore akka$persistence$journal$leveldb$LeveldbStore$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messageIds$1 = messageIds$1;
                this.permanent$1 = permanent$1;
            }
        });
    }

    public static void deleteMessagesTo(LeveldbStore $this, String persistenceId, long toSequenceNr, boolean permanent) {
        $this.withBatch(new Serializable($this, persistenceId, toSequenceNr, permanent){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final String persistenceId$1;
            private final long toSequenceNr$1;
            public final boolean permanent$2;

            public final void apply(WriteBatch batch) {
                int nid = this.$outer.numericId(this.persistenceId$1);
                long fromSequenceNr = BoxesRunTime.unboxToLong(this.$outer.withIterator(new Serializable(this, nid){
                    public static final long serialVersionUID = 0L;
                    private final int nid$1;

                    public final long apply(DBIterator iter) {
                        Key startKey = new Key(this.nid$1, 1L, 0);
                        iter.seek(Key$.MODULE$.keyToBytes(startKey));
                        return iter.hasNext() ? Key$.MODULE$.keyFromBytes((byte[])iter.peekNext().getKey()).sequenceNr() : Long.MAX_VALUE;
                    }
                    {
                        this.nid$1 = nid$1;
                    }
                }));
                new RichLong(Predef$.MODULE$.longWrapper(fromSequenceNr)).to((Object)BoxesRunTime.boxToLong((long)this.toSequenceNr$1)).foreach((Function1)new Serializable(this, batch, nid){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LeveldbStore$.anonfun.deleteMessagesTo.1 $outer;
                    private final WriteBatch batch$4;
                    private final int nid$1;

                    public final WriteBatch apply(long sequenceNr) {
                        return this.$outer.permanent$2 ? this.batch$4.delete(Key$.MODULE$.keyToBytes(new Key(this.nid$1, sequenceNr, 0))) : this.batch$4.put(Key$.MODULE$.keyToBytes(Key$.MODULE$.deletionKey(this.nid$1, sequenceNr)), Array$.MODULE$.emptyByteArray());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.batch$4 = batch$4;
                        this.nid$1 = nid$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.persistenceId$1 = persistenceId$1;
                this.toSequenceNr$1 = toSequenceNr$1;
                this.permanent$2 = permanent$2;
            }
        });
    }

    public static ReadOptions leveldbSnapshot(LeveldbStore $this) {
        return $this.leveldbReadOptions().snapshot($this.leveldb().getSnapshot());
    }

    public static Object withIterator(LeveldbStore $this, Function1 body) {
        ReadOptions ro = $this.leveldbSnapshot();
        DBIterator iterator = $this.leveldb().iterator(ro);
        try {
            return body.apply((Object)iterator);
        }
        finally {
            iterator.close();
            ro.snapshot().close();
        }
    }

    public static Object withBatch(LeveldbStore $this, Function1 body) {
        WriteBatch batch = $this.leveldb().createWriteBatch();
        try {
            Object r = body.apply((Object)batch);
            $this.leveldb().write(batch, $this.leveldbWriteOptions());
            return r;
        }
        finally {
            batch.close();
        }
    }

    public static byte[] persistentToBytes(LeveldbStore $this, PersistentRepr p) {
        return (byte[])$this.serialization().serialize((Object)p).get();
    }

    public static PersistentRepr persistentFromBytes(LeveldbStore $this, byte[] a) {
        return (PersistentRepr)$this.serialization().deserialize(a, PersistentRepr.class).get();
    }

    public static void akka$persistence$journal$leveldb$LeveldbStore$$addToMessageBatch(LeveldbStore $this, PersistentRepr persistent, WriteBatch batch) {
        int nid = $this.numericId(persistent.persistenceId());
        batch.put(Key$.MODULE$.keyToBytes(Key$.MODULE$.counterKey(nid)), Key$.MODULE$.counterToBytes(persistent.sequenceNr()));
        batch.put(Key$.MODULE$.keyToBytes(new Key(nid, persistent.sequenceNr(), 0)), $this.persistentToBytes(persistent));
    }

    public static void akka$persistence$journal$leveldb$LeveldbStore$$addToConfirmationBatch(LeveldbStore $this, PersistentConfirmation confirmation, WriteBatch batch) {
        int npid = $this.numericId(confirmation.persistenceId());
        int ncid = $this.numericId(confirmation.channelId());
        batch.put(Key$.MODULE$.keyToBytes(new Key(npid, confirmation.sequenceNr(), ncid)), confirmation.channelId().getBytes("UTF-8"));
    }

    public static void preStart(LeveldbStore $this) {
        $this.leveldb_$eq($this.leveldbFactory().open($this.leveldbDir(), $this.nativeLeveldb() ? $this.leveldbOptions() : $this.leveldbOptions().compressionType(CompressionType.NONE)));
        $this.akka$persistence$journal$leveldb$LeveldbStore$$super$preStart();
    }

    public static void postStop(LeveldbStore $this) {
        $this.leveldb().close();
        $this.akka$persistence$journal$leveldb$LeveldbStore$$super$postStop();
    }

    public static void $init$(LeveldbStore $this) {
        $this.akka$persistence$journal$leveldb$LeveldbStore$_setter_$config_$eq($this.context().system().settings().config().getConfig($this.configPath()));
        $this.akka$persistence$journal$leveldb$LeveldbStore$_setter_$nativeLeveldb_$eq($this.config().getBoolean("native"));
        $this.akka$persistence$journal$leveldb$LeveldbStore$_setter_$leveldbOptions_$eq(new Options().createIfMissing(true));
        $this.akka$persistence$journal$leveldb$LeveldbStore$_setter_$leveldbWriteOptions_$eq(new WriteOptions().sync($this.config().getBoolean("fsync")).snapshot(false));
        $this.akka$persistence$journal$leveldb$LeveldbStore$_setter_$leveldbDir_$eq(new File($this.config().getString("dir")));
        $this.akka$persistence$journal$leveldb$LeveldbStore$_setter_$serialization_$eq((Serialization)SerializationExtension$.MODULE$.apply($this.context().system()));
    }
}

