/*
 * Decompiled with CFR 0.152.
 */
package play;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.Mode;
import play.libs.Scala;

@Singleton
public class Environment {
    private final play.api.Environment env;

    @Inject
    public Environment(play.api.Environment environment) {
        this.env = environment;
    }

    public Environment(File file2, ClassLoader classLoader, play.Mode mode) {
        this(new play.api.Environment(file2, classLoader, Mode.apply(mode.ordinal())));
    }

    public Environment(File file2, play.Mode mode) {
        this(file2, Environment.class.getClassLoader(), mode);
    }

    public Environment(File file2) {
        this(file2, Environment.class.getClassLoader(), play.Mode.TEST);
    }

    public Environment(play.Mode mode) {
        this(new File("."), Environment.class.getClassLoader(), mode);
    }

    public File rootPath() {
        return this.env.rootPath();
    }

    public ClassLoader classLoader() {
        return this.env.classLoader();
    }

    public play.Mode mode() {
        if (this.env.mode().equals((Object)Mode.Prod())) {
            return play.Mode.PROD;
        }
        if (this.env.mode().equals((Object)Mode.Dev())) {
            return play.Mode.DEV;
        }
        return play.Mode.TEST;
    }

    public boolean isDev() {
        return this.mode().equals((Object)play.Mode.DEV);
    }

    public boolean isProd() {
        return this.mode().equals((Object)play.Mode.PROD);
    }

    public boolean isTest() {
        return this.mode().equals((Object)play.Mode.TEST);
    }

    public File getFile(String string2) {
        return this.env.getFile(string2);
    }

    public URL resource(String string2) {
        return Scala.orNull(this.env.resource(string2));
    }

    public InputStream resourceAsStream(String string2) {
        return Scala.orNull(this.env.resourceAsStream(string2));
    }

    public static Environment simple() {
        return new Environment(new File("."), Environment.class.getClassLoader(), play.Mode.TEST);
    }

    public play.api.Environment underlying() {
        return this.env;
    }
}

