/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import play.api.mvc.ResponseHeader;
import play.core.j.JavaResultExtractor;
import play.http.HttpEntity;
import play.mvc.Http;
import scala.Option;
import scala.collection.JavaConversions;
import scala.compat.java8.OptionConverters;

public class Result {
    private final ResponseHeader header;
    private final HttpEntity body;

    public Result(ResponseHeader responseHeader, HttpEntity httpEntity) {
        this.header = responseHeader;
        this.body = httpEntity;
    }

    public Result(int n, Optional<String> optional, Map<String, String> map2, HttpEntity httpEntity) {
        this(new ResponseHeader(n, map2, (Option<String>)OptionConverters.toScala(optional)), httpEntity);
    }

    public Result(int n, Map<String, String> map2, HttpEntity httpEntity) {
        this(n, Optional.empty(), map2, httpEntity);
    }

    public Result(int n, Map<String, String> map2) {
        this(n, Optional.empty(), map2, HttpEntity.NO_ENTITY);
    }

    public Result(int n, HttpEntity httpEntity) {
        this(n, Optional.empty(), Collections.emptyMap(), httpEntity);
    }

    public Result(int n) {
        this(n, Optional.empty(), Collections.emptyMap(), HttpEntity.NO_ENTITY);
    }

    public int status() {
        return this.header.status();
    }

    public Optional<String> reasonPhrase() {
        return OptionConverters.toJava(this.header.reasonPhrase());
    }

    protected ResponseHeader header() {
        return this.header;
    }

    public HttpEntity body() {
        return this.body;
    }

    public Optional<String> redirectLocation() {
        return this.header("Location");
    }

    public Optional<String> header(String string2) {
        return OptionConverters.toJava((Option)this.header.headers().get((Object)string2));
    }

    public Map<String, String> headers() {
        return Collections.unmodifiableMap(JavaConversions.mapAsJavaMap(this.header.headers()));
    }

    public Optional<String> contentType() {
        return this.body.contentType().map(string2 -> {
            if (string2.contains(";")) {
                return string2.substring(0, string2.indexOf(";")).trim();
            }
            return string2.trim();
        });
    }

    public Optional<String> charset() {
        return this.body.contentType().flatMap(string2 -> {
            if (string2.contains("; charset=")) {
                return Optional.of(string2.substring(string2.indexOf("; charset=") + 10, string2.length()).trim());
            }
            return Optional.empty();
        });
    }

    public Http.Flash flash() {
        return JavaResultExtractor.getFlash(this.header);
    }

    public Http.Session session() {
        return JavaResultExtractor.getSession(this.header);
    }

    public Http.Cookie cookie(String string2) {
        return JavaResultExtractor.getCookies(this.header).get(string2);
    }

    public Http.Cookies cookies() {
        return JavaResultExtractor.getCookies(this.header);
    }

    public Result withHeader(String string2, String string3) {
        return new Result(JavaResultExtractor.withHeader(this.header, string2, string3), this.body);
    }

    public Result withHeaders(String ... stringArray) {
        return new Result(JavaResultExtractor.withHeader(this.header, stringArray), this.body);
    }

    public Result as(String string2) {
        return new Result(this.header, this.body.as(string2));
    }

    public play.api.mvc.Result asScala() {
        return new play.api.mvc.Result(this.header, this.body.asScala());
    }
}

