/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import play.inject.Injector;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.With;
import play.twirl.api.Content;
import views.html.defaultpages.unauthorized;

public class Security {

    public static class Authenticator
    extends Results {
        public String getUsername(Http.Context context) {
            return (String)context.session().get("username");
        }

        public Result onUnauthorized(Http.Context context) {
            return Authenticator.unauthorized((Content)unauthorized.render());
        }
    }

    public static class AuthenticatedAction
    extends Action<Authenticated> {
        private final Injector injector;

        @Inject
        public AuthenticatedAction(Injector injector2) {
            this.injector = injector2;
        }

        @Override
        public CompletionStage<Result> call(Http.Context context) {
            Authenticator authenticator = this.injector.instanceOf(((Authenticated)this.configuration).value());
            String string2 = authenticator.getUsername(context);
            if (string2 == null) {
                Result result2 = authenticator.onUnauthorized(context);
                return CompletableFuture.completedFuture(result2);
            }
            try {
                context.request().setUsername(string2);
                return this.delegate.call(context).whenComplete((result, throwable) -> context.request().setUsername(null));
            }
            catch (Exception exception) {
                context.request().setUsername(null);
                throw exception;
            }
        }
    }

    @With(value={AuthenticatedAction.class})
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Authenticated {
        public Class<? extends Authenticator> value() default Authenticator.class;
    }
}

