/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.stream.javadsl.Flow;
import akka.util.ByteString;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.http.websocket.CloseCodes;
import play.api.libs.streams.AkkaStreams;
import play.http.websocket.Message;
import play.libs.F;
import play.libs.Json;
import play.libs.Scala;
import play.mvc.Http;
import play.mvc.LegacyWebSocket;
import play.mvc.Result;
import scala.PartialFunction;

public abstract class WebSocket {
    public static final MappedWebSocketAcceptor<String, String> Text = new MappedWebSocketAcceptor(Scala.partialFunction(message -> {
        if (message instanceof Message.Text) {
            return F.Either.Left(((Message.Text)message).data());
        }
        if (message instanceof Message.Binary) {
            return F.Either.Right(new Message.Close(CloseCodes.Unacceptable(), "This websocket only accepts text frames"));
        }
        throw Scala.noMatch();
    }), Message.Text::new);
    public static final MappedWebSocketAcceptor<ByteString, ByteString> Binary = new MappedWebSocketAcceptor(Scala.partialFunction(message -> {
        if (message instanceof Message.Binary) {
            return F.Either.Left(((Message.Binary)message).data());
        }
        if (message instanceof Message.Text) {
            return F.Either.Right(new Message.Close(CloseCodes.Unacceptable(), "This websocket only accepts binary frames"));
        }
        throw Scala.noMatch();
    }), Message.Binary::new);
    public static final MappedWebSocketAcceptor<JsonNode, JsonNode> Json = new MappedWebSocketAcceptor(Scala.partialFunction(message -> {
        try {
            if (message instanceof Message.Binary) {
                return F.Either.Left(play.libs.Json.parse((InputStream)((Message.Binary)message).data().iterator().asInputStream()));
            }
            if (message instanceof Message.Text) {
                return F.Either.Left(play.libs.Json.parse((String)((Message.Text)message).data()));
            }
        }
        catch (RuntimeException runtimeException) {
            return F.Either.Right(new Message.Close(CloseCodes.Unacceptable(), "Unable to parse JSON message"));
        }
        throw Scala.noMatch();
    }), jsonNode -> new Message.Text(play.libs.Json.stringify((JsonNode)jsonNode)));

    public abstract CompletionStage<F.Either<Result, Flow<Message, Message, ?>>> apply(Http.RequestHeader var1);

    public static <In, Out> MappedWebSocketAcceptor<In, Out> json(Class<In> clazz) {
        return new MappedWebSocketAcceptor(Scala.partialFunction(message -> {
            try {
                if (message instanceof Message.Binary) {
                    return F.Either.Left(play.libs.Json.mapper().readValue(((Message.Binary)message).data().iterator().asInputStream(), clazz));
                }
                if (message instanceof Message.Text) {
                    return F.Either.Left(play.libs.Json.mapper().readValue(((Message.Text)message).data(), clazz));
                }
            }
            catch (Exception exception) {
                return F.Either.Right(new Message.Close(CloseCodes.Unacceptable(), exception.getMessage()));
            }
            throw Scala.noMatch();
        }), object -> {
            try {
                return new Message.Text(play.libs.Json.mapper().writeValueAsString(object));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static <In, Out> WebSocket acceptOrResult(final PartialFunction<Message, F.Either<In, Message>> partialFunction, final Function<Http.RequestHeader, CompletionStage<F.Either<Result, Flow<In, Out, ?>>>> function, final Function<Out, Message> function2) {
        return new WebSocket(){

            @Override
            public CompletionStage<F.Either<Result, Flow<Message, Message, ?>>> apply(Http.RequestHeader requestHeader) {
                return ((CompletionStage)function.apply(requestHeader)).thenApply(either -> {
                    if (either.left.isPresent()) {
                        return F.Either.Left(either.left.get());
                    }
                    Flow flow2 = play.libs.streams.AkkaStreams.bypassWith(Flow.create().collect(partialFunction), AkkaStreams.onlyFirstCanFinishMerge((int)2), ((Flow)either.right.get()).map(function2::apply));
                    return F.Either.Right(flow2);
                });
            }
        };
    }

    @Deprecated
    public static <A> LegacyWebSocket<A> whenReady(BiConsumer<In<A>, Out<A>> biConsumer) {
        return new WhenReadyWebSocket<A>(biConsumer);
    }

    @Deprecated
    public static <A> LegacyWebSocket<A> reject(final Result result) {
        return new LegacyWebSocket<A>(){

            @Override
            public void onReady(In<A> in, Out<A> out) {
            }

            @Override
            public Result rejectWith() {
                return result;
            }
        };
    }

    @Deprecated
    public static <A> LegacyWebSocket<A> withActor(final Function<ActorRef, Props> function) {
        return new LegacyWebSocket<A>(){

            @Override
            public void onReady(In<A> in, Out<A> out) {
            }

            @Override
            public boolean isActor() {
                return true;
            }

            @Override
            public Props actorProps(ActorRef actorRef) {
                try {
                    return (Props)function.apply(actorRef);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Error error2) {
                    throw error2;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        };
    }

    @Deprecated
    static final class WhenReadyWebSocket<A>
    extends LegacyWebSocket<A> {
        private static final Logger logger = LoggerFactory.getLogger(WhenReadyWebSocket.class);
        private final BiConsumer<In<A>, Out<A>> callback;

        WhenReadyWebSocket(BiConsumer<In<A>, Out<A>> biConsumer) {
            if (biConsumer == null) {
                throw new NullPointerException("WebSocket onReady callback cannot be null");
            }
            this.callback = biConsumer;
        }

        @Override
        public void onReady(In<A> in, Out<A> out) {
            try {
                this.callback.accept(in, out);
            }
            catch (Throwable throwable) {
                logger.error("Exception in WebSocket.onReady", throwable);
            }
        }
    }

    @Deprecated
    public static class In<A> {
        public final List<Consumer<A>> callbacks = new CopyOnWriteArrayList<Consumer<A>>();
        public final List<Runnable> closeCallbacks = new CopyOnWriteArrayList<Runnable>();

        public void onMessage(Consumer<A> consumer) {
            this.callbacks.add(consumer);
        }

        public void onClose(Runnable runnable) {
            this.closeCallbacks.add(runnable);
        }
    }

    @Deprecated
    public static interface Out<A> {
        public void write(A var1);

        public void close();
    }

    public static class MappedWebSocketAcceptor<In, Out> {
        private final PartialFunction<Message, F.Either<In, Message>> inMapper;
        private final Function<Out, Message> outMapper;

        public MappedWebSocketAcceptor(PartialFunction<Message, F.Either<In, Message>> partialFunction, Function<Out, Message> function) {
            this.inMapper = partialFunction;
            this.outMapper = function;
        }

        public WebSocket acceptOrResult(Function<Http.RequestHeader, CompletionStage<F.Either<Result, Flow<In, Out, ?>>>> function) {
            return WebSocket.acceptOrResult(this.inMapper, function, this.outMapper);
        }

        public WebSocket accept(Function<Http.RequestHeader, Flow<In, Out, ?>> function) {
            return this.acceptOrResult(requestHeader -> CompletableFuture.completedFuture(F.Either.Right(function.apply((Http.RequestHeader)requestHeader))));
        }
    }
}

