/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ssl;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.ssl.AlgorithmChecker;
import play.api.libs.ws.ssl.AlgorithmConstraint;
import play.api.libs.ws.ssl.AlgorithmConstraintsParser$;
import play.api.libs.ws.ssl.CompositeX509KeyManager;
import play.api.libs.ws.ssl.CompositeX509TrustManager;
import play.api.libs.ws.ssl.ConfigSSLContextBuilder$;
import play.api.libs.ws.ssl.FileBasedKeyStoreBuilder;
import play.api.libs.ws.ssl.KeyManagerConfig;
import play.api.libs.ws.ssl.KeyManagerFactoryWrapper;
import play.api.libs.ws.ssl.KeyStoreBuilder;
import play.api.libs.ws.ssl.KeyStoreConfig;
import play.api.libs.ws.ssl.SSLConfig;
import play.api.libs.ws.ssl.SSLContextBuilder;
import play.api.libs.ws.ssl.SimpleSSLContextBuilder;
import play.api.libs.ws.ssl.StringBasedKeyStoreBuilder;
import play.api.libs.ws.ssl.TrustManagerConfig;
import play.api.libs.ws.ssl.TrustManagerFactoryWrapper;
import play.api.libs.ws.ssl.TrustStoreConfig;
import play.api.libs.ws.ssl.package$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001B\u0001\u0003\u00015\u0011qcQ8oM&<7k\u0015'D_:$X\r\u001f;Ck&dG-\u001a:\u000b\u0005\r!\u0011aA:tY*\u0011QAB\u0001\u0003oNT!a\u0002\u0005\u0002\t1L'm\u001d\u0006\u0003\u0013)\t1!\u00199j\u0015\u0005Y\u0011\u0001\u00029mCf\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005E\u00196\u000bT\"p]R,\u0007\u0010\u001e\"vS2$WM\u001d\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005!\u0011N\u001c4p!\t)2$\u0003\u0002\u001d\u0005\tI1k\u0015'D_:4\u0017n\u001a\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u0005\t2.Z=NC:\fw-\u001a:GC\u000e$xN]=\u0011\u0005U\u0001\u0013BA\u0011\u0003\u0005aYU-_'b]\u0006<WM\u001d$bGR|'/_,sCB\u0004XM\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005\u0019BO];ti6\u000bg.Y4fe\u001a\u000b7\r^8ssB\u0011Q#J\u0005\u0003M\t\u0011!\u0004\u0016:vgRl\u0015M\\1hKJ4\u0015m\u0019;pef<&/\u00199qKJDQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtD\u0003\u0002\u0016,Y5\u0002\"!\u0006\u0001\t\u000be9\u0003\u0019\u0001\u000e\t\u000by9\u0003\u0019A\u0010\t\u000b\r:\u0003\u0019\u0001\u0013\t\u000f=\u0002!\u0019!C\ta\u00051An\\4hKJ,\u0012!\r\t\u0003e]j\u0011a\r\u0006\u0003iU\nQa\u001d7gi)T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d4\u0005\u0019aunZ4fe\"1!\b\u0001Q\u0001\nE\nq\u0001\\8hO\u0016\u0014\b\u0005C\u0003=\u0001\u0011\u0005Q(A\u0003ck&dG\rF\u0001?!\tyT)D\u0001A\u0015\t\u0019\u0011I\u0003\u0002C\u0007\u0006\u0019a.\u001a;\u000b\u0003\u0011\u000bQA[1wCbL!A\u0012!\u0003\u0015M\u001bFjQ8oi\u0016DH\u000f\u0003\u0005I\u0001!\u0015\r\u0011\"\u0001J\u0003=\u0011XM^8dCRLwN\u001c'jgR\u001cX#\u0001&\u0011\u0007=YU*\u0003\u0002M!\t1q\n\u001d;j_:\u00042A\u0014,Z\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002S\u0019\u00051AH]8pizJ\u0011!E\u0005\u0003+B\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n\u00191+Z9\u000b\u0005U\u0003\u0002C\u0001.b\u001b\u0005Y&B\u0001/^\u0003\u0011\u0019WM\u001d;\u000b\u0005y{\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003\u0001\fAA[1wC&\u0011!m\u0017\u0002\u0004\u0007Jc\u0005\u0002\u00033\u0001\u0011\u0003\u0005\u000b\u0015\u0002&\u0002!I,go\\2bi&|g\u000eT5tiN\u0004\u0003\u0002\u00034\u0001\u0011\u000b\u0007I\u0011A4\u0002)MLwM\\1ukJ,7i\u001c8tiJ\f\u0017N\u001c;t+\u0005A\u0007cA5oa6\t!N\u0003\u0002lY\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003[B\t!bY8mY\u0016\u001cG/[8o\u0013\ty'NA\u0002TKR\u0004\"!F9\n\u0005I\u0014!aE!mO>\u0014\u0018\u000e\u001e5n\u0007>t7\u000f\u001e:bS:$\b\u0002\u0003;\u0001\u0011\u0003\u0005\u000b\u0015\u00025\u0002+MLwM\\1ukJ,7i\u001c8tiJ\f\u0017N\u001c;tA!Aa\u000f\u0001EC\u0002\u0013\u0005q-\u0001\nlKf\u001c\u0016N_3D_:\u001cHO]1j]R\u001c\b\u0002\u0003=\u0001\u0011\u0003\u0005\u000b\u0015\u00025\u0002'-,\u0017pU5{K\u000e{gn\u001d;sC&tGo\u001d\u0011\t\u0011i\u0004\u0001R1A\u0005\u0002m\f\u0001#\u00197h_JLG\u000f[7DQ\u0016\u001c7.\u001a:\u0016\u0003q\u0004\"!F?\n\u0005y\u0014!\u0001E!mO>\u0014\u0018\u000e\u001e5n\u0007\",7m[3s\u0011%\t\t\u0001\u0001E\u0001B\u0003&A0A\tbY\u001e|'/\u001b;i[\u000eCWmY6fe\u0002B!\"!\u0002\u0001\u0011\u000b\u0007I\u0011AA\u0004\u0003-YW-_'b]\u0006<WM]:\u0016\u0005\u0005%\u0001\u0003\u0002(W\u0003\u0017\u00012aPA\u0007\u0013\r\ty\u0001\u0011\u0002\u000b\u0017\u0016LX*\u00198bO\u0016\u0014\bBCA\n\u0001!\u0005\t\u0015)\u0003\u0002\n\u0005a1.Z=NC:\fw-\u001a:tA!Q\u0011q\u0003\u0001\t\u0006\u0004%\t!!\u0007\u0002\u001bQ\u0014Xo\u001d;NC:\fw-\u001a:t+\t\tY\u0002\u0005\u0003O-\u0006u\u0001cA \u0002 %\u0019\u0011\u0011\u0005!\u0003\u0019Q\u0013Xo\u001d;NC:\fw-\u001a:\t\u0015\u0005\u0015\u0002\u0001#A!B\u0013\tY\"\u0001\bueV\u001cH/T1oC\u001e,'o\u001d\u0011\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u0005y!-^5mIN\u001bFjQ8oi\u0016DH\u000fF\u0005?\u0003[\ty$!\u0011\u0002D!A\u0011qFA\u0014\u0001\u0004\t\t$\u0001\u0005qe>$xnY8m!\u0011\t\u0019$!\u000f\u000f\u0007=\t)$C\u0002\u00028A\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u001e\u0003{\u0011aa\u0015;sS:<'bAA\u001c!!A\u0011QAA\u0014\u0001\u0004\tI\u0001\u0003\u0005\u0002\u0018\u0005\u001d\u0002\u0019AA\u000e\u0011!\t)%a\nA\u0002\u0005\u001d\u0013\u0001D:fGV\u0014XMU1oI>l\u0007\u0003B\bL\u0003\u0013\u0002B!a\u0013\u0002N5\tQ,C\u0002\u0002Pu\u0013AbU3dkJ,'+\u00198e_6Dq!a\u0015\u0001\t\u0003\t)&\u0001\rck&dGmQ8na>\u001c\u0018\u000e^3LKfl\u0015M\\1hKJ$b!a\u0016\u0002^\u0005\u001d\u0004cA\u000b\u0002Z%\u0019\u00111\f\u0002\u0003/\r{W\u000e]8tSR,\u0007,\u000e\u0019:\u0017\u0016LX*\u00198bO\u0016\u0014\b\u0002CA0\u0003#\u0002\r!!\u0019\u0002!-,\u00170T1oC\u001e,'oQ8oM&<\u0007cA\u000b\u0002d%\u0019\u0011Q\r\u0002\u0003!-+\u00170T1oC\u001e,'oQ8oM&<\u0007B\u0002>\u0002R\u0001\u0007A\u0010C\u0004\u0002l\u0001!\t!!\u001c\u00025\t,\u0018\u000e\u001c3D_6\u0004xn]5uKR\u0013Xo\u001d;NC:\fw-\u001a:\u0015\u0015\u0005=\u0014QOA@\u0003\u0013\u000bY\tE\u0002\u0016\u0003cJ1!a\u001d\u0003\u0005e\u0019u.\u001c9pg&$X\rW\u001b1sQ\u0013Xo\u001d;NC:\fw-\u001a:\t\u0011\u0005]\u0014\u0011\u000ea\u0001\u0003s\n\u0001\u0003\u001e:vgRl\u0015M\\1hKJLeNZ8\u0011\u0007U\tY(C\u0002\u0002~\t\u0011!\u0003\u0016:vgRl\u0015M\\1hKJ\u001cuN\u001c4jO\"A\u0011\u0011QA5\u0001\u0004\t\u0019)A\tsKZ|7-\u0019;j_:,e.\u00192mK\u0012\u00042aDAC\u0013\r\t9\t\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019A\u0015\u0011\u000ea\u0001\u0015\"1!0!\u001bA\u0002qDq!a$\u0001\t\u0003\t\t*A\blKf\u001cFo\u001c:f\u0005VLG\u000eZ3s)\u0011\t\u0019*!'\u0011\u0007U\t)*C\u0002\u0002\u0018\n\u0011qbS3z'R|'/\u001a\"vS2$WM\u001d\u0005\t\u00037\u000bi\t1\u0001\u0002\u001e\u0006\u00191n]2\u0011\u0007U\ty*C\u0002\u0002\"\n\u0011abS3z'R|'/Z\"p]\u001aLw\rC\u0004\u0002&\u0002!\t!a*\u0002#Q\u0014Xo\u001d;Ti>\u0014XMQ;jY\u0012,'\u000f\u0006\u0003\u0002\u0014\u0006%\u0006\u0002CAV\u0003G\u0003\r!!,\u0002\u0007Q\u001c8\rE\u0002\u0016\u0003_K1!!-\u0003\u0005A!&/^:u'R|'/Z\"p]\u001aLw\rC\u0004\u00026\u0002!\t!a.\u0002\u0017\u0019LG.\u001a\"vS2$WM\u001d\u000b\t\u0003'\u000bI,!0\u0002B\"A\u00111XAZ\u0001\u0004\t\t$A\u0005ti>\u0014X\rV=qK\"A\u0011qXAZ\u0001\u0004\t\t$\u0001\u0005gS2,\u0007+\u0019;i\u0011!\t\u0019-a-A\u0002\u0005\u0015\u0017\u0001\u00039bgN<xN\u001d3\u0011\t=Y\u0015q\u0019\t\u0006\u001f\u0005%\u0017QZ\u0005\u0004\u0003\u0017\u0004\"!B!se\u0006L\bcA\b\u0002P&\u0019\u0011\u0011\u001b\t\u0003\t\rC\u0017M\u001d\u0005\b\u0003+\u0004A\u0011AAl\u00035\u0019HO]5oO\n+\u0018\u000e\u001c3feR!\u00111SAm\u0011!\tY.a5A\u0002\u0005E\u0012\u0001\u00023bi\u0006Dq!a8\u0001\t\u0003\t\t/\u0001\u000fxCJtwJ\u001c)L\u0007N\u000b$'R7qif\u0004\u0016m]:x_J$')^4\u0015\t\u0005\r\u00151\u001d\u0005\t\u00037\u000bi\u000e1\u0001\u0002\u001e\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\u0018a\u00042vS2$7*Z=NC:\fw-\u001a:\u0015\r\u0005-\u0018\u0011_Az!\ry\u0014Q^\u0005\u0004\u0003_\u0004%A\u0004-6aeZU-_'b]\u0006<WM\u001d\u0005\t\u00037\u000b)\u000f1\u0001\u0002\u001e\"1!0!:A\u0002qDq!a>\u0001\t\u0003\tI0A\rdKJ$\u0018NZ5dCR,'+\u001a<pG\u0006$\u0018n\u001c8MSN$Hc\u0001&\u0002|\"9\u0011Q`A{\u0001\u0004Q\u0012!C:tY\u000e{gNZ5h\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007\t1bZ3oKJ\fG/Z\"S\u0019R\u0019\u0011L!\u0002\t\u0011\t\u001d\u0011q a\u0001\u0005\u0013\t1\"\u001b8qkR\u001cFO]3b[B!!1\u0002B\t\u001b\t\u0011iAC\u0002\u0003\u0010}\u000b!![8\n\t\tM!Q\u0002\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0003\u0018\u0001!\tA!\u0007\u0002%\u001d,g.\u001a:bi\u0016\u001c%\u000b\u0014$s_6,&\u000b\u0014\u000b\u00043\nm\u0001\u0002\u0003B\u000f\u0005+\u0001\rAa\b\u0002\u0007U\u0014H\u000e\u0005\u0003\u0003\"\t\u0015RB\u0001B\u0012\u0015\t\u0011u,\u0003\u0003\u0003(\t\r\"aA+S\u0019\"9!1\u0006\u0001\u0005\u0002\t5\u0012aE4f]\u0016\u0014\u0018\r^3D%23%o\\7GS2,GcA-\u00030!A!\u0011\u0007B\u0015\u0001\u0004\u0011\u0019$\u0001\u0003gS2,\u0007\u0003\u0002B\u0006\u0005kIAAa\u000e\u0003\u000e\t!a)\u001b7f\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005{\t1DY;jY\u0012$&/^:u\u001b\u0006t\u0017mZ3s!\u0006\u0014\u0018-\\3uKJ\u001cHC\u0003B \u0005\u000b\u0012yE!\u0015\u0003TA\u0019qH!\u0011\n\u0007\t\r\u0003I\u0001\u0010DKJ$\b+\u0019;i)J,8\u000f^'b]\u0006<WM\u001d)be\u0006lW\r^3sg\"A!q\tB\u001d\u0001\u0004\u0011I%\u0001\u0006ueV\u001cHo\u0015;pe\u0016\u0004B!a\u0013\u0003L%\u0019!QJ/\u0003\u0011-+\u0017p\u0015;pe\u0016D\u0001\"!!\u0003:\u0001\u0007\u00111\u0011\u0005\u0007\u0011\ne\u0002\u0019\u0001&\t\ri\u0014I\u00041\u0001}\u0011\u001d\u00119\u0006\u0001C\u0001\u00053\n\u0011CY;jY\u0012$&/^:u\u001b\u0006t\u0017mZ3s))\u0011YF!\u0019\u0003d\t\u0015$q\r\t\u0004\u007f\tu\u0013b\u0001B0\u0001\n\u0001\u0002,\u000e\u0019:)J,8\u000f^'b]\u0006<WM\u001d\u0005\t\u0003W\u0013)\u00061\u0001\u0002.\"A\u0011\u0011\u0011B+\u0001\u0004\t\u0019\t\u0003\u0004I\u0005+\u0002\rA\u0013\u0005\u0007u\nU\u0003\u0019\u0001?\t\u000f\t-\u0004\u0001\"\u0001\u0003n\u0005\u0001c/\u00197jI\u0006$Xm\u0015;pe\u0016\u001cuN\u001c;bS:\u001c\bK]5wCR,7*Z=t)\u0019\t\u0019Ia\u001c\u0003r!A\u00111\u0014B5\u0001\u0004\ti\n\u0003\u0005\u0003t\t%\u0004\u0019\u0001B%\u0003!YW-_*u_J,\u0007b\u0002B<\u0001\u0011\u0005!\u0011P\u0001\u000em\u0006d\u0017\u000eZ1uKN#xN]3\u0015\r\tm$\u0011\u0011BC!\ry!QP\u0005\u0004\u0005\u007f\u0002\"\u0001B+oSRD\u0001Ba!\u0003v\u0001\u0007!\u0011J\u0001\u0006gR|'/\u001a\u0005\u0007u\nU\u0004\u0019\u0001?")
public class ConfigSSLContextBuilder
implements SSLContextBuilder {
    private final SSLConfig info;
    private final KeyManagerFactoryWrapper keyManagerFactory;
    private final TrustManagerFactoryWrapper trustManagerFactory;
    private final Logger logger;
    private Option<Seq<CRL>> revocationLists;
    private Set<AlgorithmConstraint> signatureConstraints;
    private Set<AlgorithmConstraint> keySizeConstraints;
    private AlgorithmChecker algorithmChecker;
    private Seq<KeyManager> keyManagers;
    private Seq<TrustManager> trustManagers;
    private volatile byte bitmap$0;

    private Option revocationLists$lzycompute() {
        ConfigSSLContextBuilder configSSLContextBuilder = this;
        synchronized (configSSLContextBuilder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.revocationLists = this.certificateRevocationList(this.info);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.revocationLists;
        }
    }

    private Set signatureConstraints$lzycompute() {
        ConfigSSLContextBuilder configSSLContextBuilder = this;
        synchronized (configSSLContextBuilder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.signatureConstraints = ((TraversableOnce)this.info.disabledSignatureAlgorithms().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AlgorithmConstraint apply(String input) {
                        return AlgorithmConstraintsParser$.MODULE$.apply(input);
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.signatureConstraints;
        }
    }

    private Set keySizeConstraints$lzycompute() {
        ConfigSSLContextBuilder configSSLContextBuilder = this;
        synchronized (configSSLContextBuilder) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.keySizeConstraints = ((TraversableOnce)this.info.disabledKeyAlgorithms().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AlgorithmConstraint apply(String input) {
                        return AlgorithmConstraintsParser$.MODULE$.apply(input);
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.keySizeConstraints;
        }
    }

    private AlgorithmChecker algorithmChecker$lzycompute() {
        ConfigSSLContextBuilder configSSLContextBuilder = this;
        synchronized (configSSLContextBuilder) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.algorithmChecker = new AlgorithmChecker(this.signatureConstraints(), this.keySizeConstraints());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.algorithmChecker;
        }
    }

    private Seq keyManagers$lzycompute() {
        ConfigSSLContextBuilder configSSLContextBuilder = this;
        synchronized (configSSLContextBuilder) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.keyManagers = this.info.keyManagerConfig().keyStoreConfigs().nonEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompositeX509KeyManager[]{this.buildCompositeKeyManager(this.info.keyManagerConfig(), this.algorithmChecker())})) : Nil$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.keyManagers;
        }
    }

    private Seq trustManagers$lzycompute() {
        ConfigSSLContextBuilder configSSLContextBuilder = this;
        synchronized (configSSLContextBuilder) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.trustManagers = this.info.trustManagerConfig().trustStoreConfigs().nonEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompositeX509TrustManager[]{this.buildCompositeTrustManager(this.info.trustManagerConfig(), BoxesRunTime.unboxToBoolean((Object)this.info.checkRevocation().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                })), this.revocationLists(), this.algorithmChecker())})) : Nil$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.trustManagers;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public SSLContext build() {
        return this.buildSSLContext(this.info.protocol(), this.keyManagers(), this.trustManagers(), this.info.secureRandom());
    }

    public Option<Seq<CRL>> revocationLists() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.revocationLists$lzycompute() : this.revocationLists;
    }

    public Set<AlgorithmConstraint> signatureConstraints() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.signatureConstraints$lzycompute() : this.signatureConstraints;
    }

    public Set<AlgorithmConstraint> keySizeConstraints() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.keySizeConstraints$lzycompute() : this.keySizeConstraints;
    }

    public AlgorithmChecker algorithmChecker() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.algorithmChecker$lzycompute() : this.algorithmChecker;
    }

    public Seq<KeyManager> keyManagers() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.keyManagers$lzycompute() : this.keyManagers;
    }

    public Seq<TrustManager> trustManagers() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.trustManagers$lzycompute() : this.trustManagers;
    }

    public SSLContext buildSSLContext(String protocol, Seq<KeyManager> keyManagers, Seq<TrustManager> trustManagers2, Option<SecureRandom> secureRandom) {
        SimpleSSLContextBuilder builder = new SimpleSSLContextBuilder(protocol, keyManagers, trustManagers2, secureRandom);
        return builder.build();
    }

    public CompositeX509KeyManager buildCompositeKeyManager(KeyManagerConfig keyManagerConfig, AlgorithmChecker algorithmChecker) {
        Seq keyManagers = (Seq)keyManagerConfig.keyStoreConfigs().map((Function1)new Serializable(this, algorithmChecker){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final AlgorithmChecker algorithmChecker$1;

            public final X509KeyManager apply(KeyStoreConfig ksc) {
                return this.$outer.buildKeyManager(ksc, this.algorithmChecker$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.algorithmChecker$1 = algorithmChecker$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new CompositeX509KeyManager((Seq<X509KeyManager>)keyManagers);
    }

    public CompositeX509TrustManager buildCompositeTrustManager(TrustManagerConfig trustManagerInfo, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, AlgorithmChecker algorithmChecker) {
        Seq trustManagers2 = (Seq)trustManagerInfo.trustStoreConfigs().map((Function1)new Serializable(this, revocationEnabled, revocationLists, algorithmChecker){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final boolean revocationEnabled$1;
            private final Option revocationLists$1;
            private final AlgorithmChecker algorithmChecker$2;

            public final X509TrustManager apply(TrustStoreConfig tsc) {
                return this.$outer.buildTrustManager(tsc, this.revocationEnabled$1, (Option<Seq<CRL>>)this.revocationLists$1, this.algorithmChecker$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.revocationEnabled$1 = revocationEnabled$1;
                this.revocationLists$1 = revocationLists$1;
                this.algorithmChecker$2 = algorithmChecker$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new CompositeX509TrustManager((Seq<X509TrustManager>)trustManagers2, algorithmChecker);
    }

    public KeyStoreBuilder keyStoreBuilder(KeyStoreConfig ksc) {
        Option password = ksc.password().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final char[] apply(String x$1) {
                return x$1.toCharArray();
            }
        });
        return (KeyStoreBuilder)ksc.filePath().map((Function1)new Serializable(this, ksc, password){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final KeyStoreConfig ksc$2;
            private final Option password$1;

            public final KeyStoreBuilder apply(String f) {
                return this.$outer.fileBuilder(this.ksc$2.storeType(), f, (Option<char[]>)this.password$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ksc$2 = ksc$2;
                this.password$1 = password$1;
            }
        }).getOrElse((Function0)new Serializable(this, ksc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final KeyStoreConfig ksc$2;

            public final KeyStoreBuilder apply() {
                String data = (String)this.ksc$2.data().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new IllegalStateException("No keystore builder found!");
                    }
                });
                return this.$outer.stringBuilder(data);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ksc$2 = ksc$2;
            }
        });
    }

    public KeyStoreBuilder trustStoreBuilder(TrustStoreConfig tsc) {
        return (KeyStoreBuilder)tsc.filePath().map((Function1)new Serializable(this, tsc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final TrustStoreConfig tsc$1;

            public final KeyStoreBuilder apply(String f) {
                return this.$outer.fileBuilder(this.tsc$1.storeType(), f, (Option<char[]>)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tsc$1 = tsc$1;
            }
        }).getOrElse((Function0)new Serializable(this, tsc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final TrustStoreConfig tsc$1;

            public final KeyStoreBuilder apply() {
                String data = (String)this.tsc$1.data().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new IllegalStateException("No truststore builder found!");
                    }
                });
                return this.$outer.stringBuilder(data);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tsc$1 = tsc$1;
            }
        });
    }

    public KeyStoreBuilder fileBuilder(String storeType, String filePath, Option<char[]> password) {
        return new FileBasedKeyStoreBuilder(storeType, filePath, password);
    }

    public KeyStoreBuilder stringBuilder(String data) {
        return new StringBasedKeyStoreBuilder(data);
    }

    public boolean warnOnPKCS12EmptyPasswordBug(KeyStoreConfig ksc) {
        return ksc.storeType().equalsIgnoreCase("pkcs12") && !ksc.password().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return !x$2.isEmpty();
            }
        });
    }

    /*
     * Loose catch block
     */
    public X509KeyManager buildKeyManager(KeyStoreConfig ksc, AlgorithmChecker algorithmChecker) {
        KeyManager[] keyManagers;
        block7: {
            KeyStore keyStore = this.keyStoreBuilder(ksc).build();
            if (!this.validateStoreContainsPrivateKeys(ksc, keyStore)) {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Client authentication is not possible as there are no private keys found in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ksc.filePath()})));
            }
            this.validateStore(keyStore, algorithmChecker);
            Option password = ksc.password().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final char[] apply(String x$3) {
                    return x$3.toCharArray();
                }
            });
            KeyManagerFactoryWrapper factory = this.keyManagerFactory;
            try {
                factory.init(keyStore, (char[])password.orNull(Predef$.MODULE$.$conforms()));
                keyManagers = factory.getKeyManagers();
                if (keyManagers != null) break block7;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecoverable key in keystore ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ksc})));
                throw new IllegalStateException(unrecoverableKeyException);
            }
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot create key manager with configuration ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ksc}));
            throw new IllegalStateException(msg);
        }
        return (X509KeyManager)Predef$.MODULE$.refArrayOps((Object[])keyManagers).head();
        catch (BadPaddingException badPaddingException) {
            throw new SecurityException("Mac verify error: invalid password?", badPaddingException);
        }
        catch (ArithmeticException arithmeticException) {
            boolean willExplodeOnEmptyPassword = BoxesRunTime.unboxToBoolean(package$.MODULE$.foldVersion(new Serializable(this, ksc){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConfigSSLContextBuilder $outer;
                private final KeyStoreConfig ksc$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.warnOnPKCS12EmptyPasswordBug(this.ksc$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.ksc$1 = ksc$1;
                }
            }, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            if (willExplodeOnEmptyPassword) {
                String msg2 = new StringOps(Predef$.MODULE$.augmentString("You are running JDK 1.6, have a PKCS12 keystore with a null or empty password, and have run into a JSSE bug.\n              |The bug is closed in JDK 1.8, and backported to 1.7u4 / b13, so upgrading will fix this.\n              |Please see: http://bugs.java.com/bugdatabase/view_bug.do?bug_id=6879539\n            ")).stripMargin();
                throw new IllegalStateException(msg2, arithmeticException);
            }
            throw arithmeticException;
        }
    }

    public Option<Seq<CRL>> certificateRevocationList(SSLConfig sslConfig) {
        return sslConfig.revocationLists().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;

            public final Seq<CRL> apply(Seq<URL> urls) {
                return (Seq)urls.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$certificateRevocationList$1 $outer;

                    public final CRL apply(URL url) {
                        return this.$outer.play$api$libs$ws$ssl$ConfigSSLContextBuilder$$anonfun$$$outer().generateCRLFromURL(url);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ ConfigSSLContextBuilder play$api$libs$ws$ssl$ConfigSSLContextBuilder$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public CRL generateCRL(InputStream inputStream) {
        void var3_3;
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509CRL crl = (X509CRL)cf.generateCRL(inputStream);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public CRL generateCRLFromURL(URL url) {
        CRL cRL;
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        connection.setUseCaches(false);
        DataInputStream inStream = new DataInputStream(connection.getInputStream());
        try {
            cRL = this.generateCRL(inStream);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        inStream.close();
        return cRL;
    }

    /*
     * WARNING - void declaration
     */
    public CRL generateCRLFromFile(File file) {
        CRL cRL;
        BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(file));
        DataInputStream inStream = new DataInputStream(fileStream);
        try {
            cRL = this.generateCRL(inStream);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        inStream.close();
        return cRL;
    }

    public CertPathTrustManagerParameters buildTrustManagerParameters(KeyStore trustStore, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, AlgorithmChecker algorithmChecker) {
        X509CertSelector certSelect = new X509CertSelector();
        PKIXBuilderParameters pkixParameters = new PKIXBuilderParameters(trustStore, (CertSelector)certSelect);
        pkixParameters.setRevocationEnabled(revocationEnabled);
        revocationLists.map((Function1)new Serializable(this, pkixParameters){
            public static final long serialVersionUID = 0L;
            private final PKIXBuilderParameters pkixParameters$1;

            public final void apply(Seq<CRL> crlList) {
                this.pkixParameters$1.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(JavaConverters$.MODULE$.asJavaCollectionConverter(crlList).asJavaCollection())));
            }
            {
                this.pkixParameters$1 = pkixParameters$1;
            }
        });
        Seq checkers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlgorithmChecker[]{algorithmChecker}));
        pkixParameters.setCertPathCheckers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(checkers).asJava());
        return new CertPathTrustManagerParameters(pkixParameters);
    }

    public X509TrustManager buildTrustManager(TrustStoreConfig tsc, boolean revocationEnabled, Option<Seq<CRL>> revocationLists, AlgorithmChecker algorithmChecker) {
        TrustManagerFactoryWrapper factory = this.trustManagerFactory;
        KeyStore trustStore = this.trustStoreBuilder(tsc).build();
        this.validateStore(trustStore, algorithmChecker);
        CertPathTrustManagerParameters trustManagerParameters = this.buildTrustManagerParameters(trustStore, revocationEnabled, revocationLists, algorithmChecker);
        factory.init(trustManagerParameters);
        TrustManager[] trustManagers2 = factory.getTrustManagers();
        if (trustManagers2 == null) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot create trust manager with configuration ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tsc}));
            throw new IllegalStateException(msg);
        }
        return (X509TrustManager)Predef$.MODULE$.refArrayOps((Object[])trustManagers2).head();
    }

    public boolean validateStoreContainsPrivateKeys(KeyStoreConfig ksc, KeyStore keyStore) {
        char[] password = (char[])ksc.password().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final char[] apply(String x$4) {
                return x$4.toCharArray();
            }
        }).orNull(Predef$.MODULE$.$conforms());
        BooleanRef containsPrivateKeys = BooleanRef.create((boolean)false);
        ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(keyStore.aliases()).asScala()).foreach((Function1)new Serializable(this, keyStore, password, containsPrivateKeys){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            private final KeyStore keyStore$1;
            private final char[] password$2;
            private final BooleanRef containsPrivateKeys$1;

            public final void apply(String keyAlias) {
                Key key = this.keyStore$1.getKey(keyAlias, this.password$2);
                Key key2 = key;
                if (key2 instanceof PrivateKey) {
                    this.$outer.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStoreContainsPrivateKeys: private key found for alias ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyAlias})));
                    this.containsPrivateKeys$1.elem = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStoreContainsPrivateKeys: No private key found for alias ", ", it cannot be used for client authentication"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyAlias}));
                    this.$outer.logger().warn(msg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.keyStore$1 = keyStore$1;
                this.password$2 = password$2;
                this.containsPrivateKeys$1 = containsPrivateKeys$1;
            }
        });
        return containsPrivateKeys.elem;
    }

    public void validateStore(KeyStore store, AlgorithmChecker algorithmChecker) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStore: type = ", ", size = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{store.getType(), BoxesRunTime.boxToInteger((int)store.size())})));
        ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(store.aliases()).asScala()).foreach((Function1)new Serializable(this, store, algorithmChecker){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigSSLContextBuilder $outer;
            public final KeyStore store$1;
            public final AlgorithmChecker algorithmChecker$3;

            public final Option<BoxedUnit> apply(String alias) {
                return Option$.MODULE$.apply((Object)this.store$1.getCertificate(alias)).map((Function1)new Serializable(this, alias){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$validateStore$1 $outer;
                    private final String alias$1;

                    public final void apply(Certificate c) {
                        try {
                            this.$outer.algorithmChecker$3.checkKeyAlgorithms(package$.MODULE$.certificate2X509Certificate(c));
                        }
                        catch (Exception exception) {
                            this.$outer.play$api$libs$ws$ssl$ConfigSSLContextBuilder$$anonfun$$$outer().logger().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStore: Skipping unknown exception ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.alias$1}))).append((Object)exception.getMessage()).toString());
                            this.$outer.store$1.deleteEntry(this.alias$1);
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            this.$outer.play$api$libs$ws$ssl$ConfigSSLContextBuilder$$anonfun$$$outer().logger().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateStore: Skipping certificate with weak key size in ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.alias$1}))).append((Object)certPathValidatorException.getMessage()).toString());
                            this.$outer.store$1.deleteEntry(this.alias$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.alias$1 = alias$1;
                    }
                });
            }

            public /* synthetic */ ConfigSSLContextBuilder play$api$libs$ws$ssl$ConfigSSLContextBuilder$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.store$1 = store$1;
                this.algorithmChecker$3 = algorithmChecker$3;
            }
        });
    }

    public ConfigSSLContextBuilder(SSLConfig info, KeyManagerFactoryWrapper keyManagerFactory, TrustManagerFactoryWrapper trustManagerFactory) {
        this.info = info;
        this.keyManagerFactory = keyManagerFactory;
        this.trustManagerFactory = trustManagerFactory;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

