/*
 * Decompiled with CFR 0.152.
 */
package play.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.PropertyValues;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.convert.ConversionService;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import play.api.Play;
import play.api.data.FormUtils;
import play.api.inject.Injector;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.data.DynamicForm;
import play.data.format.Formatters;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;
import play.i18n.Lang;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.F;
import play.libs.Scala;
import play.mvc.Controller;
import play.mvc.Http;
import scala.collection.Map;

public class Form<T> {
    private final String rootName;
    private final Class<T> backedType;
    private final java.util.Map<String, String> data;
    private final java.util.Map<String, List<ValidationError>> errors;
    private final Optional<T> value;
    private final Class<?>[] groups;
    final MessagesApi messagesApi;
    final Formatters formatters;
    final Validator validator;
    private static final Set<String> internalAnnotationAttributes = new HashSet<String>(3);

    private static Injector injector() {
        return Play.current().injector();
    }

    @Deprecated
    public static DynamicForm form() {
        return new DynamicForm((MessagesApi)Form.injector().instanceOf(MessagesApi.class), (Formatters)Form.injector().instanceOf(Formatters.class), (Validator)Form.injector().instanceOf(Validator.class));
    }

    @Deprecated
    public static <T> Form<T> form(Class<T> clazz) {
        return new Form<T>(clazz, (MessagesApi)Form.injector().instanceOf(MessagesApi.class), (Formatters)Form.injector().instanceOf(Formatters.class), (Validator)Form.injector().instanceOf(Validator.class));
    }

    @Deprecated
    public static <T> Form<T> form(String string, Class<T> clazz) {
        return new Form<T>(string, clazz, (MessagesApi)Form.injector().instanceOf(MessagesApi.class), (Formatters)Form.injector().instanceOf(Formatters.class), (Validator)Form.injector().instanceOf(Validator.class));
    }

    @Deprecated
    public static <T> Form<T> form(String string, Class<T> clazz, Class<?> clazz2) {
        return new Form<T>(string, clazz, clazz2, (MessagesApi)Form.injector().instanceOf(MessagesApi.class), (Formatters)Form.injector().instanceOf(Formatters.class), (Validator)Form.injector().instanceOf(Validator.class));
    }

    @Deprecated
    public static <T> Form<T> form(String string, Class<T> clazz, Class<?> ... classArray) {
        return new Form<T>(string, clazz, classArray, (MessagesApi)Form.injector().instanceOf(MessagesApi.class), (Formatters)Form.injector().instanceOf(Formatters.class), (Validator)Form.injector().instanceOf(Validator.class));
    }

    @Deprecated
    public static <T> Form<T> form(Class<T> clazz, Class<?> clazz2) {
        return new Form<T>(null, clazz, clazz2, (MessagesApi)Form.injector().instanceOf(MessagesApi.class), (Formatters)Form.injector().instanceOf(Formatters.class), (Validator)Form.injector().instanceOf(Validator.class));
    }

    @Deprecated
    public static <T> Form<T> form(Class<T> clazz, Class<?> ... classArray) {
        return new Form<T>(null, clazz, classArray, (MessagesApi)Form.injector().instanceOf(MessagesApi.class), (Formatters)Form.injector().instanceOf(Formatters.class), (Validator)Form.injector().instanceOf(Validator.class));
    }

    public Class<T> getBackedType() {
        return this.backedType;
    }

    protected T blankInstance() {
        try {
            return this.backedType.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot instantiate " + this.backedType + ". It must have a default constructor", exception);
        }
    }

    public Form(Class<T> clazz, MessagesApi messagesApi, Formatters formatters, Validator validator) {
        this(null, clazz, messagesApi, formatters, validator);
    }

    public Form(String string, Class<T> clazz, MessagesApi messagesApi, Formatters formatters, Validator validator) {
        this(string, clazz, (Class)null, messagesApi, formatters, validator);
    }

    public Form(String string, Class<T> clazz, Class<?> clazz2, MessagesApi messagesApi, Formatters formatters, Validator validator) {
        Class[] classArray;
        if (clazz2 != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz2;
        } else {
            classArray = null;
        }
        this(string, clazz, classArray, messagesApi, formatters, validator);
    }

    public Form(String string, Class<T> clazz, Class<?>[] classArray, MessagesApi messagesApi, Formatters formatters, Validator validator) {
        this(string, clazz, new HashMap<String, String>(), new HashMap<String, List<ValidationError>>(), Optional.empty(), classArray, messagesApi, formatters, validator);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, java.util.Map<String, List<ValidationError>> map2, Optional<T> optional, MessagesApi messagesApi, Formatters formatters, Validator validator) {
        this(string, clazz, map, map2, optional, (Class)null, messagesApi, formatters, validator);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, java.util.Map<String, List<ValidationError>> map2, Optional<T> optional, Class<?> clazz2, MessagesApi messagesApi, Formatters formatters, Validator validator) {
        Class[] classArray;
        if (clazz2 != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz2;
        } else {
            classArray = null;
        }
        this(string, clazz, map, map2, optional, classArray, messagesApi, formatters, validator);
    }

    public Form(String string, Class<T> clazz, java.util.Map<String, String> map, java.util.Map<String, List<ValidationError>> map2, Optional<T> optional, Class<?>[] classArray, MessagesApi messagesApi, Formatters formatters, Validator validator) {
        this.rootName = string;
        this.backedType = clazz;
        this.data = map;
        this.errors = map2;
        this.value = optional;
        this.groups = classArray;
        this.messagesApi = messagesApi;
        this.formatters = formatters;
        this.validator = validator;
    }

    protected java.util.Map<String, String> requestData(Http.Request request) {
        HashMap<String, String[]> hashMap = new HashMap();
        if (request.body().asFormUrlEncoded() != null) {
            hashMap = request.body().asFormUrlEncoded();
        }
        HashMap<String, String[]> hashMap2 = new HashMap();
        if (request.body().asMultipartFormData() != null) {
            hashMap2 = request.body().asMultipartFormData().asFormUrlEncoded();
        }
        java.util.Map<String, String> map = new HashMap();
        if (request.body().asJson() != null) {
            map = Scala.asJava((Map)FormUtils.fromJson((String)"", (JsValue)Json.parse((String)play.libs.Json.stringify((JsonNode)request.body().asJson()))));
        }
        java.util.Map map2 = request.queryString();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        this.fillDataWith(hashMap3, hashMap);
        this.fillDataWith(hashMap3, hashMap2);
        map.forEach(hashMap3::put);
        this.fillDataWith(hashMap3, map2);
        return hashMap3;
    }

    private void fillDataWith(java.util.Map<String, String> map, java.util.Map<String, String[]> map2) {
        map2.forEach((string, stringArray) -> {
            if (string.endsWith("[]")) {
                String string2 = string.substring(0, string.length() - 2);
                for (int i = 0; i < ((String[])stringArray).length; ++i) {
                    map.put(string2 + "[" + i + "]", stringArray[i]);
                }
            } else if (((String[])stringArray).length > 0) {
                map.put((String)string, stringArray[0]);
            }
        });
    }

    public Form<T> bindFromRequest(String ... stringArray) {
        return this.bind(this.requestData(Controller.request()), stringArray);
    }

    public Form<T> bindFromRequest(Http.Request request, String ... stringArray) {
        return this.bind(this.requestData(request), stringArray);
    }

    public Form<T> bindFromRequest(java.util.Map<String, String[]> map, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.fillDataWith(hashMap, map);
        return this.bind(hashMap, stringArray);
    }

    public Form<T> bind(JsonNode jsonNode, String ... stringArray) {
        return this.bind(Scala.asJava((Map)FormUtils.fromJson((String)"", (JsValue)Json.parse((String)play.libs.Json.stringify((JsonNode)jsonNode)))), stringArray);
    }

    protected Object[] getArgumentsForConstraint(String string2, String string3, ConstraintDescriptor<?> constraintDescriptor) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        String[] stringArray = new String[]{string2 + "." + string3, string3};
        linkedList.add(new DefaultMessageSourceResolvable(stringArray, string3));
        TreeMap treeMap = new TreeMap();
        constraintDescriptor.getAttributes().forEach((string, object) -> {
            if (!internalAnnotationAttributes.contains(string)) {
                treeMap.put(string, object);
            }
        });
        linkedList.addAll(treeMap.values());
        return linkedList.toArray(new Object[linkedList.size()]);
    }

    protected String getMessageForConstraintViolation(ConstraintViolation<Object> constraintViolation) {
        String string = constraintViolation.getMessage();
        Annotation annotation = constraintViolation.getConstraintDescriptor().getAnnotation();
        if (annotation instanceof Constraints.ValidateWith) {
            Constraints.ValidateWith validateWith = (Constraints.ValidateWith)annotation;
            if (constraintViolation.getMessage().equals("error.invalid")) {
                Constraints.ValidateWithValidator validateWithValidator = new Constraints.ValidateWithValidator();
                validateWithValidator.initialize(validateWith);
                F.Tuple<String, Object[]> tuple = validateWithValidator.getErrorMessageKey();
                if (tuple != null && tuple._1 != null) {
                    string = (String)tuple._1;
                }
            }
        }
        return string;
    }

    public Form<T> bind(java.util.Map<String, String> map, String ... stringArray) {
        Object object;
        Object object22;
        Object noSuchMethodException2;
        DataBinder dataBinder;
        java.util.Map<String, String> map2 = map;
        if (this.rootName == null) {
            dataBinder = new DataBinder(this.blankInstance());
        } else {
            dataBinder = new DataBinder(this.blankInstance(), this.rootName);
            map2 = new HashMap<String, String>();
            for (String object42 : map.keySet()) {
                if (!object42.startsWith(this.rootName + ".")) continue;
                map2.put(object42.substring(this.rootName.length() + 1), map.get(object42));
            }
        }
        if (stringArray.length > 0) {
            dataBinder.setAllowedFields(stringArray);
        }
        SpringValidatorAdapter springValidatorAdapter = new SpringValidatorAdapter(this.validator);
        dataBinder.setValidator((org.springframework.validation.Validator)springValidatorAdapter);
        dataBinder.setConversionService((ConversionService)this.formatters.conversion);
        dataBinder.setAutoGrowNestedPaths(true);
        java.util.Map<String, String> map3 = map2;
        Form.withRequestLocale(() -> {
            dataBinder.bind((PropertyValues)new MutablePropertyValues(map3));
            return null;
        });
        Set set = this.groups != null ? springValidatorAdapter.validate(dataBinder.getTarget(), (Class[])this.groups) : springValidatorAdapter.validate(dataBinder.getTarget(), new Class[0]);
        BindingResult bindingResult = dataBinder.getBindingResult();
        for (Object noSuchMethodException2 : set) {
            Object object3 = noSuchMethodException2.getPropertyPath().toString();
            object22 = bindingResult.getFieldError((String)object3);
            if (object22 != null && object22.isBindingFailure()) continue;
            try {
                bindingResult.rejectValue((String)object3, noSuchMethodException2.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName(), this.getArgumentsForConstraint(bindingResult.getObjectName(), (String)object3, noSuchMethodException2.getConstraintDescriptor()), this.getMessageForConstraintViolation((ConstraintViolation<Object>)noSuchMethodException2));
            }
            catch (NotReadablePropertyException validationError) {
                throw new IllegalStateException("JSR-303 validated property '" + (String)object3 + "' does not have a corresponding accessor for data binding - " + "check your DataBinder's configuration (bean property versus direct field access)", validationError);
            }
        }
        if (bindingResult.hasErrors() || bindingResult.getGlobalErrorCount() > 0) {
            object = new HashMap();
            for (Object object3 : bindingResult.getFieldErrors()) {
                ValidationError arrayList;
                object22 = object3.getObjectName() + "." + object3.getField();
                if (((String)object22).startsWith("target.") && this.rootName == null) {
                    object22 = ((String)object22).substring(7);
                }
                if (!object.containsKey(object22)) {
                    object.put(object22, new ArrayList());
                }
                if (object3.isBindingFailure()) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    Optional<Messages> optional = Optional.ofNullable(Http.Context.current.get()).map(Http.Context::messages);
                    for (String string : object3.getCodes()) {
                        string = string.replace("typeMismatch", "error.invalid");
                        if (optional.isPresent() && !optional.get().isDefinedAt(string).booleanValue()) continue;
                        builder.add((Object)string);
                    }
                    arrayList = new ValidationError((String)object22, (List<String>)builder.build().reverse(), this.convertErrorArguments(object3.getArguments()));
                } else {
                    arrayList = new ValidationError((String)object22, object3.getDefaultMessage(), this.convertErrorArguments(object3.getArguments()));
                }
                ((List)object.get(object22)).add(arrayList);
            }
            noSuchMethodException2 = bindingResult.getGlobalErrors().stream().map(objectError -> new ValidationError("", objectError.getDefaultMessage(), this.convertErrorArguments(objectError.getArguments()))).collect(Collectors.toList());
            if (!noSuchMethodException2.isEmpty()) {
                object.put("", noSuchMethodException2);
            }
            return new Form<Object>(this.rootName, this.backedType, map, (java.util.Map<String, List<ValidationError>>)object, Optional.ofNullable(bindingResult.getTarget()), this.groups, this.messagesApi, this.formatters, this.validator);
        }
        object = null;
        if (bindingResult.getTarget() != null) {
            try {
                noSuchMethodException2 = bindingResult.getTarget().getClass().getMethod("validate", new Class[0]);
                object = ((Method)noSuchMethodException2).invoke(bindingResult.getTarget(), new Object[0]);
            }
            catch (NoSuchMethodException throwable) {
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        if (object != null) {
            noSuchMethodException2 = new HashMap();
            if (object instanceof String) {
                noSuchMethodException2.put("", new ArrayList());
                ((List)noSuchMethodException2.get("")).add(new ValidationError("", (String)object, new ArrayList<Object>()));
            } else if (object instanceof List) {
                for (Object object22 : (List)object) {
                    ArrayList<Object> arrayList = (ArrayList<Object>)noSuchMethodException2.get(((ValidationError)object22).key());
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                        noSuchMethodException2.put(((ValidationError)object22).key(), arrayList);
                    }
                    arrayList.add(object22);
                }
            } else if (object instanceof java.util.Map) {
                noSuchMethodException2 = (java.util.Map)object;
            }
            return new Form<Object>(this.rootName, this.backedType, map, (java.util.Map<String, List<ValidationError>>)noSuchMethodException2, Optional.ofNullable(bindingResult.getTarget()), this.groups, this.messagesApi, this.formatters, this.validator);
        }
        return new Form<Object>(this.rootName, this.backedType, new HashMap<String, String>(map), new HashMap<String, List<ValidationError>>(this.errors), Optional.ofNullable(bindingResult.getTarget()), this.groups, this.messagesApi, this.formatters, this.validator);
    }

    private List<Object> convertErrorArguments(Object[] objectArray) {
        List list = Arrays.stream(objectArray).filter(object -> !(object instanceof DefaultMessageSourceResolvable)).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    public java.util.Map<String, String> data() {
        return this.data;
    }

    public String name() {
        return this.rootName;
    }

    public Optional<T> value() {
        return this.value;
    }

    public Form<T> fill(T t) {
        if (t == null) {
            throw new RuntimeException("Cannot fill a form with a null value");
        }
        return new Form<T>(this.rootName, this.backedType, new HashMap<String, String>(), new HashMap<String, List<ValidationError>>(), Optional.ofNullable(t), this.groups, this.messagesApi, this.formatters, this.validator);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasGlobalErrors() {
        return this.errors.containsKey("") && !this.errors.get("").isEmpty();
    }

    public List<ValidationError> globalErrors() {
        List<ValidationError> list = this.errors.get("");
        if (list == null) {
            list = new ArrayList<ValidationError>();
        }
        return list;
    }

    public ValidationError globalError() {
        List<ValidationError> list = this.globalErrors();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public java.util.Map<String, List<ValidationError>> errors() {
        return this.errors;
    }

    public ValidationError error(String string) {
        List<ValidationError> list = this.errors.get(string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public JsonNode errorsAsJson() {
        return this.errorsAsJson(Http.Context.current() != null ? Http.Context.current().lang() : null);
    }

    public JsonNode errorsAsJson(Lang lang) {
        HashMap hashMap = new HashMap();
        this.errors.forEach((string, list) -> {
            if (list != null && !list.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ValidationError validationError : list) {
                    if (this.messagesApi != null && lang != null) {
                        arrayList.add(this.messagesApi.get((play.api.i18n.Lang)lang, validationError.messages(), new Object[]{this.translateMsgArg(validationError.arguments(), this.messagesApi, lang)}));
                        continue;
                    }
                    arrayList.add(validationError.message());
                }
                hashMap.put(string, arrayList);
            }
        });
        return play.libs.Json.toJson(hashMap);
    }

    private Object translateMsgArg(List<Object> list, MessagesApi messagesApi, Lang lang) {
        if (list != null) {
            return list.stream().map(object2 -> {
                if (object2 instanceof String) {
                    return messagesApi != null ? messagesApi.get((play.api.i18n.Lang)lang, (String)object2, new Object[0]) : (String)object2;
                }
                if (object2 instanceof List) {
                    return ((List)object2).stream().map(object -> messagesApi != null ? messagesApi.get((play.api.i18n.Lang)lang, (String)object, new Object[0]) : (String)object).collect(Collectors.toList());
                }
                return object2;
            }).collect(Collectors.toList());
        }
        return null;
    }

    public T get() {
        if (!this.errors.isEmpty()) {
            throw new IllegalStateException("Error(s) binding form: " + this.errorsAsJson());
        }
        return this.value.get();
    }

    public void reject(ValidationError validationError) {
        if (!this.errors.containsKey(validationError.key())) {
            this.errors.put(validationError.key(), new ArrayList());
        }
        this.errors.get(validationError.key()).add(validationError);
    }

    public void reject(String string, String string2, List<Object> list) {
        this.reject(new ValidationError(string, string2, list));
    }

    public void reject(String string, String string2) {
        this.reject(string, string2, new ArrayList<Object>());
    }

    public void reject(String string, List<Object> list) {
        this.reject(new ValidationError("", string, list));
    }

    public void reject(String string) {
        this.reject("", string, new ArrayList<Object>());
    }

    public void discardErrors() {
        this.errors.clear();
    }

    public Field apply(String string) {
        return this.field(string);
    }

    /*
     * WARNING - void declaration
     */
    public Field field(String string) {
        void var6_12;
        int n;
        Object object;
        Annotation[] annotationArray;
        Display display;
        BeanDescriptor beanDescriptor;
        Object object3;
        String string2;
        Object object4;
        String string3 = null;
        if (this.data.containsKey(string)) {
            string3 = this.data.get(string);
        } else if (this.value.isPresent()) {
            object4 = new BeanWrapperImpl(this.value.get());
            object4.setAutoGrowNestedPaths(true);
            string2 = string;
            if (this.rootName != null && string.startsWith(this.rootName + ".")) {
                string2 = string.substring(this.rootName.length() + 1);
            }
            if (object4.isReadableProperty(string2) && (object3 = object4.getPropertyValue(string2)) != null) {
                if (this.formatters != null) {
                    String object2 = string2;
                    string3 = Form.withRequestLocale(() -> this.lambda$field$8((BeanWrapper)object4, object2, object3));
                } else {
                    string3 = object3.toString();
                }
            }
        }
        object4 = this.errors.get(string);
        if (object4 == null) {
            object4 = new ArrayList();
        }
        string2 = null;
        object3 = new BeanWrapperImpl(this.blankInstance());
        object3.setAutoGrowNestedPaths(true);
        try {
            for (Annotation annotation : object3.getPropertyTypeDescriptor(string).getAnnotations()) {
                beanDescriptor = annotation.annotationType();
                if (!beanDescriptor.isAnnotationPresent(Display.class) || !(display = beanDescriptor.getAnnotation(Display.class)).name().startsWith("format.")) continue;
                annotationArray = new ArrayList();
                object = display.attributes();
                int n2 = ((String[])object).length;
                for (int i = 0; i < n2; ++i) {
                    Object object2 = object[i];
                    Object object5 = null;
                    try {
                        object5 = annotation.getClass().getDeclaredMethod((String)object2, new Class[0]).invoke((Object)annotation, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    annotationArray.add(object5);
                }
                string2 = F.Tuple((Object)display.name(), annotationArray);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ArrayList arrayList = new ArrayList();
        Class clazz = this.backedType;
        String string4 = string;
        if (this.rootName != null && string4.startsWith(this.rootName + ".")) {
            string4 = string4.substring(this.rootName.length() + 1);
        }
        if ((n = string4.lastIndexOf(46)) > 0) {
            clazz = object3.getPropertyType(string4.substring(0, n));
            string4 = string4.substring(n + 1);
        }
        if (clazz != null && this.validator != null && (beanDescriptor = this.validator.getConstraintsForClass(clazz)) != null && (display = beanDescriptor.getConstraintsForProperty(string4)) != null) {
            Class[] classArray;
            annotationArray = null;
            for (object = clazz; object != null; object = ((Class)object).getSuperclass()) {
                java.lang.reflect.Field field = null;
                try {
                    field = ((Class)object).getDeclaredField(string4);
                }
                catch (NoSuchFieldException | SecurityException exception) {
                    continue;
                }
                annotationArray = field.getDeclaredAnnotations();
                break;
            }
            ElementDescriptor.ConstraintFinder constraintFinder = display.findConstraints();
            if (this.groups != null) {
                classArray = this.groups;
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Default.class;
            }
            List<F.Tuple<String, List<Object>>> list = Constraints.displayableConstraint(constraintFinder.unorderedAndMatchingGroups(classArray).getConstraintDescriptors(), annotationArray);
        }
        return new Field(this, string, (List<F.Tuple<String, List<Object>>>)var6_12, (F.Tuple<String, List<Object>>)string2, (List<ValidationError>)object4, string3);
    }

    public String toString() {
        return "Form(of=" + this.backedType + ", data=" + this.data + ", value=" + this.value + ", errors=" + this.errors + ")";
    }

    private static <T> T withRequestLocale(Supplier<T> supplier) {
        try {
            LocaleContextHolder.setLocale((Locale)Http.Context.current().lang().toLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            LocaleContextHolder.resetLocaleContext();
        }
    }

    private /* synthetic */ String lambda$field$8(BeanWrapper beanWrapper, String string, Object object) {
        return this.formatters.print(beanWrapper.getPropertyTypeDescriptor(string), object);
    }

    static {
        internalAnnotationAttributes.add("message");
        internalAnnotationAttributes.add("groups");
        internalAnnotationAttributes.add("payload");
    }

    public static class Field {
        private final Form<?> form;
        private final String name;
        private final List<F.Tuple<String, List<Object>>> constraints;
        private final F.Tuple<String, List<Object>> format;
        private final List<ValidationError> errors;
        private final String value;

        public Field(Form<?> form, String string, List<F.Tuple<String, List<Object>>> list, F.Tuple<String, List<Object>> tuple, List<ValidationError> list2, String string2) {
            this.form = form;
            this.name = string;
            this.constraints = list;
            this.format = tuple;
            this.errors = list2;
            this.value = string2;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public String valueOr(String string) {
            if (this.value == null) {
                return string;
            }
            return this.value;
        }

        public List<ValidationError> errors() {
            return this.errors;
        }

        public List<F.Tuple<String, List<Object>>> constraints() {
            return this.constraints;
        }

        public F.Tuple<String, List<Object>> format() {
            return this.format;
        }

        public List<Integer> indexes() {
            if (this.form == null) {
                return new ArrayList<Integer>(0);
            }
            return this.form.value().map(object -> {
                Object object2;
                BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
                beanWrapperImpl.setAutoGrowNestedPaths(true);
                String string = this.name;
                if (this.form.name() != null && this.name.startsWith(this.form.name() + ".")) {
                    string = this.name.substring(this.form.name().length() + 1);
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                if (beanWrapperImpl.isReadableProperty(string) && (object2 = beanWrapperImpl.getPropertyValue(string)) instanceof Collection) {
                    for (int i = 0; i < ((Collection)object2).size(); ++i) {
                        arrayList.add(i);
                    }
                }
                return arrayList;
            }).orElseGet(() -> {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                Pattern pattern = Pattern.compile("^" + Pattern.quote(this.name) + "\\[(\\d+)\\].*$");
                for (String string : this.form.data().keySet()) {
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    treeSet.add(Integer.parseInt(matcher.group(1)));
                }
                ArrayList arrayList = new ArrayList(treeSet);
                Collections.sort(arrayList);
                return arrayList;
            });
        }

        public Field sub(String string) {
            String string2 = string.startsWith("[") ? this.name + string : this.name + "." + string;
            return this.form.field(string2);
        }

        public String toString() {
            return "Form.Field(" + this.name + ")";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.ANNOTATION_TYPE})
    public static @interface Display {
        public String name();

        public String[] attributes() default {};
    }
}

