/*
 * Decompiled with CFR 0.152.
 */
package play.data.format;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import play.data.Form;
import play.data.format.Formatters;
import play.i18n.Lang;
import play.i18n.MessagesApi;

public class Formats {

    public static class AnnotationNonEmptyFormatter
    extends Formatters.AnnotationFormatter<NonEmpty, String> {
        @Override
        public String parse(NonEmpty nonEmpty, String string, Locale locale) throws ParseException {
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            return string;
        }

        @Override
        public String print(NonEmpty nonEmpty, String string, Locale locale) {
            if (string == null) {
                return "";
            }
            return string;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NonEmpty {
    }

    public static class AnnotationDateFormatter
    extends Formatters.AnnotationFormatter<DateTime, Date> {
        private final MessagesApi messagesApi;

        public AnnotationDateFormatter(MessagesApi messagesApi) {
            this.messagesApi = messagesApi;
        }

        @Override
        public Date parse(DateTime dateTime, String string, Locale locale) throws ParseException {
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            Lang lang = new Lang(locale);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Optional.ofNullable(this.messagesApi).map(messagesApi -> messagesApi.get((play.api.i18n.Lang)lang, dateTime.pattern(), new Object[0])).orElse(dateTime.pattern()), locale);
            simpleDateFormat.setLenient(false);
            return simpleDateFormat.parse(string);
        }

        @Override
        public String print(DateTime dateTime, Date date, Locale locale) {
            if (date == null) {
                return "";
            }
            Lang lang = new Lang(locale);
            return new SimpleDateFormat(Optional.ofNullable(this.messagesApi).map(messagesApi -> messagesApi.get((play.api.i18n.Lang)lang, dateTime.pattern(), new Object[0])).orElse(dateTime.pattern()), locale).format(date);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Form.Display(name="format.date", attributes={"pattern"})
    public static @interface DateTime {
        public String pattern();
    }

    public static class DateFormatter
    extends Formatters.SimpleFormatter<Date> {
        private final MessagesApi messagesApi;
        private final String pattern;
        private final String patternNoApp;

        public DateFormatter(MessagesApi messagesApi) {
            this(messagesApi, "formats.date");
        }

        public DateFormatter(MessagesApi messagesApi, String string) {
            this(messagesApi, string, "yyyy-MM-dd");
        }

        public DateFormatter(MessagesApi messagesApi, String string, String string2) {
            this.messagesApi = messagesApi;
            this.pattern = string;
            this.patternNoApp = string2;
        }

        @Override
        public Date parse(String string, Locale locale) throws ParseException {
            if (string == null || string.trim().isEmpty()) {
                return null;
            }
            Lang lang = new Lang(locale);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Optional.ofNullable(this.messagesApi).map(messagesApi -> messagesApi.get((play.api.i18n.Lang)lang, this.pattern, new Object[0])).orElse(this.patternNoApp), locale);
            simpleDateFormat.setLenient(false);
            return simpleDateFormat.parse(string);
        }

        @Override
        public String print(Date date, Locale locale) {
            if (date == null) {
                return "";
            }
            Lang lang = new Lang(locale);
            return new SimpleDateFormat(Optional.ofNullable(this.messagesApi).map(messagesApi -> messagesApi.get((play.api.i18n.Lang)lang, this.pattern, new Object[0])).orElse(this.patternNoApp), locale).format(date);
        }
    }
}

