/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;
import org.vafer.jdeb.producers.Producers;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarArchiveEntry;

public final class DataProducerFile
extends AbstractDataProducer
implements DataProducer {
    private final File file;
    private final String destinationName;

    public DataProducerFile(File pFile, String pDestinationName, String[] pIncludes, String[] pExcludes, Mapper[] pMapper) {
        super(pIncludes, pExcludes, pMapper);
        this.file = pFile;
        this.destinationName = pDestinationName;
    }

    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        String fileName = this.destinationName != null && this.destinationName.trim().length() > 0 ? this.destinationName.trim() : this.file.getName();
        TarArchiveEntry entry = Producers.defaultFileEntryWithName(fileName);
        entry = this.map(entry);
        entry.setSize(this.file.length());
        Producers.produceInputStreamWithEntry(pReceiver, new FileInputStream(this.file), entry);
    }
}

