/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGOutputStream;
import org.vafer.jdeb.shaded.bc.bcpg.ContainedPacket;
import org.vafer.jdeb.shaded.bc.bcpg.S2K;

public class SymmetricKeyEncSessionPacket
extends ContainedPacket {
    private int version;
    private int encAlgorithm;
    private S2K s2k;
    private byte[] secKeyData;

    public SymmetricKeyEncSessionPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.version = bCPGInputStream.read();
        this.encAlgorithm = bCPGInputStream.read();
        this.s2k = new S2K(bCPGInputStream);
        this.secKeyData = bCPGInputStream.readAll();
    }

    public SymmetricKeyEncSessionPacket(int n, S2K s2K, byte[] byArray) {
        this.version = 4;
        this.encAlgorithm = n;
        this.s2k = s2K;
        this.secKeyData = byArray;
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public byte[] getSecKeyData() {
        return this.secKeyData;
    }

    public int getVersion() {
        return this.version;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream2.write(this.version);
        bCPGOutputStream2.write(this.encAlgorithm);
        bCPGOutputStream2.writeObject(this.s2k);
        if (this.secKeyData != null && this.secKeyData.length > 0) {
            bCPGOutputStream2.write(this.secKeyData);
        }
        bCPGOutputStream.writePacket(3, byteArrayOutputStream.toByteArray(), true);
    }
}

