/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.packed.GrowableWriter;

final class NodeHash<T> {
    private GrowableWriter table;
    private int count;
    private int mask = 15;
    private final FST<T> fst;
    private final FST.Arc<T> scratchArc = new FST.Arc();
    private final FST.BytesReader in;

    public NodeHash(FST<T> fst, FST.BytesReader in) {
        this.table = new GrowableWriter(8, 16, 0.0f);
        this.fst = fst;
        this.in = in;
    }

    private boolean nodesEqual(Builder.UnCompiledNode<T> node, long address) throws IOException {
        this.fst.readFirstRealTargetArc(address, this.scratchArc, this.in);
        if (this.scratchArc.bytesPerArc != 0 && node.numArcs != this.scratchArc.numArcs) {
            return false;
        }
        for (int arcUpto = 0; arcUpto < node.numArcs; ++arcUpto) {
            Builder.Arc arc = node.arcs[arcUpto];
            if (arc.label != this.scratchArc.label || !arc.output.equals(this.scratchArc.output) || ((Builder.CompiledNode)arc.target).node != this.scratchArc.target || !arc.nextFinalOutput.equals(this.scratchArc.nextFinalOutput) || arc.isFinal != this.scratchArc.isFinal()) {
                return false;
            }
            if (this.scratchArc.isLast()) {
                return arcUpto == node.numArcs - 1;
            }
            this.fst.readNextRealArc(this.scratchArc, this.in);
        }
        return false;
    }

    private int hash(Builder.UnCompiledNode<T> node) {
        int PRIME = 31;
        int h = 0;
        for (int arcIdx = 0; arcIdx < node.numArcs; ++arcIdx) {
            Builder.Arc arc = node.arcs[arcIdx];
            h = 31 * h + arc.label;
            long n = ((Builder.CompiledNode)arc.target).node;
            h = 31 * h + (int)(n ^ n >> 32);
            h = 31 * h + arc.output.hashCode();
            h = 31 * h + arc.nextFinalOutput.hashCode();
            if (!arc.isFinal) continue;
            h += 17;
        }
        return h & Integer.MAX_VALUE;
    }

    private int hash(long node) throws IOException {
        int PRIME = 31;
        int h = 0;
        this.fst.readFirstRealTargetArc(node, this.scratchArc, this.in);
        while (true) {
            h = 31 * h + this.scratchArc.label;
            h = 31 * h + (int)(this.scratchArc.target ^ this.scratchArc.target >> 32);
            h = 31 * h + this.scratchArc.output.hashCode();
            h = 31 * h + this.scratchArc.nextFinalOutput.hashCode();
            if (this.scratchArc.isFinal()) {
                h += 17;
            }
            if (this.scratchArc.isLast()) break;
            this.fst.readNextRealArc(this.scratchArc, this.in);
        }
        return h & Integer.MAX_VALUE;
    }

    public long add(Builder.UnCompiledNode<T> nodeIn) throws IOException {
        int h = this.hash(nodeIn);
        int pos = h & this.mask;
        int c = 0;
        while (true) {
            long v;
            if ((v = this.table.get(pos)) == 0L) {
                long node = this.fst.addNode(nodeIn);
                assert (this.hash(node) == h) : "frozenHash=" + this.hash(node) + " vs h=" + h;
                ++this.count;
                this.table.set(pos, node);
                if (this.table.size() < 2 * this.count) {
                    this.rehash();
                }
                return node;
            }
            if (this.nodesEqual(nodeIn, v)) {
                return v;
            }
            pos = pos + ++c & this.mask;
        }
    }

    private void addNew(long address) throws IOException {
        int pos = this.hash(address) & this.mask;
        int c = 0;
        while (true) {
            if (this.table.get(pos) == 0L) break;
            pos = pos + ++c & this.mask;
        }
        this.table.set(pos, address);
    }

    private void rehash() throws IOException {
        GrowableWriter oldTable = this.table;
        if (oldTable.size() >= 0x3FFFFFFF) {
            throw new IllegalStateException("FST too large (> 2.1 GB)");
        }
        this.table = new GrowableWriter(oldTable.getBitsPerValue(), 2 * oldTable.size(), 0.0f);
        this.mask = this.table.size() - 1;
        for (int idx = 0; idx < oldTable.size(); ++idx) {
            long address = oldTable.get(idx);
            if (address == 0L) continue;
            this.addNew(address);
        }
    }

    public int count() {
        return this.count;
    }
}

