/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.jolbox.bonecp.BoneCPDataSource;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.PoolUtil;
import com.jolbox.bonecp.hooks.AbstractConnectionHook;
import com.jolbox.bonecp.hooks.ConnectionHook;
import com.typesafe.config.Config;
import java.sql.Statement;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import play.api.ConfigLoader$;
import play.api.Environment;
import play.api.PlayConfig;
import play.api.PlayConfig$;
import play.api.db.BoneConnectionPool$;
import play.api.db.ConnectionPool;
import play.api.db.DatabaseConfig;
import play.api.libs.JNDI$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u0013\t\u0011\"i\u001c8f\u0007>tg.Z2uS>t\u0007k\\8m\u0015\t\u0019A!\u0001\u0002eE*\u0011QAB\u0001\u0004CBL'\"A\u0004\u0002\tAd\u0017-_\u0002\u0001'\r\u0001!\u0002\u0005\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!AD\"p]:,7\r^5p]B{w\u000e\u001c\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005YQM\u001c<je>tW.\u001a8u!\t9\u0002$D\u0001\u0005\u0013\tIBAA\u0006F]ZL'o\u001c8nK:$\b\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e=A\u0011\u0011\u0003\u0001\u0005\u0006+i\u0001\rA\u0006\u0015\u00035\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\r%t'.Z2u\u0015\u0005)\u0013!\u00026bm\u0006D\u0018BA\u0014#\u0005\u0019IeN[3di\")\u0011\u0006\u0001C\u0001U\u000511M]3bi\u0016$BaK\u0019;\u007fA\u0011AfL\u0007\u0002[)\u0011a\u0006J\u0001\u0004gFd\u0017B\u0001\u0019.\u0005)!\u0015\r^1T_V\u00148-\u001a\u0005\u0006e!\u0002\raM\u0001\u0005]\u0006lW\r\u0005\u00025o9\u00111\"N\u0005\u0003m1\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011a\u0007\u0004\u0005\u0006w!\u0002\r\u0001P\u0001\tI\n\u001cuN\u001c4jOB\u0011\u0011#P\u0005\u0003}\t\u0011a\u0002R1uC\n\f7/Z\"p]\u001aLw\rC\u0003AQ\u0001\u0007\u0011)\u0001\u0003d_:4\u0007C\u0001\"J\u001b\u0005\u0019%B\u0001#F\u0003\u0019\u0019wN\u001c4jO*\u0011aiR\u0001\tif\u0004Xm]1gK*\t\u0001*A\u0002d_6L!AS\"\u0003\r\r{gNZ5h\u0011\u0015a\u0005\u0001\"\u0001N\u0003\u0015\u0019Gn\\:f)\tq\u0015\u000b\u0005\u0002\f\u001f&\u0011\u0001\u000b\u0004\u0002\u0005+:LG\u000fC\u0003S\u0017\u0002\u00071&\u0001\u0002eg\"\u0012\u0001\u0001\u0016\t\u0003CUK!A\u0016\u0012\u0003\u0013MKgn\u001a7fi>tw!\u0002-\u0003\u0011\u0003I\u0016A\u0005\"p]\u0016\u001cuN\u001c8fGRLwN\u001c)p_2\u0004\"!\u0005.\u0007\u000b\u0005\u0011\u0001\u0012A.\u0014\u0005iS\u0001\"B\u000e[\t\u0003iF#A-\t\u000f}S&\u0019!C\u0005A\u00061An\\4hKJ,\u0012!\u0019\t\u0003/\tL!a\u0019\u0003\u0003\r1{wmZ3s\u0011\u0019)'\f)A\u0005C\u00069An\\4hKJ\u0004\u0003")
public class BoneConnectionPool
implements ConnectionPool {
    private final Environment environment;

    @Override
    public DataSource create(String name, DatabaseConfig dbConfig, Config conf) {
        PlayConfig config = PlayConfig$.MODULE$.apply(conf);
        BoneCPDataSource datasource = new BoneCPDataSource();
        boolean autocommit = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("bonecp.autoCommit", "autocommit", ConfigLoader$.MODULE$.booleanLoader()));
        Option isolation = config.getOptionalDeprecated("bonecp.isolation", "isolation", ConfigLoader$.MODULE$.stringLoader()).map((Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final PlayConfig config$1;

            public final int apply(String x0$1) {
                String string;
                block7: {
                    int n;
                    block3: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        string = x0$1;
                                        if (!"NONE".equals(string)) break block2;
                                        n = 0;
                                        break block3;
                                    }
                                    if (!"READ_COMMITTED".equals(string)) break block4;
                                    n = 2;
                                    break block3;
                                }
                                if (!"READ_UNCOMMITTED".equals(string)) break block5;
                                n = 1;
                                break block3;
                            }
                            if (!"REPEATABLE_READ".equals(string)) break block6;
                            n = 4;
                            break block3;
                        }
                        if (!"SERIALIZABLE".equals(string)) break block7;
                        n = 8;
                    }
                    return n;
                }
                throw this.config$1.reportError("bonecp.isolation", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown isolation level [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})), this.config$1.reportError$default$3());
            }
            {
                this.config$1 = config$1;
            }
        });
        Option catalog = config.getOptionalDeprecated("bonecp.defaultCatalog", "defaultCatalog", ConfigLoader$.MODULE$.stringLoader());
        boolean readOnly = BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("bonecp.readOnly", "readOnly", ConfigLoader$.MODULE$.booleanLoader()));
        datasource.setClassLoader(this.environment.classLoader());
        datasource.setConnectionHook((ConnectionHook)new AbstractConnectionHook(this, datasource, autocommit, isolation, catalog, readOnly){
            public final BoneCPDataSource datasource$1;
            private final boolean autocommit$1;
            private final Option isolation$1;
            private final Option catalog$1;
            private final boolean readOnly$1;

            public void onCheckIn(ConnectionHandle connection) {
                if (BoneConnectionPool$.MODULE$.play$api$db$BoneConnectionPool$$logger().isTraceEnabled()) {
                    BoneConnectionPool$.MODULE$.play$api$db$BoneConnectionPool$$logger().trace((Function0)new Serializable(this, connection){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;
                        private final ConnectionHandle connection$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check in connection ", " [", " leased]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.connection$1, BoxesRunTime.boxToInteger((int)this.$outer.datasource$1.getTotalLeased())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.connection$1 = connection$1;
                        }
                    });
                }
            }

            public void onCheckOut(ConnectionHandle connection) {
                connection.setAutoCommit(this.autocommit$1);
                this.isolation$1.foreach((Function1)new Serializable(this, connection){
                    public static final long serialVersionUID = 0L;
                    private final ConnectionHandle connection$2;

                    public final void apply(int x$1) {
                        this.apply$mcVI$sp(x$1);
                    }

                    public void apply$mcVI$sp(int x$1) {
                        this.connection$2.setTransactionIsolation(x$1);
                    }
                    {
                        this.connection$2 = connection$2;
                    }
                });
                connection.setReadOnly(this.readOnly$1);
                this.catalog$1.foreach((Function1)new Serializable(this, connection){
                    public static final long serialVersionUID = 0L;
                    private final ConnectionHandle connection$2;

                    public final void apply(String x$1) {
                        this.connection$2.setCatalog(x$1);
                    }
                    {
                        this.connection$2 = connection$2;
                    }
                });
                if (BoneConnectionPool$.MODULE$.play$api$db$BoneConnectionPool$$logger().isTraceEnabled()) {
                    BoneConnectionPool$.MODULE$.play$api$db$BoneConnectionPool$$logger().trace((Function0)new Serializable(this, connection){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;
                        private final ConnectionHandle connection$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check out connection ", " [", " leased]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.connection$2, BoxesRunTime.boxToInteger((int)this.$outer.datasource$1.getTotalLeased())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.connection$2 = connection$2;
                        }
                    });
                }
            }

            public void onQueryExecuteTimeLimitExceeded(ConnectionHandle handle, Statement statement, String sql, Map<Object, Object> logParams, long timeElapsedInNs) {
                long timeMs = timeElapsedInNs / 1000L;
                String query = PoolUtil.fillLogParams((String)sql, logParams);
                BoneConnectionPool$.MODULE$.play$api$db$BoneConnectionPool$$logger().warn((Function0)new Serializable(this, timeMs, query){
                    public static final long serialVersionUID = 0L;
                    private final long timeMs$1;
                    private final String query$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query execute time limit exceeded (", "ms) - query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeMs$1), this.query$1}));
                    }
                    {
                        this.timeMs$1 = timeMs$1;
                        this.query$1 = query$1;
                    }
                });
            }
            {
                this.datasource$1 = datasource$1;
                this.autocommit$1 = autocommit$1;
                this.isolation$1 = isolation$1;
                this.catalog$1 = catalog$1;
                this.readOnly$1 = readOnly$1;
            }
        });
        dbConfig.url().foreach((Function1)new Serializable(this, datasource){
            public static final long serialVersionUID = 0L;
            private final BoneCPDataSource datasource$1;

            public final void apply(String x$1) {
                this.datasource$1.setJdbcUrl(x$1);
            }
            {
                this.datasource$1 = datasource$1;
            }
        });
        dbConfig.username().foreach((Function1)new Serializable(this, datasource){
            public static final long serialVersionUID = 0L;
            private final BoneCPDataSource datasource$1;

            public final void apply(String x$1) {
                this.datasource$1.setUsername(x$1);
            }
            {
                this.datasource$1 = datasource$1;
            }
        });
        dbConfig.password().foreach((Function1)new Serializable(this, datasource){
            public static final long serialVersionUID = 0L;
            private final BoneCPDataSource datasource$1;

            public final void apply(String x$1) {
                this.datasource$1.setPassword(x$1);
            }
            {
                this.datasource$1 = datasource$1;
            }
        });
        datasource.setCloseOpenStatements(BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("bonecp.closeOpenStatements", "closeOpenStatements", ConfigLoader$.MODULE$.booleanLoader())));
        datasource.setPartitionCount(BoxesRunTime.unboxToInt((Object)config.getDeprecated("bonecp.partitionCount", "partitionCount", ConfigLoader$.MODULE$.intLoader())));
        datasource.setMaxConnectionsPerPartition(BoxesRunTime.unboxToInt((Object)config.getDeprecated("bonecp.maxConnectionsPerPartition", "maxConnectionsPerPartition", ConfigLoader$.MODULE$.intLoader())));
        datasource.setMinConnectionsPerPartition(BoxesRunTime.unboxToInt((Object)config.getDeprecated("bonecp.minConnectionsPerPartition", "minConnectionsPerPartition", ConfigLoader$.MODULE$.intLoader())));
        datasource.setAcquireIncrement(BoxesRunTime.unboxToInt((Object)config.getDeprecated("bonecp.acquireIncrement", "acquireIncrement", ConfigLoader$.MODULE$.intLoader())));
        datasource.setAcquireRetryAttempts(BoxesRunTime.unboxToInt((Object)config.getDeprecated("bonecp.acquireRetryAttempts", "acquireRetryAttempts", ConfigLoader$.MODULE$.intLoader())));
        datasource.setAcquireRetryDelayInMs(((FiniteDuration)config.getDeprecated("bonecp.acquireRetryDelay", "acquireRetryDelay", ConfigLoader$.MODULE$.finiteDurationLoader())).toMillis());
        datasource.setConnectionTimeoutInMs(((FiniteDuration)config.getDeprecated("bonecp.connectionTimeout", "connectionTimeout", ConfigLoader$.MODULE$.finiteDurationLoader())).toMillis());
        datasource.setIdleMaxAgeInSeconds(((FiniteDuration)config.getDeprecated("bonecp.idleMaxAge", "idleMaxAge", ConfigLoader$.MODULE$.finiteDurationLoader())).toSeconds());
        datasource.setMaxConnectionAgeInSeconds(((FiniteDuration)config.getDeprecated("bonecp.maxConnectionAge", "maxConnectionAge", ConfigLoader$.MODULE$.finiteDurationLoader())).toSeconds());
        datasource.setDisableJMX(BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("bonecp.disableJMX", "disableJMX", ConfigLoader$.MODULE$.booleanLoader())));
        datasource.setStatisticsEnabled(BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("bonecp.statisticsEnabled", "statisticsEnabled", ConfigLoader$.MODULE$.booleanLoader())));
        datasource.setIdleConnectionTestPeriodInSeconds(((FiniteDuration)config.getDeprecated("bonecp.idleConnectionTestPeriod", "idleConnectionTestPeriod", ConfigLoader$.MODULE$.finiteDurationLoader())).toSeconds());
        datasource.setDisableConnectionTracking(BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("bonecp.disableConnectionTracking", "disableConnectionTracking", ConfigLoader$.MODULE$.booleanLoader())));
        datasource.setQueryExecuteTimeLimitInMs(((FiniteDuration)config.getDeprecated("bonecp.queryExecuteTimeLimit", "queryExecuteTimeLimit", ConfigLoader$.MODULE$.finiteDurationLoader())).toMillis());
        datasource.setResetConnectionOnClose(BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("bonecp.resetConnectionOnClose", "resetConnectionOnClose", ConfigLoader$.MODULE$.booleanLoader())));
        datasource.setDetectUnresolvedTransactions(BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("bonecp.detectUnresolvedTransactions", "detectUnresolvedTransactions", ConfigLoader$.MODULE$.booleanLoader())));
        datasource.setLogStatementsEnabled(BoxesRunTime.unboxToBoolean((Object)config.getDeprecated("bonecp.logStatements", "logStatements", ConfigLoader$.MODULE$.booleanLoader())));
        config.getOptionalDeprecated("bonecp.initSQL", "initSQL", ConfigLoader$.MODULE$.stringLoader()).foreach((Function1)new Serializable(this, datasource){
            public static final long serialVersionUID = 0L;
            private final BoneCPDataSource datasource$1;

            public final void apply(String x$1) {
                this.datasource$1.setInitSQL(x$1);
            }
            {
                this.datasource$1 = datasource$1;
            }
        });
        config.getOptionalDeprecated("bonecp.connectionTestStatement", "connectionTestStatement", ConfigLoader$.MODULE$.stringLoader()).foreach((Function1)new Serializable(this, datasource){
            public static final long serialVersionUID = 0L;
            private final BoneCPDataSource datasource$1;

            public final void apply(String x$1) {
                this.datasource$1.setConnectionTestStatement(x$1);
            }
            {
                this.datasource$1 = datasource$1;
            }
        });
        dbConfig.jndiName().foreach((Function1)new Serializable(this, datasource){
            public static final long serialVersionUID = 0L;
            private final BoneCPDataSource datasource$1;

            public final void apply(String name) {
                JNDI$.MODULE$.initialContext().rebind(name, (Object)this.datasource$1);
                String visibleUrl = this.datasource$1.getJdbcUrl();
                BoneConnectionPool$.MODULE$.play$api$db$BoneConnectionPool$$logger().info((Function0)new Serializable(this, visibleUrl, name){
                    public static final long serialVersionUID = 0L;
                    private final String visibleUrl$1;
                    private final String name$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datasource [", "] bound to JNDI as ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.visibleUrl$1, this.name$1}));
                    }
                    {
                        this.visibleUrl$1 = visibleUrl$1;
                        this.name$1 = name$1;
                    }
                });
            }
            {
                this.datasource$1 = datasource$1;
            }
        });
        return datasource;
    }

    @Override
    public void close(DataSource ds) {
        DataSource dataSource = ds;
        if (dataSource instanceof BoneCPDataSource) {
            BoneCPDataSource boneCPDataSource = (BoneCPDataSource)dataSource;
            boneCPDataSource.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw package$.MODULE$.error("Unable to close data source: not a BoneCPDataSource");
    }

    @Inject
    public BoneConnectionPool(Environment environment) {
        this.environment = environment;
    }
}

