/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import sbt.ForkTags;
import sbt.FrameworkWrapper;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Runner;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.SubclassFingerprint;
import sbt.testing.SuiteSelector;
import sbt.testing.Task;
import sbt.testing.TaskDef;

public class ForkMain {
    static Selector forkSelector(Selector selector) {
        if (selector instanceof Serializable) {
            return selector;
        }
        throw new UnsupportedOperationException("Selector implementation must be Serializable, but " + selector.getClass().getName() + " is not.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Socket socket = new Socket(InetAddress.getByName(null), (int)Integer.valueOf(stringArray[0]));
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
        try {
            try {
                new Run().run(objectInputStream, objectOutputStream);
            }
            finally {
                objectInputStream.close();
                objectOutputStream.close();
            }
        }
        finally {
            System.exit(0);
        }
    }

    private static class Run {
        private Run() {
        }

        boolean matches(Fingerprint fingerprint, Fingerprint fingerprint2) {
            if (fingerprint instanceof SubclassFingerprint && fingerprint2 instanceof SubclassFingerprint) {
                SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint;
                SubclassFingerprint subclassFingerprint2 = (SubclassFingerprint)fingerprint2;
                return subclassFingerprint.isModule() == subclassFingerprint2.isModule() && subclassFingerprint.superclassName().equals(subclassFingerprint2.superclassName());
            }
            if (fingerprint instanceof AnnotatedFingerprint && fingerprint2 instanceof AnnotatedFingerprint) {
                AnnotatedFingerprint annotatedFingerprint = (AnnotatedFingerprint)fingerprint;
                AnnotatedFingerprint annotatedFingerprint2 = (AnnotatedFingerprint)fingerprint2;
                return annotatedFingerprint.isModule() == annotatedFingerprint2.isModule() && annotatedFingerprint.annotationName().equals(annotatedFingerprint2.annotationName());
            }
            return false;
        }

        synchronized void write(ObjectOutputStream objectOutputStream, Object object) {
            try {
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                throw new RunAborted(iOException);
            }
        }

        void logError(ObjectOutputStream objectOutputStream, String string) {
            this.write(objectOutputStream, new Object[]{ForkTags.Error, string});
        }

        void logDebug(ObjectOutputStream objectOutputStream, String string) {
            this.write(objectOutputStream, new Object[]{ForkTags.Debug, string});
        }

        void writeEvents(ObjectOutputStream objectOutputStream, TaskDef taskDef, ForkEvent[] forkEventArray) {
            this.write(objectOutputStream, new Object[]{taskDef.fullyQualifiedName(), forkEventArray});
        }

        /*
         * WARNING - void declaration
         */
        void runTests(ObjectInputStream objectInputStream, final ObjectOutputStream objectOutputStream) throws Exception {
            final boolean bl = objectInputStream.readBoolean();
            TaskDef[] taskDefArray = (TaskDef[])objectInputStream.readObject();
            int n = objectInputStream.readInt();
            Logger[] loggerArray = new Logger[]{new Logger(){

                public boolean ansiCodesSupported() {
                    return bl;
                }

                public void error(String string) {
                    Run.this.logError(objectOutputStream, string);
                }

                public void warn(String string) {
                    Run.this.write(objectOutputStream, new Object[]{ForkTags.Warn, string});
                }

                public void info(String string) {
                    Run.this.write(objectOutputStream, new Object[]{ForkTags.Info, string});
                }

                public void debug(String string) {
                    Run.this.write(objectOutputStream, new Object[]{ForkTags.Debug, string});
                }

                public void trace(Throwable throwable) {
                    Run.this.write(objectOutputStream, new ForkError(throwable));
                }
            }};
            for (int i = 0; i < n; ++i) {
                Task[] taskArray;
                void var15_20;
                Object object;
                String[] stringArray = (String[])objectInputStream.readObject();
                String[] stringArray2 = (String[])objectInputStream.readObject();
                String[] stringArray3 = (String[])objectInputStream.readObject();
                Framework framework = null;
                for (String string : stringArray) {
                    try {
                        object = Class.forName(string).newInstance();
                        if (object instanceof Framework) {
                            framework = (Framework)object;
                            break;
                        }
                        framework = new FrameworkWrapper((org.scalatools.testing.Framework)object);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.logDebug(objectOutputStream, "Framework implementation '" + string + "' not present.");
                    }
                }
                if (framework == null) continue;
                ArrayList arrayList = new ArrayList();
                Runner runner = framework.fingerprints();
                int n2 = ((Fingerprint[])runner).length;
                boolean bl2 = false;
                while (var15_20 < n2) {
                    object = runner[var15_20];
                    for (TaskDef taskDef : taskDefArray) {
                        if (!this.matches((Fingerprint)object, taskDef.fingerprint())) continue;
                        arrayList.add(new TaskDef(taskDef.fullyQualifiedName(), taskDef.fingerprint(), taskDef.explicitlySpecified(), taskDef.selectors()));
                    }
                    ++var15_20;
                }
                runner = framework.runner(stringArray2, stringArray3, this.getClass().getClassLoader());
                for (Task task : taskArray = runner.tasks(arrayList.toArray(new TaskDef[arrayList.size()]))) {
                    this.runTestSafe(task, runner, loggerArray, objectOutputStream);
                }
                runner.done();
            }
            this.write(objectOutputStream, (Object)ForkTags.Done);
            objectInputStream.readObject();
        }

        void runTestSafe(Task task, Runner runner, Logger[] loggerArray, ObjectOutputStream objectOutputStream) {
            TaskDef taskDef = task.taskDef();
            try {
                Object object = new ArrayList<NestedTask>();
                for (Task object2 : this.runTest(taskDef, task, loggerArray, objectOutputStream)) {
                    object.add(new NestedTask(taskDef.fullyQualifiedName(), object2));
                }
                while (true) {
                    ArrayList arrayList = new ArrayList();
                    int n = object.size();
                    for (int i = 0; i < n; ++i) {
                        NestedTask nestedTask = (NestedTask)object.get(i);
                        String string = nestedTask.getParentName() + "-" + i;
                        for (Task task2 : this.runTest(nestedTask.getTask().taskDef(), nestedTask.getTask(), loggerArray, objectOutputStream)) {
                            arrayList.add(new NestedTask(string, task2));
                        }
                    }
                    if (arrayList.size() != 0) {
                        object = arrayList;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.writeEvents(objectOutputStream, taskDef, new ForkEvent[]{this.testError(objectOutputStream, taskDef, "Uncaught exception when running " + taskDef.fullyQualifiedName() + ": " + throwable.toString(), throwable)});
            }
        }

        Task[] runTest(TaskDef taskDef, Task task, Logger[] loggerArray, ObjectOutputStream objectOutputStream) {
            ForkEvent[] forkEventArray;
            Task[] taskArray;
            try {
                final ArrayList arrayList = new ArrayList();
                EventHandler eventHandler = new EventHandler(){

                    public void handle(Event event) {
                        arrayList.add(new ForkEvent(event));
                    }
                };
                taskArray = task.execute(eventHandler, loggerArray);
                forkEventArray = arrayList.toArray(new ForkEvent[arrayList.size()]);
            }
            catch (Throwable throwable) {
                taskArray = new Task[]{};
                forkEventArray = new ForkEvent[]{this.testError(objectOutputStream, taskDef, "Uncaught exception when running " + taskDef.fullyQualifiedName() + ": " + throwable.toString(), throwable)};
            }
            this.writeEvents(objectOutputStream, taskDef, forkEventArray);
            return taskArray;
        }

        void run(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
            try {
                this.runTests(objectInputStream, objectOutputStream);
            }
            catch (RunAborted runAborted) {
                this.internalError(runAborted);
            }
            catch (Throwable throwable) {
                try {
                    this.logError(objectOutputStream, "Uncaught exception when running tests: " + throwable.toString());
                    this.write(objectOutputStream, new ForkError(throwable));
                }
                catch (Throwable throwable2) {
                    this.internalError(throwable2);
                }
            }
        }

        void internalError(Throwable throwable) {
            System.err.println("Internal error when running tests: " + throwable.toString());
        }

        ForkEvent testEvent(final String string, final Fingerprint fingerprint, final Selector selector, final Status status, ForkError forkError, final long l) {
            final OptionalThrowable optionalThrowable = forkError == null ? new OptionalThrowable() : new OptionalThrowable((Throwable)forkError);
            return new ForkEvent(new Event(){

                public String fullyQualifiedName() {
                    return string;
                }

                public Fingerprint fingerprint() {
                    return fingerprint;
                }

                public Selector selector() {
                    return selector;
                }

                public Status status() {
                    return status;
                }

                public OptionalThrowable throwable() {
                    return optionalThrowable;
                }

                public long duration() {
                    return l;
                }
            });
        }

        ForkEvent testError(ObjectOutputStream objectOutputStream, TaskDef taskDef, String string) {
            this.logError(objectOutputStream, string);
            return this.testEvent(taskDef.fullyQualifiedName(), taskDef.fingerprint(), (Selector)new SuiteSelector(), Status.Error, null, 0L);
        }

        ForkEvent testError(ObjectOutputStream objectOutputStream, TaskDef taskDef, String string, Throwable throwable) {
            this.logError(objectOutputStream, string);
            ForkError forkError = new ForkError(throwable);
            this.write(objectOutputStream, forkError);
            return this.testEvent(taskDef.fullyQualifiedName(), taskDef.fingerprint(), (Selector)new SuiteSelector(), Status.Error, forkError, 0L);
        }

        class NestedTask {
            private String parentName;
            private Task task;

            NestedTask(String string, Task task) {
                this.parentName = string;
                this.task = task;
            }

            public String getParentName() {
                return this.parentName;
            }

            public Task getTask() {
                return this.task;
            }
        }

        class RunAborted
        extends RuntimeException {
            RunAborted(Exception exception) {
                super(exception);
            }
        }
    }

    static class ForkEvent
    implements Event,
    Serializable {
        private String fullyQualifiedName;
        private Fingerprint fingerprint;
        private Selector selector;
        private Status status;
        private OptionalThrowable throwable;
        private long duration;

        ForkEvent(Event event) {
            this.fullyQualifiedName = event.fullyQualifiedName();
            Fingerprint fingerprint = event.fingerprint();
            this.fingerprint = fingerprint instanceof SubclassFingerprint ? new SubclassFingerscan((SubclassFingerprint)fingerprint) : new AnnotatedFingerscan((AnnotatedFingerprint)fingerprint);
            this.selector = ForkMain.forkSelector(event.selector());
            this.status = event.status();
            OptionalThrowable optionalThrowable = event.throwable();
            this.throwable = optionalThrowable.isDefined() ? new OptionalThrowable((Throwable)new ForkError(optionalThrowable.get())) : optionalThrowable;
            this.duration = event.duration();
        }

        public String fullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public Fingerprint fingerprint() {
            return this.fingerprint;
        }

        public Selector selector() {
            return this.selector;
        }

        public Status status() {
            return this.status;
        }

        public OptionalThrowable throwable() {
            return this.throwable;
        }

        public long duration() {
            return this.duration;
        }
    }

    static class ForkError
    extends Exception {
        private String originalMessage;
        private ForkError cause;

        ForkError(Throwable throwable) {
            this.originalMessage = throwable.getMessage();
            this.setStackTrace(throwable.getStackTrace());
            if (throwable.getCause() != null) {
                this.cause = new ForkError(throwable.getCause());
            }
        }

        @Override
        public String getMessage() {
            return this.originalMessage;
        }

        @Override
        public Exception getCause() {
            return this.cause;
        }
    }

    static class AnnotatedFingerscan
    implements AnnotatedFingerprint,
    Serializable {
        private boolean isModule;
        private String annotationName;

        AnnotatedFingerscan(AnnotatedFingerprint annotatedFingerprint) {
            this.isModule = annotatedFingerprint.isModule();
            this.annotationName = annotatedFingerprint.annotationName();
        }

        public boolean isModule() {
            return this.isModule;
        }

        public String annotationName() {
            return this.annotationName;
        }
    }

    static class SubclassFingerscan
    implements SubclassFingerprint,
    Serializable {
        private boolean isModule;
        private String superclassName;
        private boolean requireNoArgConstructor;

        SubclassFingerscan(SubclassFingerprint subclassFingerprint) {
            this.isModule = subclassFingerprint.isModule();
            this.superclassName = subclassFingerprint.superclassName();
            this.requireNoArgConstructor = subclassFingerprint.requireNoArgConstructor();
        }

        public boolean isModule() {
            return this.isModule;
        }

        public String superclassName() {
            return this.superclassName;
        }

        public boolean requireNoArgConstructor() {
            return this.requireNoArgConstructor;
        }
    }
}

