/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.specs2.control.ActionT;
import org.specs2.control.package$;
import org.specs2.control.package$Actions$;
import org.specs2.io.DirectoryPath;
import org.specs2.io.DirectoryPath$;
import org.specs2.io.FilePath;
import org.specs2.io.FilePath$;
import org.specs2.io.FilePathReader;
import org.specs2.io.FilePathReader$;
import org.specs2.io.Paths$;
import org.specs2.text.MD5$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.io.Codec$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scalaz.Catchable;
import scalaz.Functor;
import scalaz.Monad;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.effect.IO;
import scalaz.effect.IO$;
import scalaz.effect.MonadIO;
import scalaz.stream.Process;
import scalaz.stream.Process$;
import scalaz.stream.io$;

public abstract class FilePathReader$class {
    public static ActionT filePaths(FilePathReader $this, DirectoryPath dir2, String glob, boolean verbose) {
        return package$.MODULE$.taskToAction((Task)FilePathReader$class.filePathsProcess($this, dir2).filter($this.filterWithPattern($this.globToPattern(glob))).runLog((Monad)Task$.MODULE$.taskInstance(), (Catchable)Task$.MODULE$.taskInstance())).toAction();
    }

    public static Function1 filterWithPattern(FilePathReader $this, String pattern) {
        return new Serializable($this, pattern){
            public static final long serialVersionUID = 0L;
            private final String pattern$1;

            public final boolean apply(FilePath filePath) {
                return Paths$.MODULE$.Path(filePath.path().replaceFirst(".:", "")).unixize().matches(this.pattern$1);
            }
            {
                this.pattern$1 = pattern$1;
            }
        };
    }

    public static String globToPattern(FilePathReader $this, String glob) {
        String star = "<STAR>";
        String authorizedNamePattern = new StringBuilder().append((Object)"[^\\/\\?<>\\|\\").append((Object)star).append((Object)":\"]").append((Object)star).toString();
        return glob.replace("\\", "/").replace(".", "\\.").replace("**/", new StringBuilder().append((Object)"(").append((Object)authorizedNamePattern).append((Object)"/)").append((Object)star).toString()).replace("*", authorizedNamePattern).replace(star, "*");
    }

    public static ActionT listFilePaths(FilePathReader $this, DirectoryPath directory2) {
        return package$.MODULE$.taskToAction((Task)FilePathReader$class.filePathsProcess($this, directory2).runLog((Monad)Task$.MODULE$.taskInstance(), (Catchable)Task$.MODULE$.taskInstance())).toAction();
    }

    public static ActionT listDirectFilePaths(FilePathReader $this, DirectoryPath directory2) {
        return package$Actions$.MODULE$.safe(new Serializable($this, directory2){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath directory$1;

            public final IndexedSeq<FilePath> apply() {
                return (IndexedSeq)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)this.directory$1.toFile().listFiles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.immutable.IndexedSeq<File> apply(File[] x$1) {
                        return Predef$.MODULE$.refArrayOps((Object[])x$1).toIndexedSeq();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IndexedSeq<Nothing$> apply() {
                        return (IndexedSeq)scala.package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$2) {
                        return x$2.isFile();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FilePath apply(File f) {
                        return FilePath$.MODULE$.unsafe(f);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.directory$1 = directory$1;
            }
        }, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
    }

    public static ActionT listDirectDirectoryPaths(FilePathReader $this, DirectoryPath directory2) {
        return package$Actions$.MODULE$.safe(new Serializable($this, directory2){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath directory$2;

            public final IndexedSeq<DirectoryPath> apply() {
                return (IndexedSeq)((TraversableLike)((TraversableLike)Option$.MODULE$.apply((Object)this.directory$2.toFile().listFiles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.immutable.IndexedSeq<File> apply(File[] x$3) {
                        return Predef$.MODULE$.refArrayOps((Object[])x$3).toIndexedSeq();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IndexedSeq<Nothing$> apply() {
                        return (IndexedSeq)scala.package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$4) {
                        return x$4.isDirectory();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DirectoryPath apply(File f) {
                        return DirectoryPath$.MODULE$.unsafe(f);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.directory$2 = directory$2;
            }
        }, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
    }

    private static Process filePathsProcess(FilePathReader $this, DirectoryPath directory2) {
        return FilePathReader$class.go$1($this, directory2);
    }

    public static ActionT readFile(FilePathReader $this, FilePath path2) {
        return $this.readLines(path2).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(IndexedSeq<String> x$8) {
                return x$8.mkString("\n");
            }
        }, package$.MODULE$.LogsMonoid(), (Functor<IO>)IO$.MODULE$.ioMonadCatchIO());
    }

    public static ActionT readLines(FilePathReader $this, FilePath filePath) {
        return $this.readLinesWithCodec(filePath, Codec$.MODULE$.UTF8());
    }

    public static ActionT readFileWithCodec(FilePathReader $this, FilePath path2, Codec codec) {
        return $this.readLinesWithCodec(path2, codec).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(IndexedSeq<String> x$9) {
                return x$9.mkString("\n");
            }
        }, package$.MODULE$.LogsMonoid(), (Functor<IO>)IO$.MODULE$.ioMonadCatchIO());
    }

    public static ActionT readLinesWithCodec(FilePathReader $this, FilePath filePath, Codec codec) {
        return package$Actions$.MODULE$.fromTask((Task)io$.MODULE$.linesR(filePath.path(), codec).runLog((Monad)Task$.MODULE$.taskInstance(), (Catchable)Task$.MODULE$.taskInstance()), (MonadIO<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
    }

    public static ActionT readBytes(FilePathReader $this, FilePath filePath) {
        return $this.exists(filePath).map(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$1;

            /*
             * WARNING - void declaration
             */
            public final byte[] apply(boolean exists2) {
                byte[] byArray;
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.filePath$1.path()));
                try {
                    byArray = (byte[])((TraversableOnce)scala.package$.MODULE$.Stream().continually((Function0)new Serializable(this, stream){
                        public static final long serialVersionUID = 0L;
                        private final BufferedInputStream stream$1;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return this.stream$1.read();
                        }
                        {
                            this.stream$1 = stream$1;
                        }
                    }).takeWhile((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x) {
                            return this.apply$mcZI$sp(x);
                        }

                        public boolean apply$mcZI$sp(int x) {
                            return -1 != x;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final byte apply(int x$10) {
                            return (byte)x$10;
                        }
                    }, Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    var2_2.close();
                    throw throwable;
                }
                stream.close();
                return byArray;
            }
            {
                this.filePath$1 = filePath$1;
            }
        }, package$.MODULE$.LogsMonoid(), (Functor<IO>)IO$.MODULE$.ioMonadCatchIO());
    }

    public static ActionT md5(FilePathReader $this, FilePath filePath) {
        return $this.readBytes(filePath).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(byte[] bytes) {
                return MD5$.MODULE$.md5Hex(bytes);
            }
        }, package$.MODULE$.LogsMonoid(), (Functor<IO>)IO$.MODULE$.ioMonadCatchIO());
    }

    public static ActionT exists(FilePathReader $this, FilePath filePath) {
        return package$Actions$.MODULE$.safe(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.filePath$2.toFile().exists();
            }
            {
                this.filePath$2 = filePath$2;
            }
        }, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
    }

    public static ActionT doesNotExist(FilePathReader $this, FilePath filePath) {
        return package$Actions$.MODULE$.safe(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.filePath$3.toFile().exists();
            }
            {
                this.filePath$3 = filePath$3;
            }
        }, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
    }

    public static ActionT exists(FilePathReader $this, DirectoryPath directoryPath) {
        return package$Actions$.MODULE$.safe(new Serializable($this, directoryPath){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath directoryPath$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.directoryPath$1.toFile().exists();
            }
            {
                this.directoryPath$1 = directoryPath$1;
            }
        }, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
    }

    public static ActionT doesNotExist(FilePathReader $this, DirectoryPath directoryPath) {
        return package$Actions$.MODULE$.safe(new Serializable($this, directoryPath){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath directoryPath$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.directoryPath$2.toFile().exists();
            }
            {
                this.directoryPath$2 = directoryPath$2;
            }
        }, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
    }

    public static ActionT mustExist(FilePathReader $this, File file2) {
        return package$Actions$.MODULE$.safe(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.file$1.exists();
            }
            {
                this.file$1 = file$1;
            }
        }, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid()).flatMap(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final ActionT<IO, Vector<String>, Function1<String, IO<BoxedUnit>>, BoxedUnit> apply(boolean exists2) {
                return exists2 ? package$Actions$.MODULE$.ok(BoxedUnit.UNIT, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid()) : package$Actions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1})), (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
            }
            {
                this.file$1 = file$1;
            }
        }, package$.MODULE$.LogsMonoid(), (Monad<IO>)IO$.MODULE$.ioMonadCatchIO());
    }

    public static ActionT mustBeADirectory(FilePathReader $this, File file2) {
        return package$Actions$.MODULE$.safe(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.file$2.isDirectory();
            }
            {
                this.file$2 = file$2;
            }
        }, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid()).flatMap(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$2;

            public final ActionT<IO, Vector<String>, Function1<String, IO<BoxedUnit>>, BoxedUnit> apply(boolean isDirectory) {
                return isDirectory ? package$Actions$.MODULE$.ok(BoxedUnit.UNIT, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid()) : package$Actions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2})), (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
            }
            {
                this.file$2 = file$2;
            }
        }, package$.MODULE$.LogsMonoid(), (Monad<IO>)IO$.MODULE$.ioMonadCatchIO());
    }

    public static ActionT mustNotBeADirectory(FilePathReader $this, File file2) {
        return package$Actions$.MODULE$.safe(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.file$3.isDirectory();
            }
            {
                this.file$3 = file$3;
            }
        }, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid()).flatMap(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final File file$3;

            public final ActionT<IO, Vector<String>, Function1<String, IO<BoxedUnit>>, BoxedUnit> apply(boolean isDirectory) {
                return isDirectory ? package$Actions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$3})), (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid()) : package$Actions$.MODULE$.ok(BoxedUnit.UNIT, (Monad<IO>)IO$.MODULE$.ioMonadCatchIO(), package$.MODULE$.LogsMonoid());
            }
            {
                this.file$3 = file$3;
            }
        }, package$.MODULE$.LogsMonoid(), (Monad<IO>)IO$.MODULE$.ioMonadCatchIO());
    }

    public static final Process go$1(FilePathReader $this, DirectoryPath dir2) {
        Tuple2 tuple2 = ((TraversableLike)Option$.MODULE$.apply((Object)dir2.toFile().listFiles()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.IndexedSeq<File> apply(File[] x$5) {
                return Predef$.MODULE$.refArrayOps((Object[])x$5).toIndexedSeq();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Nothing$> apply() {
                return (IndexedSeq)scala.package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
            }
        })).partition((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$6) {
                return x$6.isFile();
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq files = (IndexedSeq)tuple2._1();
            IndexedSeq directories = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)files, (Object)directories);
            IndexedSeq files2 = (IndexedSeq)tuple23._1();
            IndexedSeq directories2 = (IndexedSeq)tuple23._2();
            return Process$.MODULE$.emitAll((Seq)files2.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final FilePath apply(File f) {
                    return FilePath$.MODULE$.unsafe(f);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).fby((Function0)new Serializable($this, directories2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FilePathReader $outer;
                private final IndexedSeq directories$1;

                public final Process<Task, FilePath> apply() {
                    return Process$.MODULE$.emitAll((Seq)((TraversableLike)this.directories$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DirectoryPath apply(File f) {
                            return DirectoryPath$.MODULE$.unsafe(f);
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ FilePathReader$.anonfun.go.1.2 $outer;

                        public final Process<Task, FilePath> apply(DirectoryPath dir2) {
                            return FilePathReader$class.go$1(this.$outer.org$specs2$io$FilePathReader$$anonfun$$$outer(), dir2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Process<Task, FilePath> apply(Process<Task, FilePath> x) {
                            return (Process)Predef$.MODULE$.identity(x);
                        }
                    });
                }

                public /* synthetic */ FilePathReader org$specs2$io$FilePathReader$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.directories$1 = directories$1;
                }
            });
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(FilePathReader $this) {
    }
}

