/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class NativeCallSite
extends IdScriptableObject {
    private static final String CALLSITE_TAG = "CallSite";
    private ScriptStackElement element;
    private static final int Id_constructor = 1;
    private static final int Id_getThis = 2;
    private static final int Id_getTypeName = 3;
    private static final int Id_getFunction = 4;
    private static final int Id_getFunctionName = 5;
    private static final int Id_getMethodName = 6;
    private static final int Id_getFileName = 7;
    private static final int Id_getLineNumber = 8;
    private static final int Id_getColumnNumber = 9;
    private static final int Id_getEvalOrigin = 10;
    private static final int Id_isToplevel = 11;
    private static final int Id_isEval = 12;
    private static final int Id_isNative = 13;
    private static final int Id_isConstructor = 14;
    private static final int Id_toString = 15;
    private static final int MAX_PROTOTYPE_ID = 15;

    static void init(Scriptable scope, boolean sealed) {
        NativeCallSite cs = new NativeCallSite();
        cs.exportAsJSClass(15, scope, sealed);
    }

    static NativeCallSite make(Scriptable scope, Scriptable ctorObj) {
        NativeCallSite cs = new NativeCallSite();
        Scriptable proto = (Scriptable)ctorObj.get("prototype", ctorObj);
        cs.setParentScope(scope);
        cs.setPrototype(proto);
        return cs;
    }

    private NativeCallSite() {
    }

    void setElement(ScriptStackElement elt) {
        this.element = elt;
    }

    public String getClassName() {
        return CALLSITE_TAG;
    }

    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 0;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "getThis";
                break;
            }
            case 3: {
                arity = 0;
                s = "getTypeName";
                break;
            }
            case 4: {
                arity = 0;
                s = "getFunction";
                break;
            }
            case 5: {
                arity = 0;
                s = "getFunctionName";
                break;
            }
            case 6: {
                arity = 0;
                s = "getMethodName";
                break;
            }
            case 7: {
                arity = 0;
                s = "getFileName";
                break;
            }
            case 8: {
                arity = 0;
                s = "getLineNumber";
                break;
            }
            case 9: {
                arity = 0;
                s = "getColumnNumber";
                break;
            }
            case 10: {
                arity = 0;
                s = "getEvalOrigin";
                break;
            }
            case 11: {
                arity = 0;
                s = "isToplevel";
                break;
            }
            case 12: {
                arity = 0;
                s = "isEval";
                break;
            }
            case 13: {
                arity = 0;
                s = "isNative";
                break;
            }
            case 14: {
                arity = 0;
                s = "isConstructor";
                break;
            }
            case 15: {
                arity = 0;
                s = "toString";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(CALLSITE_TAG, id, s, arity);
    }

    protected int findPrototypeId(String s) {
        if ("constructor".equals(s)) {
            return 1;
        }
        if ("getThis".equals(s)) {
            return 2;
        }
        if ("getTypeName".equals(s)) {
            return 3;
        }
        if ("getFunction".equals(s)) {
            return 4;
        }
        if ("getFunctionName".equals(s)) {
            return 5;
        }
        if ("getMethodName".equals(s)) {
            return 6;
        }
        if ("getFileName".equals(s)) {
            return 7;
        }
        if ("getLineNumber".equals(s)) {
            return 8;
        }
        if ("getColumnNumber".equals(s)) {
            return 9;
        }
        if ("getEvalOrigin".equals(s)) {
            return 10;
        }
        if ("isToplevel".equals(s)) {
            return 11;
        }
        if ("isEval".equals(s)) {
            return 12;
        }
        if ("isNative".equals(s)) {
            return 13;
        }
        if ("isConstructor".equals(s)) {
            return 14;
        }
        if ("toString".equals(s)) {
            return 15;
        }
        return 0;
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(CALLSITE_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                return NativeCallSite.make(scope, f);
            }
            case 2: {
                return this.getUndefined();
            }
            case 3: {
                return this.getUndefined();
            }
            case 4: {
                return this.getUndefined();
            }
            case 5: {
                return this.getFunctionName(thisObj);
            }
            case 6: {
                return this.getNull();
            }
            case 7: {
                return this.getFileName(thisObj);
            }
            case 8: {
                return this.getLineNumber(thisObj);
            }
            case 9: {
                return this.getColumnNumber(thisObj);
            }
            case 10: {
                return this.getFalse();
            }
            case 11: {
                return this.getFalse();
            }
            case 12: {
                return this.getFalse();
            }
            case 13: {
                return this.getFalse();
            }
            case 14: {
                return this.getFalse();
            }
            case 15: {
                return this.js_toString(thisObj);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public String toString() {
        if (this.element == null) {
            return "";
        }
        return this.element.toString();
    }

    private Object js_toString(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeCallSite)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeCallSite cs = (NativeCallSite)obj;
        StringBuilder sb = new StringBuilder();
        cs.element.renderLocation(sb);
        return sb.toString();
    }

    private Object getUndefined() {
        return Undefined.instance;
    }

    private Object getNull() {
        return null;
    }

    private Object getFalse() {
        return Boolean.FALSE;
    }

    private Object getFunctionName(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeCallSite)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeCallSite cs = (NativeCallSite)obj;
        return cs.element == null ? null : cs.element.functionName;
    }

    private Object getFileName(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeCallSite)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeCallSite cs = (NativeCallSite)obj;
        return cs.element == null ? null : cs.element.fileName;
    }

    private Object getLineNumber(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeCallSite)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeCallSite cs = (NativeCallSite)obj;
        if (cs.element == null || cs.element.lineNumber < 0) {
            return Undefined.instance;
        }
        return cs.element.lineNumber;
    }

    private Object getColumnNumber(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeCallSite)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeCallSite cs = (NativeCallSite)obj;
        if (cs.element == null || cs.element.columnNumber < 0) {
            return Undefined.instance;
        }
        return cs.element.columnNumber;
    }
}

