/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.CharArrayWriter;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.NativeCallSite;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.StackStyle;
import org.mozilla.javascript.TopLevel;

public abstract class RhinoException
extends RuntimeException {
    static final long serialVersionUID = 1883500631321581169L;
    private static StackStyle stackStyle = StackStyle.RHINO;
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;
    Object interpreterStackInfo;
    int[] interpreterLineData;

    RhinoException() {
        Evaluator e = Context.createInterpreter();
        if (e != null) {
            e.captureStackInfo(this);
        }
    }

    RhinoException(String details) {
        super(details);
        Evaluator e = Context.createInterpreter();
        if (e != null) {
            e.captureStackInfo(this);
        }
    }

    public final String getMessage() {
        String details = this.details();
        if (this.sourceName == null || this.lineNumber <= 0) {
            return details;
        }
        StringBuilder buf = new StringBuilder(details);
        buf.append(" (");
        if (this.sourceName != null) {
            buf.append(this.sourceName);
        }
        if (this.lineNumber > 0) {
            buf.append('#');
            buf.append(this.lineNumber);
        }
        buf.append(')');
        return buf.toString();
    }

    public String details() {
        return super.getMessage();
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final void initSourceName(String sourceName) {
        if (sourceName == null) {
            throw new IllegalArgumentException();
        }
        if (this.sourceName != null) {
            throw new IllegalStateException();
        }
        this.sourceName = sourceName;
    }

    public final int lineNumber() {
        return this.lineNumber;
    }

    public final void initLineNumber(int lineNumber) {
        if (lineNumber <= 0) {
            throw new IllegalArgumentException(String.valueOf(lineNumber));
        }
        if (this.lineNumber > 0) {
            throw new IllegalStateException();
        }
        this.lineNumber = lineNumber;
    }

    public final int columnNumber() {
        return this.columnNumber;
    }

    public final void initColumnNumber(int columnNumber) {
        if (columnNumber <= 0) {
            throw new IllegalArgumentException(String.valueOf(columnNumber));
        }
        if (this.columnNumber > 0) {
            throw new IllegalStateException();
        }
        this.columnNumber = columnNumber;
    }

    public final String lineSource() {
        return this.lineSource;
    }

    public final void initLineSource(String lineSource) {
        if (lineSource == null) {
            throw new IllegalArgumentException();
        }
        if (this.lineSource != null) {
            throw new IllegalStateException();
        }
        this.lineSource = lineSource;
    }

    final void recordErrorOrigin(String sourceName, int lineNumber, String lineSource, int columnNumber) {
        if (lineNumber == -1) {
            lineNumber = 0;
        }
        if (sourceName != null) {
            this.initSourceName(sourceName);
        }
        if (lineNumber != 0) {
            this.initLineNumber(lineNumber);
        }
        if (lineSource != null) {
            this.initLineSource(lineSource);
        }
        if (columnNumber != 0) {
            this.initColumnNumber(columnNumber);
        }
    }

    private String generateStackTrace() {
        CharArrayWriter writer = new CharArrayWriter();
        super.printStackTrace(new PrintWriter(writer));
        String origStackTrace = writer.toString();
        Evaluator e = Context.createInterpreter();
        if (e != null) {
            return e.getPatchedStack(this, origStackTrace);
        }
        return null;
    }

    public String getScriptStackTrace() {
        ScriptStackElement[] stack;
        StringBuilder buffer = new StringBuilder();
        String lineSeparator = SecurityUtilities.getSystemProperty("line.separator");
        for (ScriptStackElement elem : stack = this.getScriptStack()) {
            elem.render(buffer);
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    public Object getPreparedScriptStackTrace(Context cx, Scriptable scope, Scriptable err) {
        Scriptable top = ScriptableObject.getTopLevelScope(scope);
        Function error = TopLevel.getBuiltinCtor(cx, top, TopLevel.Builtins.Error);
        Object prepare = error.get("prepareStackTrace", (Scriptable)error);
        if (prepare instanceof Function) {
            Function prepareFunc = (Function)prepare;
            ScriptStackElement[] elts = this.getScriptStack();
            Object[] rawStack = new Object[elts.length];
            for (int i = 0; i < elts.length; ++i) {
                rawStack[i] = cx.newObject(top, "CallSite");
                ((NativeCallSite)rawStack[i]).setElement(elts[i]);
            }
            return prepareFunc.call(cx, scope, null, new Object[]{err, cx.newArray(top, rawStack)});
        }
        return this.getScriptStackTrace();
    }

    public String getScriptStackTrace(FilenameFilter filter) {
        return this.getScriptStackTrace();
    }

    public ScriptStackElement[] getScriptStack() {
        Evaluator interpreter;
        ArrayList<ScriptStackElement> list = new ArrayList<ScriptStackElement>();
        ScriptStackElement[][] interpreterStack = null;
        if (this.interpreterStackInfo != null && (interpreter = Context.createInterpreter()) instanceof Interpreter) {
            interpreterStack = ((Interpreter)interpreter).getScriptStackElements(this);
        }
        int interpreterStackIndex = 0;
        StackTraceElement[] stack = this.getStackTrace();
        Pattern pattern = Pattern.compile("_c_(.*)_\\d+");
        for (StackTraceElement e : stack) {
            String fileName = e.getFileName();
            if (e.getMethodName().startsWith("_c_") && e.getLineNumber() > -1 && fileName != null && !fileName.endsWith(".java")) {
                String methodName = e.getMethodName();
                Matcher match = pattern.matcher(methodName);
                methodName = !"_c_script_0".equals(methodName) && match.find() ? match.group(1) : null;
                list.add(new ScriptStackElement(fileName, methodName, e.getLineNumber()));
                continue;
            }
            if (!"org.mozilla.javascript.Interpreter".equals(e.getClassName()) || !"interpretLoop".equals(e.getMethodName()) || interpreterStack == null || interpreterStack.length <= interpreterStackIndex) continue;
            for (ScriptStackElement elem : interpreterStack[interpreterStackIndex++]) {
                list.add(elem);
            }
        }
        return list.toArray(new ScriptStackElement[list.size()]);
    }

    public void printStackTrace(PrintWriter s) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(s);
        } else {
            s.print(this.generateStackTrace());
        }
    }

    public void printStackTrace(PrintStream s) {
        if (this.interpreterStackInfo == null) {
            super.printStackTrace(s);
        } else {
            s.print(this.generateStackTrace());
        }
    }

    public static boolean usesMozillaStackStyle() {
        return stackStyle == StackStyle.MOZILLA;
    }

    public static void useMozillaStackStyle(boolean flag) {
        stackStyle = flag ? StackStyle.MOZILLA : StackStyle.RHINO;
    }

    public static StackStyle getStackStyle() {
        return stackStyle;
    }

    public static void setStackStyle(StackStyle style) {
        stackStyle = style;
    }
}

