/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.deliver.DeliverOptions;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.publish.PublishOptions;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.DefaultMessageLogger;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.cli.CommandLine;
import org.apache.ivy.util.cli.CommandLineParser;
import org.apache.ivy.util.cli.OptionBuilder;
import org.apache.ivy.util.cli.ParseException;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.apache.ivy.util.filter.FilterHelper;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerDispatcher;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class Main {
    private static final int HELP_WIDTH = 80;

    static CommandLineParser getParser() {
        return new CommandLineParser().addCategory("settings options").addOption(new OptionBuilder("settings").arg("settingsfile").description("use given file for settings").create()).addOption(new OptionBuilder("cache").arg("cachedir").description("use given directory for cache").create()).addOption(new OptionBuilder("novalidate").description("do not validate ivy files against xsd").create()).addOption(new OptionBuilder("m2compatible").description("use maven2 compatibility").create()).addOption(new OptionBuilder("conf").arg("settingsfile").deprecated().description("use given file for settings").create()).addOption(new OptionBuilder("useOrigin").deprecated().description("use original artifact location with local resolvers instead of copying to the cache").create()).addCategory("resolve options").addOption(new OptionBuilder("ivy").arg("ivyfile").description("use given file as ivy file").create()).addOption(new OptionBuilder("refresh").description("refresh dynamic resolved revisions").create()).addOption(new OptionBuilder("dependency").arg("organisation").arg("module").arg("revision").description("use this instead of ivy file to do the rest of the work with this as a dependency.").create()).addOption(new OptionBuilder("confs").arg("configurations").countArgs(false).description("resolve given configurations").create()).addOption(new OptionBuilder("types").arg("types").countArgs(false).description("comma separated list of accepted artifact types").create()).addOption(new OptionBuilder("mode").arg("resolvemode").description("the resolve mode to use").create()).addOption(new OptionBuilder("notransitive").description("do not resolve dependencies transitively").create()).addCategory("retrieve options").addOption(new OptionBuilder("retrieve").arg("retrievepattern").description("use given pattern as retrieve pattern").create()).addOption(new OptionBuilder("ivypattern").arg("pattern").description("use given pattern to copy the ivy files").create()).addOption(new OptionBuilder("sync").description("use sync mode for retrieve").create()).addOption(new OptionBuilder("symlink").description("create symbolic links").create()).addCategory("cache path options").addOption(new OptionBuilder("cachepath").arg("cachepathfile").description("outputs a classpath consisting of all dependencies in cache (including transitive ones) of the given ivy file to the given cachepathfile").create()).addCategory("deliver options").addOption(new OptionBuilder("deliverto").arg("ivypattern").description("use given pattern as resolved ivy file pattern").create()).addCategory("publish options").addOption(new OptionBuilder("publish").arg("resolvername").description("use given resolver to publish to").create()).addOption(new OptionBuilder("publishpattern").arg("artpattern").description("use given pattern to find artifacts to publish").create()).addOption(new OptionBuilder("revision").arg("revision").description("use given revision to publish the module").create()).addOption(new OptionBuilder("status").arg("status").description("use given status to publish the module").create()).addOption(new OptionBuilder("overwrite").description("overwrite files in the repository if they exist").create()).addCategory("http auth options").addOption(new OptionBuilder("realm").arg("realm").description("use given realm for HTTP AUTH").create()).addOption(new OptionBuilder("host").arg("host").description("use given host for HTTP AUTH").create()).addOption(new OptionBuilder("username").arg("username").description("use given username for HTTP AUTH").create()).addOption(new OptionBuilder("passwd").arg("passwd").description("use given password for HTTP AUTH").create()).addCategory("launcher options").addOption(new OptionBuilder("main").arg("main").description("the FQCN of the main class to launch").create()).addOption(new OptionBuilder("args").arg("args").countArgs(false).description("the arguments to give to the launched process").create()).addOption(new OptionBuilder("cp").arg("cp").description("extra classpath to use when launching process").create()).addCategory("message options").addOption(new OptionBuilder("debug").description("set message level to debug").create()).addOption(new OptionBuilder("verbose").description("set message level to verbose").create()).addOption(new OptionBuilder("warn").description("set message level to warn").create()).addOption(new OptionBuilder("error").description("set message level to error").create()).addCategory("help options").addOption(new OptionBuilder("?").description("display this help").create()).addOption(new OptionBuilder("deprecated").description("show deprecated options").create()).addOption(new OptionBuilder("version").description("displays version information").create());
    }

    public static void main(String[] stringArray) throws Exception {
        CommandLineParser commandLineParser = Main.getParser();
        try {
            Main.run(commandLineParser, stringArray);
            System.exit(0);
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            Main.usage(commandLineParser, false);
            System.exit(1);
        }
    }

    static void run(CommandLineParser commandLineParser, String[] stringArray) throws Exception {
        String[] stringArray2;
        ExtendableItem extendableItem;
        Object object;
        File file;
        Object object2;
        CommandLine commandLine = commandLineParser.parse(stringArray);
        if (commandLine.hasOption("?")) {
            Main.usage(commandLineParser, commandLine.hasOption("deprecated"));
            return;
        }
        if (commandLine.hasOption("version")) {
            System.out.println("Apache Ivy " + Ivy.getIvyVersion() + " - " + Ivy.getIvyDate() + " :: " + Ivy.getIvyHomeURL());
            return;
        }
        boolean bl = !commandLine.hasOption("novalidate");
        Ivy ivy = Ivy.newInstance();
        Main.initMessage(commandLine, ivy);
        IvySettings ivySettings = Main.initSettings(commandLine, ivy);
        ivy.pushContext();
        File file2 = new File(ivySettings.substitute(commandLine.getOptionValue("cache", ivySettings.getDefaultCache().getAbsolutePath())));
        if (commandLine.hasOption("cache")) {
            ivySettings.setDefaultCache(file2);
        }
        if (!file2.exists()) {
            file2.mkdirs();
        } else if (!file2.isDirectory()) {
            Main.error(file2 + " is not a directory");
        }
        String[] stringArray3 = commandLine.hasOption("confs") ? commandLine.getOptionValues("confs") : new String[]{"*"};
        if (commandLine.hasOption("dependency")) {
            object2 = commandLine.getOptionValues("dependency");
            file = File.createTempFile("ivy", ".xml");
            file.deleteOnExit();
            object = DefaultModuleDescriptor.newDefaultInstance(ModuleRevisionId.newInstance(object2[0], object2[1] + "-caller", "working"));
            extendableItem = new DefaultDependencyDescriptor((ModuleDescriptor)object, ModuleRevisionId.newInstance(object2[0], object2[1], object2[2]), false, false, true);
            for (int i = 0; i < stringArray3.length; ++i) {
                ((DefaultDependencyDescriptor)extendableItem).addDependencyConfiguration("default", stringArray3[i]);
            }
            ((DefaultModuleDescriptor)object).addDependency((DependencyDescriptor)extendableItem);
            XmlModuleDescriptorWriter.write((ModuleDescriptor)object, file);
            stringArray3 = new String[]{"default"};
        } else {
            file = new File(ivySettings.substitute(commandLine.getOptionValue("ivy", "ivy.xml")));
            if (!file.exists()) {
                Main.error("ivy file not found: " + file);
            } else if (file.isDirectory()) {
                Main.error("ivy file is not a file: " + file);
            }
        }
        if (commandLine.hasOption("useOrigin")) {
            ivy.getSettings().useDeprecatedUseOrigin();
        }
        object2 = new ResolveOptions().setConfs(stringArray3).setValidate(bl).setResolveMode(commandLine.getOptionValue("mode")).setArtifactFilter(FilterHelper.getArtifactTypeFilter(commandLine.getOptionValues("types")));
        if (commandLine.hasOption("notransitive")) {
            ((ResolveOptions)object2).setTransitive(false);
        }
        if (commandLine.hasOption("refresh")) {
            ((ResolveOptions)object2).setRefresh(true);
        }
        if (((ResolveReport)(object = ivy.resolve(file.toURI().toURL(), (ResolveOptions)object2))).hasError()) {
            System.exit(1);
        }
        extendableItem = ((ResolveReport)object).getModuleDescriptor();
        if (stringArray3.length == 1 && "*".equals(stringArray3[0])) {
            stringArray3 = extendableItem.getConfigurationsNames();
        }
        if (commandLine.hasOption("retrieve")) {
            String string = ivySettings.substitute(commandLine.getOptionValue("retrieve"));
            if (string.indexOf("[") == -1) {
                string = string + "/lib/[conf]/[artifact].[ext]";
            }
            stringArray2 = ivySettings.substitute(commandLine.getOptionValue("ivypattern"));
            ivy.retrieve(extendableItem.getModuleRevisionId(), string, new RetrieveOptions().setConfs(stringArray3).setSync(commandLine.hasOption("sync")).setUseOrigin(commandLine.hasOption("useOrigin")).setDestIvyPattern((String)stringArray2).setArtifactFilter(FilterHelper.getArtifactTypeFilter(commandLine.getOptionValues("types"))).setMakeSymlinks(commandLine.hasOption("symlink")).setMakeSymlinksInMass(commandLine.hasOption("symlinkmass")));
        }
        if (commandLine.hasOption("cachepath")) {
            Main.outputCachePath(ivy, file2, (ModuleDescriptor)extendableItem, stringArray3, commandLine.getOptionValue("cachepath", "ivycachepath.txt"));
        }
        if (commandLine.hasOption("revision")) {
            ivy.deliver(extendableItem.getResolvedModuleRevisionId(), ivySettings.substitute(commandLine.getOptionValue("revision")), ivySettings.substitute(commandLine.getOptionValue("deliverto", "ivy-[revision].xml")), DeliverOptions.newInstance(ivySettings).setStatus(ivySettings.substitute(commandLine.getOptionValue("status", "release"))).setValidate(bl));
            if (commandLine.hasOption("publish")) {
                ivy.publish(extendableItem.getResolvedModuleRevisionId(), Collections.singleton(ivySettings.substitute(commandLine.getOptionValue("publishpattern", "distrib/[type]s/[artifact]-[revision].[ext]"))), commandLine.getOptionValue("publish"), new PublishOptions().setPubrevision(ivySettings.substitute(commandLine.getOptionValue("revision"))).setValidate(bl).setSrcIvyPattern(ivySettings.substitute(commandLine.getOptionValue("deliverto", "ivy-[revision].xml"))).setOverwrite(commandLine.hasOption("overwrite")));
            }
        }
        if (commandLine.hasOption("main")) {
            String[] stringArray4;
            List list = Main.getExtraClasspathFileList(commandLine);
            stringArray2 = commandLine.getOptionValues("args");
            if (stringArray2 == null) {
                stringArray2 = new String[]{};
            }
            if ((stringArray4 = commandLine.getLeftOverArgs()) == null) {
                stringArray4 = new String[]{};
            }
            String[] stringArray5 = new String[stringArray2.length + stringArray4.length];
            System.arraycopy(stringArray2, 0, stringArray5, 0, stringArray2.length);
            System.arraycopy(stringArray4, 0, stringArray5, stringArray2.length, stringArray4.length);
            Main.invoke(ivy, file2, (ModuleDescriptor)extendableItem, stringArray3, list, commandLine.getOptionValue("main"), stringArray5);
        }
        ivy.getLoggerEngine().popLogger();
        ivy.popContext();
    }

    private static List getExtraClasspathFileList(CommandLine commandLine) {
        ArrayList<File> arrayList = null;
        if (commandLine.hasOption("cp")) {
            arrayList = new ArrayList<File>();
            String[] stringArray = commandLine.getOptionValues("cp");
            for (int i = 0; i < stringArray.length; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], System.getProperty("path.separator"));
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    File file = new File(string);
                    if (file.exists()) {
                        arrayList.add(file);
                        continue;
                    }
                    Message.warn("Skipping extra classpath '" + file + "' as it does not exist.");
                }
            }
        }
        return arrayList;
    }

    private static IvySettings initSettings(CommandLine commandLine, Ivy ivy) throws java.text.ParseException, IOException, ParseException {
        IvySettings ivySettings = ivy.getSettings();
        ivySettings.addAllVariables(System.getProperties());
        if (commandLine.hasOption("m2compatible")) {
            ivySettings.setVariable("ivy.default.configuration.m2compatible", "true");
        }
        Main.configureURLHandler(commandLine.getOptionValue("realm", null), commandLine.getOptionValue("host", null), commandLine.getOptionValue("username", null), commandLine.getOptionValue("passwd", null));
        String string = commandLine.getOptionValue("settings", "");
        if ("".equals(string) && !"".equals(string = commandLine.getOptionValue("conf", ""))) {
            Message.deprecated("-conf is deprecated, use -settings instead");
        }
        if ("".equals(string)) {
            ivy.configureDefault();
        } else {
            File file = new File(string);
            if (!file.exists()) {
                Main.error("ivy configuration file not found: " + file);
            } else if (file.isDirectory()) {
                Main.error("ivy configuration file is not a file: " + file);
            }
            ivy.configure(file);
        }
        return ivySettings;
    }

    private static void initMessage(CommandLine commandLine, Ivy ivy) {
        if (commandLine.hasOption("debug")) {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(4));
        } else if (commandLine.hasOption("verbose")) {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(3));
        } else if (commandLine.hasOption("warn")) {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(1));
        } else if (commandLine.hasOption("error")) {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(0));
        } else {
            ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(2));
        }
    }

    private static void outputCachePath(Ivy ivy, File file, ModuleDescriptor moduleDescriptor, String[] stringArray, String string) {
        try {
            String string2 = System.getProperty("path.separator");
            StringBuffer stringBuffer = new StringBuffer();
            LinkedHashSet<ArtifactDownloadReport> linkedHashSet = new LinkedHashSet<ArtifactDownloadReport>();
            ResolutionCacheManager resolutionCacheManager = ivy.getResolutionCacheManager();
            XmlReportParser xmlReportParser = new XmlReportParser();
            for (int i = 0; i < stringArray.length; ++i) {
                String object = ResolveOptions.getDefaultResolveId(moduleDescriptor);
                File file2 = resolutionCacheManager.getConfigurationResolveReportInCache(object, stringArray[i]);
                xmlReportParser.parse(file2);
                linkedHashSet.addAll(Arrays.asList(xmlReportParser.getArtifactReports()));
            }
            for (ArtifactDownloadReport artifactDownloadReport : linkedHashSet) {
                if (artifactDownloadReport.getLocalFile() == null) continue;
                stringBuffer.append(artifactDownloadReport.getLocalFile().getCanonicalPath());
                stringBuffer.append(string2);
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            if (stringBuffer.length() > 0) {
                printWriter.println(stringBuffer.substring(0, stringBuffer.length() - string2.length()));
            }
            printWriter.close();
            System.out.println("cachepath output to " + string);
        }
        catch (Exception exception) {
            throw new RuntimeException("impossible to build ivy cache path: " + exception.getMessage(), exception);
        }
    }

    private static void invoke(Ivy ivy, File file, ModuleDescriptor moduleDescriptor, String[] stringArray, List list, String string, String[] stringArray2) {
        Object object;
        Object object2;
        Class<?> clazz2;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (list != null && list.size() > 0) {
            for (Class<?> clazz2 : list) {
                try {
                    arrayList.add(((File)((Object)clazz2)).toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        try {
            Object object3;
            object2 = new LinkedHashSet();
            clazz2 = ivy.getResolutionCacheManager();
            object = new XmlReportParser();
            for (int i = 0; i < stringArray.length; ++i) {
                object3 = ResolveOptions.getDefaultResolveId(moduleDescriptor);
                File file2 = clazz2.getConfigurationResolveReportInCache((String)object3, stringArray[i]);
                ((XmlReportParser)object).parse(file2);
                object2.addAll(Arrays.asList(((XmlReportParser)object).getArtifactReports()));
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object3 = (ArtifactDownloadReport)iterator.next();
                if (((ArtifactDownloadReport)object3).getLocalFile() == null) continue;
                arrayList.add(((ArtifactDownloadReport)object3).getLocalFile().toURI().toURL());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("impossible to build ivy cache path: " + exception.getMessage(), exception);
        }
        object2 = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), Main.class.getClassLoader());
        try {
            clazz2 = ((ClassLoader)object2).loadClass(string);
            object = clazz2.getMethod("main", String[].class);
            Thread.currentThread().setContextClassLoader((ClassLoader)object2);
            ((Method)object).invoke(null, new Object[]{stringArray2 == null ? new String[]{} : stringArray2});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Could not find class: " + string, classNotFoundException);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("Could not find main method: " + string, securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Could not find main method: " + string, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("No permissions to invoke main method: " + string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Unexpected exception invoking main method: " + string, invocationTargetException);
        }
    }

    private static void configureURLHandler(String string, String string2, String string3, String string4) {
        CredentialsStore.INSTANCE.addCredentials(string, string2, string3, string4);
        URLHandlerDispatcher uRLHandlerDispatcher = new URLHandlerDispatcher();
        URLHandler uRLHandler = URLHandlerRegistry.getHttp();
        uRLHandlerDispatcher.setDownloader("http", uRLHandler);
        uRLHandlerDispatcher.setDownloader("https", uRLHandler);
        URLHandlerRegistry.setDefault(uRLHandlerDispatcher);
    }

    private static void error(String string) throws ParseException {
        throw new ParseException(string);
    }

    private static void usage(CommandLineParser commandLineParser, boolean bl) {
        PrintWriter printWriter = new PrintWriter(System.out);
        commandLineParser.printHelp(printWriter, 80, "ivy", bl);
        printWriter.flush();
    }

    private Main() {
    }
}

