/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.AntMessageLogger;
import org.apache.ivy.ant.IvyAntVariableContainer;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerDispatcher;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.DataType;

public class IvyAntSettings
extends DataType {
    private Ivy ivyEngine = null;
    private File file = null;
    private URL url = null;
    private String realm = null;
    private String host = null;
    private String userName = null;
    private String passwd = null;
    private String id = "ivy.instance";
    private boolean autoRegistered = false;

    public static IvyAntSettings getDefaultInstance(ProjectComponent projectComponent) {
        Project project = projectComponent.getProject();
        Object object = project.getReference("ivy.instance");
        if (object != null && object.getClass().getClassLoader() != IvyAntSettings.class.getClassLoader()) {
            projectComponent.log("ivy.instance reference an ivy:settings defined in an other classloader.  An new default one will be used in this project.", 1);
            object = null;
        }
        if (object != null && !(object instanceof IvyAntSettings)) {
            throw new BuildException("ivy.instance reference a " + object.getClass().getName() + " an not an IvyAntSettings.  Please don't use this reference id ()");
        }
        if (object == null) {
            projectComponent.log("No ivy:settings found for the default reference 'ivy.instance'.  A default instance will be used", 3);
            IvyAntSettings ivyAntSettings = new IvyAntSettings();
            ivyAntSettings.setProject(project);
            project.addReference("ivy.instance", (Object)ivyAntSettings);
            ivyAntSettings.createIvyEngine(projectComponent);
            return ivyAntSettings;
        }
        return (IvyAntSettings)((Object)object);
    }

    public static IvyAntSettings getDefaultInstance(Task task) {
        return IvyAntSettings.getDefaultInstance((ProjectComponent)task);
    }

    public File getFile() {
        return this.file;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String string) {
        this.passwd = string;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String string) {
        this.realm = IvyAntSettings.format(string);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = IvyAntSettings.format(string);
    }

    public String getUsername() {
        return this.userName;
    }

    public void setUsername(String string) {
        this.userName = IvyAntSettings.format(string);
    }

    public void setProject(Project project) {
        super.setProject(project);
        if ("ivy.instance".equals(this.id) && !this.getProject().getReferences().containsKey(this.id)) {
            this.getProject().addReference("ivy.instance", (Object)this);
            this.autoRegistered = true;
        }
    }

    private static String format(String string) {
        return string == null ? string : (string.trim().length() == 0 ? null : string.trim());
    }

    public void addConfiguredCredentials(Credentials credentials) {
        CredentialsStore.INSTANCE.addCredentials(credentials.getRealm(), credentials.getHost(), credentials.getUsername(), credentials.getPasswd());
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setUrl(String string) throws MalformedURLException {
        this.url = new URL(string);
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public void setId(String string) {
        if (this.autoRegistered && this.getProject().getReference(this.id) == this) {
            this.getProject().getReferences().remove(this.id);
            this.autoRegistered = false;
        }
        this.id = string;
        if (this.getProject() != null) {
            this.getProject().addReference(this.id, (Object)this);
        }
    }

    public String getId() {
        return this.id;
    }

    public Ivy getConfiguredIvyInstance(ProjectComponent projectComponent) {
        if (this.ivyEngine == null) {
            this.createIvyEngine(projectComponent);
        }
        return this.ivyEngine;
    }

    public Ivy getConfiguredIvyInstance(Task task) {
        return this.getConfiguredIvyInstance((ProjectComponent)task);
    }

    void createIvyEngine(final ProjectComponent projectComponent) {
        Project project = projectComponent.getProject();
        Property property = new Property(){

            public void execute() throws BuildException {
                this.addProperties(IvyAntSettings.this.getDefaultProperties(projectComponent));
            }
        };
        property.setProject(project);
        property.init();
        property.execute();
        IvyAntVariableContainer ivyAntVariableContainer = new IvyAntVariableContainer(project);
        IvySettings ivySettings = new IvySettings(ivyAntVariableContainer);
        ivySettings.setBaseDir(project.getBaseDir());
        if (this.file == null && this.url == null) {
            this.defineDefaultSettingFile(ivyAntVariableContainer, projectComponent);
        }
        Ivy ivy = Ivy.newInstance(ivySettings);
        try {
            ivy.pushContext();
            AntMessageLogger.register(projectComponent, ivy);
            Message.showInfo();
            this.configureURLHandler();
            if (this.file != null) {
                if (!this.file.exists()) {
                    throw new BuildException("settings file does not exist: " + this.file);
                }
                ivy.configure(this.file);
            } else {
                if (this.url == null) {
                    throw new AssertionError((Object)"ivy setting should have either a file, either an url, and if not defineDefaultSettingFile must set it.");
                }
                ivy.configure(this.url);
            }
            ivyAntVariableContainer.updateProject(this.id);
            this.ivyEngine = ivy;
        }
        catch (ParseException parseException) {
            throw new BuildException("impossible to configure ivy:settings with given " + (this.file != null ? "file: " + this.file : "url: " + this.url) + " : " + parseException, (Throwable)parseException);
        }
        catch (IOException iOException) {
            throw new BuildException("impossible to configure ivy:settings with given " + (this.file != null ? "file: " + this.file : "url: " + this.url) + " : " + iOException, (Throwable)iOException);
        }
        finally {
            ivy.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getDefaultProperties(ProjectComponent projectComponent) {
        URL uRL = IvySettings.getDefaultPropertiesURL();
        Properties properties = new Properties();
        projectComponent.log("Loading " + uRL, 3);
        try {
            InputStream inputStream = uRL.openStream();
            try {
                properties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        return properties;
    }

    private void defineDefaultSettingFile(IvyVariableContainer ivyVariableContainer, ProjectComponent projectComponent) {
        String string = ivyVariableContainer.getVariable("ivy.conf.file");
        if (string != null && !string.equals(ivyVariableContainer.getVariable("ivy.settings.file"))) {
            projectComponent.log("DEPRECATED: 'ivy.conf.file' is deprecated, use 'ivy.settings.file' instead", 2);
        } else {
            string = ivyVariableContainer.getVariable("ivy.settings.file");
        }
        File[] fileArray = new File[]{new File(this.getProject().getBaseDir(), string), new File(this.getProject().getBaseDir(), "ivyconf.xml"), new File(string), new File("ivyconf.xml")};
        for (int i = 0; i < fileArray.length; ++i) {
            this.file = fileArray[i];
            projectComponent.log("searching settings file: trying " + this.file, 3);
            if (this.file.exists()) break;
        }
        if (!this.file.exists()) {
            this.file = null;
            if (Boolean.valueOf(this.getProject().getProperty("ivy.14.compatible")).booleanValue()) {
                projectComponent.log("no settings file found, using Ivy 1.4 default...", 3);
                this.url = IvySettings.getDefault14SettingsURL();
            } else {
                String string2 = ivyVariableContainer.getVariable("ivy.settings.url");
                if (string2 != null) {
                    try {
                        this.url = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new BuildException("Impossible to configure ivy:settings with given url: " + string2 + ": " + malformedURLException.getMessage(), (Throwable)malformedURLException);
                    }
                } else {
                    projectComponent.log("no settings file found, using default...", 3);
                    this.url = IvySettings.getDefaultSettingsURL();
                }
            }
        }
    }

    private void configureURLHandler() {
        CredentialsStore.INSTANCE.addCredentials(this.getRealm(), this.getHost(), this.getUsername(), this.getPasswd());
        URLHandlerDispatcher uRLHandlerDispatcher = new URLHandlerDispatcher();
        URLHandler uRLHandler = URLHandlerRegistry.getHttp();
        uRLHandlerDispatcher.setDownloader("http", uRLHandler);
        uRLHandlerDispatcher.setDownloader("https", uRLHandler);
        URLHandlerRegistry.setDefault(uRLHandlerDispatcher);
    }

    public static class Credentials {
        private String realm;
        private String host;
        private String username;
        private String passwd;

        public String getPasswd() {
            return this.passwd;
        }

        public void setPasswd(String string) {
            this.passwd = string;
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String string) {
            this.realm = IvyAntSettings.format(string);
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String string) {
            this.host = IvyAntSettings.format(string);
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String string) {
            this.username = IvyAntSettings.format(string);
        }
    }
}

