/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.install.InstallOptions;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.filter.FilterHelper;
import org.apache.tools.ant.BuildException;

public class IvyInstall
extends IvyTask {
    private String organisation;
    private String module;
    private String revision;
    private String branch;
    private String conf = "*";
    private boolean overwrite = false;
    private String from;
    private String to;
    private boolean transitive;
    private String type;
    private String matcher = "exact";
    private boolean haltOnFailure = true;
    private boolean installOriginalMetadata = false;

    @Override
    public void doExecute() throws BuildException {
        ResolveReport resolveReport;
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        if (this.organisation == null) {
            throw new BuildException("no organisation provided for ivy publish task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this.module == null && "exact".equals(this.matcher)) {
            throw new BuildException("no module name provided for ivy publish task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this.module == null && !"exact".equals(this.matcher)) {
            this.module = "*";
        }
        if (this.revision == null && "exact".equals(this.matcher)) {
            throw new BuildException("no module revision provided for ivy publish task: It can either be set explicitely via the attribute 'revision' or via 'ivy.revision' property or a prior call to <resolve/>");
        }
        if (this.revision == null && !"exact".equals(this.matcher)) {
            this.revision = "*";
        }
        if (this.branch == null && "exact".equals(this.matcher)) {
            this.branch = ivySettings.getDefaultBranch(ModuleId.newInstance(this.organisation, this.module));
        } else if (this.branch == null && !"exact".equals(this.matcher)) {
            this.branch = "*";
        }
        if (this.from == null) {
            throw new BuildException("no from resolver name: please provide it through parameter 'from'");
        }
        if (this.to == null) {
            throw new BuildException("no to resolver name: please provide it through parameter 'to'");
        }
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision);
        try {
            resolveReport = ivy.install(moduleRevisionId, this.from, this.to, new InstallOptions().setTransitive(this.transitive).setValidate(this.doValidate(ivySettings)).setOverwrite(this.overwrite).setConfs(this.conf.split(",")).setArtifactFilter(FilterHelper.getArtifactTypeFilter(this.type)).setMatcherName(this.matcher).setInstallOriginalMetadata(this.installOriginalMetadata));
        }
        catch (Exception exception) {
            throw new BuildException("impossible to install " + moduleRevisionId + ": " + exception, (Throwable)exception);
        }
        if (resolveReport.hasError() && this.isHaltonfailure()) {
            throw new BuildException("Problem happened while installing modules - see output for details");
        }
    }

    public boolean isHaltonfailure() {
        return this.haltOnFailure;
    }

    public void setHaltonfailure(boolean bl) {
        this.haltOnFailure = bl;
    }

    public void setCache(File file) {
        this.cacheAttributeNotSupported();
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String string) {
        this.to = string;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public void setTransitive(boolean bl) {
        this.transitive = bl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String string) {
        this.matcher = string;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String string) {
        this.conf = string;
    }

    public boolean isInstallOriginalMetadata() {
        return this.installOriginalMetadata;
    }

    public void setInstallOriginalMetadata(boolean bl) {
        this.installOriginalMetadata = bl;
    }
}

