/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyDeliver;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.publish.PublishOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.DateUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;

public class IvyPublish
extends IvyTask {
    private String organisation;
    private String module;
    private String revision;
    private String pubRevision;
    private String srcivypattern;
    private String status;
    private String conf = null;
    private String pubdate;
    private String deliverTarget;
    private String publishResolverName = null;
    private List artifactspattern = new ArrayList();
    private File deliveryList;
    private boolean publishivy = true;
    private boolean warnonmissing = true;
    private boolean haltonmissing = true;
    private boolean overwrite = false;
    private boolean update = false;
    private boolean merge = true;
    private boolean replacedynamicrev = true;
    private boolean forcedeliver;
    private Collection artifacts = new ArrayList();
    private String pubBranch;

    public void setCache(File file) {
        this.cacheAttributeNotSupported();
    }

    public String getSrcivypattern() {
        return this.srcivypattern;
    }

    public void setSrcivypattern(String string) {
        this.srcivypattern = string;
    }

    @Deprecated
    public String getDeliverivypattern() {
        return this.srcivypattern;
    }

    @Deprecated
    public void setDeliverivypattern(String string) {
        this.srcivypattern = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getPubdate() {
        return this.pubdate;
    }

    public void setPubdate(String string) {
        this.pubdate = string;
    }

    public String getPubrevision() {
        return this.pubRevision;
    }

    public void setPubrevision(String string) {
        this.pubRevision = string;
    }

    public String getPubbranch() {
        return this.pubBranch;
    }

    public void setPubbranch(String string) {
        this.pubBranch = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public void setConf(String string) {
        this.conf = string;
    }

    public void setDelivertarget(String string) {
        this.deliverTarget = string;
    }

    public void setDeliveryList(File file) {
        this.deliveryList = file;
    }

    public String getResolver() {
        return this.publishResolverName;
    }

    public void setResolver(String string) {
        this.publishResolverName = string;
    }

    public String getArtifactspattern() {
        return this.artifactspattern.isEmpty() ? null : this.artifactspattern.get(0);
    }

    public void setArtifactspattern(String string) {
        this.artifactspattern.clear();
        this.artifactspattern.add(string);
    }

    public void addArtifactspattern(String string) {
        this.artifactspattern.add(string);
    }

    public void addConfiguredArtifacts(ArtifactsPattern artifactsPattern) {
        this.artifactspattern.add(artifactsPattern.getPattern());
    }

    public boolean isReplacedynamicrev() {
        return this.replacedynamicrev;
    }

    public void setReplacedynamicrev(boolean bl) {
        this.replacedynamicrev = bl;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean bl) {
        this.merge = bl;
    }

    @Override
    public void doExecute() throws BuildException {
        Object object;
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        this.organisation = this.getProperty(this.organisation, ivySettings, "ivy.organisation");
        this.module = this.getProperty(this.module, ivySettings, "ivy.module");
        this.revision = this.getProperty(this.revision, ivySettings, "ivy.revision");
        this.pubBranch = this.getProperty(this.pubBranch, ivySettings, "ivy.deliver.branch");
        this.pubRevision = this.getProperty(this.pubRevision, ivySettings, "ivy.deliver.revision");
        if (this.artifactspattern.isEmpty() && (object = this.getProperty(null, ivySettings, "ivy.publish.src.artifacts.pattern")) != null) {
            this.artifactspattern.add(object);
        }
        if (this.srcivypattern == null) {
            this.srcivypattern = this.getArtifactspattern();
        }
        this.status = this.getProperty(this.status, ivySettings, "ivy.status");
        if (this.organisation == null) {
            throw new BuildException("no organisation provided for ivy publish task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this.module == null) {
            throw new BuildException("no module name provided for ivy publish task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this.revision == null) {
            throw new BuildException("no module revision provided for ivy publish task: It can either be set explicitely via the attribute 'revision' or via 'ivy.revision' property or a prior call to <resolve/>");
        }
        if (this.artifactspattern.isEmpty()) {
            throw new BuildException("no artifacts pattern: either provide it through parameter or through ivy.publish.src.artifacts.pattern property");
        }
        if (this.publishResolverName == null) {
            throw new BuildException("no publish deliver name: please provide it through parameter 'resolver'");
        }
        if ("working".equals(this.revision)) {
            this.revision = Ivy.getWorkingRevision();
        }
        object = IvyPublish.getPubDate(this.pubdate, new Date());
        if (this.pubRevision == null) {
            this.pubRevision = this.revision.startsWith("working@") ? DateUtil.format((Date)object) : this.revision;
        }
        if (this.status == null) {
            throw new BuildException("no status provided: either provide it as parameter or through the ivy.status.default property");
        }
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(this.organisation, this.module, this.revision);
        try {
            File file = this.getProject().resolveFile(IvyPatternHelper.substitute(this.srcivypattern, this.organisation, this.module, this.pubRevision, "ivy", "ivy", "xml"));
            if (this.publishivy && (!file.exists() || this.forcedeliver)) {
                IvyDeliver ivyDeliver = new IvyDeliver();
                ivyDeliver.setSettingsRef(this.getSettingsRef());
                ivyDeliver.setTaskName(this.getTaskName());
                ivyDeliver.setProject(this.getProject());
                ivyDeliver.setDeliverpattern(this.getSrcivypattern());
                ivyDeliver.setDelivertarget(this.deliverTarget);
                ivyDeliver.setDeliveryList(this.deliveryList);
                ivyDeliver.setModule(this.getModule());
                ivyDeliver.setOrganisation(this.getOrganisation());
                ivyDeliver.setPubdate(DateUtil.format((Date)object));
                ivyDeliver.setPubrevision(this.getPubrevision());
                ivyDeliver.setPubbranch(this.getPubbranch());
                ivyDeliver.setRevision(this.getRevision());
                ivyDeliver.setStatus(this.getStatus());
                ivyDeliver.setValidate(this.doValidate(ivySettings));
                ivyDeliver.setReplacedynamicrev(this.isReplacedynamicrev());
                ivyDeliver.setMerge(this.merge);
                ivyDeliver.setConf(this.conf);
                ivyDeliver.execute();
            }
            ivy.publish(moduleRevisionId, this.artifactspattern, this.publishResolverName, new PublishOptions().setPubrevision(this.getPubrevision()).setPubbranch(this.getPubbranch()).setSrcIvyPattern(this.publishivy ? this.srcivypattern : null).setStatus(this.getStatus()).setPubdate((Date)object).setExtraArtifacts(this.artifacts.toArray(new Artifact[this.artifacts.size()])).setValidate(this.doValidate(ivySettings)).setOverwrite(this.overwrite).setUpdate(this.update).setMerge(this.merge).setWarnOnMissing(this.warnonmissing).setHaltOnMissing(this.haltonmissing).setConfs(this.splitConfs(this.conf)));
        }
        catch (Exception exception) {
            if (exception instanceof BuildException) {
                throw (BuildException)((Object)exception);
            }
            throw new BuildException("impossible to publish artifacts for " + moduleRevisionId + ": " + exception, (Throwable)exception);
        }
    }

    public PublishArtifact createArtifact() {
        PublishArtifact publishArtifact = new PublishArtifact();
        this.artifacts.add(publishArtifact);
        return publishArtifact;
    }

    public boolean isPublishivy() {
        return this.publishivy;
    }

    public void setPublishivy(boolean bl) {
        this.publishivy = bl;
    }

    public boolean isWarnonmissing() {
        return this.warnonmissing;
    }

    public void setWarnonmissing(boolean bl) {
        this.warnonmissing = bl;
    }

    public boolean isHaltonmissing() {
        return this.haltonmissing;
    }

    public void setHaltonmissing(boolean bl) {
        this.haltonmissing = bl;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public void setForcedeliver(boolean bl) {
        this.forcedeliver = bl;
    }

    public boolean isForcedeliver() {
        return this.forcedeliver;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public static class ArtifactsPattern {
        private String pattern;

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String string) {
            this.pattern = string;
        }
    }

    public class PublishArtifact
    implements Artifact,
    DynamicAttribute {
        private String ext;
        private String name;
        private String type;
        private Map extra = new HashMap();

        @Override
        public String[] getConfigurations() {
            return null;
        }

        @Override
        public String getExt() {
            return this.ext == null ? this.type : this.ext;
        }

        @Override
        public ArtifactRevisionId getId() {
            return null;
        }

        @Override
        public ModuleRevisionId getModuleRevisionId() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Date getPublicationDate() {
            return null;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public URL getUrl() {
            return null;
        }

        public void setExt(String string) {
            this.ext = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setType(String string) {
            this.type = string;
        }

        @Override
        public String getAttribute(String string) {
            return (String)this.extra.get(string);
        }

        @Override
        public Map getAttributes() {
            return this.extra;
        }

        @Override
        public String getExtraAttribute(String string) {
            return (String)this.extra.get(string);
        }

        @Override
        public Map getExtraAttributes() {
            return this.extra;
        }

        @Override
        public Map getQualifiedExtraAttributes() {
            return this.extra;
        }

        @Override
        public boolean isMetadata() {
            return false;
        }

        public void setDynamicAttribute(String string, String string2) {
            this.extra.put(string, string2);
        }
    }
}

