/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.FileUtil;

public class DefaultResolutionCacheManager
implements ResolutionCacheManager,
IvySettingsAware {
    private static final String DEFAULT_CACHE_RESOLVED_IVY_PATTERN = "resolved-[organisation]-[module]-[revision].xml";
    private static final String DEFAULT_CACHE_RESOLVED_IVY_PROPERTIES_PATTERN = "resolved-[organisation]-[module]-[revision].properties";
    private String resolvedIvyPattern = "resolved-[organisation]-[module]-[revision].xml";
    private String resolvedIvyPropertiesPattern = "resolved-[organisation]-[module]-[revision].properties";
    private File basedir;
    private String name = "resolution-cache";
    private IvySettings settings;

    public DefaultResolutionCacheManager() {
    }

    public DefaultResolutionCacheManager(File file) {
        this.setBasedir(file);
    }

    @Override
    public void setSettings(IvySettings ivySettings) {
        this.settings = ivySettings;
    }

    @Override
    public File getResolutionCacheRoot() {
        return this.basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public String getResolvedIvyPattern() {
        return this.resolvedIvyPattern;
    }

    public void setResolvedIvyPattern(String string) {
        this.resolvedIvyPattern = string;
    }

    public String getResolvedIvyPropertiesPattern() {
        return this.resolvedIvyPropertiesPattern;
    }

    public void setResolvedIvyPropertiesPattern(String string) {
        this.resolvedIvyPropertiesPattern = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public File getResolvedIvyFileInCache(ModuleRevisionId moduleRevisionId) {
        String string = IvyPatternHelper.substitute(this.getResolvedIvyPattern(), moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), string);
    }

    @Override
    public File getResolvedIvyPropertiesInCache(ModuleRevisionId moduleRevisionId) {
        String string = IvyPatternHelper.substitute(this.getResolvedIvyPropertiesPattern(), moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), string);
    }

    @Override
    public File getConfigurationResolveReportInCache(String string, String string2) {
        return new File(this.getResolutionCacheRoot(), string + "-" + string2 + ".xml");
    }

    @Override
    public File[] getConfigurationResolveReportsInCache(String string) {
        final String string2 = string + "-";
        return this.getResolutionCacheRoot().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith(string2) && string.endsWith(".xml");
            }
        });
    }

    @Override
    public ModuleDescriptor getResolvedModuleDescriptor(ModuleRevisionId moduleRevisionId) throws ParseException, IOException {
        Object object;
        File file = this.getResolvedIvyFileInCache(moduleRevisionId);
        if (!file.exists()) {
            throw new IllegalStateException("Ivy file not found in cache for " + moduleRevisionId + "!");
        }
        Properties properties = new Properties();
        File file2 = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance(moduleRevisionId, moduleRevisionId.getRevision() + "-parents"));
        if (file2.exists()) {
            object = new FileInputStream(file2);
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        object = new CacheParserSettings(this.settings, properties);
        URL uRL = file.toURI().toURL();
        return this.getModuleDescriptorParser().parseDescriptor((ParserSettings)object, uRL, false);
    }

    protected ModuleDescriptorParser getModuleDescriptorParser() {
        return XmlModuleDescriptorParser.getInstance();
    }

    @Override
    public void saveResolvedModuleDescriptor(ModuleDescriptor moduleDescriptor) throws ParseException, IOException {
        ModuleRevisionId moduleRevisionId = moduleDescriptor.getResolvedModuleRevisionId();
        File file = this.getResolvedIvyFileInCache(moduleRevisionId);
        moduleDescriptor.toIvyFile(file);
        Properties properties = new Properties();
        this.saveLocalParents(moduleRevisionId, moduleDescriptor, file, properties);
        if (!properties.isEmpty()) {
            File file2 = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance(moduleRevisionId, moduleRevisionId.getRevision() + "-parents"));
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
    }

    private void saveLocalParents(ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor, File file, Properties properties) throws ParseException, IOException {
        ExtendsDescriptor[] extendsDescriptorArray = moduleDescriptor.getInheritedDescriptors();
        for (int i = 0; i < extendsDescriptorArray.length; ++i) {
            if (!extendsDescriptorArray[i].isLocal()) continue;
            ModuleDescriptor moduleDescriptor2 = extendsDescriptorArray[i].getParentMd();
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, moduleRevisionId.getRevision() + "-parent." + properties.size());
            File file2 = this.getResolvedIvyFileInCache(moduleRevisionId2);
            moduleDescriptor2.toIvyFile(file2);
            properties.setProperty(file.getName() + "|" + extendsDescriptorArray[i].getLocation(), file2.getAbsolutePath());
            this.saveLocalParents(moduleRevisionId, moduleDescriptor2, file2, properties);
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void clean() {
        FileUtil.forceDelete(this.getBasedir());
    }

    private static class MapURLResolver
    extends RelativeUrlResolver {
        private Map paths;
        private RelativeUrlResolver delegate;

        private MapURLResolver(Map map, RelativeUrlResolver relativeUrlResolver) {
            this.paths = map;
            this.delegate = relativeUrlResolver;
        }

        @Override
        public URL getURL(URL uRL, String string) throws MalformedURLException {
            String string2;
            String string3 = uRL.getPath();
            if (string3.indexOf(47) >= 0 && this.paths.containsKey((string2 = string3.substring(string3.lastIndexOf(47) + 1)) + "|" + string)) {
                File file = new File(this.paths.get(string2 + "|" + string).toString());
                return file.toURI().toURL();
            }
            return this.delegate.getURL(uRL, string);
        }
    }

    private static class CacheParserSettings
    implements ParserSettings {
        private ParserSettings delegate;
        private Map parentPaths;

        public CacheParserSettings(ParserSettings parserSettings, Map map) {
            this.delegate = parserSettings;
            this.parentPaths = map;
        }

        @Override
        public String substitute(String string) {
            return this.delegate.substitute(string);
        }

        @Override
        public Map substitute(Map map) {
            return this.delegate.substitute(map);
        }

        @Override
        public ResolutionCacheManager getResolutionCacheManager() {
            return this.delegate.getResolutionCacheManager();
        }

        @Override
        public ConflictManager getConflictManager(String string) {
            return this.delegate.getConflictManager(string);
        }

        @Override
        public PatternMatcher getMatcher(String string) {
            return this.delegate.getMatcher(string);
        }

        @Override
        public Namespace getNamespace(String string) {
            return this.delegate.getNamespace(string);
        }

        @Override
        public StatusManager getStatusManager() {
            return this.delegate.getStatusManager();
        }

        @Override
        public RelativeUrlResolver getRelativeUrlResolver() {
            return new MapURLResolver(this.parentPaths, this.delegate.getRelativeUrlResolver());
        }

        @Override
        public DependencyResolver getResolver(ModuleRevisionId moduleRevisionId) {
            return this.delegate.getResolver(moduleRevisionId);
        }

        @Override
        public File resolveFile(String string) {
            return this.delegate.resolveFile(string);
        }

        @Override
        public String getDefaultBranch(ModuleId moduleId) {
            return this.delegate.getDefaultBranch(moduleId);
        }

        @Override
        public Namespace getContextNamespace() {
            return this.delegate.getContextNamespace();
        }
    }
}

