/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.report;

import java.io.File;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.report.DownloadStatus;

public class ArtifactDownloadReport {
    public static final String MISSING_ARTIFACT = "missing artifact";
    private Artifact artifact;
    private ArtifactOrigin origin;
    private File localFile;
    private DownloadStatus downloadStatus;
    private long size;
    private String downloadDetails = "";
    private long downloadTimeMillis;
    private File unpackedLocalFile;

    public ArtifactDownloadReport(Artifact artifact) {
        this.artifact = artifact;
    }

    public DownloadStatus getDownloadStatus() {
        return this.downloadStatus;
    }

    public void setDownloadStatus(DownloadStatus downloadStatus) {
        this.downloadStatus = downloadStatus;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getExt() {
        return this.artifact.getExt();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
    }

    public void setArtifactOrigin(ArtifactOrigin artifactOrigin) {
        this.origin = artifactOrigin;
    }

    public ArtifactOrigin getArtifactOrigin() {
        return this.origin;
    }

    public void setDownloadDetails(String string) {
        this.downloadDetails = string;
    }

    public String getDownloadDetails() {
        return this.downloadDetails;
    }

    public void setDownloadTimeMillis(long l) {
        this.downloadTimeMillis = l;
    }

    public long getDownloadTimeMillis() {
        return this.downloadTimeMillis;
    }

    public String toString() {
        if (this.downloadStatus == DownloadStatus.SUCCESSFUL) {
            return "[SUCCESSFUL ] " + this.artifact + " (" + this.downloadTimeMillis + "ms)";
        }
        if (this.downloadStatus == DownloadStatus.FAILED) {
            if (this.downloadDetails == MISSING_ARTIFACT) {
                return "[NOT FOUND  ] " + this.artifact + " (" + this.downloadTimeMillis + "ms)";
            }
            return "[FAILED     ] " + this.artifact + ": " + this.downloadDetails + " (" + this.downloadTimeMillis + "ms)";
        }
        if (this.downloadStatus == DownloadStatus.NO) {
            return "[NOT REQUIRED] " + this.artifact;
        }
        return super.toString();
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File file) {
        this.localFile = file;
    }

    public boolean isDownloaded() {
        return DownloadStatus.SUCCESSFUL == this.downloadStatus;
    }

    public void setUnpackedLocalFile(File file) {
        this.unpackedLocalFile = file;
    }

    public File getUnpackedLocalFile() {
        return this.unpackedLocalFile;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.artifact == null ? 0 : this.artifact.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)object;
        return !(this.artifact == null ? artifactDownloadReport.artifact != null : !this.artifact.equals(artifactDownloadReport.artifact));
    }
}

