/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.Message;

public class ConfigurationResolveReport {
    private final ModuleDescriptor md;
    private final String conf;
    private final Date date;
    private final ResolveOptions options;
    private Map<IvyNode, List<ArtifactDownloadReport>> dependencyReports = new LinkedHashMap<IvyNode, List<ArtifactDownloadReport>>();
    private Map<ModuleRevisionId, IvyNode> dependencies = new LinkedHashMap<ModuleRevisionId, IvyNode>();
    private final ResolveEngine resolveEngine;
    private Map<ModuleId, Collection<IvyNode>> modulesIdsMap = new LinkedHashMap<ModuleId, Collection<IvyNode>>();
    private List<ModuleId> modulesIds;
    private Boolean hasChanged = null;

    public ConfigurationResolveReport(ResolveEngine resolveEngine, ModuleDescriptor moduleDescriptor, String string, Date date, ResolveOptions resolveOptions) {
        this.resolveEngine = resolveEngine;
        this.md = moduleDescriptor;
        this.conf = string;
        this.date = date;
        this.options = resolveOptions;
    }

    public void checkIfChanged() {
        String string;
        ResolutionCacheManager resolutionCacheManager = this.resolveEngine.getSettings().getResolutionCacheManager();
        File file = resolutionCacheManager.getConfigurationResolveReportInCache(string = this.options.getResolveId(), this.conf);
        if (file.exists()) {
            try {
                XmlReportParser xmlReportParser = new XmlReportParser();
                xmlReportParser.parse(file);
                List<ModuleRevisionId> list = Arrays.asList(xmlReportParser.getDependencyRevisionIds());
                HashSet<ModuleRevisionId> hashSet = new HashSet<ModuleRevisionId>(list);
                this.hasChanged = !hashSet.equals(this.getModuleRevisionIds());
            }
            catch (Exception exception) {
                Message.warn("Error while parsing configuration resolve report " + file.getAbsolutePath(), exception);
                this.hasChanged = Boolean.TRUE;
            }
        } else {
            this.hasChanged = Boolean.TRUE;
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public Set<ModuleRevisionId> getModuleRevisionIds() {
        LinkedHashSet<ModuleRevisionId> linkedHashSet = new LinkedHashSet<ModuleRevisionId>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (ivyNode.isEvicted(this.getConfiguration()) || ivyNode.hasProblem()) continue;
            linkedHashSet.add(ivyNode.getResolvedId());
        }
        return linkedHashSet;
    }

    public void addDependency(IvyNode ivyNode) {
        this.dependencies.put(ivyNode.getId(), ivyNode);
        this.dependencies.put(ivyNode.getResolvedId(), ivyNode);
        this.dependencyReports.put(ivyNode, Collections.emptyList());
    }

    public void updateDependency(ModuleRevisionId moduleRevisionId, IvyNode ivyNode) {
        this.dependencies.put(moduleRevisionId, ivyNode);
    }

    public void addDependency(IvyNode ivyNode, DownloadReport downloadReport) {
        Artifact[] artifactArray;
        this.dependencies.put(ivyNode.getId(), ivyNode);
        this.dependencies.put(ivyNode.getResolvedId(), ivyNode);
        ArrayList<ArtifactDownloadReport> arrayList = new ArrayList<ArtifactDownloadReport>();
        for (Artifact artifact : artifactArray = ivyNode.getArtifacts(this.conf)) {
            ArtifactDownloadReport artifactDownloadReport = downloadReport.getArtifactReport(artifact);
            if (artifactDownloadReport != null) {
                arrayList.add(artifactDownloadReport);
                continue;
            }
            Message.debug("no report found for " + artifact);
        }
        this.dependencyReports.put(ivyNode, arrayList);
    }

    public String getConfiguration() {
        return this.conf;
    }

    public Date getDate() {
        return this.date;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.md;
    }

    public IvyNode[] getUnresolvedDependencies() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.hasProblem()) continue;
            arrayList.add(ivyNode);
        }
        return arrayList.toArray(new IvyNode[arrayList.size()]);
    }

    private Collection<IvyNode> getDependencies() {
        return new LinkedHashSet<IvyNode>(this.dependencies.values());
    }

    public IvyNode[] getEvictedNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.isEvicted(this.conf)) continue;
            arrayList.add(ivyNode);
        }
        return arrayList.toArray(new IvyNode[arrayList.size()]);
    }

    private Set<ModuleRevisionId> getEvictedMrids() {
        IvyNode[] ivyNodeArray;
        LinkedHashSet<ModuleRevisionId> linkedHashSet = new LinkedHashSet<ModuleRevisionId>();
        for (IvyNode ivyNode : ivyNodeArray = this.getEvictedNodes()) {
            linkedHashSet.add(ivyNode.getId());
        }
        return linkedHashSet;
    }

    public IvyNode[] getDownloadedNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.isDownloaded() || ivyNode.getRealNode() != ivyNode) continue;
            arrayList.add(ivyNode);
        }
        return arrayList.toArray(new IvyNode[arrayList.size()]);
    }

    public IvyNode[] getSearchedNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.isSearched() || ivyNode.getRealNode() != ivyNode) continue;
            arrayList.add(ivyNode);
        }
        return arrayList.toArray(new IvyNode[arrayList.size()]);
    }

    public ArtifactDownloadReport[] getDownloadReports(ModuleRevisionId moduleRevisionId) {
        Collection collection = this.dependencyReports.get(this.getDependency(moduleRevisionId));
        if (collection == null) {
            return new ArtifactDownloadReport[0];
        }
        return collection.toArray(new ArtifactDownloadReport[collection.size()]);
    }

    public IvyNode getDependency(ModuleRevisionId moduleRevisionId) {
        return this.dependencies.get(moduleRevisionId);
    }

    public List<ModuleId> getModuleIds() {
        if (this.modulesIds == null) {
            List<IvyNode> list = this.resolveEngine.getSortEngine().sortNodes(this.getDependencies(), SortOptions.SILENT);
            Collections.reverse(list);
            for (IvyNode ivyNode : list) {
                ModuleId moduleId = ivyNode.getResolvedId().getModuleId();
                Collection<IvyNode> collection = this.modulesIdsMap.get(moduleId);
                if (collection == null) {
                    collection = new LinkedHashSet<IvyNode>();
                    this.modulesIdsMap.put(moduleId, collection);
                }
                collection.add(ivyNode);
            }
            this.modulesIds = new ArrayList<ModuleId>(this.modulesIdsMap.keySet());
        }
        return Collections.unmodifiableList(this.modulesIds);
    }

    public Collection<IvyNode> getNodes(ModuleId moduleId) {
        if (this.modulesIds == null) {
            this.getModuleIds();
        }
        return this.modulesIdsMap.get(moduleId);
    }

    public ResolveEngine getResolveEngine() {
        return this.resolveEngine;
    }

    public int getArtifactsNumber() {
        int n = 0;
        for (List<ArtifactDownloadReport> list : this.dependencyReports.values()) {
            n += list == null ? 0 : list.size();
        }
        return n;
    }

    public ArtifactDownloadReport[] getAllArtifactsReports() {
        return this.getArtifactsReports(null, true);
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean bl) {
        LinkedHashSet<ArtifactDownloadReport> linkedHashSet = new LinkedHashSet<ArtifactDownloadReport>();
        Set<ModuleRevisionId> set = null;
        if (!bl) {
            set = this.getEvictedMrids();
        }
        for (List<ArtifactDownloadReport> list : this.dependencyReports.values()) {
            for (ArtifactDownloadReport artifactDownloadReport : list) {
                if (downloadStatus != null && artifactDownloadReport.getDownloadStatus() != downloadStatus || !bl && set.contains(artifactDownloadReport.getArtifact().getModuleRevisionId())) continue;
                linkedHashSet.add(artifactDownloadReport);
            }
        }
        return linkedHashSet.toArray(new ArtifactDownloadReport[linkedHashSet.size()]);
    }

    public ArtifactDownloadReport[] getDownloadedArtifactsReports() {
        return this.getArtifactsReports(DownloadStatus.SUCCESSFUL, true);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        ArtifactDownloadReport[] artifactDownloadReportArray = this.getArtifactsReports(DownloadStatus.FAILED, true);
        return ConfigurationResolveReport.filterOutMergedArtifacts(artifactDownloadReportArray);
    }

    public boolean hasError() {
        return this.getUnresolvedDependencies().length > 0 || this.getFailedArtifactsReports().length > 0;
    }

    public int getNodesNumber() {
        return this.getDependencies().size();
    }

    public static ArtifactDownloadReport[] filterOutMergedArtifacts(ArtifactDownloadReport[] artifactDownloadReportArray) {
        ArrayList<ArtifactDownloadReport> arrayList = new ArrayList<ArtifactDownloadReport>(Arrays.asList(artifactDownloadReportArray));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)iterator.next();
            if (artifactDownloadReport.getArtifact().getExtraAttribute("ivy:merged") == null) continue;
            iterator.remove();
        }
        return arrayList.toArray(new ArtifactDownloadReport[arrayList.size()]);
    }
}

