/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Configurator;
import org.apache.ivy.util.FileResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSettingsParser
extends DefaultHandler {
    private Configurator configurator;
    private List configuratorTags = Arrays.asList("resolvers", "namespaces", "parsers", "latest-strategies", "conflict-managers", "outputters", "version-matchers", "statuses", "circular-dependency-strategies", "triggers", "lock-strategies", "caches", "signers");
    private IvySettings ivy;
    private String defaultResolver;
    private String defaultCM;
    private String defaultLatest;
    private String defaultCacheManager;
    private String defaultCircular;
    private String defaultLock;
    private String currentConfiguratorTag;
    private URL settings;
    private boolean deprecatedMessagePrinted = false;

    public XmlSettingsParser(IvySettings ivySettings) {
        this.ivy = ivySettings;
    }

    public void parse(URL uRL) throws ParseException, IOException {
        this.configurator = new Configurator();
        this.configurator.setFileResolver(new FileResolver(){

            @Override
            public File resolveFile(String string, String string2) {
                return Checks.checkAbsolute(string, string2);
            }
        });
        Map map = this.ivy.getTypeDefs();
        for (String string : map.keySet()) {
            this.configurator.typeDef(string, (Class)map.get(string));
        }
        this.doParse(uRL);
    }

    private void doParse(URL uRL) throws IOException, ParseException {
        this.settings = uRL;
        InputStream inputStream = null;
        try {
            inputStream = URLHandlerRegistry.getDefault().openStream(uRL);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL.toExternalForm());
            SAXParserFactory.newInstance().newSAXParser().parse(uRL.toExternalForm(), (DefaultHandler)this);
            this.ivy.validate();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            ParseException parseException = new ParseException("failed to load settings from " + uRL + ": " + exception.getMessage(), 0);
            parseException.initCause(exception);
            throw parseException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parse(Configurator configurator, URL uRL) throws IOException, ParseException {
        this.configurator = configurator;
        this.doParse(uRL);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            hashMap.put(attributes.getQName(i), this.ivy.substitute(attributes.getValue(i)));
        }
        try {
            if ("ivyconf".equals(string3)) {
                this.deprecatedMessagePrinted = true;
                Message.deprecated("'ivyconf' element is deprecated, use 'ivysettings' instead (" + this.settings + ")");
            }
            if (this.configurator.getCurrent() != null) {
                this.inConfiguratorStarted(string3, hashMap);
            } else if ("classpath".equals(string3)) {
                this.classpathStarted(hashMap);
            } else if ("typedef".equals(string3)) {
                this.typedefStarted(hashMap);
            } else if ("property".equals(string3)) {
                this.propertyStarted(hashMap);
            } else if ("properties".equals(string3)) {
                this.propertiesStarted(hashMap);
            } else if ("include".equals(string3)) {
                this.includeStarted(hashMap);
            } else if ("settings".equals(string3) || "conf".equals(string3)) {
                this.settingsStarted(string3, hashMap);
            } else if ("caches".equals(string3)) {
                this.cachesStarted(string3, hashMap);
            } else if ("version-matchers".equals(string3)) {
                this.versionMatchersStarted(string3, hashMap);
            } else if ("statuses".equals(string3)) {
                this.statusesStarted(string3, hashMap);
            } else if (this.configuratorTags.contains(string3)) {
                this.anyConfiguratorStarted(string3);
            } else if ("macrodef".equals(string3)) {
                this.macrodefStarted(string3, hashMap);
            } else if ("module".equals(string3)) {
                this.moduleStarted(hashMap);
            } else if ("credentials".equals(string3)) {
                this.credentialsStarted(hashMap);
            }
        }
        catch (ParseException parseException) {
            SAXException sAXException = new SAXException("problem in config file: " + parseException.getMessage(), parseException);
            sAXException.initCause(parseException);
            throw sAXException;
        }
        catch (IOException iOException) {
            SAXException sAXException = new SAXException("io problem while parsing config file: " + iOException.getMessage(), iOException);
            sAXException.initCause(iOException);
            throw sAXException;
        }
    }

    private void credentialsStarted(Map map) {
        String string = (String)map.remove("realm");
        String string2 = (String)map.remove("host");
        String string3 = (String)map.remove("username");
        String string4 = (String)map.remove("passwd");
        CredentialsStore.INSTANCE.addCredentials(string, string2, string3, string4);
    }

    private void moduleStarted(Map map) {
        map.put("module", map.remove("name"));
        String string = (String)map.remove("resolver");
        String string2 = (String)map.remove("branch");
        String string3 = (String)map.remove("conflict-manager");
        String string4 = (String)map.remove("resolveMode");
        String string5 = (String)map.remove("matcher");
        string5 = string5 == null ? "exactOrRegexp" : string5;
        this.ivy.addModuleConfiguration(map, this.ivy.getMatcher(string5), string, string2, string3, string4);
    }

    private void macrodefStarted(String string, Map map) {
        this.currentConfiguratorTag = string;
        Configurator.MacroDef macroDef = this.configurator.startMacroDef((String)map.get("name"));
        macroDef.addAttribute("name", null);
    }

    private void anyConfiguratorStarted(String string) {
        this.currentConfiguratorTag = string;
        this.configurator.setRoot(this.ivy);
    }

    private void statusesStarted(String string, Map map) {
        this.currentConfiguratorTag = string;
        StatusManager statusManager = new StatusManager();
        String string2 = (String)map.get("default");
        if (string2 != null) {
            statusManager.setDefaultStatus(string2);
        }
        this.ivy.setStatusManager(statusManager);
        this.configurator.setRoot(statusManager);
    }

    private void versionMatchersStarted(String string, Map map) {
        this.anyConfiguratorStarted(string);
        if ("true".equals(map.get("usedefaults"))) {
            this.ivy.configureDefaultVersionMatcher();
        }
    }

    private void cachesStarted(String string, Map map) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        this.anyConfiguratorStarted(string);
        this.defaultLock = (String)map.get("lockStrategy");
        this.defaultCacheManager = (String)map.get("default");
        String string8 = (String)map.get("defaultCacheDir");
        if (string8 != null) {
            this.ivy.setDefaultCache(Checks.checkAbsolute(string8, "defaultCacheDir"));
        }
        if ((string7 = (String)map.get("checkUpToDate")) != null) {
            Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + this.settings + ")");
            this.ivy.setCheckUpToDate(Boolean.valueOf(string7));
        }
        if ((string6 = (String)map.get("resolutionCacheDir")) != null) {
            this.ivy.setDefaultResolutionCacheBasedir(string6);
        }
        if ((string5 = (String)map.get("useOrigin")) != null) {
            this.ivy.setDefaultUseOrigin(Boolean.valueOf(string5));
        }
        if ((string4 = (String)map.get("ivyPattern")) != null) {
            this.ivy.setDefaultCacheIvyPattern(string4);
        }
        if ((string3 = (String)map.get("artifactPattern")) != null) {
            this.ivy.setDefaultCacheArtifactPattern(string3);
        }
        if ((string2 = (String)map.get("repositoryCacheDir")) != null) {
            this.ivy.setDefaultRepositoryCacheBasedir(string2);
        }
    }

    private void settingsStarted(String string, Map map) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        if ("conf".equals(string) && !this.deprecatedMessagePrinted) {
            Message.deprecated("'conf' is deprecated, use 'settings' instead (" + this.settings + ")");
        }
        if ((string9 = (String)map.get("defaultCache")) != null) {
            Message.deprecated("'defaultCache' is deprecated, use 'caches[@defaultCacheDir]' instead (" + this.settings + ")");
            this.ivy.setDefaultCache(Checks.checkAbsolute(string9, "defaultCache"));
        }
        if ((string8 = (String)map.get("defaultBranch")) != null) {
            this.ivy.setDefaultBranch(string8);
        }
        if ((string7 = (String)map.get("defaultResolveMode")) != null) {
            this.ivy.setDefaultResolveMode(string7);
        }
        if ((string6 = (String)map.get("validate")) != null) {
            this.ivy.setValidate(Boolean.valueOf(string6));
        }
        if ((string5 = (String)map.get("checkUpToDate")) != null) {
            Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + this.settings + ")");
            this.ivy.setCheckUpToDate(Boolean.valueOf(string5));
        }
        if ((string4 = (String)map.get("useRemoteConfig")) != null) {
            this.ivy.setUseRemoteConfig(Boolean.valueOf(string4));
        }
        if ((string3 = (String)map.get("cacheIvyPattern")) != null) {
            Message.deprecated("'cacheIvyPattern' is deprecated, use 'caches[@ivyPattern]' instead (" + this.settings + ")");
            this.ivy.setDefaultCacheIvyPattern(string3);
        }
        if ((string2 = (String)map.get("cacheArtifactPattern")) != null) {
            Message.deprecated("'cacheArtifactPattern' is deprecated, use 'caches[@artifactPattern]' instead (" + this.settings + ")");
            this.ivy.setDefaultCacheArtifactPattern(string2);
        }
        this.defaultResolver = (String)map.get("defaultResolver");
        this.defaultCM = (String)map.get("defaultConflictManager");
        this.defaultLatest = (String)map.get("defaultLatestStrategy");
        this.defaultCircular = (String)map.get("circularDependencyStrategy");
        String string10 = (String)map.get("httpRequestMethod");
        if ("head".equalsIgnoreCase(string10)) {
            URLHandlerRegistry.getHttp().setRequestMethod(2);
        } else if ("get".equalsIgnoreCase(string10)) {
            URLHandlerRegistry.getHttp().setRequestMethod(1);
        } else if (string10 != null && string10.trim().length() > 0) {
            throw new IllegalArgumentException("Invalid httpRequestMethod specified, must be one of {'HEAD', 'GET'}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeStarted(Map map) throws IOException, ParseException {
        IvyVariableContainer ivyVariableContainer = this.ivy.getVariableContainer();
        this.ivy.setVariableContainer(new IvyVariableContainerWrapper(ivyVariableContainer));
        try {
            String string = (String)map.get("file");
            URL uRL = null;
            if (string == null) {
                string = (String)map.get("url");
                if (string == null) {
                    throw new IllegalArgumentException("bad include tag: specify file or url to include");
                }
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = new URL(this.settings, string);
                }
                Message.verbose("including url: " + uRL.toString());
                this.ivy.setSettingsVariables(uRL);
            } else {
                uRL = this.urlFromFileAttribute(string);
                Message.verbose("including file: " + uRL);
                if ("file".equals(uRL.getProtocol())) {
                    File file;
                    block14: {
                        file = new File(new URI(uRL.toExternalForm()));
                        String string2 = (String)map.get("optional");
                        if (!"true".equals(string2) || file.exists()) break block14;
                        return;
                    }
                    try {
                        this.ivy.setSettingsVariables(Checks.checkAbsolute(file, "settings include path"));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.ivy.setSettingsVariables(Checks.checkAbsolute(uRL.getPath(), "settings include path"));
                    }
                } else {
                    this.ivy.setSettingsVariables(uRL);
                }
            }
            new XmlSettingsParser(this.ivy).parse(this.configurator, uRL);
        }
        finally {
            this.ivy.setVariableContainer(ivyVariableContainer);
        }
    }

    private URL urlFromFileAttribute(String string) throws IOException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.isAbsolute()) {
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                return file.toURI().toURL();
            }
            if ("file".equals(this.settings.getProtocol())) {
                try {
                    File file2 = new File(new URI(this.settings.toExternalForm()));
                    if (!file2.exists()) {
                        throw new FileNotFoundException(file2.getAbsolutePath());
                    }
                    return new File(file2.getParentFile(), string).toURI().toURL();
                }
                catch (URISyntaxException uRISyntaxException) {
                    return new URL(this.settings, string);
                }
            }
            return new URL(this.settings, string);
        }
    }

    private void propertiesStarted(Map map) throws IOException {
        String string = (String)map.get("file");
        String string2 = (String)map.get("environment");
        if (string != null) {
            String string3 = (String)map.get("override");
            boolean bl = string3 == null ? true : Boolean.valueOf(string3);
            Message.verbose("loading properties: " + string);
            try {
                URL uRL = this.urlFromFileAttribute(string);
                this.ivy.loadProperties(uRL, bl);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Message.verbose("Unable to find property file: " + string);
            }
        } else if (string2 != null) {
            this.ivy.getVariableContainer().setEnvironmentPrefix(string2);
        } else {
            throw new IllegalArgumentException("Didn't find a 'file' or 'environment' attribute on the 'properties' element");
        }
    }

    private void propertyStarted(Map map) {
        String string = (String)map.get("name");
        String string2 = (String)map.get("value");
        String string3 = (String)map.get("override");
        String string4 = (String)map.get("ifset");
        String string5 = (String)map.get("unlessset");
        if (string == null) {
            throw new IllegalArgumentException("missing attribute name on property tag");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("missing attribute value on property tag");
        }
        this.ivy.setVariable(string, string2, string3 == null ? true : Boolean.valueOf(string3), string4, string5);
    }

    private void typedefStarted(Map map) {
        String string = (String)map.get("name");
        String string2 = (String)map.get("classname");
        Class clazz = this.ivy.typeDef(string, string2);
        this.configurator.typeDef(string, clazz);
    }

    private void classpathStarted(Map map) throws IOException {
        String string = (String)map.get("url");
        URL uRL = null;
        if (string == null) {
            String string2 = (String)map.get("file");
            if (string2 == null) {
                throw new IllegalArgumentException("either url or file should be given for classpath element");
            }
            uRL = this.urlFromFileAttribute(string2);
        } else {
            uRL = new URL(string);
        }
        this.ivy.addClasspathURL(uRL);
    }

    private void inConfiguratorStarted(String string, Map map) {
        Object object;
        if ("macrodef".equals(this.currentConfiguratorTag) && this.configurator.getTypeDef(string) != null) {
            object = (String)map.get("name");
            if (object == null) {
                map.put("name", "@{name}");
            } else if (((String)object).indexOf("@{name}") != -1) {
                map.put("name", object);
            } else {
                map.put("name", "@{name}-" + (String)object);
            }
        }
        if (map.get("ref") != null) {
            if (map.size() != 1) {
                throw new IllegalArgumentException("ref attribute should be the only one ! found " + map.size() + " in " + string);
            }
            object = (String)map.get("ref");
            Object object2 = null;
            if ("resolvers".equals(this.currentConfiguratorTag) || "resolver".equals(string)) {
                object2 = this.ivy.getResolver((String)object);
                if (object2 == null) {
                    throw new IllegalArgumentException("unknown resolver " + (String)object + ": resolver should be defined before being referenced");
                }
            } else if ("latest-strategies".equals(this.currentConfiguratorTag)) {
                object2 = this.ivy.getLatestStrategy((String)object);
                if (object2 == null) {
                    throw new IllegalArgumentException("unknown latest strategy " + (String)object + ": latest strategy should be defined before being referenced");
                }
            } else if ("conflict-managers".equals(this.currentConfiguratorTag) && (object2 = this.ivy.getConflictManager((String)object)) == null) {
                throw new IllegalArgumentException("unknown conflict manager " + (String)object + ": conflict manager should be defined before being referenced");
            }
            if (object2 == null) {
                throw new IllegalArgumentException("bad reference " + (String)object);
            }
            this.configurator.addChild(string, object2);
        } else {
            this.configurator.startCreateChild(string);
            for (String string2 : map.keySet()) {
                this.configurator.setAttribute(string2, (String)map.get(string2));
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.configurator.getCurrent() != null) {
            if (this.configuratorTags.contains(string3) && this.configurator.getDepth() == 1) {
                this.configurator.clear();
                this.currentConfiguratorTag = null;
            } else if ("macrodef".equals(string3) && this.configurator.getDepth() == 1) {
                this.configurator.endMacroDef();
                this.currentConfiguratorTag = null;
            } else {
                this.configurator.endCreateChild();
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        Object object;
        if (this.defaultResolver != null) {
            this.ivy.setDefaultResolver(this.ivy.substitute(this.defaultResolver));
        }
        if (this.defaultCM != null) {
            object = this.ivy.getConflictManager(this.ivy.substitute(this.defaultCM));
            if (object == null) {
                throw new IllegalArgumentException("unknown conflict manager " + this.ivy.substitute(this.defaultCM));
            }
            this.ivy.setDefaultConflictManager((ConflictManager)object);
        }
        if (this.defaultLatest != null) {
            object = this.ivy.getLatestStrategy(this.ivy.substitute(this.defaultLatest));
            if (object == null) {
                throw new IllegalArgumentException("unknown latest strategy " + this.ivy.substitute(this.defaultLatest));
            }
            this.ivy.setDefaultLatestStrategy((LatestStrategy)object);
        }
        if (this.defaultCacheManager != null) {
            object = this.ivy.getRepositoryCacheManager(this.ivy.substitute(this.defaultCacheManager));
            if (object == null) {
                throw new IllegalArgumentException("unknown cache manager " + this.ivy.substitute(this.defaultCacheManager));
            }
            this.ivy.setDefaultRepositoryCacheManager((RepositoryCacheManager)object);
        }
        if (this.defaultCircular != null) {
            object = this.ivy.getCircularDependencyStrategy(this.ivy.substitute(this.defaultCircular));
            if (object == null) {
                throw new IllegalArgumentException("unknown circular dependency strategy " + this.ivy.substitute(this.defaultCircular));
            }
            this.ivy.setCircularDependencyStrategy((CircularDependencyStrategy)object);
        }
        if (this.defaultLock != null) {
            object = this.ivy.getLockStrategy(this.ivy.substitute(this.defaultLock));
            if (object == null) {
                throw new IllegalArgumentException("unknown lock strategy " + this.ivy.substitute(this.defaultLock));
            }
            this.ivy.setDefaultLockStrategy((LockStrategy)object);
        }
    }

    private static final class IvyVariableContainerWrapper
    implements IvyVariableContainer {
        private static final Collection SETTINGS_VARIABLES = Arrays.asList("ivy.settings.dir", "ivy.settings.url", "ivy.settings.file", "ivy.conf.dir", "ivy.conf.url", "ivy.conf.file");
        private final IvyVariableContainer variables;
        private Map localVariables = new HashMap();

        private IvyVariableContainerWrapper(IvyVariableContainer ivyVariableContainer) {
            this.variables = ivyVariableContainer;
        }

        @Override
        public void setVariable(String string, String string2, boolean bl) {
            if (SETTINGS_VARIABLES.contains(string)) {
                if (!this.localVariables.containsKey(string) || bl) {
                    this.localVariables.put(string, string2);
                }
            } else {
                this.variables.setVariable(string, string2, bl);
            }
        }

        @Override
        public void setEnvironmentPrefix(String string) {
            this.variables.setEnvironmentPrefix(string);
        }

        @Override
        public String getVariable(String string) {
            if (this.localVariables.containsKey(string)) {
                return (String)this.localVariables.get(string);
            }
            return this.variables.getVariable(string);
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }
}

