/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.jar.Manifest;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.core.BundleArtifact;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;

public class OSGiManifestParser
implements ModuleDescriptorParser {
    private static final OSGiManifestParser INSTANCE = new OSGiManifestParser();
    private ExecutionEnvironmentProfileProvider profileProvider = ExecutionEnvironmentProfileProvider.getInstance();

    public static OSGiManifestParser getInstance() {
        return INSTANCE;
    }

    public void add(ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) {
        this.profileProvider = executionEnvironmentProfileProvider;
    }

    @Override
    public boolean accept(Resource resource) {
        if (resource == null || resource.getName() == null || resource.getName().trim().equals("")) {
            return false;
        }
        return resource.getName().toUpperCase(Locale.US).endsWith("MANIFEST.MF");
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, Resource resource, boolean bl) throws ParseException, IOException {
        Manifest manifest = new Manifest(resource.openStream());
        BundleInfo bundleInfo = ManifestParser.parseManifest(manifest);
        try {
            bundleInfo.addArtifact(new BundleArtifact(false, new URI(resource.getName()), null));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Unsupported repository, resources names are not uris", uRISyntaxException);
        }
        return BundleInfoAdapter.toModuleDescriptor(this, null, bundleInfo, this.profileProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toIvyFile(InputStream inputStream, Resource resource, File file, ModuleDescriptor moduleDescriptor) throws ParseException, IOException {
        try {
            XmlModuleDescriptorWriter.write(moduleDescriptor, file);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, boolean bl) throws ParseException, IOException {
        URLResource uRLResource = new URLResource(uRL);
        return this.parseDescriptor(parserSettings, uRL, uRLResource, bl);
    }

    @Override
    public String getType() {
        return "manifest";
    }

    @Override
    public Artifact getMetadataArtifact(ModuleRevisionId moduleRevisionId, Resource resource) {
        return DefaultArtifact.newIvyArtifact(moduleRevisionId, new Date(resource.getLastModified()));
    }

    public String toString() {
        return "manifest parser";
    }
}

