/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite.xml;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import org.apache.ivy.osgi.updatesite.xml.EclipsePlugin;
import org.apache.ivy.osgi.updatesite.xml.Require;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser {
    public static EclipseFeature parse(InputStream inputStream) throws ParseException, IOException, SAXException {
        FeatureHandler featureHandler = new FeatureHandler();
        try {
            XMLHelper.parse(inputStream, null, (DefaultHandler)featureHandler, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        return featureHandler.feature;
    }

    private static class ImportHandler
    extends DelegatingHandler {
        Require require;
        private static final String IMPORT = "import";
        private static final String FILTER = "filter";
        private static final String MATCH = "match";
        private static final String VERSION = "version";
        private static final String PLUGIN = "plugin";
        private static final String FEATURE = "feature";

        public ImportHandler() {
            super(IMPORT);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.require = new Require();
            String string = attributes.getValue(VERSION);
            this.require.setFeature(attributes.getValue(FEATURE));
            this.require.setPlugin(attributes.getValue(PLUGIN));
            try {
                this.require.setVersion(new Version(string));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on feature's import: " + string + " (" + parseException.getMessage() + ")");
            }
            this.require.setMatch(attributes.getValue(MATCH));
            this.require.setFilter(attributes.getValue(FILTER));
        }
    }

    static class RequiresHandler
    extends DelegatingHandler {
        private static final String REQUIRES = "requires";
        List<Require> requires = new ArrayList<Require>();

        public RequiresHandler() {
            super(REQUIRES);
            this.addChild(new ImportHandler(), new DelegatingHandler.ChildElementHandler<ImportHandler>(){

                @Override
                public void childHanlded(ImportHandler importHandler) {
                    RequiresHandler.this.requires.add(importHandler.require);
                }
            });
        }
    }

    private static class CopyrightHandler
    extends DelegatingHandler {
        private static final String COPYRIGHT = "copyright";

        public CopyrightHandler() {
            super(COPYRIGHT);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
        }
    }

    private static class LicenseHandler
    extends DelegatingHandler {
        private static final String LICENSE = "license";

        public LicenseHandler() {
            super(LICENSE);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
        }
    }

    private static class DescriptionHandler
    extends DelegatingHandler {
        private static final String DESCRIPTION = "description";

        public DescriptionHandler() {
            super(DESCRIPTION);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
        }
    }

    private static class PluginHandler
    extends DelegatingHandler {
        private static final String PLUGIN = "plugin";
        private static final String FILTER = "filter";
        private static final String FRAGMENT = "fragment";
        private static final String UNPACK = "unpack";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private EclipsePlugin plugin;

        public PluginHandler() {
            super(PLUGIN);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.plugin = new EclipsePlugin();
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            this.plugin.setId(string);
            try {
                this.plugin.setVersion(new Version(string2));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on feature's plugin '" + string + "': " + string2 + " (" + parseException.getMessage() + ")");
            }
            this.plugin.setUnpack(Boolean.valueOf(attributes.getValue(UNPACK)));
            this.plugin.setFragment(attributes.getValue(FRAGMENT));
            this.plugin.setFilter(attributes.getValue(FILTER));
        }
    }

    static class FeatureHandler
    extends DelegatingHandler {
        private static final String FEATURE = "feature";
        private static final String COLOCATION_AFFINITY = "colocation-affinity";
        private static final String PRIMARY = "primary";
        private static final String EXCLUSIVE = "exclusive";
        private static final String PLUGIN = "plugin";
        private static final String APPLICATION = "application";
        private static final String ARCH = "arch";
        private static final String NL = "nl";
        private static final String WS = "ws";
        private static final String OS = "os";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private static final String PROVIDER_NAME = "provider-name";
        private static final String LABEL = "label";
        private static final String IMAGE = "image";
        EclipseFeature feature;

        public FeatureHandler() {
            super(FEATURE);
            this.addChild(new DescriptionHandler(), new DelegatingHandler.ChildElementHandler<DescriptionHandler>(){

                @Override
                public void childHanlded(DescriptionHandler descriptionHandler) {
                    FeatureHandler.this.feature.setDescription(descriptionHandler.getBufferedChars().trim());
                }
            });
            this.addChild(new LicenseHandler(), new DelegatingHandler.ChildElementHandler<LicenseHandler>(){

                @Override
                public void childHanlded(LicenseHandler licenseHandler) {
                    FeatureHandler.this.feature.setLicense(licenseHandler.getBufferedChars().trim());
                }
            });
            this.addChild(new CopyrightHandler(), new DelegatingHandler.ChildElementHandler<CopyrightHandler>(){

                @Override
                public void childHanlded(CopyrightHandler copyrightHandler) {
                    FeatureHandler.this.feature.setCopyright(copyrightHandler.getBufferedChars().trim());
                }
            });
            this.addChild(new PluginHandler(), new DelegatingHandler.ChildElementHandler<PluginHandler>(){

                @Override
                public void childHanlded(PluginHandler pluginHandler) {
                    FeatureHandler.this.feature.addPlugin(pluginHandler.plugin);
                }
            });
            this.addChild(new RequiresHandler(), new DelegatingHandler.ChildElementHandler<RequiresHandler>(){

                @Override
                public void childHanlded(RequiresHandler requiresHandler) {
                    for (Require require : requiresHandler.requires) {
                        FeatureHandler.this.feature.addRequire(require);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            try {
                this.feature = new EclipseFeature(string, new Version(string2));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on feature '" + string + "': " + string2 + " (" + parseException.getMessage() + ")");
            }
            this.feature.setOS(attributes.getValue(OS));
            this.feature.setWS(attributes.getValue(WS));
            this.feature.setNL(attributes.getValue(NL));
            this.feature.setArch(attributes.getValue(ARCH));
            this.feature.setApplication(attributes.getValue(APPLICATION));
            this.feature.setPlugin(attributes.getValue(PLUGIN));
            this.feature.setExclusive(Boolean.valueOf(attributes.getValue(EXCLUSIVE)));
            this.feature.setPrimary(Boolean.valueOf(attributes.getValue(PRIMARY)));
            this.feature.setColocationAffinity(attributes.getValue(COLOCATION_AFFINITY));
            this.feature.setProviderName(attributes.getValue(PROVIDER_NAME));
            this.feature.setLabel(attributes.getValue(LABEL));
            this.feature.setImage(attributes.getValue(IMAGE));
        }
    }
}

