/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.InheritableItem;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlModuleDescriptorUpdater {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    private XmlModuleDescriptorUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(URL uRL, File file, UpdateOptions updateOptions) throws IOException, SAXException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            XmlModuleDescriptorUpdater.update(uRL, fileOutputStream, updateOptions);
        }
        finally {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                Message.warn("failed to close a stream : " + iOException.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(URL uRL, OutputStream outputStream, UpdateOptions updateOptions) throws IOException, SAXException {
        InputStream inputStream = uRL.openStream();
        try {
            XmlModuleDescriptorUpdater.update(uRL, inputStream, outputStream, updateOptions);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Message.warn("failed to close a stream : " + iOException.toString());
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                Message.warn("failed to close a stream : " + iOException.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(InputStream inputStream, Resource resource, File file, UpdateOptions updateOptions) throws IOException, SAXException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            URL uRL = null;
            if (resource instanceof URLResource) {
                uRL = ((URLResource)resource).getURL();
            } else if (resource instanceof FileResource) {
                uRL = ((FileResource)resource).getFile().toURI().toURL();
            }
            XmlModuleDescriptorUpdater.update(uRL, inputStream, fileOutputStream, updateOptions);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Message.warn("failed to close a stream : " + iOException.toString());
            }
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                Message.warn("failed to close a stream : " + iOException.toString());
            }
        }
    }

    public static void update(URL uRL, InputStream inputStream, OutputStream outputStream, UpdateOptions updateOptions) throws IOException, SAXException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        printWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.write(LINE_SEPARATOR);
        try {
            UpdaterHandler updaterHandler = new UpdaterHandler(uRL, printWriter, updateOptions);
            InputSource inputSource = new InputSource(new BufferedInputStream(inputStream));
            if (uRL != null) {
                inputSource.setSystemId(uRL.toExternalForm());
            }
            XMLHelper.parse(inputSource, null, (DefaultHandler)updaterHandler, (LexicalHandler)updaterHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IllegalStateException illegalStateException = new IllegalStateException("impossible to update Ivy files: parser problem");
            illegalStateException.initCause(parserConfigurationException);
            throw illegalStateException;
        }
    }

    protected static class ConfigurationPrinter
    implements ItemPrinter {
        public static final ConfigurationPrinter INSTANCE = new ConfigurationPrinter();

        protected ConfigurationPrinter() {
        }

        @Override
        public void print(ModuleDescriptor moduleDescriptor, Object object, PrintWriter printWriter) {
            XmlModuleDescriptorWriter.printConfiguration((Configuration)object, printWriter);
        }
    }

    protected static class DependencyPrinter
    implements ItemPrinter {
        public static final DependencyPrinter INSTANCE = new DependencyPrinter();

        protected DependencyPrinter() {
        }

        @Override
        public void print(ModuleDescriptor moduleDescriptor, Object object, PrintWriter printWriter) {
            XmlModuleDescriptorWriter.printDependency(moduleDescriptor, (DependencyDescriptor)object, printWriter);
        }
    }

    protected static interface ItemPrinter {
        public void print(ModuleDescriptor var1, Object var2, PrintWriter var3);
    }

    private static class ExtendedBuffer {
        private String context = null;
        private Boolean print = null;
        private boolean defaultPrint = false;
        private StringWriter buffer = new StringWriter();
        private PrintWriter writer = new PrintWriter(this.buffer);

        ExtendedBuffer(String string) {
            this.context = string;
        }

        boolean isPrint() {
            if (this.print == null) {
                return this.defaultPrint;
            }
            return this.print;
        }

        void setPrint(boolean bl) {
            this.print = bl;
        }

        void setDefaultPrint(boolean bl) {
            this.defaultPrint = bl;
        }

        PrintWriter getWriter() {
            return this.writer;
        }

        String getContext() {
            return this.context;
        }

        public String toString() {
            this.writer.flush();
            return this.buffer.toString();
        }
    }

    private static class UpdaterHandler
    extends DefaultHandler
    implements LexicalHandler {
        private static final Collection STD_ATTS = Arrays.asList("organisation", "module", "branch", "revision", "status", "publication", "namespace");
        private static final List MODULE_ELEMENTS = Arrays.asList("info", "configurations", "publications", "dependencies", "conflicts");
        private static final int CONFIGURATIONS_POSITION = MODULE_ELEMENTS.indexOf("configurations");
        private static final int DEPENDENCIES_POSITION = MODULE_ELEMENTS.indexOf("dependencies");
        private static final Collection INFO_ELEMENTS = Arrays.asList("extends", "ivyauthor", "license", "repository", "description");
        private final ParserSettings settings;
        private final PrintWriter out;
        private final Map resolvedRevisions;
        private final Map resolvedBranches;
        private final String status;
        private final String revision;
        private final Date pubdate;
        private final Namespace ns;
        private final boolean replaceInclude;
        private final boolean generateRevConstraint;
        private boolean inHeader = true;
        private final List confs;
        private final URL relativePathCtx;
        private final UpdateOptions options;
        private String organisation = null;
        private String defaultConfMapping = null;
        private Boolean confMappingOverride = null;
        private String justOpen = null;
        private boolean indenting;
        private StringBuffer currentIndent = new StringBuffer();
        private ArrayList indentLevels = new ArrayList();
        private boolean hasDescription = false;
        private boolean mergedConfigurations = false;
        private boolean mergedDependencies = false;
        private String newDefaultConf = null;
        private Stack context = new Stack();
        private Stack buffers = new Stack();
        private Stack confAttributeBuffers = new Stack();

        public UpdaterHandler(URL uRL, PrintWriter printWriter, UpdateOptions updateOptions) {
            this.options = updateOptions;
            this.settings = updateOptions.getSettings();
            this.out = printWriter;
            this.resolvedRevisions = updateOptions.getResolvedRevisions();
            this.resolvedBranches = updateOptions.getResolvedBranches();
            this.status = updateOptions.getStatus();
            this.revision = updateOptions.getRevision();
            this.pubdate = updateOptions.getPubdate();
            this.ns = updateOptions.getNamespace();
            this.replaceInclude = updateOptions.isReplaceInclude();
            this.generateRevConstraint = updateOptions.isGenerateRevConstraint();
            this.relativePathCtx = uRL;
            this.confs = updateOptions.getConfsToExclude() != null ? Arrays.asList(updateOptions.getConfsToExclude()) : Collections.EMPTY_LIST;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Object object;
            this.inHeader = false;
            this.endIndent();
            if (this.justOpen != null) {
                this.write(">");
            }
            this.flushMergedElementsBefore(string3);
            if (this.options.isMerge() && ("exclude".equals(string2) || "override".equals(string2) || "conflict".equals(string2)) && "ivy-module/dependencies".equals(this.getContext())) {
                object = this.options.getMergedDescriptor();
                this.writeInheritedDependencies((ModuleDescriptor)object);
                this.out.println();
                this.out.print(this.getIndent());
            }
            this.context.push(string3);
            object = this.getContext();
            if ("info".equals(string3)) {
                this.infoStarted(attributes);
            } else if (this.replaceInclude && "include".equals(string3) && this.context.contains("configurations")) {
                this.includeStarted(attributes);
            } else if ("ivy-module/info/extends".equals(object)) {
                this.startExtends(attributes);
            } else if ("ivy-module/dependencies/dependency".equals(object)) {
                this.startElementInDependency(attributes);
            } else if ("dependencies".equals(string3)) {
                this.startDependencies(attributes);
            } else if ("ivy-module/configurations/conf".equals(object)) {
                this.startElementInConfigurationsConf(string3, attributes);
            } else if ("ivy-module/publications/artifact/conf".equals(object) || "ivy-module/dependencies/dependency/conf".equals(object) || "ivy-module/dependencies/dependency/artifact/conf".equals(object)) {
                this.buffers.push(new ExtendedBuffer(this.getContext()));
                ((ExtendedBuffer)this.confAttributeBuffers.peek()).setDefaultPrint(false);
                String string4 = this.substitute(this.settings, attributes.getValue("name"));
                if (!this.confs.contains(string4)) {
                    ((ExtendedBuffer)this.confAttributeBuffers.peek()).setPrint(true);
                    ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                    this.write("<" + string3);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                    }
                }
            } else if ("ivy-module/publications/artifact".equals(object)) {
                ExtendedBuffer extendedBuffer = new ExtendedBuffer(this.getContext());
                this.buffers.push(extendedBuffer);
                this.confAttributeBuffers.push(extendedBuffer);
                this.write("<" + string3);
                extendedBuffer.setDefaultPrint(attributes.getValue("conf") == null && (this.newDefaultConf == null || this.newDefaultConf.length() > 0));
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string5 = attributes.getQName(i);
                    if ("conf".equals(string5)) {
                        String string6 = this.substitute(this.settings, attributes.getValue("conf"));
                        String string7 = this.removeConfigurationsFromList(string6, this.confs);
                        if (string7.length() <= 0) continue;
                        this.write(" " + attributes.getQName(i) + "=\"" + string7 + "\"");
                        ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                        continue;
                    }
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            } else if ("ivy-module/dependencies/dependency/artifact".equals(object)) {
                ExtendedBuffer extendedBuffer = new ExtendedBuffer(this.getContext());
                this.buffers.push(extendedBuffer);
                this.confAttributeBuffers.push(extendedBuffer);
                this.write("<" + string3);
                extendedBuffer.setDefaultPrint(attributes.getValue("conf") == null);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string8 = attributes.getQName(i);
                    if ("conf".equals(string8)) {
                        String string9 = this.substitute(this.settings, attributes.getValue("conf"));
                        String string10 = this.removeConfigurationsFromList(string9, this.confs);
                        if (string10.length() <= 0) continue;
                        this.write(" " + attributes.getQName(i) + "=\"" + string10 + "\"");
                        ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                        continue;
                    }
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            } else if ("ivy-module/publications".equals(object)) {
                this.startPublications(attributes);
            } else {
                if (this.options.isMerge() && ((String)object).startsWith("ivy-module/info")) {
                    ModuleDescriptor moduleDescriptor = this.options.getMergedDescriptor();
                    if (((String)object).equals("ivy-module/info/description")) {
                        this.hasDescription = true;
                    } else if (!INFO_ELEMENTS.contains(string3)) {
                        this.writeInheritedDescription(moduleDescriptor);
                    }
                }
                this.write("<" + string3);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            }
            this.justOpen = string3;
        }

        private void startExtends(Attributes attributes) {
            if (this.options.isMerge()) {
                this.write("<!-- ");
            }
            this.write("<extends");
            String string = this.substitute(this.settings, attributes.getValue("organisation"));
            String string2 = this.substitute(this.settings, attributes.getValue("module"));
            ModuleId moduleId = new ModuleId(string, string2);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string3 = attributes.getQName(i);
                String string4 = null;
                if ("revision".equals(string3)) {
                    ModuleDescriptor moduleDescriptor = this.options.getMergedDescriptor();
                    if (moduleDescriptor != null) {
                        ExtendsDescriptor[] extendsDescriptorArray = moduleDescriptor.getInheritedDescriptors();
                        for (int j = 0; string4 == null && j < extendsDescriptorArray.length; ++j) {
                            ModuleRevisionId moduleRevisionId = extendsDescriptorArray[j].getResolvedParentRevisionId();
                            if (!moduleId.equals(moduleRevisionId.getModuleId())) continue;
                            string4 = moduleRevisionId.getRevision();
                        }
                    }
                    if (string4 == null) {
                        string4 = this.substitute(this.settings, attributes.getValue(i));
                    }
                } else {
                    string4 = "organisation".equals(string3) ? string : ("module".equals(string3) ? string2 : this.substitute(this.settings, attributes.getValue(i)));
                }
                this.write(" " + string3 + "=\"" + string4 + "\"");
            }
        }

        private void startElementInConfigurationsConf(String string, Attributes attributes) {
            this.buffers.push(new ExtendedBuffer(this.getContext()));
            String string2 = this.substitute(this.settings, attributes.getValue("name"));
            if (!this.confs.contains(string2)) {
                ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                String string3 = this.substitute(this.settings, attributes.getValue("extends"));
                if (string3 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ", ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (!this.confs.contains(string4)) continue;
                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                    }
                }
                this.write("<" + string);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            }
        }

        private void startDependencies(Attributes attributes) {
            String string;
            this.write("<dependencies");
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string2 = attributes.getQName(i);
                if ("defaultconfmapping".equals(string2)) {
                    String string3 = this.removeConfigurationsFromMapping(this.substitute(this.settings, attributes.getValue("defaultconfmapping")), this.confs);
                    if (string3.length() <= 0) continue;
                    this.write(" " + attributes.getQName(i) + "=\"" + string3 + "\"");
                    continue;
                }
                this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
            }
            if (this.defaultConfMapping != null && attributes.getValue("defaultconfmapping") == null && (string = this.removeConfigurationsFromMapping(this.defaultConfMapping, this.confs)).length() > 0) {
                this.write(" defaultconfmapping=\"" + string + "\"");
            }
            if (this.confMappingOverride != null && attributes.getValue("confmappingoverride") == null) {
                this.write(" confmappingoverride=\"" + this.confMappingOverride.toString() + "\"");
            }
        }

        private void startPublications(Attributes attributes) {
            this.write("<publications");
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getQName(i);
                if ("defaultconf".equals(string)) {
                    this.newDefaultConf = this.removeConfigurationsFromList(this.substitute(this.settings, attributes.getValue("defaultconf")), this.confs);
                    if (this.newDefaultConf.length() <= 0) continue;
                    this.write(" " + attributes.getQName(i) + "=\"" + this.newDefaultConf + "\"");
                    continue;
                }
                this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
            }
        }

        private void startElementInDependency(Attributes attributes) {
            Object object3;
            Object object2;
            ExtendedBuffer extendedBuffer = new ExtendedBuffer(this.getContext());
            this.buffers.push(extendedBuffer);
            this.confAttributeBuffers.push(extendedBuffer);
            extendedBuffer.setDefaultPrint(attributes.getValue("conf") == null || attributes.getValue("conf").trim().length() == 0);
            this.write("<dependency");
            String string = this.substitute(this.settings, attributes.getValue("org"));
            string = string == null ? this.organisation : string;
            String string2 = this.substitute(this.settings, attributes.getValue("name"));
            String string3 = this.substitute(this.settings, attributes.getValue("branch"));
            String string4 = this.substitute(this.settings, attributes.getValue("branchConstraint"));
            String string5 = string4 = string4 == null ? string3 : string4;
            if (string3 == null) {
                object2 = ModuleId.newInstance(string, string2);
                if (this.ns != null) {
                    object2 = NameSpaceHelper.transform((ModuleId)object2, this.ns.getToSystemTransformer());
                }
                for (Object object3 : this.resolvedRevisions.keySet()) {
                    if (!((ModuleRevisionId)object3).getModuleId().equals(object2)) continue;
                    string3 = ((ModuleRevisionId)object3).getBranch();
                    break;
                }
            }
            object2 = this.substitute(this.settings, attributes.getValue("rev"));
            String string6 = this.substitute(this.settings, attributes.getValue("revConstraint"));
            object3 = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, XmlModuleDescriptorParser.DEPENDENCY_REGULAR_ATTRIBUTES);
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(string, string2, string3, (String)object2, (Map)object3);
            ModuleRevisionId moduleRevisionId2 = this.ns == null ? moduleRevisionId : this.ns.getToSystemTransformer().transform(moduleRevisionId);
            String string7 = (String)this.resolvedBranches.get(moduleRevisionId2);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string8;
                String string9 = attributes.getQName(i);
                if ("rev".equals(string9)) {
                    string8 = (String)this.resolvedRevisions.get(moduleRevisionId2);
                    if (string8 != null) {
                        this.write(" rev=\"" + string8 + "\"");
                        if (attributes.getIndex("branchConstraint") == -1 && string4 != null) {
                            this.write(" branchConstraint=\"" + string4 + "\"");
                        }
                        if (!this.generateRevConstraint || attributes.getIndex("revConstraint") != -1 || string8.equals(moduleRevisionId2.getRevision())) continue;
                        this.write(" revConstraint=\"" + moduleRevisionId2.getRevision() + "\"");
                        continue;
                    }
                    this.write(" rev=\"" + moduleRevisionId2.getRevision() + "\"");
                    continue;
                }
                if ("revConstraint".equals(string9)) {
                    this.write(" revConstraint=\"" + (String)string6 + "\"");
                    continue;
                }
                if ("org".equals(string9)) {
                    this.write(" org=\"" + moduleRevisionId2.getOrganisation() + "\"");
                    continue;
                }
                if ("name".equals(string9)) {
                    this.write(" name=\"" + moduleRevisionId2.getName() + "\"");
                    continue;
                }
                if ("branch".equals(string9)) {
                    if (string7 != null) {
                        this.write(" branch=\"" + string7 + "\"");
                        continue;
                    }
                    if (this.resolvedBranches.containsKey(moduleRevisionId2)) continue;
                    this.write(" branch=\"" + moduleRevisionId2.getBranch() + "\"");
                    continue;
                }
                if ("branchConstraint".equals(string9)) {
                    this.write(" branchConstraint=\"" + string4 + "\"");
                    continue;
                }
                if ("conf".equals(string9)) {
                    String string10;
                    string8 = this.substitute(this.settings, attributes.getValue("conf"));
                    if (string8.length() <= 0 || (string10 = this.removeConfigurationsFromMapping(string8, this.confs)).length() <= 0) continue;
                    this.write(" conf=\"" + string10 + "\"");
                    ((ExtendedBuffer)this.buffers.peek()).setPrint(true);
                    continue;
                }
                this.write(" " + string9 + "=\"" + this.substitute(this.settings, attributes.getValue(string9)) + "\"");
            }
            if (attributes.getIndex("branch") == -1) {
                if (string7 != null) {
                    if (!string7.trim().equals("")) {
                        this.write(" branch=\"" + string7 + "\"");
                    }
                } else if (this.options.isUpdateBranch() && moduleRevisionId2.getBranch() != null) {
                    this.write(" branch=\"" + moduleRevisionId2.getBranch() + "\"");
                }
            }
        }

        private void includeStarted(Attributes attributes) throws SAXException {
            final ExtendedBuffer extendedBuffer = new ExtendedBuffer(this.getContext());
            this.buffers.push(extendedBuffer);
            try {
                URL uRL;
                if (this.settings != null) {
                    uRL = this.settings.getRelativeUrlResolver().getURL(this.relativePathCtx, this.settings.substitute(attributes.getValue("file")), this.settings.substitute(attributes.getValue("url")));
                } else {
                    String string = attributes.getValue("file");
                    if (string == null) {
                        String string2 = attributes.getValue("url");
                        uRL = new URL(string2);
                    } else {
                        uRL = Checks.checkAbsolute(string, "settings.include").toURI().toURL();
                    }
                }
                XMLHelper.parse(uRL, null, new DefaultHandler(){
                    private boolean insideConfigurations = false;
                    private boolean doIndent = false;

                    @Override
                    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                        if ("configurations".equals(string3)) {
                            String string4;
                            this.insideConfigurations = true;
                            String string5 = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("defaultconfmapping"));
                            if (string5 != null) {
                                UpdaterHandler.this.defaultConfMapping = string5;
                            }
                            if ((string4 = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("confmappingoverride"))) != null) {
                                UpdaterHandler.this.confMappingOverride = Boolean.valueOf(string4);
                            }
                        } else if ("conf".equals(string3) && this.insideConfigurations) {
                            String string6 = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("name"));
                            if (!UpdaterHandler.this.confs.contains(string6)) {
                                String string7;
                                extendedBuffer.setPrint(true);
                                if (this.doIndent) {
                                    UpdaterHandler.this.write("/>\n\t\t");
                                }
                                if ((string7 = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("extends"))) != null) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(string7, ", ");
                                    while (stringTokenizer.hasMoreTokens()) {
                                        String string8 = stringTokenizer.nextToken();
                                        if (!UpdaterHandler.this.confs.contains(string8)) continue;
                                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                                    }
                                }
                                UpdaterHandler.this.write("<" + string3);
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    UpdaterHandler.this.write(" " + attributes.getQName(i) + "=\"" + UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue(i)) + "\"");
                                }
                                this.doIndent = true;
                            }
                        }
                    }

                    @Override
                    public void endElement(String string, String string2, String string3) throws SAXException {
                        if ("configurations".equals(string3)) {
                            this.insideConfigurations = false;
                        }
                    }
                });
            }
            catch (Exception exception) {
                Message.warn("exception occurred while importing configurations: " + exception.getMessage());
                throw new SAXException(exception);
            }
        }

        private void infoStarted(Attributes attributes) {
            Object object;
            ExtendableItem extendableItem;
            String string = this.substitute(this.settings, attributes.getValue("module"));
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            LinkedHashMap<Object, String> linkedHashMap = null;
            if (this.options.isMerge()) {
                Object object2;
                extendableItem = this.options.getMergedDescriptor();
                object = extendableItem.getModuleRevisionId();
                this.organisation = ((ModuleRevisionId)object).getOrganisation();
                string3 = ((ModuleRevisionId)object).getBranch();
                string2 = ((ModuleRevisionId)object).getRevision();
                string4 = extendableItem.getStatus();
                if (extendableItem instanceof DefaultModuleDescriptor && (object2 = ((DefaultModuleDescriptor)extendableItem).getNamespace()) != null) {
                    string5 = ((Namespace)object2).getName();
                }
                if (string5 == null) {
                    string5 = attributes.getValue("namespace");
                }
                linkedHashMap = extendableItem.getQualifiedExtraAttributes();
            } else {
                this.organisation = this.substitute(this.settings, attributes.getValue("organisation"));
                string2 = this.substitute(this.settings, attributes.getValue("revision"));
                string3 = this.substitute(this.settings, attributes.getValue("branch"));
                string4 = this.substitute(this.settings, attributes.getValue("status"));
                string5 = this.substitute(this.settings, attributes.getValue("namespace"));
                linkedHashMap = new LinkedHashMap<Object, String>(attributes.getLength());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    object = attributes.getQName(i);
                    if (STD_ATTS.contains(object)) continue;
                    linkedHashMap.put(object, this.substitute(this.settings, attributes.getValue(i)));
                }
            }
            if (this.revision != null) {
                string2 = this.revision;
            }
            if (this.options.getBranch() != null) {
                string3 = this.options.getBranch();
            }
            if (this.status != null) {
                string4 = this.status;
            }
            extendableItem = ModuleRevisionId.newInstance(this.organisation, string, string3, string2, ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"organisation", "module", "revision", "status", "publication", "namespace"}));
            object = this.ns == null ? extendableItem : this.ns.getToSystemTransformer().transform((ModuleRevisionId)extendableItem);
            this.write("<info");
            if (this.organisation != null) {
                this.write(" organisation=\"" + XMLHelper.escape(((ModuleRevisionId)object).getOrganisation()) + "\"");
            }
            this.write(" module=\"" + XMLHelper.escape(((ModuleRevisionId)object).getName()) + "\"");
            if (string3 != null) {
                this.write(" branch=\"" + XMLHelper.escape(((ModuleRevisionId)object).getBranch()) + "\"");
            }
            if (((ModuleRevisionId)object).getRevision() != null) {
                this.write(" revision=\"" + XMLHelper.escape(((ModuleRevisionId)object).getRevision()) + "\"");
            }
            this.write(" status=\"" + XMLHelper.escape(string4) + "\"");
            if (this.pubdate != null) {
                this.write(" publication=\"" + DateUtil.format(this.pubdate) + "\"");
            } else if (attributes.getValue("publication") != null) {
                this.write(" publication=\"" + this.substitute(this.settings, attributes.getValue("publication")) + "\"");
            }
            if (string5 != null) {
                this.write(" namespace=\"" + string5 + "\"");
            }
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                this.write(" " + entry.getKey() + "=\"" + entry.getValue() + "\"");
            }
        }

        private void write(String string) {
            this.getWriter().print(string);
        }

        private PrintWriter getWriter() {
            return this.buffers.isEmpty() ? this.out : ((ExtendedBuffer)this.buffers.peek()).getWriter();
        }

        private String getContext() {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.context) {
                stringBuffer.append(string).append("/");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            return stringBuffer.toString();
        }

        private String substitute(ParserSettings parserSettings, String string) {
            String string2 = parserSettings == null ? string : parserSettings.substitute(string);
            return XMLHelper.escape(string2);
        }

        private String removeConfigurationsFromMapping(String string, List list) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String[] stringArray = string3.split("->");
                String[] stringArray2 = stringArray[0].split(",");
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (this.confs.contains(stringArray2[i].trim())) continue;
                    arrayList.add(stringArray2[i]);
                }
                if (arrayList.isEmpty()) continue;
                stringBuffer.append(string2);
                String string4 = "";
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(string4);
                    stringBuffer.append(iterator.next());
                    string4 = ",";
                }
                if (stringArray.length == 2) {
                    stringBuffer.append("->");
                    stringBuffer.append(stringArray[1]);
                }
                string2 = ";";
            }
            return stringBuffer.toString();
        }

        private String removeConfigurationsFromList(String string, List list) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (list.contains(string3.trim())) continue;
                stringBuffer.append(string2);
                stringBuffer.append(string3);
                string2 = ",";
            }
            return stringBuffer.toString();
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.characters(cArray, n, n2);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            this.write(XMLHelper.escape(String.valueOf(cArray, n, n2)));
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if (c == '\r' || c == '\n') {
                    this.currentIndent.setLength(0);
                    this.indenting = true;
                    continue;
                }
                if (!this.indenting) continue;
                if (Character.isWhitespace(c)) {
                    this.currentIndent.append(c);
                    continue;
                }
                this.endIndent();
            }
        }

        private void endIndent() {
            if (this.indenting) {
                this.setIndent(this.context.size() - 1, this.currentIndent.toString());
                this.indenting = false;
            }
        }

        private void setIndent(int n, String string) {
            this.fillIndents(n);
            this.indentLevels.set(n, string);
        }

        private void fillIndents(int n) {
            if (this.indentLevels.isEmpty()) {
                this.indentLevels.add("    ");
            }
            String string = (String)this.indentLevels.get(0);
            for (int i = this.indentLevels.size(); i <= n; ++i) {
                this.indentLevels.add(this.indentLevels.get(i - 1) + string);
            }
        }

        private String getIndent() {
            int n = this.context.size() - 1;
            this.fillIndents(n);
            return (String)this.indentLevels.get(n);
        }

        private void writeInheritedItems(ModuleDescriptor moduleDescriptor, InheritableItem[] inheritableItemArray, ItemPrinter itemPrinter, String string, boolean bl) {
            boolean bl2;
            PrintWriter printWriter = this.getWriter();
            Map map = this.collateInheritedItems(moduleDescriptor, inheritableItemArray);
            boolean bl3 = bl2 = !map.isEmpty();
            if (bl2 && bl) {
                if (this.currentIndent.length() == 0) {
                    printWriter.print(this.getIndent());
                }
                printWriter.print("<" + string + ">");
                this.context.push(string);
                this.justOpen = null;
            }
            for (Map.Entry entry : map.entrySet()) {
                ModuleRevisionId moduleRevisionId = (ModuleRevisionId)entry.getKey();
                List list = (List)entry.getValue();
                if (this.justOpen != null) {
                    printWriter.println(">");
                    this.justOpen = null;
                }
                this.writeInheritanceComment(string, moduleRevisionId);
                for (int i = 0; i < list.size(); ++i) {
                    InheritableItem inheritableItem = (InheritableItem)list.get(i);
                    printWriter.print(this.getIndent());
                    itemPrinter.print(moduleDescriptor, inheritableItem, printWriter);
                }
            }
            if (bl2) {
                if (bl) {
                    this.context.pop();
                    printWriter.println(this.getIndent() + "</" + string + ">");
                    printWriter.println();
                }
                printWriter.print(this.currentIndent);
            }
        }

        private void writeInheritanceComment(String string, Object object) {
            PrintWriter printWriter = this.getWriter();
            printWriter.println();
            printWriter.println(this.getIndent() + "<!-- " + string + " inherited from " + object + " -->");
        }

        private Map collateInheritedItems(ModuleDescriptor moduleDescriptor, InheritableItem[] inheritableItemArray) {
            LinkedHashMap<ModuleRevisionId, ArrayList<InheritableItem>> linkedHashMap = new LinkedHashMap<ModuleRevisionId, ArrayList<InheritableItem>>();
            for (int i = 0; i < inheritableItemArray.length; ++i) {
                ModuleRevisionId moduleRevisionId = inheritableItemArray[i].getSourceModule();
                if (moduleRevisionId == null || moduleRevisionId.getModuleId().equals(moduleDescriptor.getModuleRevisionId().getModuleId())) continue;
                ArrayList<InheritableItem> arrayList = (ArrayList<InheritableItem>)linkedHashMap.get(moduleRevisionId);
                if (arrayList == null) {
                    arrayList = new ArrayList<InheritableItem>();
                    linkedHashMap.put(moduleRevisionId, arrayList);
                }
                arrayList.add(inheritableItemArray[i]);
            }
            return linkedHashMap;
        }

        private void writeInheritedDescription(ModuleDescriptor moduleDescriptor) {
            if (!this.hasDescription) {
                this.hasDescription = true;
                String string = moduleDescriptor.getDescription();
                if (string != null && string.length() > 0) {
                    PrintWriter printWriter = this.getWriter();
                    if (this.justOpen != null) {
                        printWriter.println(">");
                    }
                    this.writeInheritanceComment("description", "parent");
                    printWriter.println(this.getIndent() + "<description>" + XMLHelper.escape(string) + "</description>");
                    printWriter.print(this.currentIndent);
                    this.justOpen = null;
                }
            }
        }

        private void writeInheritedConfigurations(ModuleDescriptor moduleDescriptor) {
            if (!this.mergedConfigurations) {
                this.mergedConfigurations = true;
                this.writeInheritedItems(moduleDescriptor, moduleDescriptor.getConfigurations(), ConfigurationPrinter.INSTANCE, "configurations", false);
            }
        }

        private void writeInheritedDependencies(ModuleDescriptor moduleDescriptor) {
            if (!this.mergedDependencies) {
                this.mergedDependencies = true;
                this.writeInheritedItems(moduleDescriptor, moduleDescriptor.getDependencies(), DependencyPrinter.INSTANCE, "dependencies", false);
            }
        }

        private void flushMergedElementsBefore(String string) {
            if (this.options.isMerge() && this.context.size() == 1 && "ivy-module".equals(this.context.peek()) && (!this.mergedConfigurations || !this.mergedDependencies)) {
                int n = string == null ? MODULE_ELEMENTS.size() : MODULE_ELEMENTS.indexOf(string);
                ModuleDescriptor moduleDescriptor = this.options.getMergedDescriptor();
                if (!this.mergedConfigurations && n > CONFIGURATIONS_POSITION && moduleDescriptor.getConfigurations().length > 0) {
                    this.mergedConfigurations = true;
                    this.writeInheritedItems(moduleDescriptor, moduleDescriptor.getConfigurations(), ConfigurationPrinter.INSTANCE, "configurations", true);
                }
                if (!this.mergedDependencies && n > DEPENDENCIES_POSITION && moduleDescriptor.getDependencies().length > 0) {
                    this.mergedDependencies = true;
                    this.writeInheritedItems(moduleDescriptor, moduleDescriptor.getDependencies(), DependencyPrinter.INSTANCE, "dependencies", true);
                }
            }
        }

        private void flushAllMergedElements() {
            this.flushMergedElementsBefore(null);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            Object object;
            String string4 = this.getContext();
            if (this.options.isMerge()) {
                object = this.options.getMergedDescriptor();
                if ("ivy-module/info".equals(string4)) {
                    this.writeInheritedDescription((ModuleDescriptor)object);
                } else if ("ivy-module/configurations".equals(string4)) {
                    this.writeInheritedConfigurations((ModuleDescriptor)object);
                } else if ("ivy-module/dependencies".equals(string4)) {
                    this.writeInheritedDependencies((ModuleDescriptor)object);
                } else if ("ivy-module".equals(string4)) {
                    this.flushAllMergedElements();
                }
            }
            if (string3.equals(this.justOpen)) {
                this.write("/>");
            } else {
                this.write("</" + string3 + ">");
            }
            if (!this.buffers.isEmpty() && ((ExtendedBuffer)(object = (ExtendedBuffer)this.buffers.peek())).getContext().equals(string4)) {
                this.buffers.pop();
                if (((ExtendedBuffer)object).isPrint()) {
                    this.write(((ExtendedBuffer)object).toString());
                }
            }
            if (!this.confAttributeBuffers.isEmpty() && ((ExtendedBuffer)(object = (ExtendedBuffer)this.confAttributeBuffers.peek())).getContext().equals(string4)) {
                this.confAttributeBuffers.pop();
            }
            if (this.options.isMerge() && "ivy-module/info/extends".equals(string4)) {
                this.write(" -->");
            }
            this.justOpen = null;
            this.context.pop();
        }

        @Override
        public void endDocument() throws SAXException {
            this.out.print(LINE_SEPARATOR);
            this.out.flush();
            this.out.close();
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            this.write("<?");
            this.write(string);
            this.write(" ");
            this.write(string2);
            this.write("?>");
            this.write(LINE_SEPARATOR);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] cArray, int n, int n2) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n, n2);
            this.write("<!--");
            this.write(stringBuffer.toString());
            this.write("-->");
            if (this.inHeader) {
                this.write(LINE_SEPARATOR);
            }
        }

        @Override
        public void endEntity(String string) throws SAXException {
        }

        @Override
        public void startEntity(String string) throws SAXException {
        }

        @Override
        public void startDTD(String string, String string2, String string3) throws SAXException {
        }
    }
}

