/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.BasicResource;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.Message;

public class ChainedRepository
extends AbstractRepository {
    private List repositories;

    public void setRepositories(List list) {
        this.repositories = list;
    }

    @Override
    public Resource getResource(String string) throws IOException {
        for (Repository repository : this.repositories) {
            this.logTry(repository);
            try {
                Resource resource = repository.getResource(string);
                if (resource == null || !resource.exists()) continue;
                this.logSuccess(repository);
                return resource;
            }
            catch (Exception exception) {
                this.logFailed(repository, exception);
            }
        }
        return new BasicResource(string, false, 0L, 0L, true);
    }

    @Override
    public void get(String string, File file) throws IOException {
        for (Repository repository : this.repositories) {
            this.logTry(repository);
            boolean bl = false;
            try {
                repository.get(string, file);
                bl = true;
            }
            catch (Exception exception) {
                this.logFailed(repository, exception);
            }
            if (!bl) continue;
            this.logSuccess(repository);
            return;
        }
        throw this.newIOEFail("copy " + string + " into " + file);
    }

    @Override
    public List list(String string) throws IOException {
        for (Repository repository : this.repositories) {
            this.logTry(repository);
            try {
                List list = repository.list(string);
                if (list == null) continue;
                this.logSuccess(repository);
                return list;
            }
            catch (Exception exception) {
                this.logFailed(repository, exception);
            }
        }
        throw this.newIOEFail("list contents in " + string);
    }

    private void logTry(Repository repository) {
        Message.debug("Mirrored repository " + this.getName() + ": trying " + repository.getName());
    }

    private void logFailed(Repository repository, Exception exception) {
        Message.warn("Mirrored repository " + this.getName() + ": " + repository.getName() + " is not available", exception);
        Message.warn("Trying the next one in the mirror list...");
    }

    private void logSuccess(Repository repository) {
        Message.debug("Mirrored repository " + this.getName() + ": success with " + repository.getName());
    }

    private IOException newIOEFail(String string) {
        return new IOException("Mirrored repository " + this.getName() + ": fail to " + string + " with every listed mirror");
    }
}

