/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.VfsResolver;
import org.apache.ivy.util.Message;

public class VfsResource
implements Resource {
    private String vfsURI;
    private FileSystemManager fsManager;
    private transient boolean init = false;
    private transient boolean exists;
    private transient long lastModified;
    private transient long contentLength;
    private transient FileContent content = null;
    private transient FileObject resourceImpl;

    public VfsResource(String string, FileSystemManager fileSystemManager) {
        this.vfsURI = string;
        this.fsManager = fileSystemManager;
        this.init = false;
    }

    private void init() {
        if (!this.init) {
            try {
                this.resourceImpl = this.fsManager.resolveFile(this.vfsURI);
                this.content = this.resourceImpl.getContent();
                this.exists = this.resourceImpl.exists();
                this.lastModified = this.content.getLastModifiedTime();
                this.contentLength = this.content.getSize();
            }
            catch (FileSystemException fileSystemException) {
                Message.debug(fileSystemException);
                Message.verbose(fileSystemException.getLocalizedMessage());
                this.exists = false;
                this.lastModified = 0L;
                this.contentLength = 0L;
            }
            this.init = true;
        }
    }

    public List getChildren() {
        this.init();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (this.resourceImpl != null && this.resourceImpl.exists() && this.resourceImpl.getType() == FileType.FOLDER) {
                FileObject[] fileObjectArray = this.resourceImpl.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    FileObject fileObject = fileObjectArray[i];
                    arrayList.add(VfsResource.normalize(fileObject.getName().getURI()));
                }
            }
        }
        catch (IOException iOException) {
            Message.debug(iOException);
            Message.verbose(iOException.getLocalizedMessage());
        }
        return arrayList;
    }

    public FileContent getContent() {
        this.init();
        return this.content;
    }

    @Override
    public String getName() {
        return VfsResource.normalize(this.vfsURI);
    }

    @Override
    public Resource clone(String string) {
        return new VfsResource(string, this.fsManager);
    }

    public static String normalize(String string) {
        if (string == null) {
            return "";
        }
        if (string.startsWith("file:////")) {
            string = string.replaceFirst("////", "///");
        }
        return string;
    }

    @Override
    public long getLastModified() {
        this.init();
        return this.lastModified;
    }

    @Override
    public long getContentLength() {
        this.init();
        return this.contentLength;
    }

    @Override
    public boolean exists() {
        this.init();
        return this.exists;
    }

    public boolean physicallyExists() {
        this.init();
        try {
            return this.resourceImpl.exists();
        }
        catch (Exception exception) {
            Message.verbose("Fail to check the existance of the resource " + this.getName(), exception);
            return false;
        }
    }

    public String toString() {
        return VfsResolver.prepareForDisplay(this.getName());
    }

    @Override
    public boolean isLocal() {
        return this.getName().startsWith("file:");
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.getContent().getInputStream();
    }
}

