/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.vsftp;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyThread;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.BasicResource;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.vsftp.VsftpResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;

public class VsftpRepository
extends AbstractRepository {
    private static final int LS_DATE_INDEX4 = 7;
    private static final int LS_DATE_INDEX3 = 6;
    private static final int LS_DATE_INDEX2 = 5;
    private static final int LS_DATE_INDEX1 = 4;
    private static final int LS_SIZE_INDEX = 3;
    private static final int LS_PARTS_NUMBER = 9;
    private static final int DISCONNECT_COMMAND_TIMEOUT = 300;
    private static final int REUSE_CONNECTION_SLEEP_TIME = 10;
    private static final int READER_ALIVE_SLEEP_TIME = 100;
    private static final int MAX_READER_ALIVE_ATTEMPT = 5;
    private static final int ERROR_SLEEP_TIME = 30;
    private static final int PROMPT_SLEEP_TIME = 50;
    private static final int MAX_READ_PROMPT_ATTEMPT = 5;
    private static final int GET_JOIN_MAX_TIME = 100;
    private static final int DEFAULT_REUSE_CONNECTION_TIME = 300000;
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final String PROMPT = "vsftp> ";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("MMM dd, yyyy HH:mm", Locale.US);
    private String host;
    private String username;
    private String authentication = "gssapi";
    private Reader in;
    private Reader err;
    private PrintWriter out;
    private volatile StringBuffer errors = new StringBuffer();
    private long readTimeout = 30000L;
    private long reuseConnection = 300000L;
    private volatile long lastCommand;
    private volatile boolean inCommand;
    private Process process;
    private Thread connectionCleaner;
    private Thread errorsReader;
    private volatile long errorsLastUpdateTime;
    private Ivy ivy = null;

    @Override
    public Resource getResource(String string) throws IOException {
        this.initIvy();
        return new VsftpResource(this, string);
    }

    private void initIvy() {
        this.ivy = IvyContext.getContext().getIvy();
    }

    protected Resource getInitResource(String string) throws IOException {
        try {
            Resource resource = this.lslToResource(string, this.sendCommand("ls -l " + string, true, true));
            return resource;
        }
        catch (IOException iOException) {
            this.cleanup(iOException);
            throw iOException;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public void get(final String string, File file) throws IOException {
        this.initIvy();
        try {
            int n;
            this.fireTransferInitiated(this.getResource(string), 5);
            File file2 = file.getParentFile();
            if (file2 != null) {
                this.sendCommand("lcd " + file2.getAbsolutePath());
            }
            if (file.exists()) {
                file.delete();
            }
            String string2 = (n = string.lastIndexOf(47)) == -1 ? string : string.substring(n + 1);
            final File file3 = file2 == null ? Checks.checkAbsolute(string2, "source") : new File(file2, string2);
            final IOException[] iOExceptionArray = new IOException[1];
            IvyThread ivyThread = new IvyThread(){

                @Override
                public void run() {
                    this.initContext();
                    try {
                        VsftpRepository.this.sendCommand("get " + string, VsftpRepository.this.getExpectedDownloadMessage(string, file3), 0L);
                    }
                    catch (IOException iOException) {
                        iOExceptionArray[0] = iOException;
                    }
                }
            };
            ivyThread.start();
            long l = 0L;
            long l2 = System.currentTimeMillis();
            long l3 = this.readTimeout;
            while (ivyThread.isAlive()) {
                long l4;
                this.checkInterrupted();
                long l5 = l4 = file3.exists() ? file3.length() : 0L;
                if (l4 > l) {
                    this.fireTransferProgress(l4 - l);
                    l2 = System.currentTimeMillis();
                    l = l4;
                } else if (System.currentTimeMillis() - l2 > l3) {
                    Message.verbose("download hang for more than " + l3 + "ms. Interrupting.");
                    ivyThread.interrupt();
                    if (file3.exists()) {
                        file3.delete();
                    }
                    throw new IOException(string + " download timeout from " + this.getHost());
                }
                try {
                    ivyThread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    if (file3.exists()) {
                        file3.delete();
                    }
                    this.cleanup();
                    return;
                }
            }
            if (iOExceptionArray[0] != null) {
                if (file3.exists()) {
                    file3.delete();
                }
                throw iOExceptionArray[0];
            }
            file3.renameTo(file);
            this.fireTransferCompleted(file.length());
        }
        catch (IOException iOException) {
            this.fireTransferError(iOException);
            this.cleanup(iOException);
            throw iOException;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public List list(String string) throws IOException {
        this.initIvy();
        try {
            String string2;
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if ((string2 = this.sendCommand("ls -l " + string, true, true)).startsWith("ls")) {
                List list = null;
                return list;
            }
            String[] stringArray = string2.split("\n");
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                while (stringArray[i].endsWith("\r") || stringArray[i].endsWith("\n")) {
                    stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 1);
                }
                if (stringArray[i].trim().length() == 0) continue;
                arrayList.add(string + stringArray[i].substring(stringArray[i].lastIndexOf(32) + 1));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (IOException iOException) {
            this.cleanup(iOException);
            throw iOException;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public void put(File file, String string, boolean bl) throws IOException {
        this.initIvy();
        try {
            if (this.getResource(string).exists()) {
                if (bl) {
                    this.sendCommand("rm " + string, this.getExpectedRemoveMessage(string));
                } else {
                    return;
                }
            }
            int n = string.lastIndexOf(47);
            String string2 = null;
            if (n != -1) {
                string2 = string.substring(0, n);
                this.mkdirs(string2);
                this.sendCommand("cd " + string2);
            }
            String string3 = string2 != null ? string2 + "/" + file.getName() : file.getName();
            this.sendCommand("put " + file.getAbsolutePath(), this.getExpectedUploadMessage(file, string3), 0L);
            this.sendCommand("mv " + string3 + " " + string);
        }
        catch (IOException iOException) {
            this.cleanup(iOException);
            throw iOException;
        }
        finally {
            this.cleanup();
        }
    }

    private void mkdirs(String string) throws IOException {
        int n;
        if (this.dirExists(string)) {
            return;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf(47)) != -1) {
            this.mkdirs(string.substring(0, n));
        }
        this.sendCommand("mkdir " + string);
    }

    private boolean dirExists(String string) throws IOException {
        return !this.sendCommand("ls " + string, true).startsWith("ls: ");
    }

    protected String sendCommand(String string) throws IOException {
        return this.sendCommand(string, false, this.readTimeout);
    }

    protected void sendCommand(String string, Pattern pattern) throws IOException {
        this.sendCommand(string, pattern, this.readTimeout);
    }

    protected void sendCommand(String string, Pattern pattern, long l) throws IOException {
        String string2 = this.sendCommand(string, true, l);
        if (!pattern.matcher(string2).matches()) {
            Message.debug("invalid response from server:");
            Message.debug("expected: '" + pattern + "'");
            Message.debug("was:      '" + string2 + "'");
            throw new IOException(string2);
        }
    }

    protected String sendCommand(String string, boolean bl) throws IOException {
        return this.sendCommand(string, bl, this.readTimeout);
    }

    protected String sendCommand(String string, boolean bl, boolean bl2) throws IOException {
        return this.sendCommand(string, bl, bl2, this.readTimeout);
    }

    protected String sendCommand(String string, boolean bl, long l) throws IOException {
        return this.sendCommand(string, bl, false, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sendCommand(String string, boolean bl, boolean bl2, long l) throws IOException {
        bl2 = false;
        this.checkInterrupted();
        this.inCommand = true;
        this.errorsLastUpdateTime = 0L;
        Object object = this;
        synchronized (object) {
            if (!bl2 || this.in != null) {
                this.ensureConnectionOpened();
                Message.debug("sending command '" + string + "' to " + this.getHost());
                this.updateLastCommandTime();
                this.out.println(string);
                this.out.flush();
            } else {
                this.sendSingleCommand(string);
            }
        }
        try {
            object = this.readResponse(bl, l);
            return object;
        }
        finally {
            this.inCommand = false;
            if (bl2) {
                this.closeConnection();
            }
        }
    }

    protected String readResponse(boolean bl) throws IOException {
        return this.readResponse(bl, this.readTimeout);
    }

    protected synchronized String readResponse(final boolean bl, long l) throws IOException {
        final StringBuffer stringBuffer = new StringBuffer();
        final IOException[] iOExceptionArray = new IOException[1];
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VsftpRepository vsftpRepository = VsftpRepository.this;
                synchronized (vsftpRepository) {
                    try {
                        boolean bl2 = false;
                        for (int i = 0; !bl2 && i < 5; ++i) {
                            int n;
                            while ((n = VsftpRepository.this.in.read()) != -1) {
                                i = 0;
                                stringBuffer.append((char)n);
                                if (stringBuffer.length() < VsftpRepository.PROMPT.length() || !stringBuffer.substring(stringBuffer.length() - VsftpRepository.PROMPT.length(), stringBuffer.length()).equals(VsftpRepository.PROMPT)) continue;
                                stringBuffer.setLength(stringBuffer.length() - VsftpRepository.PROMPT.length());
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            try {
                                Thread.sleep(50L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                        }
                        if (bl2) {
                            if (VsftpRepository.this.errorsLastUpdateTime == 0L) {
                                VsftpRepository.this.errorsLastUpdateTime = VsftpRepository.this.lastCommand;
                            }
                            while (System.currentTimeMillis() - VsftpRepository.this.errorsLastUpdateTime < 50L) {
                                try {
                                    Thread.sleep(30L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                    break;
                                }
                            }
                        }
                        if (VsftpRepository.this.errors.length() > 0) {
                            if (bl) {
                                stringBuffer.append(VsftpRepository.this.errors);
                                VsftpRepository.this.errors.setLength(0);
                            } else {
                                throw new IOException(VsftpRepository.chomp(VsftpRepository.this.errors).toString());
                            }
                        }
                        VsftpRepository.chomp(stringBuffer);
                        blArray[0] = true;
                    }
                    catch (IOException iOException) {
                        iOExceptionArray[0] = iOException;
                    }
                    finally {
                        VsftpRepository.this.notify();
                    }
                }
            }
        };
        IvyThread ivyThread = null;
        if (l == 0L) {
            runnable.run();
        } else {
            ivyThread = new IvyThread(runnable);
            ivyThread.start();
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.updateLastCommandTime();
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
        if (!blArray[0]) {
            if (ivyThread != null && ivyThread.isAlive()) {
                ivyThread.interrupt();
                for (int i = 0; i < 5 && ivyThread.isAlive(); ++i) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                if (ivyThread.isAlive()) {
                    ivyThread.stop();
                }
            }
            throw new IOException("connection timeout to " + this.getHost());
        }
        if ("Not connected.".equals(stringBuffer.toString())) {
            Message.info("vsftp connection to " + this.getHost() + " reset");
            this.closeConnection();
            throw new IOException("not connected to " + this.getHost());
        }
        Message.debug("received response '" + stringBuffer + "' from " + this.getHost());
        return stringBuffer.toString();
    }

    private synchronized void sendSingleCommand(String string) throws IOException {
        this.exec(this.getSingleCommand(string));
    }

    protected synchronized void ensureConnectionOpened() throws IOException {
        if (this.in == null) {
            Message.verbose("connecting to " + this.getUsername() + "@" + this.getHost() + "... ");
            String string = this.getConnectionCommand();
            this.exec(string);
            try {
                this.readResponse(false);
                if (this.reuseConnection > 0L) {
                    this.connectionCleaner = new IvyThread(){

                        @Override
                        public void run() {
                            this.initContext();
                            try {
                                long l = 10L;
                                while (VsftpRepository.this.in != null && l > 0L) {
                                    3.sleep(l);
                                    l = VsftpRepository.this.reuseConnection - (System.currentTimeMillis() - VsftpRepository.this.lastCommand);
                                    if (!VsftpRepository.this.inCommand) continue;
                                    l = l <= 0L ? VsftpRepository.this.reuseConnection : l;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            VsftpRepository.this.disconnect();
                        }
                    };
                    this.connectionCleaner.start();
                }
                if (this.ivy != null) {
                    this.ivy.getEventManager().addIvyListener(new IvyListener(){

                        @Override
                        public void progress(IvyEvent ivyEvent) {
                            VsftpRepository.this.disconnect();
                            ivyEvent.getSource().removeIvyListener(this);
                        }
                    }, "post-resolve");
                }
            }
            catch (IOException iOException) {
                this.closeConnection();
                throw new IOException("impossible to connect to " + this.getUsername() + "@" + this.getHost() + " using " + this.getAuthentication() + ": " + iOException.getMessage());
            }
            Message.verbose("connected to " + this.getHost());
        }
    }

    private void updateLastCommandTime() {
        this.lastCommand = System.currentTimeMillis();
    }

    private void exec(String string) throws IOException {
        Message.debug("launching '" + string + "'");
        this.process = Runtime.getRuntime().exec(string);
        this.in = new InputStreamReader(this.process.getInputStream());
        this.err = new InputStreamReader(this.process.getErrorStream());
        this.out = new PrintWriter(this.process.getOutputStream());
        this.errorsReader = new IvyThread(){

            @Override
            public void run() {
                this.initContext();
                try {
                    int n;
                    while (VsftpRepository.this.err != null && (n = VsftpRepository.this.err.read()) != -1) {
                        VsftpRepository.this.errors.append((char)n);
                        VsftpRepository.this.errorsLastUpdateTime = System.currentTimeMillis();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.errorsReader.start();
    }

    private void checkInterrupted() {
        if (this.ivy != null) {
            this.ivy.checkInterrupted();
        }
    }

    private void cleanup(Exception exception) {
        if (exception.getMessage().equals("connection timeout to " + this.getHost())) {
            this.closeConnection();
        } else {
            this.disconnect();
        }
    }

    private void cleanup() {
        if (this.reuseConnection == 0L) {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        if (this.in != null) {
            Message.verbose("disconnecting from " + this.getHost() + "... ");
            try {
                this.sendCommand("exit", false, 300L);
            }
            catch (IOException iOException) {
            }
            finally {
                this.closeConnection();
                Message.verbose("disconnected of " + this.getHost());
            }
        }
    }

    private synchronized void closeConnection() {
        if (this.connectionCleaner != null) {
            this.connectionCleaner.interrupt();
        }
        if (this.errorsReader != null) {
            this.errorsReader.interrupt();
        }
        try {
            this.process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.err.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connectionCleaner = null;
        this.errorsReader = null;
        this.process = null;
        this.in = null;
        this.out = null;
        this.err = null;
        Message.debug("connection to " + this.getHost() + " closed");
    }

    protected Resource lslToResource(String string, String string2) {
        if (string2 == null || string2.startsWith("ls")) {
            return new BasicResource(string, false, 0L, 0L, false);
        }
        String[] stringArray = string2.split("\\s+");
        if (stringArray.length != 9) {
            Message.debug("unrecognized ls format: " + string2);
            return new BasicResource(string, false, 0L, 0L, false);
        }
        try {
            long l = Long.parseLong(stringArray[3]);
            String string3 = stringArray[4] + " " + stringArray[5] + " " + stringArray[6] + " " + stringArray[7];
            return new BasicResource(string, true, l, FORMAT.parse(string3).getTime(), false);
        }
        catch (Exception exception) {
            Message.warn("impossible to parse server response: " + string2, exception);
            return new BasicResource(string, false, 0L, 0L, false);
        }
    }

    protected String getSingleCommand(String string) {
        return "vsh -noprompt -auth " + this.authentication + " " + this.username + "@" + this.host + " " + string;
    }

    protected String getConnectionCommand() {
        return "vsftp -noprompt -auth " + this.authentication + " " + this.username + "@" + this.host;
    }

    protected Pattern getExpectedDownloadMessage(String string, File file) {
        return Pattern.compile("Downloading " + file.getName() + " from [^\\s]+");
    }

    protected Pattern getExpectedRemoveMessage(String string) {
        return Pattern.compile("Removing [^\\s]+");
    }

    protected Pattern getExpectedUploadMessage(File file, String string) {
        return Pattern.compile("Uploading " + file.getName() + " to [^\\s]+");
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String string) {
        this.authentication = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    private static StringBuffer chomp(StringBuffer stringBuffer) {
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return stringBuffer;
        }
        while ("\n".equals(stringBuffer.substring(stringBuffer.length() - 1)) || "\r".equals(stringBuffer.substring(stringBuffer.length() - 1))) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.getUsername() + "@" + this.getHost() + " (" + this.getAuthentication() + ")";
    }

    public void setReuseConnection(long l) {
        this.reuseConnection = l;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long l) {
        this.readTimeout = l;
    }
}

