/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.HasLatestStrategy;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public class ChainResolver
extends AbstractResolver {
    private boolean returnFirst = false;
    private List chain = new ArrayList();
    private boolean dual;

    public void add(DependencyResolver dependencyResolver) {
        this.chain.add(dependencyResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        resolveData = new ResolveData(resolveData, this.doValidate(resolveData));
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        ResolvedModuleRevision resolvedModuleRevision = resolveData.getCurrentResolvedModuleRevision();
        ResolvedModuleRevision resolvedModuleRevision2 = resolvedModuleRevision;
        if (resolvedModuleRevision2 == null) {
            Message.verbose(this.getName() + ": Checking cache for: " + dependencyDescriptor);
            resolvedModuleRevision2 = this.findModuleInCache(dependencyDescriptor, resolveData, true);
            if (resolvedModuleRevision2 != null) {
                Message.verbose(this.getName() + ": module revision found in cache: " + resolvedModuleRevision2.getId());
                resolvedModuleRevision2 = this.forcedRevision(resolvedModuleRevision2);
            }
        }
        for (Object object : this.chain) {
            LatestStrategy object2 = this.setLatestIfRequired((DependencyResolver)object, this.getLatestStrategy());
            try {
                ResolvedModuleRevision resolvedModuleRevision3 = resolvedModuleRevision2;
                resolveData.setCurrentResolvedModuleRevision(resolvedModuleRevision3);
                resolvedModuleRevision2 = object.getDependency(dependencyDescriptor, resolveData);
                if (resolvedModuleRevision2 != resolvedModuleRevision3 && this.isReturnFirst()) {
                    resolvedModuleRevision2 = this.forcedRevision(resolvedModuleRevision2);
                }
            }
            catch (Exception exception) {
                Message.verbose("problem occurred while resolving " + dependencyDescriptor + " with " + object, exception);
                arrayList.add(exception);
            }
            finally {
                if (object2 != null) {
                    ChainResolver.setLatest((DependencyResolver)object, object2);
                }
            }
            this.checkInterrupted();
        }
        if (resolvedModuleRevision2 == null && !arrayList.isEmpty()) {
            Object object;
            if (arrayList.size() == 1) {
                object = (Exception)arrayList.get(0);
                if (object instanceof RuntimeException) {
                    throw (RuntimeException)object;
                }
                if (object instanceof ParseException) {
                    throw (ParseException)object;
                }
                throw new RuntimeException(((Throwable)object).toString(), (Throwable)object);
            }
            object = new StringBuffer();
            for (Exception exception : arrayList) {
                ((StringBuffer)object).append("\t").append(StringUtils.getErrorMessage(exception)).append("\n");
            }
            ((StringBuffer)object).setLength(((StringBuffer)object).length() - 1);
            throw new RuntimeException("several problems occurred while resolving " + dependencyDescriptor + ":\n" + object);
        }
        if (resolvedModuleRevision == resolvedModuleRevision2) {
            return resolvedModuleRevision;
        }
        return this.resolvedRevision(resolvedModuleRevision2);
    }

    private ResolvedModuleRevision resolvedRevision(ResolvedModuleRevision resolvedModuleRevision) {
        if (this.isDual() && resolvedModuleRevision != null) {
            return new ResolvedModuleRevision(resolvedModuleRevision.getResolver(), this, resolvedModuleRevision.getDescriptor(), resolvedModuleRevision.getReport(), resolvedModuleRevision.isForce());
        }
        return resolvedModuleRevision;
    }

    private ResolvedModuleRevision forcedRevision(ResolvedModuleRevision resolvedModuleRevision) {
        if (resolvedModuleRevision == null) {
            return null;
        }
        return new ResolvedModuleRevision(resolvedModuleRevision.getResolver(), resolvedModuleRevision.getArtifactResolver(), resolvedModuleRevision.getDescriptor(), resolvedModuleRevision.getReport(), true);
    }

    private LatestStrategy setLatestIfRequired(DependencyResolver dependencyResolver, LatestStrategy latestStrategy) {
        String string = ChainResolver.getLatestStrategyName(dependencyResolver);
        if (string != null && !"default".equals(string)) {
            LatestStrategy latestStrategy2 = ChainResolver.getLatest(dependencyResolver);
            ChainResolver.setLatest(dependencyResolver, latestStrategy);
            return latestStrategy2;
        }
        return null;
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        for (DependencyResolver dependencyResolver : this.chain) {
            ResolvedResource resolvedResource = dependencyResolver.findIvyFileRef(dependencyDescriptor, resolveData);
            if (resolvedResource == null) continue;
            return resolvedResource;
        }
        return null;
    }

    @Override
    public Map[] listTokenValues(String[] stringArray, Map map) {
        HashSet<Map> hashSet = new HashSet<Map>();
        for (DependencyResolver dependencyResolver : this.chain) {
            Map[] mapArray = dependencyResolver.listTokenValues(stringArray, new HashMap(map));
            hashSet.addAll(Arrays.asList(mapArray));
        }
        return hashSet.toArray(new Map[hashSet.size()]);
    }

    @Override
    public void reportFailure() {
        for (DependencyResolver dependencyResolver : this.chain) {
            dependencyResolver.reportFailure();
        }
    }

    @Override
    public void reportFailure(Artifact artifact) {
        for (DependencyResolver dependencyResolver : this.chain) {
            dependencyResolver.reportFailure(artifact);
        }
    }

    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        Object object;
        ArrayList<Artifact> arrayList = new ArrayList<Artifact>(Arrays.asList(artifactArray));
        DownloadReport downloadReport = new DownloadReport();
        Iterator iterator = this.chain.iterator();
        while (iterator.hasNext() && !arrayList.isEmpty()) {
            DependencyResolver object2 = (DependencyResolver)iterator.next();
            object = object2.download(arrayList.toArray(new Artifact[arrayList.size()]), downloadOptions);
            ArtifactDownloadReport[] artifactDownloadReportArray = ((DownloadReport)object).getArtifactsReports();
            for (int i = 0; i < artifactDownloadReportArray.length; ++i) {
                if (artifactDownloadReportArray[i].getDownloadStatus() == DownloadStatus.FAILED) continue;
                arrayList.remove(artifactDownloadReportArray[i].getArtifact());
                downloadReport.addArtifactReport(artifactDownloadReportArray[i]);
            }
        }
        for (Artifact artifact : arrayList) {
            object = new ArtifactDownloadReport(artifact);
            ((ArtifactDownloadReport)object).setDownloadStatus(DownloadStatus.FAILED);
            downloadReport.addArtifactReport((ArtifactDownloadReport)object);
        }
        return downloadReport;
    }

    public List getResolvers() {
        return this.chain;
    }

    @Override
    public void publish(Artifact artifact, File file, boolean bl) throws IOException {
        this.getFirstResolver().publish(artifact, file, bl);
    }

    @Override
    public void abortPublishTransaction() throws IOException {
        this.getFirstResolver().abortPublishTransaction();
    }

    @Override
    public void beginPublishTransaction(ModuleRevisionId moduleRevisionId, boolean bl) throws IOException {
        this.getFirstResolver().beginPublishTransaction(moduleRevisionId, bl);
    }

    @Override
    public void commitPublishTransaction() throws IOException {
        this.getFirstResolver().commitPublishTransaction();
    }

    private DependencyResolver getFirstResolver() {
        if (this.chain.isEmpty()) {
            throw new IllegalStateException("invalid chain resolver with no sub resolver");
        }
        return (DependencyResolver)this.chain.get(0);
    }

    public boolean isReturnFirst() {
        return this.returnFirst;
    }

    public void setReturnFirst(boolean bl) {
        this.returnFirst = bl;
    }

    @Override
    public void dumpSettings() {
        Message.verbose("\t" + this.getName() + " [chain] " + this.chain);
        Message.debug("\t\treturn first: " + this.isReturnFirst());
        Message.debug("\t\tdual: " + this.isDual());
        for (DependencyResolver dependencyResolver : this.chain) {
            Message.debug("\t\t-> " + dependencyResolver.getName());
        }
    }

    @Override
    public boolean exists(Artifact artifact) {
        for (DependencyResolver dependencyResolver : this.chain) {
            if (!dependencyResolver.exists(artifact)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        for (DependencyResolver dependencyResolver : this.chain) {
            ArtifactOrigin artifactOrigin = dependencyResolver.locate(artifact);
            if (ArtifactOrigin.isUnknown(artifactOrigin)) continue;
            return artifactOrigin;
        }
        return ArtifactOrigin.unkwnown(artifact);
    }

    @Override
    public ArtifactDownloadReport download(ArtifactOrigin artifactOrigin, DownloadOptions downloadOptions) {
        for (DependencyResolver dependencyResolver : this.chain) {
            ArtifactDownloadReport artifactDownloadReport = dependencyResolver.download(artifactOrigin, downloadOptions);
            if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) continue;
            return artifactDownloadReport;
        }
        ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(artifactOrigin.getArtifact());
        artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
        return artifactDownloadReport;
    }

    private static void setLatest(DependencyResolver dependencyResolver, LatestStrategy latestStrategy) {
        if (dependencyResolver instanceof HasLatestStrategy) {
            HasLatestStrategy hasLatestStrategy = (HasLatestStrategy)((Object)dependencyResolver);
            hasLatestStrategy.setLatestStrategy(latestStrategy);
        }
    }

    private static LatestStrategy getLatest(DependencyResolver dependencyResolver) {
        if (dependencyResolver instanceof HasLatestStrategy) {
            HasLatestStrategy hasLatestStrategy = (HasLatestStrategy)((Object)dependencyResolver);
            return hasLatestStrategy.getLatestStrategy();
        }
        return null;
    }

    private static String getLatestStrategyName(DependencyResolver dependencyResolver) {
        if (dependencyResolver instanceof HasLatestStrategy) {
            HasLatestStrategy hasLatestStrategy = (HasLatestStrategy)((Object)dependencyResolver);
            return hasLatestStrategy.getLatest();
        }
        return null;
    }

    public void setDual(boolean bl) {
        this.dual = bl;
    }

    public boolean isDual() {
        return this.dual;
    }

    public static class ResolvedModuleRevisionArtifactInfo
    implements ArtifactInfo {
        private ResolvedModuleRevision rmr;

        public ResolvedModuleRevisionArtifactInfo(ResolvedModuleRevision resolvedModuleRevision) {
            this.rmr = resolvedModuleRevision;
        }

        @Override
        public String getRevision() {
            return this.rmr.getId().getRevision();
        }

        @Override
        public long getLastModified() {
            return this.rmr.getPublicationDate().getTime();
        }
    }
}

