/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivy.util.MessageLoggerHelper;

public class MessageLoggerEngine
implements MessageLogger {
    private final ThreadLocal loggerStacks = new ThreadLocal();
    private MessageLogger defaultLogger = null;
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();

    private Stack getLoggerStack() {
        Stack stack = (Stack)this.loggerStacks.get();
        if (stack == null) {
            stack = new Stack();
            this.loggerStacks.set(stack);
        }
        return stack;
    }

    public void setDefaultLogger(MessageLogger messageLogger) {
        this.defaultLogger = messageLogger;
    }

    public void pushLogger(MessageLogger messageLogger) {
        Checks.checkNotNull(messageLogger, "logger");
        this.getLoggerStack().push(messageLogger);
    }

    public void popLogger() {
        if (!this.getLoggerStack().isEmpty()) {
            this.getLoggerStack().pop();
        }
    }

    public MessageLogger peekLogger() {
        if (this.getLoggerStack().isEmpty()) {
            return this.getDefaultLogger();
        }
        return (MessageLogger)this.getLoggerStack().peek();
    }

    private MessageLogger getDefaultLogger() {
        return this.defaultLogger == null ? Message.getDefaultLogger() : this.defaultLogger;
    }

    @Override
    public void warn(String string) {
        this.peekLogger().warn(string);
        this.problems.add("WARN:  " + string);
        this.warns.add(string);
    }

    @Override
    public void error(String string) {
        this.peekLogger().error(string);
        this.problems.add("\tERROR: " + string);
        this.errors.add(string);
    }

    public List getErrors() {
        return this.errors;
    }

    public List getProblems() {
        return this.problems;
    }

    public List getWarns() {
        return this.warns;
    }

    @Override
    public void sumupProblems() {
        MessageLoggerHelper.sumupProblems(this);
        this.clearProblems();
    }

    @Override
    public void clearProblems() {
        this.getDefaultLogger().clearProblems();
        for (MessageLogger messageLogger : this.getLoggerStack()) {
            messageLogger.clearProblems();
        }
        this.problems.clear();
        this.errors.clear();
        this.warns.clear();
    }

    @Override
    public void setShowProgress(boolean bl) {
        this.getDefaultLogger().setShowProgress(bl);
        for (MessageLogger messageLogger : this.getLoggerStack()) {
            messageLogger.setShowProgress(bl);
        }
    }

    @Override
    public boolean isShowProgress() {
        return this.getDefaultLogger().isShowProgress();
    }

    @Override
    public void debug(String string) {
        this.peekLogger().debug(string);
    }

    @Override
    public void deprecated(String string) {
        this.peekLogger().deprecated(string);
    }

    @Override
    public void endProgress() {
        this.peekLogger().endProgress();
    }

    @Override
    public void endProgress(String string) {
        this.peekLogger().endProgress(string);
    }

    @Override
    public void info(String string) {
        this.peekLogger().info(string);
    }

    @Override
    public void rawinfo(String string) {
        this.peekLogger().rawinfo(string);
    }

    @Override
    public void log(String string, int n) {
        this.peekLogger().log(string, n);
    }

    @Override
    public void progress() {
        this.peekLogger().progress();
    }

    @Override
    public void rawlog(String string, int n) {
        this.peekLogger().rawlog(string, n);
    }

    @Override
    public void verbose(String string) {
        this.peekLogger().verbose(string);
    }
}

