/*
 * Decompiled with CFR 0.152.
 */
package play.i18n;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import play.Play;
import play.i18n.Lang;
import play.i18n.MessagesApi;
import play.mvc.Http;
import scala.collection.JavaConverters;
import scala.collection.mutable.Buffer;

public class Messages {
    private final Lang lang;
    private final MessagesApi messages;

    private static Lang getLang() {
        Lang lang = null;
        if (Http.Context.current.get() != null) {
            lang = Http.Context.current().lang();
        } else {
            Locale locale = Locale.getDefault();
            lang = new Lang(new play.api.i18n.Lang(locale.getLanguage(), locale.getCountry()));
        }
        return lang;
    }

    private static MessagesApi getMessagesApi() {
        return Play.application().injector().instanceOf(MessagesApi.class);
    }

    private static Buffer<Object> convertArgsToScalaBuffer(Object ... objectArray) {
        return (Buffer)JavaConverters.asScalaBufferConverter(Messages.wrapArgsToListIfNeeded(objectArray)).asScala();
    }

    static <T> List<T> wrapArgsToListIfNeeded(T ... TArray) {
        List list = null;
        list = ArrayUtils.isNotEmpty((Object[])TArray) && TArray.length == 1 && TArray[0] instanceof List ? (List)TArray[0] : Arrays.asList(TArray);
        return list;
    }

    public static String get(Lang lang, String string, Object ... objectArray) {
        return Messages.getMessagesApi().get((play.api.i18n.Lang)lang, string, objectArray);
    }

    public static String get(Lang lang, List<String> list, Object ... objectArray) {
        return Messages.getMessagesApi().get((play.api.i18n.Lang)lang, list, objectArray);
    }

    public static String get(String string, Object ... objectArray) {
        return Messages.getMessagesApi().get((play.api.i18n.Lang)Messages.getLang(), string, objectArray);
    }

    public static String get(List<String> list, Object ... objectArray) {
        return Messages.getMessagesApi().get((play.api.i18n.Lang)Messages.getLang(), list, objectArray);
    }

    public static Boolean isDefined(Lang lang, String string) {
        return Messages.getMessagesApi().isDefinedAt(lang, string);
    }

    public static Boolean isDefined(String string) {
        return Messages.getMessagesApi().isDefinedAt(Messages.getLang(), string);
    }

    public Messages(Lang lang, MessagesApi messagesApi) {
        this.lang = lang;
        this.messages = messagesApi;
    }

    public Lang lang() {
        return this.lang;
    }

    public MessagesApi messagesApi() {
        return this.messages;
    }

    public String at(String string, Object ... objectArray) {
        return this.messages.get((play.api.i18n.Lang)this.lang, string, objectArray);
    }

    public String at(List<String> list, Object ... objectArray) {
        return this.messages.get((play.api.i18n.Lang)this.lang, list, objectArray);
    }

    public Boolean isDefinedAt(String string) {
        return this.messages.isDefinedAt(this.lang, string);
    }
}

