/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Inject;
import play.inject.Injector;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.With;
import play.twirl.api.Content;
import views.html.defaultpages.unauthorized;

public class Security {

    public static class Authenticator
    extends Results {
        public String getUsername(Http.Context context) {
            return (String)context.session().get("username");
        }

        public Result onUnauthorized(Http.Context context) {
            return Authenticator.unauthorized((Content)unauthorized.render());
        }
    }

    public static class AuthenticatedAction
    extends Action<Authenticated> {
        private Injector injector;

        public AuthenticatedAction() {
        }

        @Inject
        public AuthenticatedAction(Injector injector) {
            this.injector = injector;
        }

        @Override
        public F.Promise<Result> call(final Http.Context context) {
            try {
                Authenticator authenticator = this.injector == null ? ((Authenticated)this.configuration).value().newInstance() : this.injector.instanceOf(((Authenticated)this.configuration).value());
                String string = authenticator.getUsername(context);
                if (string == null) {
                    Result result = authenticator.onUnauthorized(context);
                    return F.Promise.pure(result);
                }
                try {
                    context.request().setUsername(string);
                    return this.delegate.call(context).transform(new F.Function<Result, Result>(){

                        @Override
                        public Result apply(Result result) throws Throwable {
                            context.request().setUsername(null);
                            return result;
                        }
                    }, throwable -> {
                        context.request().setUsername(null);
                        return throwable;
                    });
                }
                catch (Exception exception) {
                    context.request().setUsername(null);
                    throw exception;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable2) {
                throw new RuntimeException(throwable2);
            }
        }
    }

    @With(value={AuthenticatedAction.class})
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Authenticated {
        public Class<? extends Authenticator> value() default Authenticator.class;
    }
}

