/*
 * Decompiled with CFR 0.152.
 */
package play.core.netty.utils;

import play.core.netty.utils.Cookie;
import play.core.netty.utils.CookieUtil;

public class DefaultCookie
implements Cookie {
    private final String name;
    private String value;
    private boolean wrap;
    private String domain;
    private String path;
    private int maxAge = Integer.MIN_VALUE;
    private boolean secure;
    private boolean httpOnly;

    public DefaultCookie(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        this.name = string;
        this.setValue(string2);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public void setValue(String string) {
        if (string == null) {
            throw new NullPointerException("value");
        }
        this.value = string;
    }

    @Override
    public boolean wrap() {
        return this.wrap;
    }

    @Override
    public void setWrap(boolean bl) {
        this.wrap = bl;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public void setDomain(String string) {
        this.domain = CookieUtil.validateAttributeValue("domain", string);
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public void setPath(String string) {
        this.path = CookieUtil.validateAttributeValue("path", string);
    }

    @Override
    public int maxAge() {
        return this.maxAge;
    }

    @Override
    public void setMaxAge(int n) {
        this.maxAge = n;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public void setHttpOnly(boolean bl) {
        this.httpOnly = bl;
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)object;
        if (!this.name().equalsIgnoreCase(cookie.name())) {
            return false;
        }
        if (this.path() == null) {
            if (cookie.path() != null) {
                return false;
            }
        } else {
            if (cookie.path() == null) {
                return false;
            }
            if (!this.path().equals(cookie.path())) {
                return false;
            }
        }
        if (this.domain() == null) {
            return cookie.domain() == null;
        }
        if (cookie.domain() == null) {
            return false;
        }
        return this.domain().equalsIgnoreCase(cookie.domain());
    }

    @Override
    public int compareTo(Cookie cookie) {
        int n = this.name().compareToIgnoreCase(cookie.name());
        if (n != 0) {
            return n;
        }
        if (this.path() == null) {
            if (cookie.path() != null) {
                return -1;
            }
        } else {
            if (cookie.path() == null) {
                return 1;
            }
            n = this.path().compareTo(cookie.path());
            if (n != 0) {
                return n;
            }
        }
        if (this.domain() == null) {
            if (cookie.domain() != null) {
                return -1;
            }
        } else {
            if (cookie.domain() == null) {
                return 1;
            }
            n = this.domain().compareToIgnoreCase(cookie.domain());
            return n;
        }
        return 0;
    }

    @Deprecated
    protected String validateValue(String string, String string2) {
        return CookieUtil.validateAttributeValue(string, string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.name()).append('=').append(this.value());
        if (this.domain() != null) {
            stringBuilder.append(", domain=").append(this.domain());
        }
        if (this.path() != null) {
            stringBuilder.append(", path=").append(this.path());
        }
        if (this.maxAge() >= 0) {
            stringBuilder.append(", maxAge=").append(this.maxAge()).append('s');
        }
        if (this.isSecure()) {
            stringBuilder.append(", secure");
        }
        if (this.isHttpOnly()) {
            stringBuilder.append(", HTTPOnly");
        }
        return stringBuilder.toString();
    }
}

