/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.common;

import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString$;
import play.api.Logger;
import play.api.Logger$;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.HeaderNames$;
import play.api.http.HttpEntity;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpProtocol$;
import play.api.http.Status$;
import play.api.libs.iteratee.Execution;
import play.api.mvc.Cookie;
import play.api.mvc.Cookies$;
import play.api.mvc.DiscardingCookie;
import play.api.mvc.Flash;
import play.api.mvc.Flash$;
import play.api.mvc.RequestHeader;
import play.api.mvc.ResponseHeader;
import play.api.mvc.Result;
import play.core.server.common.ServerResultException;
import play.core.server.common.ServerResultUtils;
import play.core.server.common.ServerResultUtils$DefaultClose$;
import play.core.server.common.ServerResultUtils$DefaultKeepAlive$;
import play.core.server.common.ServerResultUtils$SendClose$;
import play.core.server.common.ServerResultUtils$SendKeepAlive$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class ServerResultUtils$ {
    public static final ServerResultUtils$ MODULE$;
    private final Logger logger;
    private final String play$core$server$common$ServerResultUtils$$KEEP_ALIVE;
    private final String play$core$server$common$ServerResultUtils$$CLOSE;

    static {
        new ServerResultUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    public ServerResultUtils.ConnectionHeader determineConnectionHeader(RequestHeader request, Result result) {
        String string = request.version();
        String string2 = HttpProtocol$.MODULE$.HTTP_1_1();
        return !(string != null ? !string.equals(string2) : string2 != null) ? (result.header().headers().get((Object)HeaderNames$.MODULE$.CONNECTION()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.equalsIgnoreCase(ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$CLOSE());
            }
        }) ? ServerResultUtils$DefaultClose$.MODULE$ : (result.body() instanceof HttpEntity.Streamed && result.body().contentLength().isEmpty() || request.headers().get(HeaderNames$.MODULE$.CONNECTION()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.equalsIgnoreCase(ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$CLOSE());
            }
        }) ? ServerResultUtils$SendClose$.MODULE$ : ServerResultUtils$DefaultKeepAlive$.MODULE$)) : (result.header().headers().get((Object)HeaderNames$.MODULE$.CONNECTION()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.equalsIgnoreCase(ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$CLOSE());
            }
        }) ? ServerResultUtils$DefaultClose$.MODULE$ : (result.body() instanceof HttpEntity.Streamed && result.body().contentLength().isEmpty() || request.headers().get(HeaderNames$.MODULE$.CONNECTION()).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return !x$4.equalsIgnoreCase(ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$KEEP_ALIVE());
            }
        }) ? ServerResultUtils$DefaultClose$.MODULE$ : ServerResultUtils$SendKeepAlive$.MODULE$));
    }

    public Future<Result> validateResult(RequestHeader request, Result result, HttpErrorHandler httpErrorHandler, Materializer mat) {
        Future future;
        String string = request.version();
        String string2 = HttpProtocol$.MODULE$.HTTP_1_0();
        if (!(string != null ? !string.equals(string2) : string2 != null) && result.body() instanceof HttpEntity.Chunked) {
            this.cancelEntity(result.body(), mat);
            ServerResultException exception = new ServerResultException("HTTP 1.0 client does not support chunked response", result, null);
            Future errorResult = httpErrorHandler.onServerError(request, (Throwable)exception);
            future = errorResult.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Result apply(Result originalErrorResult) {
                    ResponseHeader newHeader = originalErrorResult.header().copy(Status$.MODULE$.HTTP_VERSION_NOT_SUPPORTED(), originalErrorResult.header().headers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONNECTION()), (Object)ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$CLOSE())), originalErrorResult.header().copy$default$3());
                    return originalErrorResult.copy(newHeader, originalErrorResult.copy$default$2());
                }
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        } else if (this.mayHaveEntity(result.header().status()) || result.body().isKnownEmpty()) {
            future = Future$.MODULE$.successful((Object)result);
        } else {
            this.cancelEntity(result.body(), mat);
            HttpEntity.Strict x$6 = new HttpEntity.Strict(ByteString$.MODULE$.empty(), result.body().contentType());
            ResponseHeader x$7 = result.copy$default$1();
            future = Future$.MODULE$.successful((Object)result.copy(x$7, (HttpEntity)x$6));
        }
        return future;
    }

    public <R> Future<R> resultConversionWithErrorHandling(RequestHeader requestHeader, Result result, HttpErrorHandler errorHandler, Function1<Result, Future<R>> resultConverter, Function0<R> fallbackResponse) {
        Future future;
        try {
            future = ((Future)resultConverter.apply((Object)result)).recoverWith((PartialFunction)new Serializable(requestHeader, result, errorHandler, resultConverter, fallbackResponse){
                public static final long serialVersionUID = 0L;
                private final RequestHeader requestHeader$1;
                private final Result result$1;
                private final HttpErrorHandler errorHandler$1;
                private final Function1 resultConverter$1;
                private final Function0 fallbackResponse$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Future future = ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$handleConversionError$1(A1, this.requestHeader$1, this.result$1, this.errorHandler$1, this.resultConverter$1, this.fallbackResponse$1);
                    return (B1)future;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    this.requestHeader$1 = requestHeader$1;
                    this.result$1 = result$1;
                    this.errorHandler$1 = errorHandler$1;
                    this.resultConverter$1 = resultConverter$1;
                    this.fallbackResponse$1 = fallbackResponse$1;
                }
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }
        catch (Throwable throwable) {
            Future future2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            future = future2 = this.play$core$server$common$ServerResultUtils$$handleConversionError$1(e, requestHeader, result, errorHandler, resultConverter, fallbackResponse);
        }
        return future;
    }

    public boolean mayHaveEntity(int status) {
        int n = status;
        boolean bl = Status$.MODULE$.CONTINUE() == n ? true : (Status$.MODULE$.SWITCHING_PROTOCOLS() == n ? true : (Status$.MODULE$.NO_CONTENT() == n ? true : Status$.MODULE$.NOT_MODIFIED() == n));
        boolean bl2 = !bl;
        return bl2;
    }

    public Object cancelEntity(HttpEntity entity, Materializer mat) {
        Object object;
        HttpEntity httpEntity = entity;
        if (httpEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked chunked = (HttpEntity.Chunked)httpEntity;
            Source chunks = chunked.chunks();
            object = chunks.runWith((Graph)Sink$.MODULE$.cancelled(), mat);
        } else if (httpEntity instanceof HttpEntity.Streamed) {
            HttpEntity.Streamed streamed = (HttpEntity.Streamed)httpEntity;
            Source data = streamed.data();
            object = data.runWith((Graph)Sink$.MODULE$.cancelled(), mat);
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public String play$core$server$common$ServerResultUtils$$KEEP_ALIVE() {
        return this.play$core$server$common$ServerResultUtils$$KEEP_ALIVE;
    }

    public String play$core$server$common$ServerResultUtils$$CLOSE() {
        return this.play$core$server$common$ServerResultUtils$$CLOSE;
    }

    public Result cleanFlashCookie(RequestHeader requestHeader, Result result) {
        Flash requestFlash;
        Option optResultFlashCookies = result.header().headers().get((Object)HeaderNames$.MODULE$.SET_COOKIE()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Cookie> apply(String setCookieValue) {
                return Cookies$.MODULE$.decodeSetCookieHeader(setCookieValue).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Cookie x$5) {
                        String string = x$5.name();
                        String string2 = Flash$.MODULE$.COOKIE_NAME();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                });
            }
        });
        return optResultFlashCookies.isDefined() ? result : ((requestFlash = requestHeader.flash()).isEmpty() ? result : result.discardingCookies((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DiscardingCookie[]{Flash$.MODULE$.discard()})));
    }

    public Iterable<Tuple2<String, String>> splitSetCookieHeaders(Map<String, String> headers) {
        return headers.contains((Object)HeaderNames$.MODULE$.SET_COOKIE()) ? (Iterable)((TraversableLike)headers.to(Predef$.MODULE$.fallbackStringCanBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SeqLike<Tuple2<String, String>, Object> apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2;
                block4: {
                    SeqLike seqLike;
                    block3: {
                        block2: {
                            tuple2 = x0$2;
                            if (tuple2 == null) break block2;
                            String string = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            String string2 = HeaderNames$.MODULE$.SET_COOKIE();
                            String string3 = string;
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                            String[] cookieParts = Cookies$.MODULE$.SetCookieHeaderSeparatorRegex().split((CharSequence)value);
                            seqLike = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cookieParts).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, String> apply(String cookiePart) {
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.SET_COOKIE()), (Object)cookiePart);
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        String name = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        seqLike = (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)name, (Object)value)}));
                    }
                    return seqLike;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()) : headers;
    }

    public final Future play$core$server$common$ServerResultUtils$$handleConversionError$1(Throwable conversionError, RequestHeader requestHeader$1, Result result$1, HttpErrorHandler errorHandler$1, Function1 resultConverter$1, Function0 fallbackResponse$1) {
        Future future;
        try {
            if (this.logger().isErrorEnabled()) {
                String prettyHeaders = ((TraversableOnce)result$1.header().headers().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<", ">: <", ">"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value}));
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception occurred while converting Result with headers ", ". Calling HttpErrorHandler to get alternative Result."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prettyHeaders}));
                this.logger().error((Function0)new Serializable(msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$1;

                    public final String apply() {
                        return this.msg$1;
                    }
                    {
                        this.msg$1 = msg$1;
                    }
                }, (Function0)new Serializable(conversionError){
                    public static final long serialVersionUID = 0L;
                    private final Throwable conversionError$1;

                    public final Throwable apply() {
                        return this.conversionError$1;
                    }
                    {
                        this.conversionError$1 = conversionError$1;
                    }
                });
            }
            future = errorHandler$1.onServerError(requestHeader$1, (Throwable)new ServerResultException("Error converting Play Result for server backend", result$1, conversionError)).flatMap((Function1)new Serializable(requestHeader$1, resultConverter$1, fallbackResponse$1){
                public static final long serialVersionUID = 0L;
                private final RequestHeader requestHeader$1;
                private final Function1 resultConverter$1;
                private final Function0 fallbackResponse$1;

                public final Future<R> apply(Result errorResult) {
                    return ServerResultUtils$.MODULE$.resultConversionWithErrorHandling(this.requestHeader$1, errorResult, (HttpErrorHandler)DefaultHttpErrorHandler$.MODULE$, this.resultConverter$1, this.fallbackResponse$1);
                }
                {
                    this.requestHeader$1 = requestHeader$1;
                    this.resultConverter$1 = resultConverter$1;
                    this.fallbackResponse$1 = fallbackResponse$1;
                }
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }
        catch (Throwable throwable) {
            Future future2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable onErrorError = (Throwable)option.get();
            this.logger().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error occurred during error handling. Original error: ";
                }
            }, (Function0)new Serializable(conversionError){
                public static final long serialVersionUID = 0L;
                private final Throwable conversionError$1;

                public final Throwable apply() {
                    return this.conversionError$1;
                }
                {
                    this.conversionError$1 = conversionError$1;
                }
            });
            this.logger().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error occurred during error handling. Error handling error: ";
                }
            }, (Function0)new Serializable(onErrorError){
                public static final long serialVersionUID = 0L;
                private final Throwable onErrorError$1;

                public final Throwable apply() {
                    return this.onErrorError$1;
                }
                {
                    this.onErrorError$1 = onErrorError$1;
                }
            });
            future = future2 = Future$.MODULE$.successful(fallbackResponse$1.apply());
        }
        return future;
    }

    private ServerResultUtils$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.play$core$server$common$ServerResultUtils$$KEEP_ALIVE = "keep-alive";
        this.play$core$server$common$ServerResultUtils$$CLOSE = "close";
    }
}

