/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import com.novocode.junit.AbstractEvent;
import com.novocode.junit.OutputCapture;
import com.novocode.junit.RichLogger;
import com.novocode.junit.TestAssumptionFailedEvent;
import com.novocode.junit.TestFailedEvent;
import com.novocode.junit.TestFinishedEvent;
import com.novocode.junit.TestIgnoredEvent;
import java.io.IOException;
import java.util.HashSet;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatools.testing.Event;
import org.scalatools.testing.EventHandler;

final class EventDispatcher
extends RunListener {
    private final RichLogger logger;
    private final HashSet<String> reported = new HashSet();
    private final EventHandler handler;
    private final boolean quiet;
    private final boolean verbose;
    private OutputCapture capture;

    EventDispatcher(RichLogger richLogger, EventHandler eventHandler, boolean bl, boolean bl2) {
        this.logger = richLogger;
        this.handler = eventHandler;
        this.quiet = bl;
        this.verbose = bl2;
    }

    public void testAssumptionFailure(Failure failure) {
        this.uncapture(true);
        this.postIfFirst(new TestAssumptionFailedEvent(failure));
    }

    public void testFailure(Failure failure) {
        this.uncapture(true);
        this.postIfFirst(new TestFailedEvent(failure));
    }

    public void testFinished(Description description) {
        this.uncapture(false);
        this.postIfFirst(new TestFinishedEvent(description));
    }

    public void testIgnored(Description description) {
        this.postIfFirst(new TestIgnoredEvent(description));
    }

    public void testStarted(Description description) {
        this.debugOrInfo("Test " + AbstractEvent.buildName(description) + " started");
        this.capture();
    }

    public void testRunFinished(Result result) {
        this.debugOrInfo("Test run finished: " + result.getFailureCount() + " failed, " + result.getIgnoreCount() + " ignored, " + result.getRunCount() + " total, " + (double)result.getRunTime() / 1000.0 + "s");
    }

    public void testRunStarted(Description description) {
        this.debugOrInfo("Test run started");
    }

    private void postIfFirst(AbstractEvent abstractEvent) {
        abstractEvent.logTo(this.logger);
        if (this.reported.add(abstractEvent.testName())) {
            this.handler.handle((Event)abstractEvent);
        }
    }

    void post(AbstractEvent abstractEvent) {
        abstractEvent.logTo(this.logger);
        this.handler.handle((Event)abstractEvent);
    }

    private void capture() {
        if (this.quiet && this.capture == null) {
            this.capture = OutputCapture.start();
        }
    }

    void uncapture(boolean bl) {
        if (this.quiet && this.capture != null) {
            this.capture.stop();
            if (bl) {
                try {
                    this.capture.replay();
                }
                catch (IOException iOException) {
                    this.logger.error("Error replaying captured stdio", iOException);
                }
            }
            this.capture = null;
        }
    }

    private void debugOrInfo(String string) {
        if (this.verbose) {
            this.logger.info(string);
        } else {
            this.logger.debug(string);
        }
    }
}

