/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ning;

import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.ws.ning.NingAsyncHttpClientConfigBuilder;
import play.api.libs.ws.ning.NingWSClientConfig;
import play.inject.ApplicationLifecycle;
import play.libs.F;
import play.libs.ws.WSAPI;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import play.libs.ws.ning.NingWSClient;

@Singleton
public class NingWSAPI
implements WSAPI {
    private final NingWSClient client;

    @Inject
    public NingWSAPI(NingWSClientConfig ningWSClientConfig, ApplicationLifecycle applicationLifecycle) {
        this.client = new NingWSClient(new NingAsyncHttpClientConfigBuilder(ningWSClientConfig).build());
        applicationLifecycle.addStopHook(() -> {
            this.client.close();
            return F.Promise.pure(null);
        });
    }

    @Override
    public WSClient client() {
        return this.client;
    }

    @Override
    public WSRequest url(String string) {
        return this.client().url(string);
    }
}

