/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ning;

import com.fasterxml.jackson.databind.JsonNode;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import play.libs.Json;
import play.libs.XML;
import play.libs.ws.WSCookie;
import play.libs.ws.WSResponse;
import play.libs.ws.ning.NingWSCookie;

public class NingWSResponse
implements WSResponse {
    private Response ahcResponse;

    public NingWSResponse(Response response) {
        this.ahcResponse = response;
    }

    @Override
    public Object getUnderlying() {
        return this.ahcResponse;
    }

    @Override
    public int getStatus() {
        return this.ahcResponse.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.ahcResponse.getStatusText();
    }

    @Override
    public Map<String, List<String>> getAllHeaders() {
        return this.ahcResponse.getHeaders();
    }

    @Override
    public String getHeader(String string) {
        return this.ahcResponse.getHeader(string);
    }

    @Override
    public List<WSCookie> getCookies() {
        ArrayList<WSCookie> arrayList = new ArrayList<WSCookie>();
        for (Cookie cookie : this.ahcResponse.getCookies()) {
            arrayList.add(new NingWSCookie(cookie));
        }
        return arrayList;
    }

    @Override
    public WSCookie getCookie(String string) {
        for (Cookie cookie : this.ahcResponse.getCookies()) {
            if (!cookie.getName().equals(string)) continue;
            return new NingWSCookie(cookie);
        }
        return null;
    }

    @Override
    public String getBody() {
        try {
            String string;
            String string2 = this.ahcResponse.getContentType();
            if (string2 == null) {
                string2 = "application/octet-stream";
            }
            if ((string = AsyncHttpProviderUtils.parseCharset((String)string2)) != null) {
                return this.ahcResponse.getResponseBody(string);
            }
            if (string2.startsWith("text/")) {
                return this.ahcResponse.getResponseBody(AsyncHttpProviderUtils.DEFAULT_CHARSET.toString());
            }
            return this.ahcResponse.getResponseBody("utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public Document asXml() {
        try {
            return XML.fromInputStream((InputStream)this.ahcResponse.getResponseBodyAsStream(), (String)"utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public JsonNode asJson() {
        try {
            return Json.parse((InputStream)this.ahcResponse.getResponseBodyAsStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public InputStream getBodyAsStream() {
        try {
            return this.ahcResponse.getResponseBodyAsStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public byte[] asByteArray() {
        try {
            return this.ahcResponse.getResponseBodyAsBytes();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public URI getUri() {
        try {
            return this.ahcResponse.getUri().toJavaNetURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

