/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import java.io.File;
import java.io.FileOutputStream;
import play.api.Application;
import play.api.ApplicationLoader;
import play.api.ApplicationLoader$;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Mode$;
import play.api.Play$;
import play.core.server.RealServerProcess;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerProcess;
import play.core.server.ServerProvider;
import play.core.server.ServerProvider$;
import play.core.server.ServerStartException;
import play.core.server.ServerStartException$;
import play.core.server.ServerWithStop;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public final class ProdServerStart$ {
    public static final ProdServerStart$ MODULE$;

    static {
        new ProdServerStart$();
    }

    public void main(String[] args) {
        RealServerProcess process = new RealServerProcess((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        this.start(process);
    }

    public ServerWithStop start(ServerProcess process) {
        try {
            ServerConfig config = this.readServerConfigSettings(process);
            Option<File> pidFile = this.createPidFile(process, config.configuration());
            Environment environment = new Environment(config.rootDir(), process.classLoader(), Mode$.MODULE$.Prod());
            ApplicationLoader.Context context = ApplicationLoader$.MODULE$.createContext(environment, ApplicationLoader$.MODULE$.createContext$default$2(), ApplicationLoader$.MODULE$.createContext$default$3(), ApplicationLoader$.MODULE$.createContext$default$4());
            ApplicationLoader loader = ApplicationLoader$.MODULE$.apply(context);
            Application application = loader.load(context);
            Play$.MODULE$.start(application);
            ServerProvider serverProvider = ServerProvider$.MODULE$.fromConfiguration(process.classLoader(), config.configuration());
            Server server = serverProvider.createServer(config, application);
            process.addShutdownHook((Function0<BoxedUnit>)new Serializable(pidFile, server){
                public static final long serialVersionUID = 0L;
                private final Option pidFile$1;
                private final Server server$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.server$1.stop();
                    this.pidFile$1.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(File x$1) {
                            return x$1.delete();
                        }
                    });
                    Predef$.MODULE$.assert(!this.pidFile$1.exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(File x$2) {
                            return x$2.exists();
                        }
                    }), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "PID file should not exist!";
                        }
                    });
                }
                {
                    this.pidFile$1 = pidFile$1;
                    this.server$1 = server$1;
                }
            });
            return server;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ServerStartException) {
                ServerStartException serverStartException = (ServerStartException)throwable2;
                String message = serverStartException.message();
                Option<Throwable> cause = serverStartException.cause();
                throw process.exit(message, cause, process.exit$default$3());
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw process.exit("Oops, cannot start the server.", (Option<Throwable>)new Some((Object)e), process.exit$default$3());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ServerConfig readServerConfigSettings(ServerProcess process) {
        void var6_5;
        Option rootDirArg = process.args().headOption().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        });
        Map rootDirConfig = (Map)rootDirArg.fold((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(File dir) {
                return ServerConfig$.MODULE$.rootDirConfig(dir);
            }
        });
        Configuration configuration = Configuration$.MODULE$.load(process.classLoader(), process.properties(), rootDirConfig, true);
        String path = (String)configuration.getString("play.server.dir", configuration.getString$default$2()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new ServerStartException("No root server path supplied", ServerStartException$.MODULE$.apply$default$2());
            }
        });
        File file = new File(path);
        if (file.exists() && file.isDirectory()) {
            Option httpsPort;
            File rootDir = file;
            Option httpPort = this.parsePort$1("http", configuration);
            if (httpPort.orElse((Function0)new Serializable(httpsPort = this.parsePort$1("https", configuration)){
                public static final long serialVersionUID = 0L;
                private final Option httpsPort$1;

                public final Option<Object> apply() {
                    return this.httpsPort$1;
                }
                {
                    this.httpsPort$1 = httpsPort$1;
                }
            }).isDefined()) {
                String address = (String)configuration.getString("play.server.http.address", configuration.getString$default$2()).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "0.0.0.0";
                    }
                });
                return new ServerConfig(rootDir, (Option<Object>)httpPort, (Option<Object>)httpsPort, address, Mode$.MODULE$.Prod(), process.properties(), configuration);
            }
            throw new ServerStartException("Must provide either an HTTP or HTTPS port", ServerStartException$.MODULE$.apply$default$2());
        }
        throw new ServerStartException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad root server path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_5})), ServerStartException$.MODULE$.apply$default$2());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<File> createPidFile(ServerProcess process, Configuration configuration) {
        None$ none$;
        String pidFilePath;
        String string = pidFilePath = (String)configuration.getString("play.server.pidfile.path", configuration.getString$default$2()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new ServerStartException("Pid file path not configured", ServerStartException$.MODULE$.apply$default$2());
            }
        });
        String string2 = "/dev/null";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            none$ = None$.MODULE$;
            return none$;
        }
        File pidFile = new File(pidFilePath).getAbsoluteFile();
        if (pidFile.exists()) {
            throw new ServerStartException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This application is already running (Or delete ", " file)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pidFile.getPath()})), ServerStartException$.MODULE$.apply$default$2());
        }
        String pid = (String)process.pid().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new ServerStartException("Couldn't determine current process's pid", ServerStartException$.MODULE$.apply$default$2());
            }
        });
        FileOutputStream out = new FileOutputStream(pidFile);
        try {
            out.write(pid.getBytes());
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.close();
            throw throwable;
        }
        out.close();
        none$ = new Some((Object)pidFile);
        return none$;
    }

    private final Option parsePort$1(String portType, Configuration configuration$1) {
        return configuration$1.getString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"play.server.", ".port"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{portType})), configuration$1.getString$default$2()).flatMap((Function1)new Serializable(portType){
            public static final long serialVersionUID = 0L;
            private final String portType$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Option<Object> apply(String x0$1) {
                int i;
                String string = x0$1;
                if ("disabled".equals(string)) {
                    return None$.MODULE$;
                }
                try {
                    i = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ServerStartException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ", " port: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.portType$1.toUpperCase(), string})), ServerStartException$.MODULE$.apply$default$2());
                }
                return new Some((Object)BoxesRunTime.boxToInteger((int)i));
            }
            {
                this.portType$1 = portType$1;
            }
        });
    }

    private ProdServerStart$() {
        MODULE$ = this;
    }
}

