/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.iteratee;

import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import play.api.libs.iteratee.CharEncoding;
import play.api.libs.iteratee.Enumeratee;
import play.api.libs.iteratee.Enumeratee$class;
import play.api.libs.iteratee.Iteratee;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;

public final class CharEncoding$ {
    public static final CharEncoding$ MODULE$;

    static {
        new CharEncoding$();
    }

    public Enumeratee<byte[], String> decode(Charset charset) {
        return new CharEncoding.Coder<byte[], String>(charset){
            private final byte[] empty;
            private final Charset charset$1;

            public <A> Iteratee<byte[], Iteratee<String, A>> applyOn(Iteratee<String, A> inner) {
                return CharEncoding.Coder.class.applyOn(this, inner);
            }

            public <A> Iteratee<byte[], Iteratee<String, A>> apply(Iteratee<String, A> inner) {
                return Enumeratee$class.apply(this, inner);
            }

            public <A> Iteratee<byte[], A> transform(Iteratee<String, A> inner) {
                return Enumeratee$class.transform(this, inner);
            }

            public <A> Iteratee<byte[], A> $amp$greater$greater(Iteratee<String, A> inner) {
                return Enumeratee$class.$amp$greater$greater(this, inner);
            }

            public <A> Iteratee<byte[], Iteratee<String, A>> $amp$greater(Iteratee<String, A> inner) {
                return Enumeratee$class.$amp$greater(this, inner);
            }

            public <To2> Enumeratee<byte[], To2> compose(Enumeratee<String, To2> other) {
                return Enumeratee$class.compose(this, other);
            }

            public <To2> Enumeratee<byte[], To2> $greater$less$greater(Enumeratee<String, To2> other) {
                return Enumeratee$class.$greater$less$greater(this, other);
            }

            public <X> Enumeratee<byte[], String> composeConcat(Enumeratee<String, String> other, Function1<String, TraversableLike<X, String>> p, CanBuildFrom<String, X, String> bf) {
                return Enumeratee$class.composeConcat(this, other, p, bf);
            }

            public <X> Enumeratee<byte[], String> $greater$plus$greater(Enumeratee<String, String> other, Function1<String, TraversableLike<X, String>> p, CanBuildFrom<String, X, String> bf) {
                return Enumeratee$class.$greater$plus$greater(this, other, p, bf);
            }

            public byte[] empty() {
                return this.empty;
            }

            public byte[] concat(byte[] a, byte[] b) {
                return (byte[])Predef$.MODULE$.byteArrayOps(a).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(b), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
            }

            public Either<CoderResult, Tuple2<String, byte[]>> code(byte[] bytes, boolean last) {
                Left left;
                StringWriter out;
                CharsetDecoder decoder = this.charset$1.newDecoder();
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                CharBuffer charBuffer = CharBuffer.allocate(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(2), (int)package$.MODULE$.ceil((double)((float)bytes.length * decoder.averageCharsPerByte()))));
                CoderResult result2 = this.process$1(charBuffer, decoder, byteBuffer, out = new StringWriter());
                if (result2.isUnmappable() || last && result2.isMalformed()) {
                    left = scala.package$.MODULE$.Left().apply((Object)result2);
                } else {
                    byte[] remaining = result2.isError() ? (byte[])Predef$.MODULE$.byteArrayOps(bytes).drop(byteBuffer.position()) : this.empty();
                    left = scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)out.toString(), (Object)remaining));
                }
                return left;
            }

            private final CoderResult process$1(CharBuffer charBuffer, CharsetDecoder decoder$1, ByteBuffer byteBuffer$1, StringWriter out$1) {
                CoderResult result2;
                while (true) {
                    result2 = decoder$1.decode(byteBuffer$1, charBuffer, true);
                    out$1.write(charBuffer.array(), 0, charBuffer.position());
                    if (!result2.isOverflow()) break;
                    if (charBuffer.position() == 0) {
                        charBuffer = CharBuffer.allocate(2 * charBuffer.capacity());
                        continue;
                    }
                    charBuffer.clear();
                }
                return result2;
            }
            {
                this.charset$1 = charset$1;
                Enumeratee$class.$init$(this);
                CharEncoding.Coder.class.$init$(this);
                this.empty = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
            }
        };
    }

    public Enumeratee<byte[], String> decode(String charset) {
        return this.decode(Charset.forName(charset));
    }

    public Enumeratee<String, byte[]> encode(Charset charset) {
        return new CharEncoding.Coder<String, byte[]>(charset){
            private final Charset charset$2;

            public <A> Iteratee<String, Iteratee<byte[], A>> applyOn(Iteratee<byte[], A> inner) {
                return CharEncoding.Coder.class.applyOn(this, inner);
            }

            public <A> Iteratee<String, Iteratee<byte[], A>> apply(Iteratee<byte[], A> inner) {
                return Enumeratee$class.apply(this, inner);
            }

            public <A> Iteratee<String, A> transform(Iteratee<byte[], A> inner) {
                return Enumeratee$class.transform(this, inner);
            }

            public <A> Iteratee<String, A> $amp$greater$greater(Iteratee<byte[], A> inner) {
                return Enumeratee$class.$amp$greater$greater(this, inner);
            }

            public <A> Iteratee<String, Iteratee<byte[], A>> $amp$greater(Iteratee<byte[], A> inner) {
                return Enumeratee$class.$amp$greater(this, inner);
            }

            public <To2> Enumeratee<String, To2> compose(Enumeratee<byte[], To2> other) {
                return Enumeratee$class.compose(this, other);
            }

            public <To2> Enumeratee<String, To2> $greater$less$greater(Enumeratee<byte[], To2> other) {
                return Enumeratee$class.$greater$less$greater(this, other);
            }

            public <X> Enumeratee<String, byte[]> composeConcat(Enumeratee<byte[], byte[]> other, Function1<byte[], TraversableLike<X, byte[]>> p, CanBuildFrom<byte[], X, byte[]> bf) {
                return Enumeratee$class.composeConcat(this, other, p, bf);
            }

            public <X> Enumeratee<String, byte[]> $greater$plus$greater(Enumeratee<byte[], byte[]> other, Function1<byte[], TraversableLike<X, byte[]>> p, CanBuildFrom<byte[], X, byte[]> bf) {
                return Enumeratee$class.$greater$plus$greater(this, other, p, bf);
            }

            public String empty() {
                return "";
            }

            public String concat(String a, String b) {
                return new StringBuilder().append((Object)a).append((Object)b).toString();
            }

            public Either<CoderResult, Tuple2<byte[], String>> code(String chars, boolean last) {
                Left left;
                ByteArrayOutputStream out;
                CharsetEncoder encoder = this.charset$2.newEncoder();
                CharBuffer charBuffer = CharBuffer.wrap(chars);
                ByteBuffer byteBuffer = ByteBuffer.allocate(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(6), (int)package$.MODULE$.ceil((double)((float)chars.length() * encoder.averageBytesPerChar()))));
                CoderResult result2 = this.process$2(byteBuffer, encoder, charBuffer, out = new ByteArrayOutputStream());
                if (result2.isUnmappable() || last && result2.isMalformed()) {
                    left = scala.package$.MODULE$.Left().apply((Object)result2);
                } else {
                    String remaining = result2.isError() ? (String)new StringOps(Predef$.MODULE$.augmentString(chars)).drop(charBuffer.position()) : "";
                    byte[] bytes = out.toByteArray();
                    byte[] bytesWithoutBom = this.charset$2.name().startsWith("UTF-") && bytes.length >= 2 && bytes[0] == (byte)254 && bytes[1] == (byte)255 ? (byte[])Predef$.MODULE$.byteArrayOps(bytes).drop(2) : bytes;
                    left = scala.package$.MODULE$.Right().apply((Object)new Tuple2((Object)bytesWithoutBom, (Object)remaining));
                }
                return left;
            }

            private final CoderResult process$2(ByteBuffer byteBuffer, CharsetEncoder encoder$1, CharBuffer charBuffer$1, ByteArrayOutputStream out$2) {
                CoderResult result2;
                while (true) {
                    result2 = encoder$1.encode(charBuffer$1, byteBuffer, true);
                    out$2.write(byteBuffer.array(), 0, byteBuffer.position());
                    if (!result2.isOverflow()) break;
                    if (byteBuffer.position() == 0) {
                        byteBuffer = ByteBuffer.allocate(2 * byteBuffer.capacity());
                        continue;
                    }
                    byteBuffer.clear();
                }
                return result2;
            }
            {
                this.charset$2 = charset$2;
                Enumeratee$class.$init$(this);
                CharEncoding.Coder.class.$init$(this);
            }
        };
    }

    public Enumeratee<String, byte[]> encode(String charset) {
        return this.encode(Charset.forName(charset));
    }

    private CharEncoding$() {
        MODULE$ = this;
    }
}

