/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.GenSeqLike;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SeqView;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParSeq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import scodec.bits.Bases;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.BitVector;
import scodec.bits.BitVector$;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteOrdering$LittleEndian$;
import scodec.bits.ByteVector;

public abstract class BitVector$class {
    public static final long length(BitVector $this) {
        return $this.size();
    }

    public static final boolean isEmpty(BitVector $this) {
        return $this.sizeLessThan(1L);
    }

    public static final boolean nonEmpty(BitVector $this) {
        return !$this.isEmpty();
    }

    public static final boolean sizeGreaterThan(BitVector $this, long n) {
        return n < 0L || !$this.sizeLessThanOrEqual(n);
    }

    public static final boolean sizeGreaterThanOrEqual(BitVector $this, long n) {
        return n < 0L || !$this.sizeLessThanOrEqual(n - 1L);
    }

    public static final boolean sizeLessThanOrEqual(BitVector $this, long n) {
        return n == Long.MAX_VALUE || $this.sizeLessThan(n + 1L);
    }

    public static final Option intSize(BitVector $this) {
        return $this.size() <= Integer.MAX_VALUE ? new Some((Object)BoxesRunTime.boxToInteger((int)((int)$this.size()))) : None$.MODULE$;
    }

    public static final boolean apply(BitVector $this, long n) {
        return $this.get(n);
    }

    public static final Option lift(BitVector $this, long n) {
        return $this.sizeGreaterThan(n) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)$this.get(n))) : None$.MODULE$;
    }

    public static BitVector unchunk(BitVector $this) {
        return $this;
    }

    public static final BitVector insert(BitVector $this, long idx, boolean b) {
        return $this.take(idx).$colon$plus(b).$plus$plus($this.drop(idx));
    }

    public static final BitVector splice(BitVector $this, long idx, BitVector b) {
        return $this.take(idx).$plus$plus(b).$plus$plus($this.drop(idx));
    }

    public static final BitVector patch(BitVector $this, long idx, BitVector b) {
        return $this.take(idx).$plus$plus(b).$plus$plus($this.drop(idx + b.size()));
    }

    public static final BitVector set(BitVector $this, long n) {
        return $this.update(n, true);
    }

    public static final BitVector clear(BitVector $this, long n) {
        return $this.update(n, false);
    }

    public static BitVector $plus$plus(BitVector $this, BitVector b2) {
        return $this.isEmpty() ? b2 : new BitVector.Chunks(new BitVector.Append($this, b2));
    }

    public static final BitVector $plus$colon(BitVector $this, boolean b) {
        return BitVector$.MODULE$.bit(b).$plus$plus($this);
    }

    public static final BitVector $colon$plus(BitVector $this, boolean b) {
        return $this.$plus$plus(BitVector$.MODULE$.bit(b));
    }

    public static int depth(BitVector $this) {
        int n;
        BitVector bitVector = $this;
        if ($this instanceof BitVector.Append) {
            BitVector.Append append = (BitVector.Append)$this;
            BitVector l = append.left();
            BitVector r = append.right();
            int n2 = l.depth();
            Predef$ predef$ = Predef$.MODULE$;
            n = 1 + RichInt$.MODULE$.max$extension(n2, r.depth());
        } else if ($this instanceof BitVector.Chunks) {
            BitVector.Chunks chunks = (BitVector.Chunks)$this;
            n = 1 + chunks.chunks().depth();
        } else {
            n = 0;
        }
        return n;
    }

    public static final BitVector dropRight(BitVector $this, long n) {
        return n <= 0L ? $this : (n >= $this.size() ? BitVector$.MODULE$.empty() : $this.take($this.size() - n));
    }

    public static final BitVector takeRight(BitVector $this, long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"takeRight(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n)})));
        }
        return n >= $this.size() ? $this : $this.drop($this.size() - n);
    }

    public static final Tuple2 splitAt(BitVector $this, long n) {
        return new Tuple2((Object)$this.take(n), (Object)$this.drop(n));
    }

    public static final BitVector slice(BitVector $this, long from, long until) {
        return $this.drop(from).take(until - from);
    }

    public static Either acquire(BitVector $this, long n) {
        return $this.sizeGreaterThanOrEqual(n) ? package$.MODULE$.Right().apply((Object)$this.take(n)) : package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot acquire ", " bits from a vector that contains ", " bits"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n), BoxesRunTime.boxToLong((long)$this.size())})));
    }

    public static final Object acquireThen(BitVector $this, long n, Function1 err, Function1 f) {
        return $this.sizeGreaterThanOrEqual(n) ? f.apply((Object)$this.take(n)) : err.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot acquire ", " bits from a vector that contains ", " bits"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n), BoxesRunTime.boxToLong((long)$this.size())})));
    }

    public static final Either consume(BitVector $this, long n, Function1 decode) {
        Left left;
        Serializable serializable = new Serializable($this, n, decode){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ BitVector $outer;
            public final long n$2;
            public final Function1 decode$1;

            public final Serializable apply(BitVector toDecode) {
                Left left;
                Serializable serializable = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ BitVector$.anonfun.consume.1 $outer;

                    public final Tuple2<BitVector, A> apply(A decoded) {
                        return new Tuple2((Object)this.$outer.$outer.drop(this.$outer.n$2), decoded);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                };
                Either either = ((Either)this.decode$1.apply((Object)toDecode)).right().e();
                if (!(either instanceof Left)) {
                    if (!(either instanceof Right)) {
                        throw new MatchError((Object)either);
                    }
                    Right right = (Right)either;
                    Object object = right.b();
                    Serializable serializable2 = serializable;
                    left = new Right(serializable.apply(object));
                } else {
                    Left left2 = (Left)either;
                    left = new Left(left2.a());
                }
                return left;
            }

            public /* synthetic */ BitVector scodec$bits$BitVector$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.n$2 = n$2;
                this.decode$1 = decode$1;
            }
        };
        Either either = $this.acquire(n).right().e();
        if (!(either instanceof Left)) {
            Left left2;
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = right.b();
            Serializable serializable2 = serializable;
            BitVector bitVector = (BitVector)object;
            Serializable serializable3 = serializable;
            Serializable serializable4 = new /* invalid duplicate definition of identical inner class */;
            Either either2 = ((Either)decode.apply((Object)bitVector)).right().e();
            if (!(either2 instanceof Left)) {
                if (!(either2 instanceof Right)) {
                    throw new MatchError((Object)either2);
                }
                Right right2 = (Right)either2;
                Object object2 = right2.b();
                Serializable serializable5 = serializable4;
                Object object3 = object2;
                Serializable serializable6 = serializable4;
                left2 = new Right((Object)new Tuple2((Object)serializable.$outer.drop(n), object2));
            } else {
                Left left3 = (Left)either2;
                left2 = new Left(left3.a());
            }
            left = (Either)left2;
        } else {
            Left left4 = (Left)either;
            left = new Left(left4.a());
        }
        return left;
    }

    public static final Object consumeThen(BitVector $this, long n, Function1 err, Function2 f) {
        return $this.sizeGreaterThanOrEqual(n) ? f.apply((Object)$this.take(n), (Object)$this.drop(n)) : err.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot acquire ", " bits from a vector that contains ", " bits"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n), BoxesRunTime.boxToLong((long)$this.size())})));
    }

    public static final boolean startsWith(BitVector $this, BitVector b) {
        BitVector bitVector = $this.take(b.size());
        BitVector bitVector2 = b;
        return !(bitVector != null ? !((Object)bitVector).equals(b) : b != null);
    }

    public static final boolean endsWith(BitVector $this, BitVector b) {
        BitVector bitVector = $this.takeRight(b.size());
        BitVector bitVector2 = b;
        return !(bitVector != null ? !((Object)bitVector).equals(b) : b != null);
    }

    public static final long indexOfSlice(BitVector $this, BitVector slice) {
        return $this.indexOfSlice(slice, 0L);
    }

    public static final long indexOfSlice(BitVector $this, BitVector slice, long from) {
        return BitVector$class.go$2($this, $this.drop(from), from, slice);
    }

    public static final boolean containsSlice(BitVector $this, BitVector slice) {
        return $this.indexOfSlice(slice) >= 0L;
    }

    public static final Stream grouped(BitVector $this, long n) {
        Stream stream;
        if ($this.isEmpty()) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            BitVector bitVector = $this.take(n);
            stream = Stream$.MODULE$.consWrapper((Function0)new Serializable($this, n){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BitVector $outer;
                private final long n$3;

                public final Stream<BitVector> apply() {
                    return this.$outer.drop(this.n$3).grouped(this.n$3);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.n$3 = n$3;
                }
            }).$hash$colon$colon((Object)bitVector);
        }
        return stream;
    }

    public static final boolean head(BitVector $this) {
        return $this.get(0L);
    }

    public static final Option headOption(BitVector $this) {
        return $this.lift(0L);
    }

    public static final BitVector tail(BitVector $this) {
        return $this.drop(1L);
    }

    public static final BitVector init(BitVector $this) {
        return $this.dropRight(1L);
    }

    public static final boolean last(BitVector $this) {
        return $this.apply($this.size() - 1L);
    }

    public static final Option lastOption(BitVector $this) {
        return $this.lift($this.size() - 1L);
    }

    public static final BitVector padTo(BitVector $this, long n) {
        return $this.padRight(n);
    }

    public static final BitVector padRight(BitVector $this, long n) {
        if (n < $this.size()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BitVector.padRight(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n)})));
        }
        return $this.$plus$plus(BitVector$.MODULE$.fill(n - $this.size(), false));
    }

    public static final BitVector padLeft(BitVector $this, long n) {
        if (n < $this.size()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BitVector.padLeft(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n)})));
        }
        return BitVector$.MODULE$.fill(n - $this.size(), false).$plus$plus($this);
    }

    public static final BitVector reverse(BitVector $this) {
        return BitVector$.MODULE$.apply($this.compact().underlying().reverse().map((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final byte apply(byte b) {
                return BitVector$.MODULE$.scodec$bits$BitVector$$reverseBitsInBytes(b);
            }
        })).drop(8L - BitVector$.MODULE$.scodec$bits$BitVector$$validBitsInLastByte($this.size()));
    }

    public static final BitVector reverseByteOrder(BitVector $this) {
        BitVector bitVector;
        if ($this.size() % 8L == 0L) {
            bitVector = BitVector$.MODULE$.toBytes($this.compact().underlying().reverse(), $this.size());
        } else {
            long validFinalBits = BitVector$.MODULE$.scodec$bits$BitVector$$validBitsInLastByte($this.size());
            BitVector.Bytes last = $this.take(validFinalBits).compact();
            ByteVector b = $this.drop(validFinalBits).toByteVector().reverse();
            BitVector.Bytes init = BitVector$.MODULE$.toBytes(b, $this.size() - last.size());
            bitVector = init.$plus$plus(last);
        }
        return bitVector;
    }

    public static final BitVector invertReverseByteOrder(BitVector $this) {
        Tuple2<BitVector, BitVector> tuple2;
        block4: {
            BitVector bitVector;
            block3: {
                Tuple2 tuple22;
                block2: {
                    if ($this.size() % 8L != 0L) break block2;
                    bitVector = $this.reverseByteOrder();
                    break block3;
                }
                long validFinalBits = BitVector$.MODULE$.scodec$bits$BitVector$$validBitsInLastByte($this.size());
                tuple2 = $this.splitAt($this.size() - validFinalBits);
                if (tuple2 == null) break block4;
                BitVector init = (BitVector)tuple2._1();
                BitVector last = (BitVector)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)init, (Object)last);
                BitVector init2 = (BitVector)tuple22._1();
                BitVector last2 = (BitVector)tuple22._2();
                bitVector = last2.$plus$plus(init2.bytes().reverse().bits());
            }
            return bitVector;
        }
        throw new MatchError(tuple2);
    }

    public static final BitVector reverseBitOrder(BitVector $this) {
        return BitVector$.MODULE$.apply($this.compact().underlying().map((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final byte apply(byte b) {
                return BitVector$.MODULE$.scodec$bits$BitVector$$reverseBitsInBytes(b);
            }
        })).drop(8L - BitVector$.MODULE$.scodec$bits$BitVector$$validBitsInLastByte($this.size()));
    }

    public static final long populationCount(BitVector $this) {
        return BitVector$class.go$3($this, $this, 0L);
    }

    public static final BitVector not(BitVector $this) {
        return $this.mapBytes((Function1<ByteVector, ByteVector>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ByteVector apply(ByteVector x$3) {
                return x$3.not();
            }
        });
    }

    public static final BitVector and(BitVector $this, BitVector other) {
        return BitVector$class.zipBytesWith($this, other, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(byte x$4, byte x$5) {
                return (byte)(x$4 & x$5);
            }
        });
    }

    public static final BitVector or(BitVector $this, BitVector other) {
        return BitVector$class.zipBytesWith($this, other, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(byte x$6, byte x$7) {
                return (byte)(x$6 | x$7);
            }
        });
    }

    public static final BitVector xor(BitVector $this, BitVector other) {
        return BitVector$class.zipBytesWith($this, other, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(byte x$8, byte x$9) {
                return (byte)(x$8 ^ x$9);
            }
        });
    }

    public static final BitVector shiftLeft(BitVector $this, long n) {
        return n <= 0L ? $this : (n >= $this.size() ? BitVector$.MODULE$.low($this.size()) : $this.drop(n).$plus$plus(BitVector$.MODULE$.low(n)));
    }

    public static final BitVector shiftRight(BitVector $this, long n, boolean signExtension) {
        BitVector bitVector;
        if ($this.isEmpty() || n <= 0L) {
            bitVector = $this;
        } else {
            boolean extensionHigh;
            boolean bl = extensionHigh = signExtension && $this.head();
            bitVector = n >= $this.size() ? (extensionHigh ? BitVector$.MODULE$.high($this.size()) : BitVector$.MODULE$.low($this.size())) : (extensionHigh ? BitVector$.MODULE$.high(n) : BitVector$.MODULE$.low(n)).$plus$plus($this.dropRight(n));
        }
        return bitVector;
    }

    public static final BitVector rotateLeft(BitVector $this, long n) {
        long n0;
        return n <= 0L ? $this : ($this.isEmpty() ? $this : ((n0 = n % $this.size()) == 0L ? $this : $this.drop(n0).$plus$plus($this.take(n0))));
    }

    public static final BitVector rotateRight(BitVector $this, long n) {
        long n0;
        return n <= 0L ? $this : ($this.isEmpty() ? $this : ((n0 = n % $this.size()) == 0L ? $this : $this.takeRight(n0).$plus$plus($this.dropRight(n0))));
    }

    public static final BitVector.Bytes compact(BitVector $this) {
        BitVector.Bytes bytes;
        block7: {
            BitVector.Bytes bytes2;
            block5: {
                block6: {
                    block4: {
                        if (BitVector$.MODULE$.scodec$bits$BitVector$$bytesNeededForBits($this.size()) > Integer.MAX_VALUE) {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot compact bit vector of size ", " GB"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)$this.size() / (double)8 / 1.0E9))})));
                        }
                        BitVector bitVector = $this;
                        if (!($this instanceof BitVector.Bytes)) break block4;
                        BitVector.Bytes bytes3 = (BitVector.Bytes)$this;
                        ByteVector b = bytes3.underlying();
                        long n = bytes3.size();
                        ByteVector b2 = b.compact();
                        bytes2 = b2 == b ? bytes3 : new BitVector.Bytes(b2, n);
                        break block5;
                    }
                    if (!($this instanceof BitVector.Drop)) break block6;
                    BitVector.Drop drop = (BitVector.Drop)$this;
                    BitVector.Bytes bs = drop.interpretDrop();
                    ByteVector b2 = bs.underlying().compact();
                    bytes2 = b2 == bs.underlying() ? bs : new BitVector.Bytes(b2, bs.size());
                    break block5;
                }
                bytes = (BitVector.Bytes)BitVector$.MODULE$.reduceBalanced(BitVector$class.go$4($this, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BitVector[]{$this})), (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)), new BitVector$.anonfun.1($this), new BitVector$.anonfun.2($this));
                if (bytes == null) break block7;
                ByteVector b = bytes.underlying();
                long n = bytes.size();
                bytes2 = new BitVector.Bytes(b.compact(), n);
            }
            return bytes2;
        }
        throw new MatchError((Object)bytes);
    }

    public static final BitVector.Bytes copy(BitVector $this) {
        BitVector.Bytes bytes;
        BitVector bitVector = $this;
        if ($this instanceof BitVector.Bytes) {
            BitVector.Bytes bytes2 = (BitVector.Bytes)$this;
            ByteVector b = bytes2.underlying();
            long n = bytes2.size();
            bytes = new BitVector.Bytes(b.copy(), n);
        } else {
            bytes = $this.compact();
        }
        return bytes;
    }

    public static final BitVector force(BitVector $this) {
        return BitVector$class.go$5($this, (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BitVector[]{$this})));
    }

    public static final IndexedSeq toIndexedSeq(BitVector $this) {
        None$ none$;
        Serializable serializable = new Serializable($this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ BitVector $outer;

            public final Object apply(int n) {
                return new IndexedSeq<Object>(this){
                    private final /* synthetic */ BitVector$.anonfun.toIndexedSeq.1 $outer;

                    public GenericCompanion<IndexedSeq> companion() {
                        return IndexedSeq.class.companion((IndexedSeq)this);
                    }

                    public IndexedSeq<Object> seq() {
                        return IndexedSeq.class.seq((IndexedSeq)this);
                    }

                    public int hashCode() {
                        return IndexedSeqLike.class.hashCode((IndexedSeqLike)this);
                    }

                    public IndexedSeq<Object> thisCollection() {
                        return IndexedSeqLike.class.thisCollection((IndexedSeqLike)this);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public IndexedSeq toCollection(Object repr) {
                        return IndexedSeqLike.class.toCollection((IndexedSeqLike)this, (Object)repr);
                    }

                    public Iterator<Object> iterator() {
                        return IndexedSeqLike.class.iterator((IndexedSeqLike)this);
                    }

                    public <A1> Buffer<A1> toBuffer() {
                        return IndexedSeqLike.class.toBuffer((IndexedSeqLike)this);
                    }

                    public Combiner<Object, ParSeq<Object>> parCombiner() {
                        return SeqLike.class.parCombiner((SeqLike)this);
                    }

                    public int lengthCompare(int len) {
                        return SeqLike.class.lengthCompare((SeqLike)this, (int)len);
                    }

                    public boolean isEmpty() {
                        return SeqLike.class.isEmpty((SeqLike)this);
                    }

                    public int size() {
                        return SeqLike.class.size((SeqLike)this);
                    }

                    public int segmentLength(Function1<Object, Object> p, int from) {
                        return SeqLike.class.segmentLength((SeqLike)this, p, (int)from);
                    }

                    public int indexWhere(Function1<Object, Object> p, int from) {
                        return SeqLike.class.indexWhere((SeqLike)this, p, (int)from);
                    }

                    public int lastIndexWhere(Function1<Object, Object> p, int end) {
                        return SeqLike.class.lastIndexWhere((SeqLike)this, p, (int)end);
                    }

                    public Iterator<IndexedSeq<Object>> permutations() {
                        return SeqLike.class.permutations((SeqLike)this);
                    }

                    public Iterator<IndexedSeq<Object>> combinations(int n) {
                        return SeqLike.class.combinations((SeqLike)this, (int)n);
                    }

                    public IndexedSeq<Object> reverse() {
                        return SeqLike.class.reverse((SeqLike)this);
                    }

                    public <B, That> That reverseMap(Function1<Object, B> f, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)SeqLike.class.reverseMap((SeqLike)this, f, bf);
                    }

                    public Iterator<Object> reverseIterator() {
                        return SeqLike.class.reverseIterator((SeqLike)this);
                    }

                    public <B> boolean startsWith(GenSeq<B> that, int offset) {
                        return SeqLike.class.startsWith((SeqLike)this, that, (int)offset);
                    }

                    public <B> boolean endsWith(GenSeq<B> that) {
                        return SeqLike.class.endsWith((SeqLike)this, that);
                    }

                    public <B> int indexOfSlice(GenSeq<B> that) {
                        return SeqLike.class.indexOfSlice((SeqLike)this, that);
                    }

                    public <B> int indexOfSlice(GenSeq<B> that, int from) {
                        return SeqLike.class.indexOfSlice((SeqLike)this, that, (int)from);
                    }

                    public <B> int lastIndexOfSlice(GenSeq<B> that) {
                        return SeqLike.class.lastIndexOfSlice((SeqLike)this, that);
                    }

                    public <B> int lastIndexOfSlice(GenSeq<B> that, int end) {
                        return SeqLike.class.lastIndexOfSlice((SeqLike)this, that, (int)end);
                    }

                    public <B> boolean containsSlice(GenSeq<B> that) {
                        return SeqLike.class.containsSlice((SeqLike)this, that);
                    }

                    public boolean contains(Object elem) {
                        return SeqLike.class.contains((SeqLike)this, (Object)elem);
                    }

                    public <B, That> That union(GenSeq<B> that, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)SeqLike.class.union((SeqLike)this, that, bf);
                    }

                    public <B> IndexedSeq<Object> diff(GenSeq<B> that) {
                        return SeqLike.class.diff((SeqLike)this, that);
                    }

                    public <B> IndexedSeq<Object> intersect(GenSeq<B> that) {
                        return SeqLike.class.intersect((SeqLike)this, that);
                    }

                    public IndexedSeq<Object> distinct() {
                        return SeqLike.class.distinct((SeqLike)this);
                    }

                    public <B, That> That patch(int from, GenSeq<B> patch, int replaced, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)SeqLike.class.patch((SeqLike)this, (int)from, patch, (int)replaced, bf);
                    }

                    public <B, That> That updated(int index, B elem, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)SeqLike.class.updated((SeqLike)this, (int)index, elem, bf);
                    }

                    public <B, That> That $plus$colon(B elem, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)SeqLike.class.$plus$colon((SeqLike)this, elem, bf);
                    }

                    public <B, That> That $colon$plus(B elem, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)SeqLike.class.$colon$plus((SeqLike)this, elem, bf);
                    }

                    public <B, That> That padTo(int len, B elem, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)SeqLike.class.padTo((SeqLike)this, (int)len, elem, bf);
                    }

                    public <B> boolean corresponds(GenSeq<B> that, Function2<Object, B, Object> p) {
                        return SeqLike.class.corresponds((SeqLike)this, that, p);
                    }

                    public IndexedSeq<Object> sortWith(Function2<Object, Object, Object> lt) {
                        return SeqLike.class.sortWith((SeqLike)this, lt);
                    }

                    public <B> IndexedSeq<Object> sortBy(Function1<Object, B> f, Ordering<B> ord) {
                        return SeqLike.class.sortBy((SeqLike)this, f, ord);
                    }

                    public <B> IndexedSeq<Object> sorted(Ordering<B> ord) {
                        return SeqLike.class.sorted((SeqLike)this, ord);
                    }

                    public Seq<Object> toSeq() {
                        return SeqLike.class.toSeq((SeqLike)this);
                    }

                    public Range indices() {
                        return SeqLike.class.indices((SeqLike)this);
                    }

                    public Object view() {
                        return SeqLike.class.view((SeqLike)this);
                    }

                    public SeqView<Object, IndexedSeq<Object>> view(int from, int until) {
                        return SeqLike.class.view((SeqLike)this, (int)from, (int)until);
                    }

                    public String toString() {
                        return SeqLike.class.toString((SeqLike)this);
                    }

                    public boolean isDefinedAt(int idx) {
                        return GenSeqLike.class.isDefinedAt((GenSeqLike)this, (int)idx);
                    }

                    public int prefixLength(Function1<Object, Object> p) {
                        return GenSeqLike.class.prefixLength((GenSeqLike)this, p);
                    }

                    public int indexWhere(Function1<Object, Object> p) {
                        return GenSeqLike.class.indexWhere((GenSeqLike)this, p);
                    }

                    public <B> int indexOf(B elem) {
                        return GenSeqLike.class.indexOf((GenSeqLike)this, elem);
                    }

                    public <B> int indexOf(B elem, int from) {
                        return GenSeqLike.class.indexOf((GenSeqLike)this, elem, (int)from);
                    }

                    public <B> int lastIndexOf(B elem) {
                        return GenSeqLike.class.lastIndexOf((GenSeqLike)this, elem);
                    }

                    public <B> int lastIndexOf(B elem, int end) {
                        return GenSeqLike.class.lastIndexOf((GenSeqLike)this, elem, (int)end);
                    }

                    public int lastIndexWhere(Function1<Object, Object> p) {
                        return GenSeqLike.class.lastIndexWhere((GenSeqLike)this, p);
                    }

                    public <B> boolean startsWith(GenSeq<B> that) {
                        return GenSeqLike.class.startsWith((GenSeqLike)this, that);
                    }

                    public boolean equals(Object that) {
                        return GenSeqLike.class.equals((GenSeqLike)this, (Object)that);
                    }

                    public <U> void foreach(Function1<Object, U> f) {
                        IterableLike.class.foreach((IterableLike)this, f);
                    }

                    public boolean forall(Function1<Object, Object> p) {
                        return IterableLike.class.forall((IterableLike)this, p);
                    }

                    public boolean exists(Function1<Object, Object> p) {
                        return IterableLike.class.exists((IterableLike)this, p);
                    }

                    public Option<Object> find(Function1<Object, Object> p) {
                        return IterableLike.class.find((IterableLike)this, p);
                    }

                    public <B> B foldRight(B z, Function2<Object, B, B> op) {
                        return (B)IterableLike.class.foldRight((IterableLike)this, z, op);
                    }

                    public <B> B reduceRight(Function2<Object, B, B> op) {
                        return (B)IterableLike.class.reduceRight((IterableLike)this, op);
                    }

                    public Iterable<Object> toIterable() {
                        return IterableLike.class.toIterable((IterableLike)this);
                    }

                    public Iterator<Object> toIterator() {
                        return IterableLike.class.toIterator((IterableLike)this);
                    }

                    public Object head() {
                        return IterableLike.class.head((IterableLike)this);
                    }

                    public IndexedSeq<Object> slice(int from, int until) {
                        return IterableLike.class.slice((IterableLike)this, (int)from, (int)until);
                    }

                    public IndexedSeq<Object> take(int n) {
                        return IterableLike.class.take((IterableLike)this, (int)n);
                    }

                    public IndexedSeq<Object> drop(int n) {
                        return IterableLike.class.drop((IterableLike)this, (int)n);
                    }

                    public IndexedSeq<Object> takeWhile(Function1<Object, Object> p) {
                        return IterableLike.class.takeWhile((IterableLike)this, p);
                    }

                    public Iterator<IndexedSeq<Object>> grouped(int size) {
                        return IterableLike.class.grouped((IterableLike)this, (int)size);
                    }

                    public Iterator<IndexedSeq<Object>> sliding(int size) {
                        return IterableLike.class.sliding((IterableLike)this, (int)size);
                    }

                    public Iterator<IndexedSeq<Object>> sliding(int size, int step) {
                        return IterableLike.class.sliding((IterableLike)this, (int)size, (int)step);
                    }

                    public IndexedSeq<Object> takeRight(int n) {
                        return IterableLike.class.takeRight((IterableLike)this, (int)n);
                    }

                    public IndexedSeq<Object> dropRight(int n) {
                        return IterableLike.class.dropRight((IterableLike)this, (int)n);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        IterableLike.class.copyToArray((IterableLike)this, (Object)xs, (int)start, (int)len);
                    }

                    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<IndexedSeq<Object>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.class.zip((IterableLike)this, that, bf);
                    }

                    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<IndexedSeq<Object>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.class.zipAll((IterableLike)this, that, thisElem, thatElem, bf);
                    }

                    public <A1, That> That zipWithIndex(CanBuildFrom<IndexedSeq<Object>, Tuple2<A1, Object>, That> bf) {
                        return (That)IterableLike.class.zipWithIndex((IterableLike)this, bf);
                    }

                    public <B> boolean sameElements(GenIterable<B> that) {
                        return IterableLike.class.sameElements((IterableLike)this, that);
                    }

                    public Stream<Object> toStream() {
                        return IterableLike.class.toStream((IterableLike)this);
                    }

                    public boolean canEqual(Object that) {
                        return IterableLike.class.canEqual((IterableLike)this, (Object)that);
                    }

                    public Builder<Object, IndexedSeq<Object>> newBuilder() {
                        return GenericTraversableTemplate.class.newBuilder((GenericTraversableTemplate)this);
                    }

                    public <B> Builder<B, IndexedSeq<B>> genericBuilder() {
                        return GenericTraversableTemplate.class.genericBuilder((GenericTraversableTemplate)this);
                    }

                    public <A1, A2> Tuple2<IndexedSeq<A1>, IndexedSeq<A2>> unzip(Function1<Object, Tuple2<A1, A2>> asPair) {
                        return GenericTraversableTemplate.class.unzip((GenericTraversableTemplate)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<IndexedSeq<A1>, IndexedSeq<A2>, IndexedSeq<A3>> unzip3(Function1<Object, Tuple3<A1, A2, A3>> asTriple) {
                        return GenericTraversableTemplate.class.unzip3((GenericTraversableTemplate)this, asTriple);
                    }

                    public <B> IndexedSeq<B> flatten(Function1<Object, GenTraversableOnce<B>> asTraversable) {
                        return GenericTraversableTemplate.class.flatten((GenericTraversableTemplate)this, asTraversable);
                    }

                    public <B> IndexedSeq<IndexedSeq<B>> transpose(Function1<Object, GenTraversableOnce<B>> asTraversable) {
                        return GenericTraversableTemplate.class.transpose((GenericTraversableTemplate)this, asTraversable);
                    }

                    public IndexedSeq<Object> repr() {
                        return TraversableLike.class.repr((TraversableLike)this);
                    }

                    public final boolean isTraversableAgain() {
                        return TraversableLike.class.isTraversableAgain((TraversableLike)this);
                    }

                    public boolean hasDefiniteSize() {
                        return TraversableLike.class.hasDefiniteSize((TraversableLike)this);
                    }

                    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)TraversableLike.class.$plus$plus((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)TraversableLike.class.$plus$plus$colon((TraversableLike)this, that, bf);
                    }

                    public <B, That> That map(Function1<Object, B> f, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)TraversableLike.class.map((TraversableLike)this, f, bf);
                    }

                    public <B, That> That flatMap(Function1<Object, GenTraversableOnce<B>> f, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)TraversableLike.class.flatMap((TraversableLike)this, f, bf);
                    }

                    public IndexedSeq<Object> filter(Function1<Object, Object> p) {
                        return TraversableLike.class.filter((TraversableLike)this, p);
                    }

                    public IndexedSeq<Object> filterNot(Function1<Object, Object> p) {
                        return TraversableLike.class.filterNot((TraversableLike)this, p);
                    }

                    public <B, That> That collect(PartialFunction<Object, B> pf, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)TraversableLike.class.collect((TraversableLike)this, pf, bf);
                    }

                    public Tuple2<IndexedSeq<Object>, IndexedSeq<Object>> partition(Function1<Object, Object> p) {
                        return TraversableLike.class.partition((TraversableLike)this, p);
                    }

                    public <K> Map<K, IndexedSeq<Object>> groupBy(Function1<Object, K> f) {
                        return TraversableLike.class.groupBy((TraversableLike)this, f);
                    }

                    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<IndexedSeq<Object>, B, That> cbf) {
                        return (That)TraversableLike.class.scan((TraversableLike)this, z, op, cbf);
                    }

                    public <B, That> That scanLeft(B z, Function2<B, Object, B> op, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)TraversableLike.class.scanLeft((TraversableLike)this, z, op, bf);
                    }

                    public <B, That> That scanRight(B z, Function2<Object, B, B> op, CanBuildFrom<IndexedSeq<Object>, B, That> bf) {
                        return (That)TraversableLike.class.scanRight((TraversableLike)this, z, op, bf);
                    }

                    public Option<Object> headOption() {
                        return TraversableLike.class.headOption((TraversableLike)this);
                    }

                    public IndexedSeq<Object> tail() {
                        return TraversableLike.class.tail((TraversableLike)this);
                    }

                    public Object last() {
                        return TraversableLike.class.last((TraversableLike)this);
                    }

                    public Option<Object> lastOption() {
                        return TraversableLike.class.lastOption((TraversableLike)this);
                    }

                    public IndexedSeq<Object> init() {
                        return TraversableLike.class.init((TraversableLike)this);
                    }

                    public IndexedSeq<Object> sliceWithKnownDelta(int from, int until, int delta) {
                        return TraversableLike.class.sliceWithKnownDelta((TraversableLike)this, (int)from, (int)until, (int)delta);
                    }

                    public IndexedSeq<Object> sliceWithKnownBound(int from, int until) {
                        return TraversableLike.class.sliceWithKnownBound((TraversableLike)this, (int)from, (int)until);
                    }

                    public IndexedSeq<Object> dropWhile(Function1<Object, Object> p) {
                        return TraversableLike.class.dropWhile((TraversableLike)this, p);
                    }

                    public Tuple2<IndexedSeq<Object>, IndexedSeq<Object>> span(Function1<Object, Object> p) {
                        return TraversableLike.class.span((TraversableLike)this, p);
                    }

                    public Tuple2<IndexedSeq<Object>, IndexedSeq<Object>> splitAt(int n) {
                        return TraversableLike.class.splitAt((TraversableLike)this, (int)n);
                    }

                    public Iterator<IndexedSeq<Object>> tails() {
                        return TraversableLike.class.tails((TraversableLike)this);
                    }

                    public Iterator<IndexedSeq<Object>> inits() {
                        return TraversableLike.class.inits((TraversableLike)this);
                    }

                    public Traversable<Object> toTraversable() {
                        return TraversableLike.class.toTraversable((TraversableLike)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, Object, Col> cbf) {
                        return (Col)TraversableLike.class.to((TraversableLike)this, cbf);
                    }

                    public String stringPrefix() {
                        return TraversableLike.class.stringPrefix((TraversableLike)this);
                    }

                    public FilterMonadic<Object, IndexedSeq<Object>> withFilter(Function1<Object, Object> p) {
                        return TraversableLike.class.withFilter((TraversableLike)this, p);
                    }

                    public ParSeq<Object> par() {
                        return Parallelizable.class.par((Parallelizable)this);
                    }

                    public List<Object> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<Object, Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<Object, B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, Object, B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<Object, B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, Object, B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, Object, B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, Object, B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<Object, B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(B z, Function2<B, Object, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public <B> boolean min(Ordering<B> cmp) {
                        return (boolean)TraversableOnce.class.min((TraversableOnce)this, cmp);
                    }

                    public <B> boolean max(Ordering<B> cmp) {
                        return (boolean)TraversableOnce.class.max((TraversableOnce)this, cmp);
                    }

                    public <B> boolean maxBy(Function1<Object, B> f, Ordering<B> cmp) {
                        return (boolean)TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
                    }

                    public <B> boolean minBy(Function1<Object, B> f, Ordering<B> cmp) {
                        return (boolean)TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<Object> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public scala.collection.immutable.IndexedSeq<Object> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<Object> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Object, Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
                    }

                    public <A1, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
                        return PartialFunction.class.orElse((PartialFunction)this, that);
                    }

                    public <C> PartialFunction<Object, C> andThen(Function1<Object, C> k) {
                        return PartialFunction.class.andThen((PartialFunction)this, k);
                    }

                    public Function1<Object, Option<Object>> lift() {
                        return PartialFunction.class.lift((PartialFunction)this);
                    }

                    public <A1, B1> B1 applyOrElse(A1 x, Function1<A1, B1> function1) {
                        return (B1)PartialFunction.class.applyOrElse((PartialFunction)this, x, function1);
                    }

                    public <U> Function1<Object, Object> runWith(Function1<Object, U> action) {
                        return PartialFunction.class.runWith((PartialFunction)this, action);
                    }

                    public boolean apply$mcZD$sp(double v1) {
                        return Function1.class.apply$mcZD$sp((Function1)this, (double)v1);
                    }

                    public double apply$mcDD$sp(double v1) {
                        return Function1.class.apply$mcDD$sp((Function1)this, (double)v1);
                    }

                    public float apply$mcFD$sp(double v1) {
                        return Function1.class.apply$mcFD$sp((Function1)this, (double)v1);
                    }

                    public int apply$mcID$sp(double v1) {
                        return Function1.class.apply$mcID$sp((Function1)this, (double)v1);
                    }

                    public long apply$mcJD$sp(double v1) {
                        return Function1.class.apply$mcJD$sp((Function1)this, (double)v1);
                    }

                    public void apply$mcVD$sp(double v1) {
                        Function1.class.apply$mcVD$sp((Function1)this, (double)v1);
                    }

                    public boolean apply$mcZF$sp(float v1) {
                        return Function1.class.apply$mcZF$sp((Function1)this, (float)v1);
                    }

                    public double apply$mcDF$sp(float v1) {
                        return Function1.class.apply$mcDF$sp((Function1)this, (float)v1);
                    }

                    public float apply$mcFF$sp(float v1) {
                        return Function1.class.apply$mcFF$sp((Function1)this, (float)v1);
                    }

                    public int apply$mcIF$sp(float v1) {
                        return Function1.class.apply$mcIF$sp((Function1)this, (float)v1);
                    }

                    public long apply$mcJF$sp(float v1) {
                        return Function1.class.apply$mcJF$sp((Function1)this, (float)v1);
                    }

                    public void apply$mcVF$sp(float v1) {
                        Function1.class.apply$mcVF$sp((Function1)this, (float)v1);
                    }

                    public double apply$mcDI$sp(int v1) {
                        return Function1.class.apply$mcDI$sp((Function1)this, (int)v1);
                    }

                    public float apply$mcFI$sp(int v1) {
                        return Function1.class.apply$mcFI$sp((Function1)this, (int)v1);
                    }

                    public int apply$mcII$sp(int v1) {
                        return Function1.class.apply$mcII$sp((Function1)this, (int)v1);
                    }

                    public long apply$mcJI$sp(int v1) {
                        return Function1.class.apply$mcJI$sp((Function1)this, (int)v1);
                    }

                    public void apply$mcVI$sp(int v1) {
                        Function1.class.apply$mcVI$sp((Function1)this, (int)v1);
                    }

                    public boolean apply$mcZJ$sp(long v1) {
                        return Function1.class.apply$mcZJ$sp((Function1)this, (long)v1);
                    }

                    public double apply$mcDJ$sp(long v1) {
                        return Function1.class.apply$mcDJ$sp((Function1)this, (long)v1);
                    }

                    public float apply$mcFJ$sp(long v1) {
                        return Function1.class.apply$mcFJ$sp((Function1)this, (long)v1);
                    }

                    public int apply$mcIJ$sp(long v1) {
                        return Function1.class.apply$mcIJ$sp((Function1)this, (long)v1);
                    }

                    public long apply$mcJJ$sp(long v1) {
                        return Function1.class.apply$mcJJ$sp((Function1)this, (long)v1);
                    }

                    public void apply$mcVJ$sp(long v1) {
                        Function1.class.apply$mcVJ$sp((Function1)this, (long)v1);
                    }

                    public <A> Function1<A, Object> compose(Function1<A, Object> g) {
                        return Function1.class.compose((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcZD$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcZD$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcDD$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcDD$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcFD$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcFD$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcID$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcID$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcJD$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcJD$sp((Function1)this, g);
                    }

                    public <A> Function1<A, BoxedUnit> compose$mcVD$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcVD$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcZF$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcZF$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcDF$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcDF$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcFF$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcFF$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcIF$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcIF$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcJF$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcJF$sp((Function1)this, g);
                    }

                    public <A> Function1<A, BoxedUnit> compose$mcVF$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcVF$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcZI$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcZI$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcDI$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcDI$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcFI$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcFI$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcII$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcII$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcJI$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcJI$sp((Function1)this, g);
                    }

                    public <A> Function1<A, BoxedUnit> compose$mcVI$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcVI$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcZJ$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcZJ$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcDJ$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcDJ$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcFJ$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcFJ$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcIJ$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcIJ$sp((Function1)this, g);
                    }

                    public <A> Function1<A, Object> compose$mcJJ$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcJJ$sp((Function1)this, g);
                    }

                    public <A> Function1<A, BoxedUnit> compose$mcVJ$sp(Function1<A, Object> g) {
                        return Function1.class.compose$mcVJ$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcZD$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcZD$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcDD$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcDD$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcFD$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcFD$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcID$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcID$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcJD$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcJD$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcVD$sp(Function1<BoxedUnit, A> g) {
                        return Function1.class.andThen$mcVD$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcZF$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcZF$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcDF$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcDF$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcFF$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcFF$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcIF$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcIF$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcJF$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcJF$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcVF$sp(Function1<BoxedUnit, A> g) {
                        return Function1.class.andThen$mcVF$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcZI$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcZI$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcDI$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcDI$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcFI$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcFI$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcII$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcII$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcJI$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcJI$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcVI$sp(Function1<BoxedUnit, A> g) {
                        return Function1.class.andThen$mcVI$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcZJ$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcZJ$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcDJ$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcDJ$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcFJ$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcFJ$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcIJ$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcIJ$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcJJ$sp(Function1<Object, A> g) {
                        return Function1.class.andThen$mcJJ$sp((Function1)this, g);
                    }

                    public <A> Function1<Object, A> andThen$mcVJ$sp(Function1<BoxedUnit, A> g) {
                        return Function1.class.andThen$mcVJ$sp((Function1)this, g);
                    }

                    public int length() {
                        return (int)this.$outer.$outer.size();
                    }

                    public boolean apply(int idx) {
                        return this.apply$mcZI$sp(idx);
                    }

                    public boolean apply$mcZI$sp(int idx) {
                        return this.$outer.$outer.get(idx);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        Function1.class.$init$((Function1)this);
                        PartialFunction.class.$init$((PartialFunction)this);
                        GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Parallelizable.class.$init$((Parallelizable)this);
                        TraversableLike.class.$init$((TraversableLike)this);
                        GenericTraversableTemplate.class.$init$((GenericTraversableTemplate)this);
                        GenTraversable.class.$init$((GenTraversable)this);
                        Traversable.class.$init$((Traversable)this);
                        GenIterable.class.$init$((GenIterable)this);
                        IterableLike.class.$init$((IterableLike)this);
                        Iterable.class.$init$((Iterable)this);
                        GenSeqLike.class.$init$((GenSeqLike)this);
                        GenSeq.class.$init$((GenSeq)this);
                        SeqLike.class.$init$((SeqLike)this);
                        Seq.class.$init$((Seq)this);
                        IndexedSeqLike.class.$init$((IndexedSeqLike)this);
                        IndexedSeq.class.$init$((IndexedSeq)this);
                    }
                };
            }

            public /* synthetic */ BitVector scodec$bits$BitVector$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        Option<Object> option = $this.intSize();
        if (!option.isEmpty()) {
            Object object = option.get();
            Serializable serializable2 = serializable;
            int n = BoxesRunTime.unboxToInt((Object)object);
            Serializable serializable3 = serializable;
            none$ = new Some((Object)new /* invalid duplicate definition of identical inner class */);
        } else {
            none$ = None$.MODULE$;
        }
        Serializable serializable4 = new Serializable($this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ BitVector $outer;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BitVector too big for Seq: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.size())})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        None$ none$2 = none$;
        if (!none$.isEmpty()) {
            return (IndexedSeq)none$2.get();
        }
        Serializable serializable5 = serializable4;
        Serializable serializable6 = serializable4;
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BitVector too big for Seq: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)$this.size())})));
    }

    public static final ByteVector toByteVector(BitVector $this) {
        return BitVector$.MODULE$.scodec$bits$BitVector$$clearUnneededBits($this.size(), $this.compact().underlying());
    }

    public static final ByteVector bytes(BitVector $this) {
        return $this.toByteVector();
    }

    public static final byte[] toByteArray(BitVector $this) {
        return $this.toByteVector().toArray();
    }

    public static final ByteBuffer toByteBuffer(BitVector $this) {
        return $this.toByteVector().toByteBuffer();
    }

    public static final String toBin(BitVector $this) {
        String string = $this.toByteVector().toBin();
        Predef$ predef$ = Predef$.MODULE$;
        return (String)new StringOps(string).take((int)$this.size());
    }

    public static final String toBin(BitVector $this, Bases.BinaryAlphabet alphabet) {
        String string = $this.toByteVector().toBin(alphabet);
        Predef$ predef$ = Predef$.MODULE$;
        return (String)new StringOps(string).take((int)$this.size());
    }

    public static final String toHex(BitVector $this) {
        return $this.toHex(Bases$Alphabets$HexLowercase$.MODULE$);
    }

    public static final String toHex(BitVector $this, Bases.HexAlphabet alphabet) {
        String string;
        String full = $this.toByteVector().toHex(alphabet);
        long l = $this.size() % 8L;
        if (0L == l) {
            string = full;
        } else if (l <= 4L) {
            String string2 = full;
            Predef$ predef$ = Predef$.MODULE$;
            string = (String)new StringOps(full).init();
        } else {
            string = full;
        }
        return string;
    }

    public static final String toBase64(BitVector $this) {
        return $this.toBase64(Bases$Alphabets$Base64$.MODULE$);
    }

    public static final String toBase64(BitVector $this, Bases.Base64Alphabet alphabet) {
        return $this.toByteVector().toBase64(alphabet);
    }

    public static final byte sliceToByte(BitVector $this, long start, int bits2, boolean signed) {
        byte by;
        while (start % 8L != 0L) {
            BitVector bitVector = $this.drop(start);
            start = 0L;
            $this = bitVector;
        }
        if ($this.isEmpty()) {
            by = (byte)0;
        } else {
            Predef$.MODULE$.require($this.sizeGreaterThanOrEqual(start + (long)bits2) && bits2 >= 0 && bits2 <= 8);
            int result = 0xFF & $this.getByte(0L);
            if (bits2 != 0) {
                result >>>= 8 - bits2;
            }
            if (signed && bits2 != 8 && (1 << bits2 - 1 & result) != 0) {
                int toShift = 32 - bits2;
                result = result << toShift >> toShift;
            }
            by = (byte)result;
        }
        return by;
    }

    public static final boolean sliceToByte$default$3(BitVector $this) {
        return true;
    }

    public static final byte toByte(BitVector $this, boolean signed) {
        byte by;
        Predef$.MODULE$.require($this.sizeLessThanOrEqual(8L));
        if ($this.isEmpty()) {
            by = (byte)0;
        } else {
            int bits2 = BoxesRunTime.unboxToInt((Object)$this.intSize().get());
            int result = 0xFF & $this.getByte(0L);
            if (bits2 != 0) {
                result >>>= 8 - bits2;
            }
            if (signed && bits2 != 8 && (1 << bits2 - 1 & result) != 0) {
                int toShift = 32 - bits2;
                result = result << toShift >> toShift;
            }
            by = (byte)result;
        }
        return by;
    }

    public static final boolean toByte$default$1(BitVector $this) {
        return true;
    }

    public static final short sliceToShort(BitVector $this, long start, int bits2, boolean signed, ByteOrdering ordering) {
        while (true) {
            if (start % 8L != 0L) {
                BitVector bitVector = $this.drop(start);
                start = 0L;
                $this = bitVector;
                continue;
            }
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            BitVector bitVector = $this.drop(start).invertReverseByteOrder();
            ordering = ByteOrdering$BigEndian$.MODULE$;
            start = 0L;
            $this = bitVector;
        }
        Predef$.MODULE$.require($this.sizeGreaterThanOrEqual(start + (long)bits2) && bits2 >= 0 && bits2 <= 16);
        int mod = bits2 % 8;
        IntRef result = new IntRef(0);
        long bytesNeeded = BitVector$.MODULE$.scodec$bits$BitVector$$bytesNeededForBits(bits2);
        long base = start / 8L;
        BitVector$class.go$6($this, 0, result, bytesNeeded, base);
        if (mod != 0) {
            result.elem >>>= 8 - mod;
        }
        if (signed && bits2 != 16 && (1 << bits2 - 1 & result.elem) != 0) {
            int toShift = 32 - bits2;
            result.elem = result.elem << toShift >> toShift;
        }
        return (short)result.elem;
    }

    public static final boolean sliceToShort$default$3(BitVector $this) {
        return true;
    }

    public static final ByteOrdering sliceToShort$default$4(BitVector $this) {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public static final short toShort(BitVector $this, boolean signed, ByteOrdering ordering) {
        while (true) {
            Predef$.MODULE$.require($this.sizeLessThanOrEqual(16L));
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            ordering = ByteOrdering$BigEndian$.MODULE$;
            $this = $this.invertReverseByteOrder();
        }
        int bits2 = BoxesRunTime.unboxToInt((Object)$this.intSize().get());
        int mod = bits2 % 8;
        IntRef result = new IntRef(0);
        long bytesNeeded = BitVector$.MODULE$.scodec$bits$BitVector$$bytesNeededForBits(bits2);
        BitVector$class.go$7($this, 0, result, bytesNeeded);
        if (mod != 0) {
            result.elem >>>= 8 - mod;
        }
        if (signed && bits2 != 16 && (1 << bits2 - 1 & result.elem) != 0) {
            int toShift = 32 - bits2;
            result.elem = result.elem << toShift >> toShift;
        }
        return (short)result.elem;
    }

    public static final boolean toShort$default$1(BitVector $this) {
        return true;
    }

    public static final ByteOrdering toShort$default$2(BitVector $this) {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public static final int sliceToInt(BitVector $this, long start, int bits2, boolean signed, ByteOrdering ordering) {
        while (true) {
            if (start % 8L != 0L) {
                BitVector bitVector = $this.drop(start);
                start = 0L;
                $this = bitVector;
                continue;
            }
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            BitVector bitVector = $this.drop(start).invertReverseByteOrder();
            ordering = ByteOrdering$BigEndian$.MODULE$;
            start = 0L;
            $this = bitVector;
        }
        Predef$.MODULE$.require($this.sizeGreaterThanOrEqual(start + (long)bits2) && bits2 >= 0 && bits2 <= 32);
        int mod = bits2 % 8;
        IntRef result = new IntRef(0);
        long bytesNeeded = BitVector$.MODULE$.scodec$bits$BitVector$$bytesNeededForBits(bits2);
        long base = start / 8L;
        BitVector$class.go$8($this, 0, result, bytesNeeded, base);
        if (mod != 0) {
            result.elem >>>= 8 - mod;
        }
        if (signed && bits2 != 32 && (1 << bits2 - 1 & result.elem) != 0) {
            int toShift = 32 - bits2;
            result.elem = result.elem << toShift >> toShift;
        }
        return result.elem;
    }

    public static final boolean sliceToInt$default$3(BitVector $this) {
        return true;
    }

    public static final ByteOrdering sliceToInt$default$4(BitVector $this) {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public static final int toInt(BitVector $this, boolean signed, ByteOrdering ordering) {
        while (true) {
            Predef$.MODULE$.require($this.sizeLessThanOrEqual(32L));
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            ordering = ByteOrdering$BigEndian$.MODULE$;
            $this = $this.invertReverseByteOrder();
        }
        int bits2 = BoxesRunTime.unboxToInt((Object)$this.intSize().get());
        int mod = bits2 % 8;
        IntRef result = new IntRef(0);
        long bytesNeeded = BitVector$.MODULE$.scodec$bits$BitVector$$bytesNeededForBits(bits2);
        BitVector$class.go$9($this, 0, result, bytesNeeded);
        if (mod != 0) {
            result.elem >>>= 8 - mod;
        }
        if (signed && bits2 != 32 && (1 << bits2 - 1 & result.elem) != 0) {
            int toShift = 32 - bits2;
            result.elem = result.elem << toShift >> toShift;
        }
        return result.elem;
    }

    public static final boolean toInt$default$1(BitVector $this) {
        return true;
    }

    public static final ByteOrdering toInt$default$2(BitVector $this) {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public static final long sliceToLong(BitVector $this, long start, int bits2, boolean signed, ByteOrdering ordering) {
        block9: {
            LongRef result;
            int mod;
            block8: {
                long base;
                long bytesNeeded;
                block7: {
                    while (true) {
                        if (start % 8L != 0L) {
                            BitVector bitVector = $this.drop(start);
                            start = 0L;
                            $this = bitVector;
                            continue;
                        }
                        ByteOrdering byteOrdering = ordering;
                        ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
                        if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
                        BitVector bitVector = $this.drop(start).invertReverseByteOrder();
                        ordering = ByteOrdering$BigEndian$.MODULE$;
                        start = 0L;
                        $this = bitVector;
                    }
                    Predef$.MODULE$.require($this.sizeGreaterThanOrEqual(start + (long)bits2) && bits2 >= 0 && bits2 <= 64);
                    mod = bits2 % 8;
                    result = new LongRef(0L);
                    bytesNeeded = BitVector$.MODULE$.scodec$bits$BitVector$$bytesNeededForBits(bits2);
                    base = start / 8L;
                    ByteOrdering byteOrdering = ordering;
                    ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
                    ByteOrdering byteOrdering2 = ordering;
                    if (byteOrdering$BigEndian$ != null ? !byteOrdering$BigEndian$.equals(ordering) : ordering != null) break block7;
                    BitVector$class.go$10($this, 0, result, bytesNeeded, base);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block8;
                }
                ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
                ByteOrdering byteOrdering = ordering;
                if (byteOrdering$LittleEndian$ != null ? !byteOrdering$LittleEndian$.equals(ordering) : ordering != null) break block9;
                BitVector$class.go$11($this, 0, result, bytesNeeded, base);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (mod != 0) {
                result.elem >>>= 8 - mod;
            }
            if (signed && bits2 != 64 && ((long)(1 << bits2 - 1) & result.elem) != 0L) {
                int toShift = 64 - bits2;
                result.elem = result.elem << toShift >> toShift;
            }
            return result.elem;
        }
        throw new MatchError((Object)ordering);
    }

    public static final boolean sliceToLong$default$3(BitVector $this) {
        return true;
    }

    public static final ByteOrdering sliceToLong$default$4(BitVector $this) {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public static final long toLong(BitVector $this, boolean signed, ByteOrdering ordering) {
        while (true) {
            Predef$.MODULE$.require($this.sizeLessThanOrEqual(64L));
            ByteOrdering byteOrdering = ordering;
            ByteOrdering$LittleEndian$ byteOrdering$LittleEndian$ = ByteOrdering$LittleEndian$.MODULE$;
            if (byteOrdering != null ? !byteOrdering.equals(byteOrdering$LittleEndian$) : byteOrdering$LittleEndian$ != null) break;
            ordering = ByteOrdering$BigEndian$.MODULE$;
            $this = $this.invertReverseByteOrder();
        }
        int bits2 = BoxesRunTime.unboxToInt((Object)$this.intSize().get());
        int mod = bits2 % 8;
        LongRef result = new LongRef(0L);
        long bytesNeeded = BitVector$.MODULE$.scodec$bits$BitVector$$bytesNeededForBits(bits2);
        BitVector$class.go$12($this, 0, result, bytesNeeded);
        if (mod != 0) {
            result.elem >>>= 8 - mod;
        }
        if (signed && bits2 != 64 && ((long)(1 << bits2 - 1) & result.elem) != 0L) {
            int toShift = 64 - bits2;
            result.elem = result.elem << toShift >> toShift;
        }
        return result.elem;
    }

    public static final boolean toLong$default$1(BitVector $this) {
        return true;
    }

    public static final ByteOrdering toLong$default$2(BitVector $this) {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public static final Either decodeString(BitVector $this, Charset charset) {
        return $this.bytes().decodeString(charset);
    }

    public static final Either decodeUtf8(BitVector $this) {
        return $this.bytes().decodeUtf8();
    }

    public static final Either decodeAscii(BitVector $this) {
        return $this.bytes().decodeAscii();
    }

    public static final BitVector deflate(BitVector $this, int level, int strategy, boolean nowrap, int chunkSize) {
        return $this.bytes().deflate(level, strategy, nowrap, chunkSize).bits();
    }

    public static final int deflate$default$1(BitVector $this) {
        return -1;
    }

    public static final int deflate$default$2(BitVector $this) {
        return 0;
    }

    public static final boolean deflate$default$3(BitVector $this) {
        return false;
    }

    public static final int deflate$default$4(BitVector $this) {
        return 4096;
    }

    public static final Either inflate(BitVector $this, int chunkSize) {
        Left left;
        Serializable serializable = new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$28) {
                return x$28.bits();
            }
        };
        Either either = $this.bytes().inflate(chunkSize).right().e();
        if (!(either instanceof Left)) {
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = right.b();
            Serializable serializable2 = serializable;
            ByteVector byteVector = (ByteVector)object;
            Serializable serializable3 = serializable;
            left = new Right((Object)byteVector.bits());
        } else {
            Left left2 = (Left)either;
            left = new Left(left2.a());
        }
        return left;
    }

    public static final int inflate$default$1(BitVector $this) {
        return 4096;
    }

    public static final BitVector digest(BitVector $this, String algorithm) {
        return $this.digest(MessageDigest.getInstance(algorithm));
    }

    public static final BitVector digest(BitVector $this, MessageDigest digest2) {
        return BitVector$.MODULE$.apply($this.bytes().digest(digest2));
    }

    public static final Either encrypt(BitVector $this, Cipher ci, Key key, Option aparams, SecureRandom sr) {
        return $this.cipher(ci, key, 1, (Option<AlgorithmParameters>)aparams, sr);
    }

    public static final Option encrypt$default$3(BitVector $this) {
        return None$.MODULE$;
    }

    public static final Either decrypt(BitVector $this, Cipher ci, Key key, Option aparams, SecureRandom sr) {
        return $this.cipher(ci, key, 2, (Option<AlgorithmParameters>)aparams, sr);
    }

    public static final Option decrypt$default$3(BitVector $this) {
        return None$.MODULE$;
    }

    public static final boolean equals(BitVector $this, Object other) {
        boolean bl;
        Object object = other;
        if (other instanceof BitVector) {
            BitVector bitVector = (BitVector)other;
            int chunkSize = 524288;
            bl = BitVector$class.go$13($this, $this, bitVector, 524288);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final int hashCode(BitVector $this) {
        int chunkSize = 524288;
        return BitVector$class.go$1($this, $this, MurmurHash3$.MODULE$.stringHash("BitVector"), 524288);
    }

    public static final String toString(BitVector $this) {
        return $this.isEmpty() ? "BitVector(empty)" : ($this.sizeLessThan(513L) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BitVector(", " bits, 0x", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)$this.size()), $this.toHex()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BitVector(", " bits, #", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)$this.size()), BoxesRunTime.boxToInteger((int)$this.hashCode())})));
    }

    public static final void checkBounds(BitVector $this, long n) {
        if ($this.sizeGreaterThan(n)) {
            return;
        }
        throw $this.outOfBounds(n);
    }

    public static final Nothing$ outOfBounds(BitVector $this, long n) {
        throw new NoSuchElementException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid index: ", " of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n), BoxesRunTime.boxToLong((long)$this.size())})));
    }

    public static final BitVector mapBytes(BitVector $this, Function1 f) {
        block7: {
            Product product;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                BitVector bitVector = $this;
                                if (!($this instanceof BitVector.Bytes)) break block2;
                                BitVector.Bytes bytes = (BitVector.Bytes)$this;
                                ByteVector bs = bytes.underlying();
                                long n = bytes.size();
                                product = BitVector$.MODULE$.toBytes((ByteVector)f.apply((Object)bs), n);
                                break block3;
                            }
                            if (!($this instanceof BitVector.Append)) break block4;
                            BitVector.Append append = (BitVector.Append)$this;
                            BitVector l = append.left();
                            BitVector r = append.right();
                            product = new BitVector.Append(l.mapBytes((Function1<ByteVector, ByteVector>)f), r.mapBytes((Function1<ByteVector, ByteVector>)f));
                            break block3;
                        }
                        if (!($this instanceof BitVector.Drop)) break block5;
                        BitVector.Drop drop = (BitVector.Drop)$this;
                        BitVector.Bytes b = drop.underlying();
                        long n = drop.m();
                        product = new BitVector.Drop(b.mapBytes((Function1<ByteVector, ByteVector>)f).compact(), n);
                        break block3;
                    }
                    if (!($this instanceof BitVector.Suspend)) break block6;
                    BitVector.Suspend suspend = (BitVector.Suspend)$this;
                    product = new BitVector.Suspend((Function0<BitVector>)new Serializable($this, suspend, f){
                        public static final long serialVersionUID = 0L;
                        private final BitVector.Suspend x6$1;
                        private final Function1 f$3;

                        public final BitVector apply() {
                            return this.x6$1.underlying().mapBytes((Function1<ByteVector, ByteVector>)this.f$3);
                        }
                        {
                            this.x6$1 = x6$1;
                            this.f$3 = f$3;
                        }
                    });
                    break block3;
                }
                if (!($this instanceof BitVector.Chunks)) break block7;
                BitVector.Chunks chunks = (BitVector.Chunks)$this;
                product = new BitVector.Chunks(new BitVector.Append(chunks.chunks().left().mapBytes((Function1<ByteVector, ByteVector>)f), chunks.chunks().right().mapBytes((Function1<ByteVector, ByteVector>)f)));
            }
            return product;
        }
        throw new MatchError((Object)$this);
    }

    public static Either cipher(BitVector $this, Cipher ci, Key key, int opmode, Option aparams, SecureRandom sr) {
        Left left;
        Serializable serializable = new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$29) {
                return x$29.bits();
            }
        };
        Either either = $this.bytes().cipher(ci, key, opmode, (Option<AlgorithmParameters>)aparams, sr).right().e();
        if (!(either instanceof Left)) {
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = right.b();
            Serializable serializable2 = serializable;
            ByteVector byteVector = (ByteVector)object;
            Serializable serializable3 = serializable;
            left = new Right((Object)byteVector.bits());
        } else {
            Left left2 = (Left)either;
            left = new Left(left2.a());
        }
        return left;
    }

    public static Option cipher$default$4(BitVector $this) {
        return None$.MODULE$;
    }

    public static String internalPretty(BitVector $this, String prefix) {
        block7: {
            String string;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                BitVector bitVector = $this;
                                if (!($this instanceof BitVector.Append)) break block2;
                                BitVector.Append append = (BitVector.Append)$this;
                                BitVector l = append.left();
                                BitVector r = append.right();
                                string = new StringBuilder().append((Object)prefix).append((Object)"append\n").append((Object)l.internalPretty(new StringBuilder().append((Object)prefix).append((Object)"  ").toString())).append((Object)"\n").append((Object)r.internalPretty(new StringBuilder().append((Object)prefix).append((Object)"  ").toString())).toString();
                                break block3;
                            }
                            if (!($this instanceof BitVector.Bytes)) break block4;
                            BitVector.Bytes bytes = (BitVector.Bytes)$this;
                            ByteVector b = bytes.underlying();
                            long n = bytes.size();
                            string = new StringBuilder().append((Object)prefix).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bits ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n)}))).append((Object)b.pretty(new StringBuilder().append((Object)"  ").append((Object)prefix).toString())).toString();
                            break block3;
                        }
                        if (!($this instanceof BitVector.Drop)) break block5;
                        BitVector.Drop drop = (BitVector.Drop)$this;
                        BitVector.Bytes u = drop.underlying();
                        long n = drop.m();
                        string = new StringBuilder().append((Object)prefix).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n)}))).append((Object)u.internalPretty(new StringBuilder().append((Object)prefix).append((Object)"  ").toString())).toString();
                        break block3;
                    }
                    if (!($this instanceof BitVector.Suspend)) break block6;
                    BitVector.Suspend suspend = (BitVector.Suspend)$this;
                    string = new StringBuilder().append((Object)prefix).append((Object)"suspend\n").append((Object)suspend.underlying().internalPretty(new StringBuilder().append((Object)prefix).append((Object)"  ").toString())).toString();
                    break block3;
                }
                if (!($this instanceof BitVector.Chunks)) break block7;
                BitVector.Chunks chunks = (BitVector.Chunks)$this;
                string = new StringBuilder().append((Object)prefix).append((Object)"chunks\n").append((Object)chunks.chunks().left().internalPretty("  ")).append((Object)"\n").append((Object)chunks.chunks().right().internalPretty("  ")).toString();
            }
            return string;
        }
        throw new MatchError((Object)$this);
    }

    private static BitVector zipBytesWith(BitVector $this, BitVector other, Function2 op) {
        long l = $this.size();
        Predef$ predef$ = Predef$.MODULE$;
        return BitVector$.MODULE$.toBytes($this.compact().underlying().zipWithI(other.compact().underlying(), (Function2<Object, Object, Object>)op), BoxesRunTime.unboxToLong((Object)new RichLong(l).min((Object)BoxesRunTime.boxToLong((long)other.size()))));
    }

    public static final Object writeReplace(BitVector $this) {
        return new BitVector.SerializationProxy($this.toByteArray(), $this.size());
    }

    private static final long go$2(BitVector $this, BitVector b, long idx, BitVector slice$1) {
        while (true) {
            block5: {
                long l;
                block4: {
                    block3: {
                        if (!b.startsWith(slice$1)) break block3;
                        l = idx;
                        break block4;
                    }
                    if (!b.isEmpty()) break block5;
                    l = -1L;
                }
                return l;
            }
            ++idx;
            b = b.tail();
        }
    }

    private static final long go$3(BitVector $this, BitVector b, long acc) {
        while (!b.isEmpty()) {
            acc = b.head() ? acc + 1L : acc;
            b = b.tail();
        }
        return acc;
    }

    private static final Vector go$4(BitVector $this, List b, Vector acc) {
        while (true) {
            boolean bl = false;
            .colon.colon colon2 = null;
            List list = b;
            if (b instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)b;
                BitVector s = (BitVector)colon2.hd$1();
                List rem = colon2.tl$1();
                if (s instanceof BitVector.Suspend) {
                    BitVector.Suspend suspend = (BitVector.Suspend)s;
                    BitVector bitVector = suspend.underlying();
                    b = rem.$colon$colon((Object)bitVector);
                    continue;
                }
            }
            if (bl) {
                BitVector b2 = (BitVector)colon2.hd$1();
                List rem = colon2.tl$1();
                if (b2 instanceof BitVector.Bytes) {
                    BitVector.Bytes bytes = (BitVector.Bytes)b2;
                    acc = (Vector)acc.$colon$plus((Object)bytes, Vector$.MODULE$.canBuildFrom());
                    b = rem;
                    continue;
                }
            }
            if (bl) {
                BitVector bitVector = (BitVector)colon2.hd$1();
                List rem = colon2.tl$1();
                if (bitVector instanceof BitVector.Append) {
                    BitVector.Append append = (BitVector.Append)bitVector;
                    BitVector l = append.left();
                    BitVector r = append.right();
                    BitVector bitVector2 = l;
                    BitVector bitVector3 = r;
                    b = rem.$colon$colon((Object)r).$colon$colon((Object)l);
                    continue;
                }
            }
            if (bl) {
                BitVector d = (BitVector)colon2.hd$1();
                List rem = colon2.tl$1();
                if (d instanceof BitVector.Drop) {
                    BitVector.Drop drop = (BitVector.Drop)d;
                    acc = (Vector)acc.$colon$plus((Object)drop.interpretDrop(), Vector$.MODULE$.canBuildFrom());
                    b = rem;
                    continue;
                }
            }
            if (!bl) break;
            BitVector c = (BitVector)colon2.hd$1();
            List rem = colon2.tl$1();
            if (!(c instanceof BitVector.Chunks)) break;
            BitVector.Chunks chunks = (BitVector.Chunks)c;
            BitVector bitVector = chunks.chunks().left();
            BitVector bitVector4 = chunks.chunks().right();
            b = rem.$colon$colon((Object)bitVector4).$colon$colon((Object)bitVector);
        }
        Vector vector = acc;
        return acc;
    }

    private static final BitVector go$5(BitVector $this, Vector cont) {
        BitVector bitVector;
        block5: {
            while (cont.nonEmpty()) {
                Tuple2 tuple2;
                block6: {
                    Vector cont2;
                    BitVector cur;
                    block9: {
                        BitVector bitVector2;
                        block8: {
                            block7: {
                                tuple2 = new Tuple2(cont.head(), (Object)cont.tail());
                                if (tuple2 == null) break block6;
                                cur = (BitVector)tuple2._1();
                                cont2 = (Vector)tuple2._2();
                                BitVector bitVector3 = cur;
                                if (!(cur instanceof BitVector.Bytes)) break block7;
                                BitVector.Bytes bytes = (BitVector.Bytes)cur;
                                bitVector2 = (BitVector)cont2.foldLeft((Object)bytes, (Function2)new Serializable($this){
                                    public static final long serialVersionUID = 0L;

                                    public final BitVector apply(BitVector x$18, BitVector x$19) {
                                        return x$18.$plus$plus(x$19);
                                    }
                                });
                                break block8;
                            }
                            if (cur instanceof BitVector.Append) {
                                BitVector.Append append = (BitVector.Append)cur;
                                BitVector l = append.left();
                                BitVector r = append.right();
                                BitVector bitVector4 = l;
                                BitVector bitVector5 = r;
                                cont = (Vector)((Vector)cont2.$plus$colon((Object)r, Vector$.MODULE$.canBuildFrom())).$plus$colon((Object)l, Vector$.MODULE$.canBuildFrom());
                                continue;
                            }
                            if (!(cur instanceof BitVector.Drop)) break block9;
                            BitVector.Drop drop = (BitVector.Drop)cur;
                            bitVector2 = (BitVector)cont2.foldLeft((Object)drop, (Function2)new Serializable($this){
                                public static final long serialVersionUID = 0L;

                                public final BitVector apply(BitVector x$22, BitVector x$23) {
                                    return x$22.$plus$plus(x$23);
                                }
                            });
                        }
                        BitVector bitVector6 = bitVector2;
                        bitVector = bitVector2;
                        break block5;
                    }
                    if (cur instanceof BitVector.Suspend) {
                        BitVector.Suspend suspend = (BitVector.Suspend)cur;
                        BitVector bitVector7 = suspend.underlying();
                        cont = (Vector)cont2.$plus$colon((Object)bitVector7, Vector$.MODULE$.canBuildFrom());
                        continue;
                    }
                    if (cur instanceof BitVector.Chunks) {
                        BitVector.Chunks chunks = (BitVector.Chunks)cur;
                        BitVector.Append append = chunks.chunks();
                        cont = (Vector)cont2.$plus$colon((Object)append, Vector$.MODULE$.canBuildFrom());
                        continue;
                    }
                    throw new MatchError((Object)cur);
                }
                throw new MatchError((Object)tuple2);
            }
            bitVector = (BitVector)cont.foldLeft((Object)BitVector$.MODULE$.empty(), (Function2)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final BitVector apply(BitVector x$26, BitVector x$27) {
                    return x$26.$plus$plus(x$27);
                }
            });
        }
        return bitVector;
    }

    private static final void go$6(BitVector $this, int i, IntRef result$1, long bytesNeeded$1, long base$1) {
        while ((long)i < bytesNeeded$1) {
            result$1.elem = result$1.elem << 8 | 0xFF & $this.getByte(base$1 + (long)i);
            ++i;
        }
    }

    private static final void go$7(BitVector $this, int i, IntRef result$2, long bytesNeeded$2) {
        while ((long)i < bytesNeeded$2) {
            result$2.elem = result$2.elem << 8 | 0xFF & $this.getByte(i);
            ++i;
        }
    }

    private static final void go$8(BitVector $this, int i, IntRef result$3, long bytesNeeded$3, long base$2) {
        while ((long)i < bytesNeeded$3) {
            result$3.elem = result$3.elem << 8 | 0xFF & $this.getByte(base$2 + (long)i);
            ++i;
        }
    }

    private static final void go$9(BitVector $this, int i, IntRef result$4, long bytesNeeded$4) {
        while ((long)i < bytesNeeded$4) {
            result$4.elem = result$4.elem << 8 | 0xFF & $this.getByte(i);
            ++i;
        }
    }

    private static final void go$10(BitVector $this, int i, LongRef result$5, long bytesNeeded$5, long base$3) {
        while ((long)i < bytesNeeded$5) {
            result$5.elem = result$5.elem << 8 | 0xFFL & (long)$this.getByte(base$3 + (long)i);
            ++i;
        }
    }

    private static final void go$11(BitVector $this, int i, LongRef result$5, long bytesNeeded$5, long base$3) {
        while ((long)i < bytesNeeded$5) {
            result$5.elem |= (0xFFL & (long)$this.getByte(base$3 + (long)i)) << 8 * i;
            ++i;
        }
    }

    private static final void go$12(BitVector $this, int i, LongRef result$6, long bytesNeeded$6) {
        while ((long)i < bytesNeeded$6) {
            result$6.elem = result$6.elem << 8 | 0xFFL & (long)$this.getByte(i);
            ++i;
        }
    }

    private static final boolean go$13(BitVector $this, BitVector x, BitVector y, int chunkSize$2) {
        boolean bl;
        block2: {
            while (true) {
                if (x.isEmpty()) {
                    bl = y.isEmpty();
                    break block2;
                }
                BitVector chunkX = x.take(chunkSize$2);
                BitVector chunkY = y.take(chunkSize$2);
                if (chunkX.size() != chunkY.size()) break;
                ByteVector byteVector = chunkX.toByteVector();
                ByteVector byteVector2 = chunkY.toByteVector();
                if (byteVector != null ? !((Object)byteVector).equals(byteVector2) : byteVector2 != null) break;
                y = y.drop(chunkSize$2);
                x = x.drop(chunkSize$2);
            }
            bl = false;
        }
        return bl;
    }

    private static final int go$1(BitVector $this, BitVector bits2, int h, int chunkSize$1) {
        while (!bits2.isEmpty()) {
            h = MurmurHash3$.MODULE$.mix(h, MurmurHash3$.MODULE$.bytesHash(bits2.take(chunkSize$1).toByteArray()));
            bits2 = bits2.drop(chunkSize$1);
        }
        return MurmurHash3$.MODULE$.finalizeHash(h, (int)($this.size() % (long)Integer.MAX_VALUE) + 1);
    }

    public static void $init$(BitVector $this) {
    }
}

