/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence;

import akka.actor.ActorKilledException;
import akka.dispatch.Envelope;
import akka.dispatch.Envelope$;
import akka.persistence.JournalProtocol;
import akka.persistence.JournalProtocol$DeleteMessages$;
import akka.persistence.PersistenceFailure;
import akka.persistence.PersistentId;
import akka.persistence.PersistentIdImpl;
import akka.persistence.ProcessorImpl;
import akka.persistence.ProcessorImpl$;
import akka.persistence.Recover;
import akka.persistence.Recover$;
import akka.persistence.Recovery;
import akka.persistence.RecoveryCompleted$;
import akka.persistence.RecoveryFailure;
import akka.persistence.Resequenceable;
import akka.persistence.SnapshotSelectionCriteria;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class ProcessorImpl$class {
    public static void onReplaySuccess(ProcessorImpl $this, PartialFunction receive2, boolean awaitReplay) {
        $this._currentState_$eq($this.akka$persistence$ProcessorImpl$$initializing());
        akka.actor.package$.MODULE$.actorRef2Scala($this.journal()).$bang((Object)new JournalProtocol.ReadHighestSequenceNr($this.lastSequenceNr(), $this.persistenceId(), $this.self()), $this.self());
    }

    public static void onReplayFailure(ProcessorImpl $this, PartialFunction receive2, boolean awaitReplay, Throwable cause) {
        ProcessorImpl$class.akka$persistence$ProcessorImpl$$onRecoveryFailure($this, receive2, cause);
    }

    public static void akka$persistence$ProcessorImpl$$onRecoveryFailure(ProcessorImpl $this, PartialFunction receive2, Throwable cause) {
        receive2.applyOrElse((Object)new RecoveryFailure(cause), (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessorImpl $outer;

            public final void apply(Object message) {
                this.$outer.unhandled(message);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static void akka$persistence$ProcessorImpl$$onRecoveryCompleted(ProcessorImpl $this, PartialFunction receive2) {
        receive2.applyOrElse((Object)RecoveryCompleted$.MODULE$, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessorImpl $outer;

            public final void apply(Object message) {
                this.$outer.unhandled(message);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static String processorId(ProcessorImpl $this) {
        return $this.akka$persistence$ProcessorImpl$$_persistenceId();
    }

    public static String snapshotterId(ProcessorImpl $this) {
        return $this.persistenceId();
    }

    public static boolean recoveryRunning(ProcessorImpl $this) {
        Recovery.State state = $this._currentState();
        Recovery.State state2 = $this.akka$persistence$ProcessorImpl$$processing();
        return state != null ? !state.equals(state2) : state2 != null;
    }

    public static boolean recoveryFinished(ProcessorImpl $this) {
        Recovery.State state = $this._currentState();
        Recovery.State state2 = $this.akka$persistence$ProcessorImpl$$processing();
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static void deleteMessage(ProcessorImpl $this, long sequenceNr) {
        $this.deleteMessage(sequenceNr, false);
    }

    public static void deleteMessage(ProcessorImpl $this, long sequenceNr, boolean permanent) {
        akka.actor.package$.MODULE$.actorRef2Scala($this.journal()).$bang((Object)new JournalProtocol.DeleteMessages((scala.collection.immutable.Seq<PersistentId>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PersistentIdImpl[]{new PersistentIdImpl($this.persistenceId(), sequenceNr)})), permanent, JournalProtocol$DeleteMessages$.MODULE$.apply$default$3()), $this.self());
    }

    public static void deleteMessages(ProcessorImpl $this, long toSequenceNr) {
        $this.deleteMessages(toSequenceNr, true);
    }

    public static void deleteMessages(ProcessorImpl $this, long toSequenceNr, boolean permanent) {
        akka.actor.package$.MODULE$.actorRef2Scala($this.journal()).$bang((Object)new JournalProtocol.DeleteMessagesTo($this.persistenceId(), toSequenceNr, permanent), $this.self());
    }

    public static void flushJournalBatch(ProcessorImpl $this) {
        akka.actor.package$.MODULE$.actorRef2Scala($this.journal()).$bang((Object)new JournalProtocol.WriteMessages((scala.collection.immutable.Seq<Resequenceable>)$this.akka$persistence$ProcessorImpl$$processorBatch(), $this.self(), $this.instanceId()), $this.self());
        $this.akka$persistence$ProcessorImpl$$processorBatch_$eq((Vector<Resequenceable>)package$.MODULE$.Vector().empty());
    }

    public static void aroundPreStart(ProcessorImpl $this) {
        try {
            $this.preStart();
            return;
        }
        finally {
            $this.akka$persistence$ProcessorImpl$$super$preStart();
        }
    }

    public static void aroundPostStop(ProcessorImpl $this) {
        try {
            $this.unstashAll($this.akka$persistence$ProcessorImpl$$unstashFilterPredicate());
            return;
        }
        finally {
            $this.postStop();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void aroundPreRestart(ProcessorImpl $this, Throwable reason, Option message) {
        try {
            $this.receiverStash().prepend((scala.collection.immutable.Seq)$this.akka$persistence$ProcessorImpl$$processorBatch().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProcessorImpl $outer;

                public final Envelope apply(Resequenceable p) {
                    return Envelope$.MODULE$.apply((Object)p, p.sender(), this.$outer.context().system());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Vector$.MODULE$.canBuildFrom()));
            $this.receiverStash().unstashAll();
            $this.unstashAll($this.akka$persistence$ProcessorImpl$$unstashFilterPredicate());
            return;
        }
        finally {
            var4_3 = false;
            var5_5 = null;
            var6_7 = message;
            if (!(var6_7 instanceof Some)) ** GOTO lbl-1000
            var4_3 = true;
            var5_5 = (Some)var6_7;
            var7_9 = var5_5.x();
            if (var7_9 instanceof JournalProtocol.WriteMessageSuccess) {
                var8_11 = (JournalProtocol.WriteMessageSuccess)var7_9;
                m = var8_11.persistent();
                $this.preRestartDefault(reason, (Option<Object>)new Some((Object)m));
                var10_15 = BoxedUnit.UNIT;
            } else if (var4_3 && (var11_23 = var5_5.x()) instanceof JournalProtocol.LoopMessageSuccess) {
                var12_25 = (JournalProtocol.LoopMessageSuccess)var11_23;
                m = var12_25.message();
                $this.preRestartDefault(reason, (Option<Object>)new Some(m));
                var10_16 = BoxedUnit.UNIT;
            } else if (var4_3 && (var14_29 = var5_5.x()) instanceof JournalProtocol.ReplayedMessage) {
                var15_31 = (JournalProtocol.ReplayedMessage)var14_29;
                m = var15_31.persistent();
                $this.preRestartDefault(reason, (Option<Object>)new Some((Object)m));
                var10_17 = BoxedUnit.UNIT;
            } else {
                $this.preRestartDefault(reason, (Option<Object>)None$.MODULE$);
                var10_18 = BoxedUnit.UNIT;
            }
        }
    }

    public static void preStart(ProcessorImpl $this) throws Exception {
        akka.actor.package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new Recover(Recover$.MODULE$.apply$default$1(), Recover$.MODULE$.apply$default$2(), Recover$.MODULE$.apply$default$3()), $this.self());
    }

    public static void preRestart(ProcessorImpl $this, Throwable reason, Option message) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = message;
                    if (!(option instanceof Some)) break block2;
                    long x$9 = $this.lastSequenceNr();
                    SnapshotSelectionCriteria x$10 = Recover$.MODULE$.apply$default$1();
                    long x$11 = Recover$.MODULE$.apply$default$3();
                    akka.actor.package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new Recover(x$10, x$9, x$11), $this.self());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                akka.actor.package$.MODULE$.actorRef2Scala($this.self()).$bang((Object)new Recover(Recover$.MODULE$.apply$default$1(), Recover$.MODULE$.apply$default$2(), Recover$.MODULE$.apply$default$3()), $this.self());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public static void preRestartDefault(ProcessorImpl $this, Throwable reason, Option message) {
        try {
            $this.preRestart(reason, (Option<Object>)message);
            return;
        }
        finally {
            $this.akka$persistence$ProcessorImpl$$super$preRestart(reason, (Option<Object>)message);
        }
    }

    public static void unhandled(ProcessorImpl $this, Object message) {
        Object object = message;
        RecoveryCompleted$ recoveryCompleted$ = RecoveryCompleted$.MODULE$;
        Object object2 = object;
        if (!(recoveryCompleted$ != null ? !recoveryCompleted$.equals(object2) : object2 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (object instanceof RecoveryFailure) {
                RecoveryFailure recoveryFailure = (RecoveryFailure)object;
                Throwable cause = recoveryFailure.cause();
                String errorMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor killed after recovery failure (persistent id = [", "]). "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.persistenceId()}))).append((Object)"To avoid killing processors on recovery failure, a processor must handle RecoveryFailure messages. ").append((Object)"RecoveryFailure was caused by: ").append((Object)cause).toString();
                throw new ActorKilledException(errorMsg);
            }
            if (object instanceof PersistenceFailure) {
                PersistenceFailure persistenceFailure = (PersistenceFailure)object;
                Object payload = persistenceFailure.payload();
                long sequenceNumber = persistenceFailure.sequenceNr();
                Throwable cause = persistenceFailure.cause();
                String errorMsg = new StringBuilder().append((Object)"Processor killed after persistence failure ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(persistent id = [", "], sequence nr = [", "], payload class = [", "]). "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.persistenceId(), BoxesRunTime.boxToLong((long)sequenceNumber), payload.getClass().getName()}))).append((Object)"To avoid killing processors on persistence failure, a processor must handle PersistenceFailure messages. ").append((Object)"PersistenceFailure was caused by: ").append((Object)cause).toString();
                throw new ActorKilledException(errorMsg);
            }
            $this.akka$persistence$ProcessorImpl$$super$unhandled(object);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static long akka$persistence$ProcessorImpl$$nextSequenceNr(ProcessorImpl $this) {
        $this.akka$persistence$ProcessorImpl$$sequenceNr_$eq($this.akka$persistence$ProcessorImpl$$sequenceNr() + 1L);
        return $this.akka$persistence$ProcessorImpl$$sequenceNr();
    }

    public static void $init$(ProcessorImpl $this) {
        $this.akka$persistence$ProcessorImpl$_setter_$instanceId_$eq(ProcessorImpl$.MODULE$.akka$persistence$ProcessorImpl$$instanceIdCounter().incrementAndGet());
        $this.akka$persistence$ProcessorImpl$_setter_$akka$persistence$ProcessorImpl$$initializing_$eq(new ProcessorImpl$.anon.1($this));
        $this.akka$persistence$ProcessorImpl$_setter_$akka$persistence$ProcessorImpl$$processing_$eq(new ProcessorImpl$.anon.2($this));
        $this.akka$persistence$ProcessorImpl$_setter_$akka$persistence$ProcessorImpl$$_persistenceId_$eq($this.extension().persistenceId($this.self()));
        $this.akka$persistence$ProcessorImpl$$processorBatch_$eq((Vector<Resequenceable>)package$.MODULE$.Vector().empty());
        $this.akka$persistence$ProcessorImpl$$sequenceNr_$eq(0L);
        $this.akka$persistence$ProcessorImpl$_setter_$akka$persistence$ProcessorImpl$$unstashFilterPredicate_$eq((Function1)new ProcessorImpl$.anonfun.1($this));
    }
}

